/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import com.mojang.serialization.DynamicOps;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.ConversionParams;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Shearable;
import net.minecraft.world.entity.VariantHolder;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.SuspiciousStewEffects;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SuspiciousEffectHolder;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.neoforged.neoforge.event.EventHooks;

public class MushroomCow
extends Cow
implements Shearable,
VariantHolder<Variant> {
    private static final EntityDataAccessor<String> DATA_TYPE = SynchedEntityData.defineId(MushroomCow.class, EntityDataSerializers.STRING);
    private static final int MUTATE_CHANCE = 1024;
    private static final String TAG_STEW_EFFECTS = "stew_effects";
    @Nullable
    private SuspiciousStewEffects stewEffects;
    @Nullable
    private UUID lastLightningBoltUUID;

    public MushroomCow(EntityType<? extends MushroomCow> p_28914_, Level p_28915_) {
        super(p_28914_, p_28915_);
    }

    public float getWalkTargetValue(BlockPos p_28933_, LevelReader p_28934_) {
        return p_28934_.getBlockState(p_28933_.below()).is(Blocks.MYCELIUM) ? 10.0f : p_28934_.getPathfindingCostFromLightLevels(p_28933_);
    }

    public static boolean checkMushroomSpawnRules(EntityType<MushroomCow> p_218201_, LevelAccessor p_218202_, EntitySpawnReason p_360426_, BlockPos p_218204_, RandomSource p_218205_) {
        return p_218202_.getBlockState(p_218204_.below()).is(BlockTags.MOOSHROOMS_SPAWNABLE_ON) && MushroomCow.isBrightEnoughToSpawn((BlockAndTintGetter)p_218202_, (BlockPos)p_218204_);
    }

    public void thunderHit(ServerLevel p_28921_, LightningBolt p_28922_) {
        UUID uuid = p_28922_.getUUID();
        if (!uuid.equals(this.lastLightningBoltUUID)) {
            this.setVariant(this.getVariant() == Variant.RED ? Variant.BROWN : Variant.RED);
            this.lastLightningBoltUUID = uuid;
            this.playSound(SoundEvents.MOOSHROOM_CONVERT, 2.0f, 1.0f);
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder p_326279_) {
        super.defineSynchedData(p_326279_);
        p_326279_.define(DATA_TYPE, Variant.RED.type);
    }

    public InteractionResult mobInteract(Player p_28941_, InteractionHand p_28942_) {
        ItemStack itemstack = p_28941_.getItemInHand(p_28942_);
        if (itemstack.is(Items.BOWL) && !this.isBaby()) {
            ItemStack itemstack2;
            boolean flag = false;
            if (this.stewEffects != null) {
                flag = true;
                itemstack2 = new ItemStack(Items.SUSPICIOUS_STEW);
                itemstack2.set(DataComponents.SUSPICIOUS_STEW_EFFECTS, this.stewEffects);
                this.stewEffects = null;
            } else {
                itemstack2 = new ItemStack(Items.MUSHROOM_STEW);
            }
            ItemStack itemstack1 = ItemUtils.createFilledResult((ItemStack)itemstack, (Player)p_28941_, (ItemStack)itemstack2, (boolean)false);
            p_28941_.setItemInHand(p_28942_, itemstack1);
            SoundEvent soundevent = flag ? SoundEvents.MOOSHROOM_MILK_SUSPICIOUSLY : SoundEvents.MOOSHROOM_MILK;
            this.playSound(soundevent, 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        if (itemstack.is(Items.SHEARS) && this.readyForShearing()) {
            Level itemstack2 = this.level();
            if (itemstack2 instanceof ServerLevel) {
                ServerLevel serverlevel = (ServerLevel)itemstack2;
                this.shear(serverlevel, SoundSource.PLAYERS, itemstack);
                this.gameEvent(GameEvent.SHEAR, p_28941_);
                itemstack.hurtAndBreak(1, p_28941_, MushroomCow.getSlotForHand((InteractionHand)p_28942_));
            }
            return InteractionResult.SUCCESS;
        }
        if (this.getVariant() == Variant.BROWN && itemstack.is(ItemTags.SMALL_FLOWERS)) {
            if (this.stewEffects != null) {
                for (int i = 0; i < 2; ++i) {
                    this.level().addParticle((ParticleOptions)ParticleTypes.SMOKE, this.getX() + this.random.nextDouble() / 2.0, this.getY(0.5), this.getZ() + this.random.nextDouble() / 2.0, 0.0, this.random.nextDouble() / 5.0, 0.0);
                }
            } else {
                Optional<SuspiciousStewEffects> optional = this.getEffectsFromItemStack(itemstack);
                if (optional.isEmpty()) {
                    return InteractionResult.PASS;
                }
                itemstack.consume(1, p_28941_);
                for (int j = 0; j < 4; ++j) {
                    this.level().addParticle((ParticleOptions)ParticleTypes.EFFECT, this.getX() + this.random.nextDouble() / 2.0, this.getY(0.5), this.getZ() + this.random.nextDouble() / 2.0, 0.0, this.random.nextDouble() / 5.0, 0.0);
                }
                this.stewEffects = optional.get();
                this.playSound(SoundEvents.MOOSHROOM_EAT, 2.0f, 1.0f);
            }
            return InteractionResult.SUCCESS;
        }
        return super.mobInteract(p_28941_, p_28942_);
    }

    @Override
    public void shear(ServerLevel p_376375_, SoundSource p_28924_, ItemStack p_373092_) {
        p_376375_.playSound(null, (Entity)((Object)this), SoundEvents.MOOSHROOM_SHEAR, p_28924_, 1.0f, 1.0f);
        if (!EventHooks.canLivingConvert((LivingEntity)((Object)this), EntityType.COW, timer -> {})) {
            return;
        }
        this.convertTo(EntityType.COW, ConversionParams.single((Mob)((Object)this), (boolean)false, (boolean)false), p_381482_ -> {
            EventHooks.onLivingConvert((LivingEntity)((Object)((Object)this)), (LivingEntity)p_381482_);
            p_376375_.sendParticles(ParticleTypes.EXPLOSION, this.getX(), this.getY(0.5), this.getZ(), 1, 0.0, 0.0, 0.0, 0.0);
            this.dropFromShearingLootTable(p_376375_, BuiltInLootTables.SHEAR_MOOSHROOM, p_373092_, (p_381483_, p_381484_) -> {
                for (int i = 0; i < p_381484_.getCount(); ++i) {
                    ItemEntity item = this.spawnAtLocation((ServerLevel)p_381483_, p_381484_.copyWithCount(1), this.getBbHeight());
                    if (item == null) continue;
                    item.setNoPickUpDelay();
                }
            });
        });
    }

    @Override
    public boolean readyForShearing() {
        return this.isAlive() && !this.isBaby();
    }

    public void addAdditionalSaveData(CompoundTag p_28944_) {
        super.addAdditionalSaveData(p_28944_);
        p_28944_.putString("Type", this.getVariant().getSerializedName());
        if (this.stewEffects != null) {
            SuspiciousStewEffects.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.stewEffects).ifSuccess(p_297973_ -> p_28944_.put(TAG_STEW_EFFECTS, (Tag)p_297973_));
        }
    }

    public void readAdditionalSaveData(CompoundTag p_28936_) {
        super.readAdditionalSaveData(p_28936_);
        this.setVariant(Variant.byName(p_28936_.getString("Type")));
        if (p_28936_.contains(TAG_STEW_EFFECTS, 9)) {
            SuspiciousStewEffects.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)p_28936_.get(TAG_STEW_EFFECTS)).ifSuccess(p_330058_ -> {
                this.stewEffects = p_330058_;
            });
        }
    }

    private Optional<SuspiciousStewEffects> getEffectsFromItemStack(ItemStack p_298333_) {
        SuspiciousEffectHolder suspiciouseffectholder = SuspiciousEffectHolder.tryGet((ItemLike)p_298333_.getItem());
        return suspiciouseffectholder != null ? Optional.of(suspiciouseffectholder.getSuspiciousEffects()) : Optional.empty();
    }

    public void setVariant(Variant p_360882_) {
        this.entityData.set(DATA_TYPE, p_360882_.type);
    }

    public Variant getVariant() {
        return Variant.byName(this.entityData.get(DATA_TYPE));
    }

    @Nullable
    public MushroomCow getBreedOffspring(ServerLevel p_148942_, AgeableMob p_148943_) {
        MushroomCow mushroomcow = EntityType.MOOSHROOM.create(p_148942_, EntitySpawnReason.BREEDING);
        if (mushroomcow != null) {
            mushroomcow.setVariant(this.getOffspringVariant((MushroomCow)p_148943_));
        }
        return mushroomcow;
    }

    private Variant getOffspringVariant(MushroomCow p_28931_) {
        Variant mushroomcow$variant1;
        Variant mushroomcow$variant = this.getVariant();
        Variant mushroomcow$variant2 = mushroomcow$variant == (mushroomcow$variant1 = p_28931_.getVariant()) && this.random.nextInt(1024) == 0 ? (mushroomcow$variant == Variant.BROWN ? Variant.RED : Variant.BROWN) : (this.random.nextBoolean() ? mushroomcow$variant : mushroomcow$variant1);
        return mushroomcow$variant2;
    }

    public static enum Variant implements StringRepresentable
    {
        RED("red", Blocks.RED_MUSHROOM.defaultBlockState()),
        BROWN("brown", Blocks.BROWN_MUSHROOM.defaultBlockState());

        public static final StringRepresentable.EnumCodec<Variant> CODEC;
        final String type;
        private final BlockState blockState;

        private Variant(String p_363362_, BlockState p_365388_) {
            this.type = p_363362_;
            this.blockState = p_365388_;
        }

        public BlockState getBlockState() {
            return this.blockState;
        }

        public String getSerializedName() {
            return this.type;
        }

        static Variant byName(String p_364149_) {
            return (Variant)CODEC.byName(p_364149_, (Enum)RED);
        }

        static {
            CODEC = StringRepresentable.fromEnum(Variant::values);
        }
    }
}

