/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.SectionPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Endermite;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.portal.TeleportTransition;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.event.entity.EntityTeleportEvent;

public class ThrownEnderpearl
extends ThrowableItemProjectile {
    private long ticketTimer = 0L;

    public ThrownEnderpearl(EntityType<? extends ThrownEnderpearl> p_37491_, Level p_37492_) {
        super(p_37491_, p_37492_);
    }

    public ThrownEnderpearl(Level p_37499_, LivingEntity p_37500_, ItemStack p_360657_) {
        super(EntityType.ENDER_PEARL, p_37500_, p_37499_, p_360657_);
    }

    protected Item getDefaultItem() {
        return Items.ENDER_PEARL;
    }

    protected void setOwnerThroughUUID(UUID p_373083_) {
        this.deregisterFromCurrentOwner();
        super.setOwnerThroughUUID(p_373083_);
        this.registerToCurrentOwner();
    }

    public void setOwner(@Nullable Entity p_372876_) {
        this.deregisterFromCurrentOwner();
        super.setOwner(p_372876_);
        this.registerToCurrentOwner();
    }

    private void deregisterFromCurrentOwner() {
        Entity entity = this.getOwner();
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverplayer = (ServerPlayer)entity;
            serverplayer.deregisterEnderPearl(this);
        }
    }

    private void registerToCurrentOwner() {
        Entity entity = this.getOwner();
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverplayer = (ServerPlayer)entity;
            serverplayer.registerEnderPearl(this);
        }
    }

    @Nullable
    protected Entity findOwner(UUID p_360307_) {
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)level;
            Entity entity = super.findOwner(p_360307_);
            if (entity != null) {
                return entity;
            }
            for (ServerLevel serverlevel1 : serverlevel.getServer().getAllLevels()) {
                if (serverlevel1 == serverlevel || (entity = serverlevel1.getEntity(p_360307_)) == null) continue;
                return entity;
            }
            return null;
        }
        return null;
    }

    protected void onHitEntity(EntityHitResult p_37502_) {
        super.onHitEntity(p_37502_);
        p_37502_.getEntity().hurt(this.damageSources().thrown((Entity)((Object)this), this.getOwner()), 0.0f);
    }

    protected void onHit(HitResult p_37504_) {
        super.onHit(p_37504_);
        for (int i = 0; i < 32; ++i) {
            this.level().addParticle((ParticleOptions)ParticleTypes.PORTAL, this.getX(), this.getY() + this.random.nextDouble() * 2.0, this.getZ(), this.random.nextGaussian(), 0.0, this.random.nextGaussian());
        }
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)level;
            if (!this.isRemoved()) {
                Entity entity = this.getOwner();
                if (entity != null && ThrownEnderpearl.isAllowedToTeleportOwner(entity, serverlevel)) {
                    if (entity.isPassenger()) {
                        entity.unRide();
                    }
                    Vec3 vec3 = this.oldPosition();
                    if (entity instanceof ServerPlayer) {
                        EntityTeleportEvent.EnderPearl event;
                        ServerPlayer serverplayer = (ServerPlayer)entity;
                        if (serverplayer.connection.isAcceptingMessages() && !(event = EventHooks.onEnderPearlLand((ServerPlayer)serverplayer, (double)this.getX(), (double)this.getY(), (double)this.getZ(), (ThrownEnderpearl)this, (float)5.0f, (HitResult)p_37504_)).isCanceled()) {
                            ServerPlayer serverplayer1;
                            Endermite endermite;
                            if (this.random.nextFloat() < 0.05f && serverlevel.getGameRules().getBoolean(GameRules.RULE_DOMOBSPAWNING) && (endermite = EntityType.ENDERMITE.create(serverlevel, EntitySpawnReason.TRIGGERED)) != null) {
                                endermite.moveTo(entity.getX(), entity.getY(), entity.getZ(), entity.getYRot(), entity.getXRot());
                                serverlevel.addFreshEntity((Entity)endermite);
                            }
                            if (this.isOnPortalCooldown()) {
                                entity.setPortalCooldown();
                            }
                            if ((serverplayer1 = serverplayer.teleport(new TeleportTransition(serverlevel, event.getTarget(), entity.getDeltaMovement(), entity.getYRot(), entity.getXRot(), TeleportTransition.DO_NOTHING))) != null) {
                                serverplayer1.resetFallDistance();
                                serverplayer1.resetCurrentImpulseContext();
                                serverplayer1.hurtServer(serverplayer.serverLevel(), this.damageSources().fall(), event.getAttackDamage());
                            }
                            this.playSound(serverlevel, vec3);
                        }
                    } else {
                        Entity entity1 = entity.teleport(new TeleportTransition(serverlevel, vec3, entity.getDeltaMovement(), entity.getYRot(), entity.getXRot(), TeleportTransition.DO_NOTHING));
                        if (entity1 != null) {
                            entity1.resetFallDistance();
                        }
                        this.playSound(serverlevel, vec3);
                    }
                    this.discard();
                    return;
                }
                this.discard();
                return;
            }
        }
    }

    private static boolean isAllowedToTeleportOwner(Entity p_352055_, Level p_352453_) {
        if (p_352055_.level().dimension() == p_352453_.dimension()) {
            boolean bl;
            if (!(p_352055_ instanceof LivingEntity)) {
                bl = p_352055_.isAlive();
            } else {
                LivingEntity livingentity = (LivingEntity)p_352055_;
                bl = livingentity.isAlive() && !livingentity.isSleeping();
            }
            return bl;
        }
        return p_352055_.canUsePortal(true);
    }

    /*
     * Unable to fully structure code
     */
    public void tick() {
        i = SectionPos.blockToSectionCoord((double)this.position().x());
        j = SectionPos.blockToSectionCoord((double)this.position().z());
        entity = this.getOwner();
        if (!(entity instanceof ServerPlayer)) ** GOTO lbl-1000
        serverplayer = (ServerPlayer)entity;
        if (!entity.isAlive() && serverplayer.serverLevel().getGameRules().getBoolean(GameRules.RULE_ENDER_PEARLS_VANISH_ON_DEATH)) {
            this.discard();
        } else lbl-1000:
        // 2 sources

        {
            super.tick();
        }
        if (this.isAlive()) {
            blockpos = BlockPos.containing((Position)this.position());
            if ((--this.ticketTimer <= 0L || i != SectionPos.blockToSectionCoord((int)blockpos.getX()) || j != SectionPos.blockToSectionCoord((int)blockpos.getZ())) && entity instanceof ServerPlayer) {
                serverplayer1 = (ServerPlayer)entity;
                this.ticketTimer = serverplayer1.registerAndUpdateEnderPearlTicket(this);
            }
        }
    }

    private void playSound(Level p_350706_, Vec3 p_350543_) {
        p_350706_.playSound(null, p_350543_.x, p_350543_.y, p_350543_.z, SoundEvents.PLAYER_TELEPORT, SoundSource.PLAYERS);
    }

    @Nullable
    public Entity teleport(TeleportTransition p_379805_) {
        Entity entity = super.teleport(p_379805_);
        if (entity != null) {
            entity.placePortalTicket(BlockPos.containing((Position)entity.position()));
        }
        return entity;
    }

    public boolean canTeleport(Level p_352941_, Level p_352929_) {
        boolean bl;
        Entity entity;
        if (p_352941_.dimension() == Level.END && p_352929_.dimension() == Level.OVERWORLD && (entity = this.getOwner()) instanceof ServerPlayer) {
            ServerPlayer serverplayer = (ServerPlayer)entity;
            bl = super.canTeleport(p_352941_, p_352929_) && serverplayer.seenCredits;
        } else {
            bl = super.canTeleport(p_352941_, p_352929_);
        }
        return bl;
    }

    protected void onInsideBlock(BlockState p_353066_) {
        Entity entity;
        super.onInsideBlock(p_353066_);
        if (p_353066_.is(Blocks.END_GATEWAY) && (entity = this.getOwner()) instanceof ServerPlayer) {
            ServerPlayer serverplayer = (ServerPlayer)entity;
            serverplayer.onInsideBlock(p_353066_);
        }
    }

    public void onRemoval(Entity.RemovalReason p_379730_) {
        if (p_379730_ != Entity.RemovalReason.UNLOADED_WITH_PLAYER) {
            this.deregisterFromCurrentOwner();
        }
        super.onRemoval(p_379730_);
    }
}

