/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.vehicle;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.UnmodifiableIterator;
import com.mojang.datafixers.util.Pair;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.BlockUtil;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.WanderingTrader;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractBoat;
import net.minecraft.world.entity.vehicle.DismountHelper;
import net.minecraft.world.entity.vehicle.MinecartBehavior;
import net.minecraft.world.entity.vehicle.NewMinecartBehavior;
import net.minecraft.world.entity.vehicle.OldMinecartBehavior;
import net.minecraft.world.entity.vehicle.VehicleEntity;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.PoweredRailBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public abstract class AbstractMinecart
extends VehicleEntity {
    private static final Vec3 LOWERED_PASSENGER_ATTACHMENT = new Vec3(0.0, 0.0, 0.0);
    private static final EntityDataAccessor<Integer> DATA_ID_DISPLAY_BLOCK = SynchedEntityData.defineId(AbstractMinecart.class, EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> DATA_ID_DISPLAY_OFFSET = SynchedEntityData.defineId(AbstractMinecart.class, EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> DATA_ID_CUSTOM_DISPLAY = SynchedEntityData.defineId(AbstractMinecart.class, EntityDataSerializers.BOOLEAN);
    private static final ImmutableMap<Pose, ImmutableList<Integer>> POSE_DISMOUNT_HEIGHTS = ImmutableMap.of((Object)Pose.STANDING, (Object)ImmutableList.of((Object)0, (Object)1, (Object)-1), (Object)Pose.CROUCHING, (Object)ImmutableList.of((Object)0, (Object)1, (Object)-1), (Object)Pose.SWIMMING, (Object)ImmutableList.of((Object)0, (Object)1));
    protected static final float WATER_SLOWDOWN_FACTOR = 0.95f;
    private boolean onRails;
    private boolean flipped;
    private final MinecartBehavior behavior;
    private static final Map<RailShape, Pair<Vec3i, Vec3i>> EXITS = Util.make(Maps.newEnumMap(RailShape.class), p_38135_ -> {
        Vec3i vec3i = Direction.WEST.getUnitVec3i();
        Vec3i vec3i1 = Direction.EAST.getUnitVec3i();
        Vec3i vec3i2 = Direction.NORTH.getUnitVec3i();
        Vec3i vec3i3 = Direction.SOUTH.getUnitVec3i();
        Vec3i vec3i4 = vec3i.below();
        Vec3i vec3i5 = vec3i1.below();
        Vec3i vec3i6 = vec3i2.below();
        Vec3i vec3i7 = vec3i3.below();
        p_38135_.put(RailShape.NORTH_SOUTH, Pair.of((Object)vec3i2, (Object)vec3i3));
        p_38135_.put(RailShape.EAST_WEST, Pair.of((Object)vec3i, (Object)vec3i1));
        p_38135_.put(RailShape.ASCENDING_EAST, Pair.of((Object)vec3i4, (Object)vec3i1));
        p_38135_.put(RailShape.ASCENDING_WEST, Pair.of((Object)vec3i, (Object)vec3i5));
        p_38135_.put(RailShape.ASCENDING_NORTH, Pair.of((Object)vec3i2, (Object)vec3i7));
        p_38135_.put(RailShape.ASCENDING_SOUTH, Pair.of((Object)vec3i6, (Object)vec3i3));
        p_38135_.put(RailShape.SOUTH_EAST, Pair.of((Object)vec3i3, (Object)vec3i1));
        p_38135_.put(RailShape.SOUTH_WEST, Pair.of((Object)vec3i3, (Object)vec3i));
        p_38135_.put(RailShape.NORTH_WEST, Pair.of((Object)vec3i2, (Object)vec3i));
        p_38135_.put(RailShape.NORTH_EAST, Pair.of((Object)vec3i2, (Object)vec3i1));
    });

    protected AbstractMinecart(EntityType<?> p_38087_, Level p_38088_) {
        super(p_38087_, p_38088_);
        this.blocksBuilding = true;
        this.behavior = AbstractMinecart.useExperimentalMovement(p_38088_) ? new NewMinecartBehavior(this) : new OldMinecartBehavior(this);
    }

    protected AbstractMinecart(EntityType<?> p_38090_, Level p_38091_, double p_38092_, double p_38093_, double p_38094_) {
        this(p_38090_, p_38091_);
        this.setInitialPos(p_38092_, p_38093_, p_38094_);
    }

    public void setInitialPos(double p_374451_, double p_374374_, double p_374085_) {
        this.setPos(p_374451_, p_374374_, p_374085_);
        this.xo = p_374451_;
        this.yo = p_374374_;
        this.zo = p_374085_;
    }

    @Nullable
    public static <T extends AbstractMinecart> T createMinecart(Level p_366408_, double p_38121_, double p_38122_, double p_38123_, EntityType<T> p_374583_, EntitySpawnReason p_374412_, ItemStack p_305892_, @Nullable Player p_306203_) {
        AbstractMinecart t = (AbstractMinecart)((Object)p_374583_.create(p_366408_, p_374412_));
        if (t != null) {
            t.setInitialPos(p_38121_, p_38122_, p_38123_);
            EntityType.createDefaultStackConfig(p_366408_, p_305892_, p_306203_).accept(t);
            MinecartBehavior minecartBehavior = t.getBehavior();
            if (minecartBehavior instanceof NewMinecartBehavior) {
                NewMinecartBehavior newminecartbehavior = (NewMinecartBehavior)minecartBehavior;
                BlockPos blockpos = t.getCurrentBlockPosOrRailBelow();
                BlockState blockstate = p_366408_.getBlockState(blockpos);
                newminecartbehavior.adjustToRails(blockpos, blockstate, true);
            }
        }
        return (T)((Object)t);
    }

    public MinecartBehavior getBehavior() {
        return this.behavior;
    }

    protected Entity.MovementEmission getMovementEmission() {
        return Entity.MovementEmission.EVENTS;
    }

    protected void defineSynchedData(SynchedEntityData.Builder p_326247_) {
        super.defineSynchedData(p_326247_);
        p_326247_.define(DATA_ID_DISPLAY_BLOCK, Block.getId(Blocks.AIR.defaultBlockState()));
        p_326247_.define(DATA_ID_DISPLAY_OFFSET, 6);
        p_326247_.define(DATA_ID_CUSTOM_DISPLAY, false);
    }

    public boolean canCollideWith(Entity p_38168_) {
        return AbstractBoat.canVehicleCollide((Entity)((Object)this), p_38168_);
    }

    public boolean isPushable() {
        return true;
    }

    public Vec3 getRelativePortalPosition(Direction.Axis p_38132_, BlockUtil.FoundRectangle p_38133_) {
        return LivingEntity.resetForwardDirectionOfRelativePortalPosition(super.getRelativePortalPosition(p_38132_, p_38133_));
    }

    protected Vec3 getPassengerAttachmentPoint(Entity p_294753_, EntityDimensions p_295251_, float p_296054_) {
        boolean flag = p_294753_ instanceof Villager || p_294753_ instanceof WanderingTrader;
        return flag ? LOWERED_PASSENGER_ATTACHMENT : super.getPassengerAttachmentPoint(p_294753_, p_295251_, p_296054_);
    }

    public Vec3 getDismountLocationForPassenger(LivingEntity p_38145_) {
        Direction direction = this.getMotionDirection();
        if (direction.getAxis() == Direction.Axis.Y) {
            return super.getDismountLocationForPassenger(p_38145_);
        }
        int[][] aint = DismountHelper.offsetsForDirection((Direction)direction);
        BlockPos blockpos = this.blockPosition();
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        ImmutableList<Pose> immutablelist = p_38145_.getDismountPoses();
        for (Pose pose : immutablelist) {
            EntityDimensions entitydimensions = p_38145_.getDimensions(pose);
            float f = Math.min(entitydimensions.width(), 1.0f) / 2.0f;
            UnmodifiableIterator unmodifiableIterator = ((ImmutableList)POSE_DISMOUNT_HEIGHTS.get((Object)pose)).iterator();
            while (unmodifiableIterator.hasNext()) {
                int i = (Integer)unmodifiableIterator.next();
                for (int[] aint1 : aint) {
                    blockpos$mutableblockpos.set(blockpos.getX() + aint1[0], blockpos.getY() + i, blockpos.getZ() + aint1[1]);
                    double d0 = this.level().getBlockFloorHeight(DismountHelper.nonClimbableShape((BlockGetter)((Object)this.level()), (BlockPos)blockpos$mutableblockpos), () -> DismountHelper.nonClimbableShape((BlockGetter)((Object)this.level()), (BlockPos)blockpos$mutableblockpos.below()));
                    if (!DismountHelper.isBlockFloorValid((double)d0)) continue;
                    AABB aabb = new AABB(-f, 0.0, -f, f, entitydimensions.height(), f);
                    Vec3 vec3 = Vec3.upFromBottomCenterOf((Vec3i)blockpos$mutableblockpos, (double)d0);
                    if (!DismountHelper.canDismountTo((CollisionGetter)this.level(), (LivingEntity)p_38145_, (AABB)aabb.move(vec3))) continue;
                    p_38145_.setPose(pose);
                    return vec3;
                }
            }
        }
        double d1 = this.getBoundingBox().maxY;
        blockpos$mutableblockpos.set((double)blockpos.getX(), d1, (double)blockpos.getZ());
        for (Pose pose1 : immutablelist) {
            int j;
            double d3;
            double d2 = p_38145_.getDimensions(pose1).height();
            if (!(d1 + d2 <= (d3 = DismountHelper.findCeilingFrom((BlockPos)blockpos$mutableblockpos, (int)(j = Mth.ceil((double)(d1 - (double)blockpos$mutableblockpos.getY() + d2))), p_381557_ -> this.level().getBlockState((BlockPos)p_381557_).getCollisionShape((BlockGetter)((Object)this.level()), (BlockPos)p_381557_))))) continue;
            p_38145_.setPose(pose1);
            break;
        }
        return super.getDismountLocationForPassenger(p_38145_);
    }

    protected float getBlockSpeedFactor() {
        BlockState blockstate = this.level().getBlockState(this.blockPosition());
        return blockstate.is(BlockTags.RAILS) ? 1.0f : super.getBlockSpeedFactor();
    }

    public void animateHurt(float p_265349_) {
        this.setHurtDir(-this.getHurtDir());
        this.setHurtTime(10);
        this.setDamage(this.getDamage() + this.getDamage() * 10.0f);
    }

    public boolean isPickable() {
        return !this.isRemoved();
    }

    public static Pair<Vec3i, Vec3i> exits(RailShape p_38126_) {
        return EXITS.get(p_38126_);
    }

    public Direction getMotionDirection() {
        return this.behavior.getMotionDirection();
    }

    protected double getDefaultGravity() {
        return this.isInWater() ? 0.005 : 0.04;
    }

    public void tick() {
        if (this.getHurtTime() > 0) {
            this.setHurtTime(this.getHurtTime() - 1);
        }
        if (this.getDamage() > 0.0f) {
            this.setDamage(this.getDamage() - 1.0f);
        }
        this.checkBelowWorld();
        this.handlePortal();
        this.behavior.tick();
        this.updateInWaterStateAndDoFluidPushing();
        if (this.isInLava()) {
            this.lavaHurt();
            this.fallDistance *= 0.5f;
        }
        this.firstTick = false;
    }

    public boolean isFirstTick() {
        return this.firstTick;
    }

    public BlockPos getCurrentBlockPosOrRailBelow() {
        int i = Mth.floor((double)this.getX());
        int j = Mth.floor((double)this.getY());
        int k = Mth.floor((double)this.getZ());
        if (AbstractMinecart.useExperimentalMovement(this.level())) {
            double d0 = this.getY() - 0.1 - (double)1.0E-5f;
            if (this.level().getBlockState(BlockPos.containing((double)i, (double)d0, (double)k)).is(BlockTags.RAILS)) {
                j = Mth.floor((double)d0);
            }
        } else if (this.level().getBlockState(new BlockPos(i, j - 1, k)).is(BlockTags.RAILS)) {
            --j;
        }
        return new BlockPos(i, j, k);
    }

    protected double getMaxSpeed(ServerLevel p_376848_) {
        return this.behavior.getMaxSpeed(p_376848_);
    }

    public void activateMinecart(int p_38111_, int p_38112_, int p_38113_, boolean p_38114_) {
    }

    public void lerpPositionAndRotationStep(int p_364572_, double p_364337_, double p_362183_, double p_362957_, double p_363121_, double p_365178_) {
        super.lerpPositionAndRotationStep(p_364572_, p_364337_, p_362183_, p_362957_, p_363121_, p_365178_);
    }

    public void applyGravity() {
        super.applyGravity();
    }

    public void reapplyPosition() {
        super.reapplyPosition();
    }

    public boolean updateInWaterStateAndDoFluidPushing() {
        return super.updateInWaterStateAndDoFluidPushing();
    }

    public Vec3 getKnownMovement() {
        return this.behavior.getKnownMovement(super.getKnownMovement());
    }

    public void cancelLerp() {
        this.behavior.cancelLerp();
    }

    public void lerpTo(double p_38102_, double p_38103_, double p_38104_, float p_38105_, float p_38106_, int p_38107_) {
        this.behavior.lerpTo(p_38102_, p_38103_, p_38104_, p_38105_, p_38106_, p_38107_);
    }

    public double lerpTargetX() {
        return this.behavior.lerpTargetX();
    }

    public double lerpTargetY() {
        return this.behavior.lerpTargetY();
    }

    public double lerpTargetZ() {
        return this.behavior.lerpTargetZ();
    }

    public float lerpTargetXRot() {
        return this.behavior.lerpTargetXRot();
    }

    public float lerpTargetYRot() {
        return this.behavior.lerpTargetYRot();
    }

    public void lerpMotion(double p_38171_, double p_38172_, double p_38173_) {
        this.behavior.lerpMotion(p_38171_, p_38172_, p_38173_);
    }

    protected void moveAlongTrack(ServerLevel p_376546_) {
        this.behavior.moveAlongTrack(p_376546_);
    }

    protected void comeOffTrack(ServerLevel p_376696_) {
        double d0 = this.getMaxSpeed(p_376696_);
        Vec3 vec3 = this.getDeltaMovement();
        this.setDeltaMovement(Mth.clamp((double)vec3.x, (double)(-d0), (double)d0), vec3.y, Mth.clamp((double)vec3.z, (double)(-d0), (double)d0));
        if (this.onGround()) {
            this.setDeltaMovement(this.getDeltaMovement().scale(0.5));
        }
        this.move(MoverType.SELF, this.getDeltaMovement());
        if (!this.onGround()) {
            this.setDeltaMovement(this.getDeltaMovement().scale(0.95));
        }
    }

    protected double makeStepAlongTrack(BlockPos p_365229_, RailShape p_363321_, double p_364439_) {
        return this.behavior.stepAlongTrack(p_365229_, p_363321_, p_364439_);
    }

    public void move(MoverType p_362087_, Vec3 p_363190_) {
        if (AbstractMinecart.useExperimentalMovement(this.level())) {
            Vec3 vec3 = this.position().add(p_363190_);
            super.move(p_362087_, p_363190_);
            boolean flag = this.behavior.pushAndPickupEntities();
            if (flag) {
                super.move(p_362087_, vec3.subtract(this.position()));
            }
            if (p_362087_.equals((Object)MoverType.PISTON)) {
                this.onRails = false;
            }
        } else {
            super.move(p_362087_, p_363190_);
            this.applyEffectsFromBlocks();
        }
    }

    public void applyEffectsFromBlocks() {
        if (!AbstractMinecart.useExperimentalMovement(this.level())) {
            this.applyEffectsFromBlocks(this.position(), this.position());
        } else {
            super.applyEffectsFromBlocks();
        }
    }

    public boolean isOnRails() {
        return this.onRails;
    }

    public void setOnRails(boolean p_365128_) {
        this.onRails = p_365128_;
    }

    public boolean isFlipped() {
        return this.flipped;
    }

    public void setFlipped(boolean p_364443_) {
        this.flipped = p_364443_;
    }

    public Vec3 getRedstoneDirection(BlockPos p_361470_) {
        PoweredRailBlock poweredRail;
        BlockState blockstate = this.level().getBlockState(p_361470_);
        Block block = blockstate.getBlock();
        if (block instanceof PoweredRailBlock && !(poweredRail = (PoweredRailBlock)block).isActivatorRail() && ((Boolean)blockstate.getValue((Property)PoweredRailBlock.POWERED)).booleanValue()) {
            RailShape railshape = ((BaseRailBlock)blockstate.getBlock()).getRailDirection(blockstate, (BlockGetter)((Object)this.level()), p_361470_, this);
            if (railshape == RailShape.EAST_WEST) {
                if (this.isRedstoneConductor(p_361470_.west())) {
                    return new Vec3(1.0, 0.0, 0.0);
                }
                if (this.isRedstoneConductor(p_361470_.east())) {
                    return new Vec3(-1.0, 0.0, 0.0);
                }
            } else if (railshape == RailShape.NORTH_SOUTH) {
                if (this.isRedstoneConductor(p_361470_.north())) {
                    return new Vec3(0.0, 0.0, 1.0);
                }
                if (this.isRedstoneConductor(p_361470_.south())) {
                    return new Vec3(0.0, 0.0, -1.0);
                }
            }
            return Vec3.ZERO;
        }
        return Vec3.ZERO;
    }

    public boolean isRedstoneConductor(BlockPos p_38130_) {
        return this.level().getBlockState(p_38130_).isRedstoneConductor((BlockGetter)((Object)this.level()), p_38130_);
    }

    protected Vec3 applyNaturalSlowdown(Vec3 p_362705_) {
        double d0 = this.behavior.getSlowdownFactor();
        Vec3 vec3 = p_362705_.multiply(d0, 0.0, d0);
        if (this.isInWater()) {
            vec3 = vec3.scale((double)0.95f);
        }
        return vec3;
    }

    protected void readAdditionalSaveData(CompoundTag p_38137_) {
        if (p_38137_.getBoolean("CustomDisplayTile")) {
            this.setDisplayBlockState(NbtUtils.readBlockState((HolderGetter)this.level().holderLookup(Registries.BLOCK), (CompoundTag)p_38137_.getCompound("DisplayState")));
            this.setDisplayOffset(p_38137_.getInt("DisplayOffset"));
        }
        this.flipped = p_38137_.getBoolean("FlippedRotation");
        this.firstTick = p_38137_.getBoolean("HasTicked");
    }

    protected void addAdditionalSaveData(CompoundTag p_38151_) {
        if (this.hasCustomDisplay()) {
            p_38151_.putBoolean("CustomDisplayTile", true);
            p_38151_.put("DisplayState", NbtUtils.writeBlockState((BlockState)this.getDisplayBlockState()));
            p_38151_.putInt("DisplayOffset", this.getDisplayOffset());
        }
        p_38151_.putBoolean("FlippedRotation", this.flipped);
        p_38151_.putBoolean("HasTicked", this.firstTick);
    }

    public void push(Entity p_38165_) {
        double d1;
        double d0;
        double d2;
        if (!(this.level().isClientSide || p_38165_.noPhysics || this.noPhysics || this.hasPassenger(p_38165_) || !((d2 = (d0 = p_38165_.getX() - this.getX()) * d0 + (d1 = p_38165_.getZ() - this.getZ()) * d1) >= (double)1.0E-4f))) {
            d2 = Math.sqrt(d2);
            d0 /= d2;
            d1 /= d2;
            double d3 = 1.0 / d2;
            if (d3 > 1.0) {
                d3 = 1.0;
            }
            d0 *= d3;
            d1 *= d3;
            d0 *= (double)0.1f;
            d1 *= (double)0.1f;
            d0 *= 0.5;
            d1 *= 0.5;
            if (p_38165_ instanceof AbstractMinecart) {
                AbstractMinecart abstractminecart = (AbstractMinecart)((Object)p_38165_);
                this.pushOtherMinecart(abstractminecart, d0, d1);
            } else {
                this.push(-d0, 0.0, -d1);
                p_38165_.push(d0 / 4.0, 0.0, d1 / 4.0);
            }
        }
    }

    private void pushOtherMinecart(AbstractMinecart p_374524_, double p_374304_, double p_374378_) {
        double d1;
        double d0;
        if (AbstractMinecart.useExperimentalMovement(this.level())) {
            d0 = this.getDeltaMovement().x;
            d1 = this.getDeltaMovement().z;
        } else {
            d0 = p_374524_.getX() - this.getX();
            d1 = p_374524_.getZ() - this.getZ();
        }
        Vec3 vec3 = new Vec3(d0, 0.0, d1).normalize();
        Vec3 vec31 = new Vec3((double)Mth.cos((float)(this.getYRot() * ((float)Math.PI / 180))), 0.0, (double)Mth.sin((float)(this.getYRot() * ((float)Math.PI / 180)))).normalize();
        double d2 = Math.abs(vec3.dot(vec31));
        if (!(d2 < (double)0.8f) || AbstractMinecart.useExperimentalMovement(this.level())) {
            Vec3 vec32 = this.getDeltaMovement();
            Vec3 vec33 = p_374524_.getDeltaMovement();
            if (p_374524_.isFurnace() && !this.isFurnace()) {
                this.setDeltaMovement(vec32.multiply(0.2, 1.0, 0.2));
                this.push(vec33.x - p_374304_, 0.0, vec33.z - p_374378_);
                p_374524_.setDeltaMovement(vec33.multiply(0.95, 1.0, 0.95));
            } else if (!p_374524_.isFurnace() && this.isFurnace()) {
                p_374524_.setDeltaMovement(vec33.multiply(0.2, 1.0, 0.2));
                p_374524_.push(vec32.x + p_374304_, 0.0, vec32.z + p_374378_);
                this.setDeltaMovement(vec32.multiply(0.95, 1.0, 0.95));
            } else {
                double d3 = (vec33.x + vec32.x) / 2.0;
                double d4 = (vec33.z + vec32.z) / 2.0;
                this.setDeltaMovement(vec32.multiply(0.2, 1.0, 0.2));
                this.push(d3 - p_374304_, 0.0, d4 - p_374378_);
                p_374524_.setDeltaMovement(vec33.multiply(0.2, 1.0, 0.2));
                p_374524_.push(d3 + p_374304_, 0.0, d4 + p_374378_);
            }
        }
    }

    public BlockState getDisplayBlockState() {
        return !this.hasCustomDisplay() ? this.getDefaultDisplayBlockState() : Block.stateById(this.getEntityData().get(DATA_ID_DISPLAY_BLOCK));
    }

    public BlockState getDefaultDisplayBlockState() {
        return Blocks.AIR.defaultBlockState();
    }

    public int getDisplayOffset() {
        return !this.hasCustomDisplay() ? this.getDefaultDisplayOffset() : this.getEntityData().get(DATA_ID_DISPLAY_OFFSET).intValue();
    }

    public int getDefaultDisplayOffset() {
        return 6;
    }

    public void setDisplayBlockState(BlockState p_38147_) {
        this.getEntityData().set(DATA_ID_DISPLAY_BLOCK, Block.getId(p_38147_));
        this.setCustomDisplay(true);
    }

    public void setDisplayOffset(int p_38175_) {
        this.getEntityData().set(DATA_ID_DISPLAY_OFFSET, p_38175_);
        this.setCustomDisplay(true);
    }

    public boolean hasCustomDisplay() {
        return this.getEntityData().get(DATA_ID_CUSTOM_DISPLAY);
    }

    public void setCustomDisplay(boolean p_38139_) {
        this.getEntityData().set(DATA_ID_CUSTOM_DISPLAY, p_38139_);
    }

    public static boolean useExperimentalMovement(Level p_360970_) {
        return p_360970_.enabledFeatures().contains(FeatureFlags.MINECART_IMPROVEMENTS);
    }

    public abstract ItemStack getPickResult();

    public boolean isRideable() {
        return false;
    }

    public boolean isFurnace() {
        return false;
    }
}

