/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.vehicle;

import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecartContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public interface ContainerEntity
extends Container,
MenuProvider {
    public Vec3 position();

    public AABB getBoundingBox();

    @Nullable
    public ResourceKey<LootTable> getContainerLootTable();

    public void setContainerLootTable(@Nullable ResourceKey<LootTable> var1);

    public long getContainerLootTableSeed();

    public void setContainerLootTableSeed(long var1);

    public NonNullList<ItemStack> getItemStacks();

    public void clearItemStacks();

    public Level level();

    public boolean isRemoved();

    default public boolean isEmpty() {
        return this.isChestVehicleEmpty();
    }

    default public void addChestVehicleSaveData(CompoundTag p_219944_, HolderLookup.Provider p_332101_) {
        if (this.getContainerLootTable() != null) {
            p_219944_.putString("LootTable", this.getContainerLootTable().location().toString());
            if (this.getContainerLootTableSeed() != 0L) {
                p_219944_.putLong("LootTableSeed", this.getContainerLootTableSeed());
            }
        } else {
            ContainerHelper.saveAllItems((CompoundTag)p_219944_, this.getItemStacks(), (HolderLookup.Provider)p_332101_);
        }
    }

    default public void readChestVehicleSaveData(CompoundTag p_219935_, HolderLookup.Provider p_331073_) {
        this.clearItemStacks();
        if (p_219935_.contains("LootTable", 8)) {
            this.setContainerLootTable(ResourceKey.create(Registries.LOOT_TABLE, ResourceLocation.parse(p_219935_.getString("LootTable"))));
            this.setContainerLootTableSeed(p_219935_.getLong("LootTableSeed"));
        } else {
            ContainerHelper.loadAllItems((CompoundTag)p_219935_, this.getItemStacks(), (HolderLookup.Provider)p_331073_);
        }
    }

    default public void chestVehicleDestroyed(DamageSource p_219928_, ServerLevel p_376406_, Entity p_219930_) {
        if (p_376406_.getGameRules().getBoolean(GameRules.RULE_DOENTITYDROPS)) {
            Containers.dropContents((Level)p_376406_, (Entity)p_219930_, (Container)this);
            Entity entity = p_219928_.getDirectEntity();
            if (entity != null && entity.getType() == EntityType.PLAYER) {
                PiglinAi.angerNearbyPiglins(p_376406_, (Player)entity, true);
            }
        }
    }

    default public InteractionResult interactWithContainerVehicle(Player p_270068_) {
        p_270068_.openMenu(this);
        return InteractionResult.SUCCESS;
    }

    default public void unpackChestVehicleLootTable(@Nullable Player p_219950_) {
        MinecraftServer minecraftserver = this.level().getServer();
        if (this.getContainerLootTable() != null && minecraftserver != null) {
            LootTable loottable = minecraftserver.reloadableRegistries().getLootTable(this.getContainerLootTable());
            if (p_219950_ != null) {
                CriteriaTriggers.GENERATE_LOOT.trigger((ServerPlayer)p_219950_, this.getContainerLootTable());
            }
            this.setContainerLootTable(null);
            LootParams.Builder lootparams$builder = new LootParams.Builder((ServerLevel)this.level()).withParameter(LootContextParams.ORIGIN, (Object)this.position());
            ContainerEntity containerEntity = this;
            if (containerEntity instanceof AbstractMinecartContainer) {
                AbstractMinecartContainer entityContainer = (AbstractMinecartContainer)containerEntity;
                lootparams$builder.withParameter(LootContextParams.ATTACKING_ENTITY, (Object)entityContainer);
            }
            if (p_219950_ != null) {
                lootparams$builder.withLuck(p_219950_.getLuck()).withParameter(LootContextParams.THIS_ENTITY, (Object)p_219950_);
            }
            loottable.fill(this, lootparams$builder.create(LootContextParamSets.CHEST), this.getContainerLootTableSeed());
        }
    }

    default public void clearChestVehicleContent() {
        this.unpackChestVehicleLootTable(null);
        this.getItemStacks().clear();
    }

    default public boolean isChestVehicleEmpty() {
        for (ItemStack itemstack : this.getItemStacks()) {
            if (itemstack.isEmpty()) continue;
            return false;
        }
        return true;
    }

    default public ItemStack removeChestVehicleItemNoUpdate(int p_219946_) {
        this.unpackChestVehicleLootTable(null);
        ItemStack itemstack = this.getItemStacks().get(p_219946_);
        if (itemstack.isEmpty()) {
            return ItemStack.EMPTY;
        }
        this.getItemStacks().set(p_219946_, ItemStack.EMPTY);
        return itemstack;
    }

    default public ItemStack getChestVehicleItem(int p_219948_) {
        this.unpackChestVehicleLootTable(null);
        return this.getItemStacks().get(p_219948_);
    }

    default public ItemStack removeChestVehicleItem(int p_219937_, int p_219938_) {
        this.unpackChestVehicleLootTable(null);
        return ContainerHelper.removeItem(this.getItemStacks(), (int)p_219937_, (int)p_219938_);
    }

    default public void setChestVehicleItem(int p_219941_, ItemStack p_219942_) {
        this.unpackChestVehicleLootTable(null);
        this.getItemStacks().set(p_219941_, p_219942_);
        p_219942_.limitSize(this.getMaxStackSize(p_219942_));
    }

    default public SlotAccess getChestVehicleSlot(final int p_219952_) {
        return p_219952_ >= 0 && p_219952_ < this.getContainerSize() ? new SlotAccess(){

            public ItemStack get() {
                return ContainerEntity.this.getChestVehicleItem(p_219952_);
            }

            public boolean set(ItemStack p_219964_) {
                ContainerEntity.this.setChestVehicleItem(p_219952_, p_219964_);
                return true;
            }
        } : SlotAccess.NULL;
    }

    default public boolean isChestVehicleStillValid(Player p_219955_) {
        return !this.isRemoved() && p_219955_.canInteractWithEntity(this.getBoundingBox(), 4.0);
    }
}

