/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.EncoderException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentHolder;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.component.PatchedDataComponentMap;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.stats.Stats;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.NullOps;
import net.minecraft.util.StringUtil;
import net.minecraft.util.Unit;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.AdventureModePredicate;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemUseAnimation;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.Consumable;
import net.minecraft.world.item.component.DamageResistant;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.item.component.TooltipProvider;
import net.minecraft.world.item.component.UseCooldown;
import net.minecraft.world.item.component.UseRemainder;
import net.minecraft.world.item.component.WrittenBookContent;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.item.enchantment.Repairable;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.level.saveddata.maps.MapId;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.common.MutableDataComponentHolder;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.extensions.IItemStackExtension;
import net.neoforged.neoforge.common.util.AttributeTooltipContext;
import net.neoforged.neoforge.common.util.AttributeUtil;
import net.neoforged.neoforge.common.util.DataComponentUtil;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.event.entity.player.UseItemOnBlockEvent;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.slf4j.Logger;

public final class ItemStack
implements DataComponentHolder,
IItemStackExtension,
MutableDataComponentHolder {
    public static final Codec<ItemStack> CODEC = Codec.lazyInitialized(() -> RecordCodecBuilder.create(p_381569_ -> p_381569_.group((App)Item.CODEC.fieldOf("id").forGetter(ItemStack::getItemHolder), (App)ExtraCodecs.intRange((int)1, (int)99).fieldOf("count").orElse((Object)1).forGetter(ItemStack::getCount), (App)DataComponentPatch.CODEC.optionalFieldOf("components", (Object)DataComponentPatch.EMPTY).forGetter(p_330103_ -> p_330103_.components.asPatch())).apply((Applicative)p_381569_, ItemStack::new)));
    public static final Codec<ItemStack> SINGLE_ITEM_CODEC = Codec.lazyInitialized(() -> RecordCodecBuilder.create(p_381570_ -> p_381570_.group((App)Item.CODEC.fieldOf("id").forGetter(ItemStack::getItemHolder), (App)DataComponentPatch.CODEC.optionalFieldOf("components", (Object)DataComponentPatch.EMPTY).forGetter(p_332616_ -> p_332616_.components.asPatch())).apply((Applicative)p_381570_, (p_332614_, p_332615_) -> new ItemStack((Holder<Item>)p_332614_, 1, (DataComponentPatch)p_332615_))));
    public static final Codec<ItemStack> STRICT_CODEC = CODEC.validate(ItemStack::validateStrict);
    public static final Codec<ItemStack> STRICT_SINGLE_ITEM_CODEC = SINGLE_ITEM_CODEC.validate(ItemStack::validateStrict);
    public static final Codec<ItemStack> OPTIONAL_CODEC = ExtraCodecs.optionalEmptyMap(CODEC).xmap(p_330099_ -> p_330099_.orElse(EMPTY), p_330101_ -> p_330101_.isEmpty() ? Optional.empty() : Optional.of(p_330101_));
    public static final Codec<ItemStack> SIMPLE_ITEM_CODEC = Item.CODEC.xmap(ItemStack::new, ItemStack::getItemHolder);
    public static final StreamCodec<RegistryFriendlyByteBuf, ItemStack> OPTIONAL_STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, ItemStack>(){
        private static final StreamCodec<RegistryFriendlyByteBuf, Holder<Item>> ITEM_STREAM_CODEC = ByteBufCodecs.holderRegistry(Registries.ITEM);

        public ItemStack decode(RegistryFriendlyByteBuf p_320491_) {
            int i = p_320491_.readVarInt();
            if (i <= 0) {
                return EMPTY;
            }
            Holder holder = (Holder)ITEM_STREAM_CODEC.decode((Object)p_320491_);
            DataComponentPatch datacomponentpatch = (DataComponentPatch)DataComponentPatch.STREAM_CODEC.decode((Object)p_320491_);
            return new ItemStack(holder, i, datacomponentpatch);
        }

        public void encode(RegistryFriendlyByteBuf p_320527_, ItemStack p_320873_) {
            if (p_320873_.isEmpty()) {
                p_320527_.writeVarInt(0);
            } else {
                p_320527_.writeVarInt(p_320873_.getCount());
                ITEM_STREAM_CODEC.encode((Object)p_320527_, p_320873_.getItemHolder());
                DataComponentPatch.STREAM_CODEC.encode((Object)p_320527_, (Object)p_320873_.components.asPatch());
            }
        }
    };
    public static final StreamCodec<RegistryFriendlyByteBuf, ItemStack> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, ItemStack>(){

        public ItemStack decode(RegistryFriendlyByteBuf p_330597_) {
            ItemStack itemstack = (ItemStack)OPTIONAL_STREAM_CODEC.decode((Object)p_330597_);
            if (itemstack.isEmpty()) {
                throw new DecoderException("Empty ItemStack not allowed");
            }
            return itemstack;
        }

        public void encode(RegistryFriendlyByteBuf p_331762_, ItemStack p_331138_) {
            if (p_331138_.isEmpty()) {
                throw new EncoderException("Empty ItemStack not allowed");
            }
            OPTIONAL_STREAM_CODEC.encode((Object)p_331762_, (Object)p_331138_);
        }
    };
    public static final StreamCodec<RegistryFriendlyByteBuf, List<ItemStack>> OPTIONAL_LIST_STREAM_CODEC = OPTIONAL_STREAM_CODEC.apply(ByteBufCodecs.collection(NonNullList::createWithCapacity));
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final ItemStack EMPTY = new ItemStack((Void)null);
    private static final Component DISABLED_ITEM_TOOLTIP = Component.translatable((String)"item.disabled").withStyle(ChatFormatting.RED);
    private int count;
    private int popTime;
    @Deprecated
    @Nullable
    private final Item item;
    final PatchedDataComponentMap components;
    @Nullable
    private Entity entityRepresentation;

    private static DataResult<ItemStack> validateStrict(ItemStack p_340966_) {
        DataResult<Unit> dataresult = ItemStack.validateComponents(p_340966_.getComponents());
        if (dataresult.isError()) {
            return dataresult.map(p_340777_ -> p_340966_);
        }
        return p_340966_.getCount() > p_340966_.getMaxStackSize() ? DataResult.error(() -> "Item stack with stack size of " + p_340966_.getCount() + " was larger than maximum: " + p_340966_.getMaxStackSize()) : DataResult.success((Object)p_340966_);
    }

    public static StreamCodec<RegistryFriendlyByteBuf, ItemStack> validatedStreamCodec(final StreamCodec<RegistryFriendlyByteBuf, ItemStack> p_340962_) {
        return new StreamCodec<RegistryFriendlyByteBuf, ItemStack>(){

            public ItemStack decode(RegistryFriendlyByteBuf p_341238_) {
                ItemStack itemstack = (ItemStack)p_340962_.decode((Object)p_341238_);
                if (!itemstack.isEmpty()) {
                    RegistryOps registryops = p_341238_.registryAccess().createSerializationContext((DynamicOps)NullOps.INSTANCE);
                    CODEC.encodeStart((DynamicOps)registryops, (Object)itemstack).getOrThrow(DecoderException::new);
                }
                return itemstack;
            }

            public void encode(RegistryFriendlyByteBuf p_341112_, ItemStack p_341358_) {
                p_340962_.encode((Object)p_341112_, (Object)p_341358_);
            }
        };
    }

    public Optional<TooltipComponent> getTooltipImage() {
        return this.getItem().getTooltipImage(this);
    }

    @Override
    public DataComponentMap getComponents() {
        return !this.isEmpty() ? this.components : DataComponentMap.EMPTY;
    }

    public void clearComponents() {
        this.components.clearPatch();
    }

    public DataComponentMap getPrototype() {
        return !this.isEmpty() ? this.getItem().components() : DataComponentMap.EMPTY;
    }

    public DataComponentPatch getComponentsPatch() {
        return !this.isEmpty() ? this.components.asPatch() : DataComponentPatch.EMPTY;
    }

    public boolean isComponentsPatchEmpty() {
        return !this.isEmpty() ? this.components.isPatchEmpty() : true;
    }

    public ItemStack(ItemLike p_41599_) {
        this(p_41599_, 1);
    }

    public ItemStack(Holder<Item> p_204116_) {
        this(p_204116_.value(), 1);
    }

    public ItemStack(Holder<Item> p_312081_, int p_41605_, DataComponentPatch p_330362_) {
        this(p_312081_.value(), p_41605_, PatchedDataComponentMap.fromPatch(p_312081_.value().components(), p_330362_));
    }

    public ItemStack(Holder<Item> p_220155_, int p_220156_) {
        this(p_220155_.value(), p_220156_);
    }

    public ItemStack(ItemLike p_41601_, int p_41602_) {
        this(p_41601_, p_41602_, new PatchedDataComponentMap(p_41601_.asItem().components()));
    }

    private ItemStack(ItemLike p_330978_, int p_330639_, PatchedDataComponentMap p_330546_) {
        this.item = p_330978_.asItem();
        this.count = p_330639_;
        this.components = p_330546_;
        this.getItem().verifyComponentsAfterLoad(this);
    }

    private ItemStack(@Nullable Void p_282703_) {
        this.item = null;
        this.components = new PatchedDataComponentMap(DataComponentMap.EMPTY);
    }

    public static DataResult<Unit> validateComponents(DataComponentMap p_341201_) {
        if (p_341201_.has(DataComponents.MAX_DAMAGE) && p_341201_.getOrDefault(DataComponents.MAX_STACK_SIZE, 1) > 1) {
            return DataResult.error(() -> "Item cannot be both damageable and stackable");
        }
        ItemContainerContents itemcontainercontents = p_341201_.getOrDefault(DataComponents.CONTAINER, ItemContainerContents.EMPTY);
        for (ItemStack itemstack : itemcontainercontents.nonEmptyItems()) {
            int j;
            int i = itemstack.getCount();
            if (i <= (j = itemstack.getMaxStackSize())) continue;
            return DataResult.error(() -> "Item stack with count of " + i + " was larger than maximum: " + j);
        }
        return DataResult.success((Object)Unit.INSTANCE);
    }

    public static Optional<ItemStack> parse(HolderLookup.Provider p_331096_, Tag p_330238_) {
        return CODEC.parse(p_331096_.createSerializationContext(NbtOps.INSTANCE), (Object)p_330238_).resultOrPartial(p_330102_ -> LOGGER.error("Tried to load invalid item: '{}'", p_330102_));
    }

    public static ItemStack parseOptional(HolderLookup.Provider p_330543_, CompoundTag p_330539_) {
        return p_330539_.isEmpty() ? EMPTY : ItemStack.parse(p_330543_, p_330539_).orElse(EMPTY);
    }

    public boolean isEmpty() {
        return this == EMPTY || this.item == Items.AIR || this.count <= 0;
    }

    public boolean isItemEnabled(FeatureFlagSet p_250869_) {
        return this.isEmpty() || this.getItem().isEnabled(p_250869_);
    }

    public ItemStack split(int p_41621_) {
        int i = Math.min(p_41621_, this.getCount());
        ItemStack itemstack = this.copyWithCount(i);
        this.shrink(i);
        return itemstack;
    }

    public ItemStack copyAndClear() {
        if (this.isEmpty()) {
            return EMPTY;
        }
        ItemStack itemstack = this.copy();
        this.setCount(0);
        return itemstack;
    }

    public Item getItem() {
        return this.isEmpty() ? Items.AIR : this.item;
    }

    public Holder<Item> getItemHolder() {
        return this.getItem().builtInRegistryHolder();
    }

    public boolean is(TagKey<Item> p_204118_) {
        return this.getItem().builtInRegistryHolder().is(p_204118_);
    }

    public boolean is(Item p_150931_) {
        return this.getItem() == p_150931_;
    }

    public boolean is(Predicate<Holder<Item>> p_220168_) {
        return p_220168_.test(this.getItem().builtInRegistryHolder());
    }

    public boolean is(Holder<Item> p_220166_) {
        return this.is(p_220166_.value());
    }

    public boolean is(HolderSet<Item> p_298683_) {
        return p_298683_.contains(this.getItemHolder());
    }

    public Stream<TagKey<Item>> getTags() {
        return this.getItem().builtInRegistryHolder().tags();
    }

    public InteractionResult useOn(UseOnContext p_41662_) {
        UseItemOnBlockEvent e = (UseItemOnBlockEvent)NeoForge.EVENT_BUS.post((Event)new UseItemOnBlockEvent(p_41662_, UseItemOnBlockEvent.UsePhase.ITEM_AFTER_BLOCK));
        if (e.isCanceled()) {
            return e.getCancellationResult();
        }
        if (!p_41662_.getLevel().isClientSide) {
            return CommonHooks.onPlaceItemIntoWorld((UseOnContext)p_41662_);
        }
        return this.onItemUse(p_41662_, c -> this.getItem().useOn(p_41662_));
    }

    public InteractionResult onItemUseFirst(UseOnContext p_41662_) {
        UseItemOnBlockEvent e = (UseItemOnBlockEvent)NeoForge.EVENT_BUS.post((Event)new UseItemOnBlockEvent(p_41662_, UseItemOnBlockEvent.UsePhase.ITEM_BEFORE_BLOCK));
        if (e.isCanceled()) {
            return e.getCancellationResult();
        }
        return this.onItemUse(p_41662_, c -> this.getItem().onItemUseFirst(this, p_41662_));
    }

    private InteractionResult onItemUse(UseOnContext p_41662_, Function<UseOnContext, InteractionResult> callback) {
        InteractionResult.Success interactionresult$success;
        Player player = p_41662_.getPlayer();
        BlockPos blockpos = p_41662_.getClickedPos();
        if (player != null && !player.getAbilities().mayBuild && !this.canPlaceOnBlockInAdventureMode(new BlockInWorld((LevelReader)((Object)p_41662_.getLevel()), blockpos, false))) {
            return InteractionResult.PASS;
        }
        Item item = this.getItem();
        InteractionResult interactionresult = callback.apply(p_41662_);
        if (player != null && interactionresult instanceof InteractionResult.Success && (interactionresult$success = (InteractionResult.Success)interactionresult).wasItemInteraction()) {
            player.awardStat(Stats.ITEM_USED.get((Object)item));
        }
        return interactionresult;
    }

    public float getDestroySpeed(BlockState p_41692_) {
        return this.getItem().getDestroySpeed(this, p_41692_);
    }

    public InteractionResult use(Level p_41683_, Player p_41684_, InteractionHand p_41685_) {
        InteractionResult.Success interactionresult$success;
        ItemStack itemstack = this.copy();
        boolean flag = this.getUseDuration(p_41684_) <= 0;
        InteractionResult interactionresult = this.getItem().use(p_41683_, p_41684_, p_41685_);
        return flag && interactionresult instanceof InteractionResult.Success ? interactionresult$success.heldItemTransformedTo((interactionresult$success = (InteractionResult.Success)interactionresult).heldItemTransformedTo() == null ? this.applyAfterUseComponentSideEffects(p_41684_, itemstack) : interactionresult$success.heldItemTransformedTo().applyAfterUseComponentSideEffects(p_41684_, itemstack)) : interactionresult;
    }

    public ItemStack finishUsingItem(Level p_41672_, LivingEntity p_41673_) {
        ItemStack itemstack = this.copy();
        ItemStack itemstack1 = this.getItem().finishUsingItem(this, p_41672_, p_41673_);
        return itemstack1.applyAfterUseComponentSideEffects(p_41673_, itemstack);
    }

    private ItemStack applyAfterUseComponentSideEffects(LivingEntity p_366464_, ItemStack p_366810_) {
        UseRemainder useremainder = (UseRemainder)p_366810_.get(DataComponents.USE_REMAINDER);
        UseCooldown usecooldown = (UseCooldown)p_366810_.get(DataComponents.USE_COOLDOWN);
        int i = p_366810_.getCount();
        ItemStack itemstack = this;
        if (useremainder != null) {
            itemstack = useremainder.convertIntoRemainder(this, i, p_366464_.hasInfiniteMaterials(), p_366464_::handleExtraItemsCreatedOnUse);
        }
        if (usecooldown != null) {
            usecooldown.apply(p_366810_, p_366464_);
        }
        return itemstack;
    }

    public Tag save(HolderLookup.Provider p_331900_, Tag p_330830_) {
        if (this.isEmpty()) {
            throw new IllegalStateException("Cannot encode empty ItemStack");
        }
        return DataComponentUtil.wrapEncodingExceptions((DataComponentHolder)this, CODEC, (HolderLookup.Provider)p_331900_, (Tag)p_330830_);
    }

    public Tag save(HolderLookup.Provider p_332160_) {
        if (this.isEmpty()) {
            throw new IllegalStateException("Cannot encode empty ItemStack");
        }
        return DataComponentUtil.wrapEncodingExceptions((DataComponentHolder)this, CODEC, (HolderLookup.Provider)p_332160_);
    }

    public Tag saveOptional(HolderLookup.Provider p_330895_) {
        return this.isEmpty() ? new CompoundTag() : this.save(p_330895_, new CompoundTag());
    }

    public int getMaxStackSize() {
        return this.getItem().getMaxStackSize(this);
    }

    public boolean isStackable() {
        return this.getMaxStackSize() > 1 && (!this.isDamageableItem() || !this.isDamaged());
    }

    public boolean isDamageableItem() {
        return this.has(DataComponents.MAX_DAMAGE) && !this.has(DataComponents.UNBREAKABLE) && this.has(DataComponents.DAMAGE);
    }

    public boolean isDamaged() {
        return this.isDamageableItem() && this.getItem().isDamaged(this);
    }

    public int getDamageValue() {
        return this.getItem().getDamage(this);
    }

    public void setDamageValue(int p_41722_) {
        this.getItem().setDamage(this, p_41722_);
    }

    public int getMaxDamage() {
        return this.getItem().getMaxDamage(this);
    }

    public boolean isBroken() {
        return this.isDamageableItem() && this.getDamageValue() >= this.getMaxDamage();
    }

    public boolean nextDamageWillBreak() {
        return this.isDamageableItem() && this.getDamageValue() >= this.getMaxDamage() - 1;
    }

    public void hurtAndBreak(int p_220158_, ServerLevel p_346256_, @Nullable ServerPlayer p_220160_, Consumer<Item> p_348596_) {
        this.hurtAndBreak(p_220158_, p_346256_, (LivingEntity)p_220160_, p_348596_);
    }

    public void hurtAndBreak(int p_220158_, ServerLevel p_346256_, @Nullable LivingEntity p_220160_, Consumer<Item> p_348596_) {
        p_220158_ = this.getItem().damageItem(this, p_220158_, p_220160_, p_348596_);
        int i = this.processDurabilityChange(p_220158_, p_346256_, p_220160_);
        if (i != 0) {
            this.applyDamage(this.getDamageValue() + i, p_220160_, p_348596_);
        }
    }

    private int processDurabilityChange(int p_361290_, ServerLevel p_361409_, @Nullable ServerPlayer p_364940_) {
        return this.processDurabilityChange(p_361290_, p_361409_, (LivingEntity)p_364940_);
    }

    private int processDurabilityChange(int p_361290_, ServerLevel p_361409_, @Nullable LivingEntity p_364940_) {
        if (!this.isDamageableItem()) {
            return 0;
        }
        if (p_364940_ != null && p_364940_.hasInfiniteMaterials()) {
            return 0;
        }
        return p_361290_ > 0 ? EnchantmentHelper.processDurabilityChange(p_361409_, this, p_361290_) : p_361290_;
    }

    private void applyDamage(int p_361754_, @Nullable ServerPlayer p_364853_, Consumer<Item> p_360895_) {
        this.applyDamage(p_361754_, (LivingEntity)p_364853_, p_360895_);
    }

    private void applyDamage(int p_361754_, @Nullable LivingEntity p_364853_, Consumer<Item> p_360895_) {
        if (p_364853_ instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)p_364853_;
            CriteriaTriggers.ITEM_DURABILITY_CHANGED.trigger(serverPlayer, this, p_361754_);
        }
        this.setDamageValue(p_361754_);
        if (this.isBroken()) {
            Item item = this.getItem();
            this.shrink(1);
            p_360895_.accept(item);
        }
    }

    public void hurtWithoutBreaking(int p_362924_, Player p_363410_) {
        if (p_363410_ instanceof ServerPlayer) {
            ServerPlayer serverplayer = (ServerPlayer)p_363410_;
            int i = this.processDurabilityChange(p_362924_, serverplayer.serverLevel(), serverplayer);
            if (i == 0) {
                return;
            }
            int j = Math.min(this.getDamageValue() + i, this.getMaxDamage() - 1);
            this.applyDamage(j, serverplayer, (Item p_360034_) -> {});
        }
    }

    public void hurtAndBreak(int p_41623_, LivingEntity p_41624_, EquipmentSlot p_319898_) {
        Level level = p_41624_.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)level;
            this.hurtAndBreak(p_41623_, serverlevel, p_41624_, (Item p_348383_) -> p_41624_.onEquippedItemBroken((Item)p_348383_, p_319898_));
        }
    }

    public ItemStack hurtAndConvertOnBreak(int p_352405_, ItemLike p_352337_, LivingEntity p_352175_, EquipmentSlot p_352058_) {
        this.hurtAndBreak(p_352405_, p_352175_, p_352058_);
        if (this.isEmpty()) {
            ItemStack itemstack = this.transmuteCopyIgnoreEmpty(p_352337_, 1);
            if (itemstack.isDamageableItem()) {
                itemstack.setDamageValue(0);
            }
            return itemstack;
        }
        return this;
    }

    public boolean isBarVisible() {
        return this.getItem().isBarVisible(this);
    }

    public int getBarWidth() {
        return this.getItem().getBarWidth(this);
    }

    public int getBarColor() {
        return this.getItem().getBarColor(this);
    }

    public boolean overrideStackedOnOther(Slot p_150927_, ClickAction p_150928_, Player p_150929_) {
        return this.getItem().overrideStackedOnOther(this, p_150927_, p_150928_, p_150929_);
    }

    public boolean overrideOtherStackedOnMe(ItemStack p_150933_, Slot p_150934_, ClickAction p_150935_, Player p_150936_, SlotAccess p_150937_) {
        return this.getItem().overrideOtherStackedOnMe(this, p_150933_, p_150934_, p_150935_, p_150936_, p_150937_);
    }

    public boolean hurtEnemy(LivingEntity p_41641_, LivingEntity p_364087_) {
        Item item = this.getItem();
        if (item.hurtEnemy(this, p_41641_, p_364087_)) {
            if (p_364087_ instanceof Player) {
                Player player = (Player)p_364087_;
                player.awardStat(Stats.ITEM_USED.get((Object)item));
            }
            return true;
        }
        return false;
    }

    public void postHurtEnemy(LivingEntity p_346409_, LivingEntity p_363649_) {
        this.getItem().postHurtEnemy(this, p_346409_, p_363649_);
    }

    public void mineBlock(Level p_41687_, BlockState p_41688_, BlockPos p_41689_, Player p_41690_) {
        Item item = this.getItem();
        if (item.mineBlock(this, p_41687_, p_41688_, p_41689_, p_41690_)) {
            p_41690_.awardStat(Stats.ITEM_USED.get((Object)item));
        }
    }

    public boolean isCorrectToolForDrops(BlockState p_41736_) {
        return this.getItem().isCorrectToolForDrops(this, p_41736_);
    }

    public InteractionResult interactLivingEntity(Player p_41648_, LivingEntity p_41649_, InteractionHand p_41650_) {
        return this.getItem().interactLivingEntity(this, p_41648_, p_41649_, p_41650_);
    }

    public ItemStack copy() {
        if (this.isEmpty()) {
            return EMPTY;
        }
        ItemStack itemstack = new ItemStack(this.getItem(), this.count, this.components.copy());
        itemstack.setPopTime(this.getPopTime());
        return itemstack;
    }

    public ItemStack copyWithCount(int p_256354_) {
        if (this.isEmpty()) {
            return EMPTY;
        }
        ItemStack itemstack = this.copy();
        itemstack.setCount(p_256354_);
        return itemstack;
    }

    public ItemStack transmuteCopy(ItemLike p_347550_) {
        return this.transmuteCopy(p_347550_, this.getCount());
    }

    public ItemStack transmuteCopy(ItemLike p_323864_, int p_323647_) {
        return this.isEmpty() ? EMPTY : this.transmuteCopyIgnoreEmpty(p_323864_, p_323647_);
    }

    private ItemStack transmuteCopyIgnoreEmpty(ItemLike p_323811_, int p_323856_) {
        return new ItemStack(p_323811_.asItem().builtInRegistryHolder(), p_323856_, this.components.asPatch());
    }

    public static boolean matches(ItemStack p_41729_, ItemStack p_41730_) {
        if (p_41729_ == p_41730_) {
            return true;
        }
        return p_41729_.getCount() != p_41730_.getCount() ? false : ItemStack.isSameItemSameComponents(p_41729_, p_41730_);
    }

    @Deprecated
    public static boolean listMatches(List<ItemStack> p_331725_, List<ItemStack> p_331113_) {
        if (p_331725_.size() != p_331113_.size()) {
            return false;
        }
        for (int i = 0; i < p_331725_.size(); ++i) {
            if (ItemStack.matches(p_331725_.get(i), p_331113_.get(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isSameItem(ItemStack p_287761_, ItemStack p_287676_) {
        return p_287761_.is(p_287676_.getItem());
    }

    public static boolean isSameItemSameComponents(ItemStack p_150943_, ItemStack p_150944_) {
        if (!p_150943_.is(p_150944_.getItem())) {
            return false;
        }
        return p_150943_.isEmpty() && p_150944_.isEmpty() ? true : Objects.equals(p_150943_.components, p_150944_.components);
    }

    public static MapCodec<ItemStack> lenientOptionalFieldOf(String p_338501_) {
        return CODEC.lenientOptionalFieldOf(p_338501_).xmap(p_323389_ -> p_323389_.orElse(EMPTY), p_323388_ -> p_323388_.isEmpty() ? Optional.empty() : Optional.of(p_323388_));
    }

    public static int hashItemAndComponents(@Nullable ItemStack p_331961_) {
        if (p_331961_ != null) {
            int i = 31 + p_331961_.getItem().hashCode();
            return 31 * i + p_331961_.getComponents().hashCode();
        }
        return 0;
    }

    @Deprecated
    public static int hashStackList(List<ItemStack> p_332135_) {
        int i = 0;
        for (ItemStack itemstack : p_332135_) {
            i = i * 31 + ItemStack.hashItemAndComponents(itemstack);
        }
        return i;
    }

    public String toString() {
        return this.getCount() + " " + String.valueOf(this.getItem());
    }

    public void inventoryTick(Level p_41667_, Entity p_41668_, int p_41669_, boolean p_41670_) {
        if (this.popTime > 0) {
            --this.popTime;
        }
        if (this.getItem() != null) {
            this.getItem().inventoryTick(this, p_41667_, p_41668_, p_41669_, p_41670_);
        }
    }

    public void onCraftedBy(Level p_41679_, Player p_41680_, int p_41681_) {
        p_41680_.awardStat(Stats.ITEM_CRAFTED.get((Object)this.getItem()), p_41681_);
        this.getItem().onCraftedBy(this, p_41679_, p_41680_);
    }

    public void onCraftedBySystem(Level p_307669_) {
        this.getItem().onCraftedPostProcess(this, p_307669_);
    }

    public int getUseDuration(LivingEntity p_345724_) {
        return this.getItem().getUseDuration(this, p_345724_);
    }

    public ItemUseAnimation getUseAnimation() {
        return this.getItem().getUseAnimation(this);
    }

    public void releaseUsing(Level p_41675_, LivingEntity p_41676_, int p_41677_) {
        ItemStack itemstack1;
        ItemStack itemstack = this.copy();
        if (this.getItem().releaseUsing(this, p_41675_, p_41676_, p_41677_) && (itemstack1 = this.applyAfterUseComponentSideEffects(p_41676_, itemstack)) != this) {
            p_41676_.setItemInHand(p_41676_.getUsedItemHand(), itemstack1);
        }
    }

    public boolean useOnRelease() {
        return this.getItem().useOnRelease(this);
    }

    @Nullable
    public <T> T set(DataComponentType<? super T> p_331064_, @Nullable T p_330775_) {
        return this.components.set(p_331064_, p_330775_);
    }

    @Nullable
    public <T, U> T update(DataComponentType<T> p_331083_, T p_331443_, U p_331049_, BiFunction<T, U, T> p_331846_) {
        return this.set(p_331083_, p_331846_.apply(this.getOrDefault(p_331083_, p_331443_), p_331049_));
    }

    @Nullable
    public <T> T update(DataComponentType<T> p_330921_, T p_331257_, UnaryOperator<T> p_331701_) {
        T t = this.getOrDefault(p_330921_, p_331257_);
        return this.set(p_330921_, p_331701_.apply(t));
    }

    @Nullable
    public <T> T remove(DataComponentType<? extends T> p_332139_) {
        return this.components.remove(p_332139_);
    }

    public void applyComponentsAndValidate(DataComponentPatch p_341407_) {
        DataComponentPatch datacomponentpatch = this.components.asPatch();
        this.components.applyPatch(p_341407_);
        Optional optional = ItemStack.validateStrict(this).error();
        if (optional.isPresent()) {
            LOGGER.error("Failed to apply component patch '{}' to item: '{}'", (Object)p_341407_, (Object)((DataResult.Error)optional.get()).message());
            this.components.restorePatch(datacomponentpatch);
        } else {
            this.getItem().verifyComponentsAfterLoad(this);
        }
    }

    public void applyComponents(DataComponentPatch p_332097_) {
        this.components.applyPatch(p_332097_);
        this.getItem().verifyComponentsAfterLoad(this);
    }

    public void applyComponents(DataComponentMap p_330402_) {
        this.components.setAll(p_330402_);
        this.getItem().verifyComponentsAfterLoad(this);
    }

    public Component getHoverName() {
        String s;
        Component component = (Component)this.get(DataComponents.CUSTOM_NAME);
        if (component != null) {
            return component;
        }
        WrittenBookContent writtenbookcontent = (WrittenBookContent)this.get(DataComponents.WRITTEN_BOOK_CONTENT);
        if (writtenbookcontent != null && !StringUtil.isBlank((String)(s = (String)writtenbookcontent.title().raw()))) {
            return Component.literal((String)s);
        }
        return this.getItemName();
    }

    public Component getItemName() {
        return this.getItem().getName(this);
    }

    public Component getStyledHoverName() {
        MutableComponent mutablecomponent = Component.empty().append(this.getHoverName()).withStyle(this.getRarity().getStyleModifier());
        if (this.has(DataComponents.CUSTOM_NAME)) {
            mutablecomponent.withStyle(ChatFormatting.ITALIC);
        }
        return mutablecomponent;
    }

    public <T extends TooltipProvider> void addToTooltip(DataComponentType<T> p_331344_, Item.TooltipContext p_341231_, Consumer<Component> p_331885_, TooltipFlag p_331177_) {
        TooltipProvider t = (TooltipProvider)this.get(p_331344_);
        if (t != null) {
            t.addToTooltip(p_341231_, p_331885_, p_331177_);
        }
    }

    public List<Component> getTooltipLines(Item.TooltipContext p_339637_, @Nullable Player p_41652_, TooltipFlag p_41653_) {
        AdventureModePredicate adventuremodepredicate1;
        MapId mapid;
        if (!p_41653_.isCreative() && this.has(DataComponents.HIDE_TOOLTIP)) {
            return List.of();
        }
        ArrayList list = Lists.newArrayList();
        list.add(this.getStyledHoverName());
        if (!p_41653_.isAdvanced() && !this.has(DataComponents.CUSTOM_NAME) && (mapid = (MapId)this.get(DataComponents.MAP_ID)) != null) {
            list.add(MapItem.getTooltipForId(mapid));
        }
        Consumer<Component> consumer = list::add;
        if (!this.has(DataComponents.HIDE_ADDITIONAL_TOOLTIP)) {
            this.getItem().appendHoverText(this, p_339637_, list, p_41653_);
        }
        this.addToTooltip(DataComponents.JUKEBOX_PLAYABLE, p_339637_, consumer, p_41653_);
        this.addToTooltip(DataComponents.TRIM, p_339637_, consumer, p_41653_);
        this.addToTooltip(DataComponents.STORED_ENCHANTMENTS, p_339637_, consumer, p_41653_);
        this.addToTooltip(DataComponents.ENCHANTMENTS, p_339637_, consumer, p_41653_);
        this.addToTooltip(DataComponents.DYED_COLOR, p_339637_, consumer, p_41653_);
        this.addToTooltip(DataComponents.LORE, p_339637_, consumer, p_41653_);
        AttributeUtil.addAttributeTooltips((ItemStack)this, consumer, (AttributeTooltipContext)AttributeTooltipContext.of((Player)p_41652_, (Item.TooltipContext)p_339637_, (TooltipFlag)p_41653_));
        this.addToTooltip(DataComponents.UNBREAKABLE, p_339637_, consumer, p_41653_);
        this.addToTooltip(DataComponents.OMINOUS_BOTTLE_AMPLIFIER, p_339637_, consumer, p_41653_);
        this.addToTooltip(DataComponents.SUSPICIOUS_STEW_EFFECTS, p_339637_, consumer, p_41653_);
        AdventureModePredicate adventuremodepredicate = (AdventureModePredicate)this.get(DataComponents.CAN_BREAK);
        if (adventuremodepredicate != null && adventuremodepredicate.showInTooltip()) {
            consumer.accept(CommonComponents.EMPTY);
            consumer.accept(AdventureModePredicate.CAN_BREAK_HEADER);
            adventuremodepredicate.addToTooltip(consumer);
        }
        if ((adventuremodepredicate1 = (AdventureModePredicate)this.get(DataComponents.CAN_PLACE_ON)) != null && adventuremodepredicate1.showInTooltip()) {
            consumer.accept(CommonComponents.EMPTY);
            consumer.accept(AdventureModePredicate.CAN_PLACE_HEADER);
            adventuremodepredicate1.addToTooltip(consumer);
        }
        if (p_41653_.isAdvanced()) {
            if (this.isDamaged()) {
                list.add(Component.translatable((String)"item.durability", (Object[])new Object[]{this.getMaxDamage() - this.getDamageValue(), this.getMaxDamage()}));
            }
            list.add(Component.literal((String)BuiltInRegistries.ITEM.getKey((Object)this.getItem()).toString()).withStyle(ChatFormatting.DARK_GRAY));
            int i = this.components.size();
            if (i > 0) {
                list.add(Component.translatable((String)"item.components", (Object[])new Object[]{i}).withStyle(ChatFormatting.DARK_GRAY));
            }
        }
        if (p_41652_ != null && !this.getItem().isEnabled(p_41652_.level().enabledFeatures())) {
            list.add(DISABLED_ITEM_TOOLTIP);
        }
        EventHooks.onItemTooltip((ItemStack)this, (Player)p_41652_, (List)list, (TooltipFlag)p_41653_, (Item.TooltipContext)p_339637_);
        return list;
    }

    @Deprecated
    private void addAttributeTooltips(Consumer<Component> p_330796_, @Nullable Player p_330530_) {
        ItemAttributeModifiers itemattributemodifiers = this.getOrDefault(DataComponents.ATTRIBUTE_MODIFIERS, ItemAttributeModifiers.EMPTY);
        if (itemattributemodifiers.showInTooltip()) {
            for (EquipmentSlotGroup equipmentslotgroup : EquipmentSlotGroup.values()) {
                MutableBoolean mutableboolean = new MutableBoolean(true);
                this.forEachModifier(equipmentslotgroup, (Holder<Attribute> p_348379_, AttributeModifier p_348380_) -> {
                    if (mutableboolean.isTrue()) {
                        p_330796_.accept(CommonComponents.EMPTY);
                        p_330796_.accept((Component)Component.translatable((String)("item.modifiers." + equipmentslotgroup.getSerializedName())).withStyle(ChatFormatting.GRAY));
                        mutableboolean.setFalse();
                    }
                    this.addModifierTooltip(p_330796_, p_330530_, (Holder<Attribute>)p_348379_, (AttributeModifier)p_348380_);
                });
            }
        }
    }

    private void addModifierTooltip(Consumer<Component> p_331062_, @Nullable Player p_330317_, Holder<Attribute> p_330626_, AttributeModifier p_331252_) {
        double d0 = p_331252_.amount();
        boolean flag = false;
        if (p_330317_ != null) {
            if (p_331252_.is(Item.BASE_ATTACK_DAMAGE_ID)) {
                d0 += p_330317_.getAttributeBaseValue(Attributes.ATTACK_DAMAGE);
                flag = true;
            } else if (p_331252_.is(Item.BASE_ATTACK_SPEED_ID)) {
                d0 += p_330317_.getAttributeBaseValue(Attributes.ATTACK_SPEED);
                flag = true;
            }
        }
        double d1 = p_331252_.operation() == AttributeModifier.Operation.ADD_MULTIPLIED_BASE || p_331252_.operation() == AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL ? d0 * 100.0 : (p_330626_.is(Attributes.KNOCKBACK_RESISTANCE) ? d0 * 10.0 : d0);
        if (flag) {
            p_331062_.accept((Component)CommonComponents.space().append((Component)Component.translatable((String)("attribute.modifier.equals." + p_331252_.operation().id()), (Object[])new Object[]{ItemAttributeModifiers.ATTRIBUTE_MODIFIER_FORMAT.format(d1), Component.translatable((String)p_330626_.value().getDescriptionId())})).withStyle(ChatFormatting.DARK_GREEN));
        } else if (d0 > 0.0) {
            p_331062_.accept((Component)Component.translatable((String)("attribute.modifier.plus." + p_331252_.operation().id()), (Object[])new Object[]{ItemAttributeModifiers.ATTRIBUTE_MODIFIER_FORMAT.format(d1), Component.translatable((String)p_330626_.value().getDescriptionId())}).withStyle(p_330626_.value().getStyle(true)));
        } else if (d0 < 0.0) {
            p_331062_.accept((Component)Component.translatable((String)("attribute.modifier.take." + p_331252_.operation().id()), (Object[])new Object[]{ItemAttributeModifiers.ATTRIBUTE_MODIFIER_FORMAT.format(-d1), Component.translatable((String)p_330626_.value().getDescriptionId())}).withStyle(p_330626_.value().getStyle(false)));
        }
    }

    public boolean hasFoil() {
        Boolean obool = (Boolean)this.get(DataComponents.ENCHANTMENT_GLINT_OVERRIDE);
        return obool != null ? obool.booleanValue() : this.getItem().isFoil(this);
    }

    public Rarity getRarity() {
        Rarity rarity = this.getOrDefault(DataComponents.RARITY, Rarity.COMMON);
        if (!this.isEnchanted()) {
            return rarity;
        }
        return switch (rarity) {
            case Rarity.COMMON, Rarity.UNCOMMON -> Rarity.RARE;
            case Rarity.RARE -> Rarity.EPIC;
            default -> rarity;
        };
    }

    public boolean isEnchantable() {
        if (!this.has(DataComponents.ENCHANTABLE)) {
            return false;
        }
        ItemEnchantments itemenchantments = (ItemEnchantments)this.get(DataComponents.ENCHANTMENTS);
        return itemenchantments != null && itemenchantments.isEmpty();
    }

    public void enchant(Holder<Enchantment> p_344751_, int p_41665_) {
        EnchantmentHelper.updateEnchantments(this, p_344404_ -> p_344404_.upgrade(p_344751_, p_41665_));
    }

    public boolean isEnchanted() {
        return !this.getOrDefault(DataComponents.ENCHANTMENTS, ItemEnchantments.EMPTY).isEmpty();
    }

    public ItemEnchantments getTagEnchantments() {
        return this.getEnchantments();
    }

    @Deprecated
    public ItemEnchantments getEnchantments() {
        return this.getOrDefault(DataComponents.ENCHANTMENTS, ItemEnchantments.EMPTY);
    }

    public boolean isFramed() {
        return this.entityRepresentation instanceof ItemFrame;
    }

    public void setEntityRepresentation(@Nullable Entity p_41637_) {
        if (!this.isEmpty()) {
            this.entityRepresentation = p_41637_;
        }
    }

    @Nullable
    public ItemFrame getFrame() {
        return this.entityRepresentation instanceof ItemFrame ? (ItemFrame)((Object)this.getEntityRepresentation()) : null;
    }

    @Nullable
    public Entity getEntityRepresentation() {
        return !this.isEmpty() ? this.entityRepresentation : null;
    }

    public void forEachModifier(EquipmentSlotGroup p_348610_, BiConsumer<Holder<Attribute>, AttributeModifier> p_348516_) {
        this.getAttributeModifiers().forEach(p_348610_, p_348516_);
        EnchantmentHelper.forEachModifier(this, p_348610_, p_348516_);
    }

    public void forEachModifier(EquipmentSlot p_332001_, BiConsumer<Holder<Attribute>, AttributeModifier> p_330882_) {
        this.getAttributeModifiers().forEach(p_332001_, p_330882_);
        EnchantmentHelper.forEachModifier(this, p_332001_, p_330882_);
    }

    public Component getDisplayName() {
        MutableComponent mutablecomponent = Component.empty().append(this.getHoverName());
        if (this.has(DataComponents.CUSTOM_NAME)) {
            mutablecomponent.withStyle(ChatFormatting.ITALIC);
        }
        MutableComponent mutablecomponent1 = ComponentUtils.wrapInSquareBrackets((Component)mutablecomponent);
        if (!this.isEmpty()) {
            mutablecomponent1.withStyle(this.getRarity().getStyleModifier()).withStyle(p_220170_ -> p_220170_.withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_ITEM, (Object)new HoverEvent.ItemStackInfo(this))));
        }
        return mutablecomponent1;
    }

    public boolean canPlaceOnBlockInAdventureMode(BlockInWorld p_331419_) {
        AdventureModePredicate adventuremodepredicate = (AdventureModePredicate)this.get(DataComponents.CAN_PLACE_ON);
        return adventuremodepredicate != null && adventuremodepredicate.test(p_331419_);
    }

    public boolean canBreakBlockInAdventureMode(BlockInWorld p_331592_) {
        AdventureModePredicate adventuremodepredicate = (AdventureModePredicate)this.get(DataComponents.CAN_BREAK);
        return adventuremodepredicate != null && adventuremodepredicate.test(p_331592_);
    }

    public int getPopTime() {
        return this.popTime;
    }

    public void setPopTime(int p_41755_) {
        this.popTime = p_41755_;
    }

    public int getCount() {
        return this.isEmpty() ? 0 : this.count;
    }

    public void setCount(int p_41765_) {
        this.count = p_41765_;
    }

    public void limitSize(int p_335437_) {
        if (!this.isEmpty() && this.getCount() > p_335437_) {
            this.setCount(p_335437_);
        }
    }

    public void grow(int p_41770_) {
        this.setCount(this.getCount() + p_41770_);
    }

    public void shrink(int p_41775_) {
        this.grow(-p_41775_);
    }

    public void consume(int p_326311_, @Nullable LivingEntity p_326200_) {
        if (p_326200_ == null || !p_326200_.hasInfiniteMaterials()) {
            this.shrink(p_326311_);
        }
    }

    public ItemStack consumeAndReturn(int p_347624_, @Nullable LivingEntity p_347710_) {
        ItemStack itemstack = this.copyWithCount(p_347624_);
        this.consume(p_347624_, p_347710_);
        return itemstack;
    }

    public void onUseTick(Level p_41732_, LivingEntity p_41733_, int p_41734_) {
        Consumable consumable = (Consumable)this.get(DataComponents.CONSUMABLE);
        if (consumable != null && consumable.shouldEmitParticlesAndSounds(p_41734_)) {
            consumable.emitParticlesAndSounds(p_41733_.getRandom(), p_41733_, this, 5);
        }
        this.getItem().onUseTick(p_41732_, p_41733_, this, p_41734_);
    }

    @Deprecated
    public void onDestroyed(ItemEntity p_150925_) {
        this.getItem().onDestroyed(p_150925_);
    }

    public SoundEvent getBreakingSound() {
        return this.getItem().getBreakingSound();
    }

    public boolean canBeHurtBy(DamageSource p_335431_) {
        if (!this.getItem().canBeHurtBy(this, p_335431_)) {
            return false;
        }
        DamageResistant damageresistant = (DamageResistant)this.get(DataComponents.DAMAGE_RESISTANT);
        return damageresistant == null || !damageresistant.isResistantTo(p_335431_);
    }

    public boolean isValidRepairItem(ItemStack p_362836_) {
        Repairable repairable = (Repairable)this.get(DataComponents.REPAIRABLE);
        return repairable != null && repairable.isValidRepairItem(p_362836_);
    }
}

