/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.consume_effects;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Fox;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.consume_effects.ConsumeEffect;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.event.entity.EntityTeleportEvent;

public record TeleportRandomlyConsumeEffect(float diameter) implements ConsumeEffect
{
    private static final float DEFAULT_DIAMETER = 16.0f;
    public static final MapCodec<TeleportRandomlyConsumeEffect> CODEC = RecordCodecBuilder.mapCodec(p_366612_ -> p_366612_.group((App)ExtraCodecs.POSITIVE_FLOAT.optionalFieldOf("diameter", (Object)Float.valueOf(16.0f)).forGetter(TeleportRandomlyConsumeEffect::diameter)).apply((Applicative)p_366612_, TeleportRandomlyConsumeEffect::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, TeleportRandomlyConsumeEffect> STREAM_CODEC = StreamCodec.composite(ByteBufCodecs.FLOAT, TeleportRandomlyConsumeEffect::diameter, TeleportRandomlyConsumeEffect::new);

    public TeleportRandomlyConsumeEffect() {
        this(16.0f);
    }

    public ConsumeEffect.Type<TeleportRandomlyConsumeEffect> getType() {
        return ConsumeEffect.Type.TELEPORT_RANDOMLY;
    }

    public boolean apply(Level p_366648_, ItemStack p_366476_, LivingEntity p_366884_) {
        boolean flag = false;
        for (int i = 0; i < 16; ++i) {
            SoundSource soundsource;
            SoundEvent soundevent;
            double d0 = p_366884_.getX() + (p_366884_.getRandom().nextDouble() - 0.5) * (double)this.diameter;
            double d1 = Mth.clamp((double)(p_366884_.getY() + (p_366884_.getRandom().nextDouble() - 0.5) * (double)this.diameter), (double)p_366648_.getMinY(), (double)(p_366648_.getMinY() + ((ServerLevel)p_366648_).getLogicalHeight() - 1));
            double d2 = p_366884_.getZ() + (p_366884_.getRandom().nextDouble() - 0.5) * (double)this.diameter;
            if (p_366884_.isPassenger()) {
                p_366884_.stopRiding();
            }
            Vec3 vec3 = p_366884_.position();
            EntityTeleportEvent.ItemConsumption event = EventHooks.onItemConsumptionTeleport((LivingEntity)p_366884_, (ItemStack)p_366476_, (double)d0, (double)d1, (double)d2);
            if (event.isCanceled()) {
                return false;
            }
            if (!p_366884_.randomTeleport(event.getTargetX(), event.getTargetY(), event.getTargetZ(), true)) continue;
            p_366648_.gameEvent(GameEvent.TELEPORT, vec3, GameEvent.Context.of((Entity)p_366884_));
            if (p_366884_ instanceof Fox) {
                soundevent = SoundEvents.FOX_TELEPORT;
                soundsource = SoundSource.NEUTRAL;
            } else {
                soundevent = SoundEvents.CHORUS_FRUIT_TELEPORT;
                soundsource = SoundSource.PLAYERS;
            }
            p_366648_.playSound(null, p_366884_.getX(), p_366884_.getY(), p_366884_.getZ(), soundevent, soundsource);
            p_366884_.resetFallDistance();
            flag = true;
            break;
        }
        if (flag && p_366884_ instanceof Player) {
            Player player = (Player)p_366884_;
            player.resetCurrentImpulseContext();
        }
        return flag;
    }
}

