/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.BannerItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BannerPatternLayers;

public class BannerDuplicateRecipe
extends CustomRecipe {
    public BannerDuplicateRecipe(CraftingBookCategory p_250373_) {
        super(p_250373_);
    }

    public boolean matches(CraftingInput p_346043_, Level p_43786_) {
        if (p_346043_.ingredientCount() != 2) {
            return false;
        }
        DyeColor dyecolor = null;
        boolean flag = false;
        boolean flag1 = false;
        for (int i = 0; i < p_346043_.size(); ++i) {
            ItemStack itemstack = p_346043_.getItem(i);
            if (itemstack.isEmpty()) continue;
            Item item = itemstack.getItem();
            if (!(item instanceof BannerItem)) {
                return false;
            }
            BannerItem banneritem = (BannerItem)item;
            if (dyecolor == null) {
                dyecolor = banneritem.getColor();
            } else if (dyecolor != banneritem.getColor()) {
                return false;
            }
            int j = itemstack.getOrDefault(DataComponents.BANNER_PATTERNS, BannerPatternLayers.EMPTY).layers().size();
            if (j > 6) {
                return false;
            }
            if (j > 0) {
                if (flag1) {
                    return false;
                }
                flag1 = true;
                continue;
            }
            if (flag) {
                return false;
            }
            flag = true;
        }
        return flag1 && flag;
    }

    public ItemStack assemble(CraftingInput p_346069_, HolderLookup.Provider p_335574_) {
        for (int i = 0; i < p_346069_.size(); ++i) {
            int j;
            ItemStack itemstack = p_346069_.getItem(i);
            if (itemstack.isEmpty() || (j = itemstack.getOrDefault(DataComponents.BANNER_PATTERNS, BannerPatternLayers.EMPTY).layers().size()) <= 0 || j > 6) continue;
            return itemstack.copyWithCount(1);
        }
        return ItemStack.EMPTY;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingInput p_345377_) {
        NonNullList<ItemStack> nonnulllist = NonNullList.withSize(p_345377_.size(), ItemStack.EMPTY);
        for (int i = 0; i < nonnulllist.size(); ++i) {
            ItemStack itemstack = p_345377_.getItem(i);
            if (itemstack.isEmpty()) continue;
            ItemStack itemstack1 = itemstack.getCraftingRemainder();
            if (!itemstack1.isEmpty()) {
                nonnulllist.set(i, itemstack1);
                continue;
            }
            if (itemstack.getOrDefault(DataComponents.BANNER_PATTERNS, BannerPatternLayers.EMPTY).layers().isEmpty()) continue;
            nonnulllist.set(i, itemstack.copyWithCount(1));
        }
        return nonnulllist;
    }

    public RecipeSerializer<BannerDuplicateRecipe> getSerializer() {
        return RecipeSerializer.BANNER_DUPLICATE;
    }
}

