/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import com.google.common.annotations.VisibleForTesting;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.JsonOps;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.TreeMap;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeAccess;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeMap;
import net.minecraft.world.item.crafting.RecipePropertySet;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SelectableRecipe;
import net.minecraft.world.item.crafting.SingleItemRecipe;
import net.minecraft.world.item.crafting.SmithingRecipe;
import net.minecraft.world.item.crafting.StonecutterRecipe;
import net.minecraft.world.item.crafting.display.RecipeDisplay;
import net.minecraft.world.item.crafting.display.RecipeDisplayEntry;
import net.minecraft.world.item.crafting.display.RecipeDisplayId;
import net.minecraft.world.level.Level;
import org.slf4j.Logger;

public class RecipeManager
extends SimplePreparableReloadListener<RecipeMap>
implements RecipeAccess {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Map<ResourceKey<RecipePropertySet>, IngredientExtractor> RECIPE_PROPERTY_SETS = Map.of(RecipePropertySet.SMITHING_ADDITION, p_380841_ -> {
        Optional optional;
        if (p_380841_ instanceof SmithingRecipe) {
            SmithingRecipe smithingrecipe = (SmithingRecipe)p_380841_;
            optional = smithingrecipe.additionIngredient();
        } else {
            optional = Optional.empty();
        }
        return optional;
    }, RecipePropertySet.SMITHING_BASE, p_380848_ -> {
        Optional optional;
        if (p_380848_ instanceof SmithingRecipe) {
            SmithingRecipe smithingrecipe = (SmithingRecipe)p_380848_;
            optional = smithingrecipe.baseIngredient();
        } else {
            optional = Optional.empty();
        }
        return optional;
    }, RecipePropertySet.SMITHING_TEMPLATE, p_380847_ -> {
        Optional optional;
        if (p_380847_ instanceof SmithingRecipe) {
            SmithingRecipe smithingrecipe = (SmithingRecipe)p_380847_;
            optional = smithingrecipe.templateIngredient();
        } else {
            optional = Optional.empty();
        }
        return optional;
    }, RecipePropertySet.FURNACE_INPUT, RecipeManager.forSingleInput(RecipeType.SMELTING), RecipePropertySet.BLAST_FURNACE_INPUT, RecipeManager.forSingleInput(RecipeType.BLASTING), RecipePropertySet.SMOKER_INPUT, RecipeManager.forSingleInput(RecipeType.SMOKING), RecipePropertySet.CAMPFIRE_INPUT, RecipeManager.forSingleInput(RecipeType.CAMPFIRE_COOKING));
    private final HolderLookup.Provider registries;
    private RecipeMap recipes = RecipeMap.EMPTY;
    private Map<ResourceKey<RecipePropertySet>, RecipePropertySet> propertySets = Map.of();
    private SelectableRecipe.SingleInputSet<StonecutterRecipe> stonecutterRecipes = SelectableRecipe.SingleInputSet.empty();
    private List<ServerDisplayInfo> allDisplays = List.of();
    private Map<ResourceKey<Recipe<?>>, List<ServerDisplayInfo>> recipeToDisplay = Map.of();

    public RecipeManager(HolderLookup.Provider p_324137_) {
        this.registries = p_324137_;
    }

    @Override
    protected RecipeMap prepare(ResourceManager p_379845_, ProfilerFiller p_380058_) {
        TreeMap<ResourceLocation, Recipe> sortedmap = new TreeMap<ResourceLocation, Recipe>();
        SimpleJsonResourceReloadListener.scanDirectory(p_379845_, Registries.elementsDirPath(Registries.RECIPE), this.registries.createSerializationContext(JsonOps.INSTANCE), Recipe.CODEC, sortedmap);
        ArrayList list = new ArrayList(sortedmap.size());
        sortedmap.forEach((p_379232_, p_379233_) -> {
            ResourceKey<Recipe<?>> resourcekey = ResourceKey.create(Registries.RECIPE, p_379232_);
            RecipeHolder recipeholder = new RecipeHolder(resourcekey, p_379233_);
            list.add(recipeholder);
        });
        return RecipeMap.create(list);
    }

    @Override
    protected void apply(RecipeMap p_380231_, ResourceManager p_44038_, ProfilerFiller p_44039_) {
        this.recipes = p_380231_;
        LOGGER.info("Loaded {} recipes", (Object)p_380231_.values().size());
    }

    public void finalizeRecipeLoading(FeatureFlagSet p_379660_) {
        ArrayList list = new ArrayList();
        List<IngredientCollector> list1 = RECIPE_PROPERTY_SETS.entrySet().stream().map(p_380840_ -> new IngredientCollector((ResourceKey)p_380840_.getKey(), (IngredientExtractor)p_380840_.getValue())).toList();
        this.recipes.values().forEach(p_380845_ -> {
            Recipe recipe = p_380845_.value();
            if (!recipe.isSpecial() && recipe.placementInfo().isImpossibleToPlace()) {
                LOGGER.warn("Recipe {} can't be placed due to empty ingredients and will be ignored", (Object)p_380845_.id().location());
            } else {
                StonecutterRecipe stonecutterrecipe;
                list1.forEach(p_380839_ -> p_380839_.accept(recipe));
                if (recipe instanceof StonecutterRecipe && RecipeManager.isIngredientEnabled(p_379660_, (stonecutterrecipe = (StonecutterRecipe)recipe).input()) && stonecutterrecipe.resultDisplay().isEnabled(p_379660_)) {
                    list.add(new SelectableRecipe.SingleInputEntry(stonecutterrecipe.input(), new SelectableRecipe(stonecutterrecipe.resultDisplay(), Optional.of(p_380845_))));
                }
            }
        });
        this.propertySets = list1.stream().collect(Collectors.toUnmodifiableMap(p_380846_ -> p_380846_.key, p_380852_ -> p_380852_.asPropertySet(p_379660_)));
        this.stonecutterRecipes = new SelectableRecipe.SingleInputSet(list);
        this.allDisplays = RecipeManager.unpackRecipeInfo(this.recipes.values(), p_379660_);
        this.recipeToDisplay = this.allDisplays.stream().collect(Collectors.groupingBy(p_379212_ -> p_379212_.parent.id(), IdentityHashMap::new, Collectors.toList()));
    }

    static List<Ingredient> filterDisabled(FeatureFlagSet p_379504_, List<Ingredient> p_379890_) {
        p_379890_.removeIf(p_379230_ -> !RecipeManager.isIngredientEnabled(p_379504_, p_379230_));
        return p_379890_;
    }

    private static boolean isIngredientEnabled(FeatureFlagSet p_379722_, Ingredient p_380390_) {
        return p_380390_.items().stream().allMatch(p_379224_ -> ((Item)p_379224_.value()).isEnabled(p_379722_));
    }

    public <I extends RecipeInput, T extends Recipe<I>> Optional<RecipeHolder<T>> getRecipeFor(RecipeType<T> p_345895_, I p_345268_, Level p_346336_, @Nullable ResourceKey<Recipe<?>> p_380176_) {
        RecipeHolder<T> recipeholder = p_380176_ != null ? this.byKeyTyped(p_345895_, p_380176_) : null;
        return this.getRecipeFor(p_345895_, p_345268_, p_346336_, recipeholder);
    }

    public <I extends RecipeInput, T extends Recipe<I>> Optional<RecipeHolder<T>> getRecipeFor(RecipeType<T> p_220249_, I p_345826_, Level p_220251_, @Nullable RecipeHolder<T> p_346407_) {
        return p_346407_ != null && p_346407_.value().matches(p_345826_, p_220251_) ? Optional.of(p_346407_) : this.getRecipeFor(p_220249_, p_345826_, p_220251_);
    }

    public <I extends RecipeInput, T extends Recipe<I>> Optional<RecipeHolder<T>> getRecipeFor(RecipeType<T> p_44016_, I p_345492_, Level p_44018_) {
        return this.recipes.getRecipesFor(p_44016_, p_345492_, p_44018_).findFirst();
    }

    public Optional<RecipeHolder<?>> byKey(ResourceKey<Recipe<?>> p_379753_) {
        return Optional.ofNullable(this.recipes.byKey(p_379753_));
    }

    @Nullable
    private <T extends Recipe<?>> RecipeHolder<T> byKeyTyped(RecipeType<T> p_341695_, ResourceKey<Recipe<?>> p_379841_) {
        RecipeHolder recipeholder = this.recipes.byKey(p_379841_);
        return recipeholder != null && recipeholder.value().getType().equals(p_341695_) ? recipeholder : null;
    }

    public Map<ResourceKey<RecipePropertySet>, RecipePropertySet> getSynchronizedItemProperties() {
        return this.propertySets;
    }

    public SelectableRecipe.SingleInputSet<StonecutterRecipe> getSynchronizedStonecutterRecipes() {
        return this.stonecutterRecipes;
    }

    public RecipePropertySet propertySet(ResourceKey<RecipePropertySet> p_379366_) {
        return this.propertySets.getOrDefault(p_379366_, RecipePropertySet.EMPTY);
    }

    public SelectableRecipe.SingleInputSet<StonecutterRecipe> stonecutterRecipes() {
        return this.stonecutterRecipes;
    }

    public Collection<RecipeHolder<?>> getRecipes() {
        return this.recipes.values();
    }

    @Nullable
    public ServerDisplayInfo getRecipeFromDisplay(RecipeDisplayId p_379566_) {
        return this.allDisplays.get(p_379566_.index());
    }

    public void listDisplaysForRecipe(ResourceKey<Recipe<?>> p_379964_, Consumer<RecipeDisplayEntry> p_379437_) {
        List<ServerDisplayInfo> list = this.recipeToDisplay.get(p_379964_);
        if (list != null) {
            list.forEach(p_379228_ -> p_379437_.accept(p_379228_.display));
        }
    }

    @VisibleForTesting
    protected static RecipeHolder<?> fromJson(ResourceKey<Recipe<?>> p_380059_, JsonObject p_44047_, HolderLookup.Provider p_323755_) {
        Recipe recipe = (Recipe)Recipe.CODEC.parse(p_323755_.createSerializationContext(JsonOps.INSTANCE), (Object)p_44047_).getOrThrow(JsonParseException::new);
        return new RecipeHolder(p_380059_, recipe);
    }

    public static <I extends RecipeInput, T extends Recipe<I>> CachedCheck<I, T> createCheck(final RecipeType<T> p_220268_) {
        return new CachedCheck<I, T>(){
            @Nullable
            private ResourceKey<Recipe<?>> lastRecipe;

            @Override
            public Optional<RecipeHolder<T>> getRecipeFor(I p_344742_, ServerLevel p_379891_) {
                RecipeManager recipemanager = p_379891_.recipeAccess();
                Optional optional = recipemanager.getRecipeFor(p_220268_, p_344742_, (Level)p_379891_, this.lastRecipe);
                if (optional.isPresent()) {
                    RecipeHolder recipeholder = optional.get();
                    this.lastRecipe = recipeholder.id();
                    return Optional.of(recipeholder);
                }
                return Optional.empty();
            }
        };
    }

    private static List<ServerDisplayInfo> unpackRecipeInfo(Iterable<RecipeHolder<?>> p_379538_, FeatureFlagSet p_379868_) {
        ArrayList<ServerDisplayInfo> list = new ArrayList<ServerDisplayInfo>();
        Object2IntOpenHashMap object2intmap = new Object2IntOpenHashMap();
        for (RecipeHolder<?> recipeholder : p_379538_) {
            Recipe recipe = recipeholder.value();
            OptionalInt optionalint = recipe.group().isEmpty() ? OptionalInt.empty() : OptionalInt.of(object2intmap.computeIfAbsent((Object)recipe.group(), arg_0 -> RecipeManager.lambda$unpackRecipeInfo$13((Object2IntMap)object2intmap, arg_0)));
            Optional<Object> optional = recipe.isSpecial() ? Optional.empty() : Optional.of(recipe.placementInfo().ingredients());
            for (RecipeDisplay recipedisplay : recipe.display()) {
                if (!recipedisplay.isEnabled(p_379868_)) continue;
                int i = list.size();
                RecipeDisplayId recipedisplayid = new RecipeDisplayId(i);
                RecipeDisplayEntry recipedisplayentry = new RecipeDisplayEntry(recipedisplayid, recipedisplay, optionalint, recipe.recipeBookCategory(), optional);
                list.add(new ServerDisplayInfo(recipedisplayentry, recipeholder));
            }
        }
        return list;
    }

    private static IngredientExtractor forSingleInput(RecipeType<? extends SingleItemRecipe> p_381108_) {
        return p_380850_ -> {
            Optional<Object> optional;
            if (p_380850_.getType() == p_381108_ && p_380850_ instanceof SingleItemRecipe) {
                SingleItemRecipe singleitemrecipe = (SingleItemRecipe)p_380850_;
                optional = Optional.of(singleitemrecipe.input());
            } else {
                optional = Optional.empty();
            }
            return optional;
        };
    }

    public RecipeMap recipeMap() {
        return this.recipes;
    }

    private static /* synthetic */ int lambda$unpackRecipeInfo$13(Object2IntMap object2intmap, Object p_379226_) {
        return object2intmap.size();
    }

    public record ServerDisplayInfo(RecipeDisplayEntry display, RecipeHolder<?> parent) {
    }

    @FunctionalInterface
    public static interface IngredientExtractor {
        public Optional<Ingredient> apply(Recipe<?> var1);
    }

    public static class IngredientCollector
    implements Consumer<Recipe<?>> {
        final ResourceKey<RecipePropertySet> key;
        private final IngredientExtractor extractor;
        private final List<Ingredient> ingredients = new ArrayList<Ingredient>();

        protected IngredientCollector(ResourceKey<RecipePropertySet> p_380992_, IngredientExtractor p_380987_) {
            this.key = p_380992_;
            this.extractor = p_380987_;
        }

        @Override
        public void accept(Recipe<?> p_380946_) {
            this.extractor.apply(p_380946_).ifPresent(this.ingredients::add);
        }

        public RecipePropertySet asPropertySet(FeatureFlagSet p_380941_) {
            return RecipePropertySet.create(RecipeManager.filterDisabled(p_380941_, this.ingredients));
        }
    }

    public static interface CachedCheck<I extends RecipeInput, T extends Recipe<I>> {
        public Optional<RecipeHolder<T>> getRecipeFor(I var1, ServerLevel var2);
    }
}

