/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.MapCodec;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.BigDripleafStemBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.Tilt;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.util.TriState;

public class BigDripleafBlock
extends HorizontalDirectionalBlock
implements BonemealableBlock,
SimpleWaterloggedBlock {
    public static final MapCodec<BigDripleafBlock> CODEC = BigDripleafBlock.simpleCodec(BigDripleafBlock::new);
    private static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    private static final EnumProperty<Tilt> TILT = BlockStateProperties.TILT;
    private static final int NO_TICK = -1;
    private static final Object2IntMap<Tilt> DELAY_UNTIL_NEXT_TILT_STATE = (Object2IntMap)Util.make(new Object2IntArrayMap(), p_152305_ -> {
        p_152305_.defaultReturnValue(-1);
        p_152305_.put((Object)Tilt.UNSTABLE, 10);
        p_152305_.put((Object)Tilt.PARTIAL, 10);
        p_152305_.put((Object)Tilt.FULL, 100);
    });
    private static final int MAX_GEN_HEIGHT = 5;
    private static final int STEM_WIDTH = 6;
    private static final int ENTITY_DETECTION_MIN_Y = 11;
    private static final int LOWEST_LEAF_TOP = 13;
    private static final Map<Tilt, VoxelShape> LEAF_SHAPES = ImmutableMap.of((Object)Tilt.NONE, (Object)Block.box(0.0, 11.0, 0.0, 16.0, 15.0, 16.0), (Object)Tilt.UNSTABLE, (Object)Block.box(0.0, 11.0, 0.0, 16.0, 15.0, 16.0), (Object)Tilt.PARTIAL, (Object)Block.box(0.0, 11.0, 0.0, 16.0, 13.0, 16.0), (Object)Tilt.FULL, (Object)Shapes.empty());
    private static final VoxelShape STEM_SLICER = Block.box(0.0, 13.0, 0.0, 16.0, 16.0, 16.0);
    private static final Map<Direction, VoxelShape> STEM_SHAPES = ImmutableMap.of((Object)Direction.NORTH, (Object)Shapes.joinUnoptimized((VoxelShape)BigDripleafStemBlock.NORTH_SHAPE, (VoxelShape)STEM_SLICER, (BooleanOp)BooleanOp.ONLY_FIRST), (Object)Direction.SOUTH, (Object)Shapes.joinUnoptimized((VoxelShape)BigDripleafStemBlock.SOUTH_SHAPE, (VoxelShape)STEM_SLICER, (BooleanOp)BooleanOp.ONLY_FIRST), (Object)Direction.EAST, (Object)Shapes.joinUnoptimized((VoxelShape)BigDripleafStemBlock.EAST_SHAPE, (VoxelShape)STEM_SLICER, (BooleanOp)BooleanOp.ONLY_FIRST), (Object)Direction.WEST, (Object)Shapes.joinUnoptimized((VoxelShape)BigDripleafStemBlock.WEST_SHAPE, (VoxelShape)STEM_SLICER, (BooleanOp)BooleanOp.ONLY_FIRST));
    private final Map<BlockState, VoxelShape> shapesCache;

    public MapCodec<BigDripleafBlock> codec() {
        return CODEC;
    }

    public BigDripleafBlock(BlockBehaviour.Properties p_152214_) {
        super(p_152214_);
        this.registerDefaultState((BlockState)((Object)((BlockState)((Object)((BlockState)((Object)((BlockState)this.stateDefinition.any()).setValue((Property)WATERLOGGED, Boolean.valueOf(false)))).setValue((Property)FACING, (Comparable)Direction.NORTH))).setValue((Property)TILT, (Comparable)Tilt.NONE)));
        this.shapesCache = this.getShapeForEachState(BigDripleafBlock::calculateShape);
    }

    private static VoxelShape calculateShape(BlockState p_152318_) {
        return Shapes.or((VoxelShape)LEAF_SHAPES.get(p_152318_.getValue((Property)TILT)), (VoxelShape)STEM_SHAPES.get(p_152318_.getValue((Property)FACING)));
    }

    public static void placeWithRandomHeight(LevelAccessor p_220793_, RandomSource p_220794_, BlockPos p_220795_, Direction p_220796_) {
        int j;
        int i = Mth.nextInt((RandomSource)p_220794_, (int)2, (int)5);
        BlockPos.MutableBlockPos blockpos$mutableblockpos = p_220795_.mutable();
        for (j = 0; j < i && BigDripleafBlock.canPlaceAt((LevelHeightAccessor)p_220793_, (BlockPos)blockpos$mutableblockpos, p_220793_.getBlockState((BlockPos)blockpos$mutableblockpos)); ++j) {
            blockpos$mutableblockpos.move(Direction.UP);
        }
        int k = p_220795_.getY() + j - 1;
        blockpos$mutableblockpos.setY(p_220795_.getY());
        while (blockpos$mutableblockpos.getY() < k) {
            BigDripleafStemBlock.place((LevelAccessor)p_220793_, (BlockPos)blockpos$mutableblockpos, (FluidState)p_220793_.getFluidState((BlockPos)blockpos$mutableblockpos), (Direction)p_220796_);
            blockpos$mutableblockpos.move(Direction.UP);
        }
        BigDripleafBlock.place(p_220793_, (BlockPos)blockpos$mutableblockpos, p_220793_.getFluidState((BlockPos)blockpos$mutableblockpos), p_220796_);
    }

    private static boolean canReplace(BlockState p_152320_) {
        return p_152320_.isAir() || p_152320_.is(Blocks.WATER) || p_152320_.is(Blocks.SMALL_DRIPLEAF);
    }

    protected static boolean canPlaceAt(LevelHeightAccessor p_152252_, BlockPos p_152253_, BlockState p_152254_) {
        return !p_152252_.isOutsideBuildHeight(p_152253_) && BigDripleafBlock.canReplace(p_152254_);
    }

    protected static boolean place(LevelAccessor p_152242_, BlockPos p_152243_, FluidState p_152244_, Direction p_152245_) {
        BlockState blockstate = (BlockState)((Object)((BlockState)((Object)Blocks.BIG_DRIPLEAF.defaultBlockState().setValue((Property)WATERLOGGED, Boolean.valueOf(p_152244_.isSourceOfType(Fluids.WATER))))).setValue((Property)FACING, (Comparable)p_152245_));
        return p_152242_.setBlock(p_152243_, blockstate, 3);
    }

    protected void onProjectileHit(Level p_152228_, BlockState p_152229_, BlockHitResult p_152230_, Projectile p_152231_) {
        this.setTiltAndScheduleTick(p_152229_, p_152228_, p_152230_.getBlockPos(), Tilt.FULL, SoundEvents.BIG_DRIPLEAF_TILT_DOWN);
    }

    protected FluidState getFluidState(BlockState p_152312_) {
        return (Boolean)p_152312_.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(p_152312_);
    }

    protected boolean canSurvive(BlockState p_152289_, LevelReader p_152290_, BlockPos p_152291_) {
        BlockPos blockpos = p_152291_.below();
        BlockState blockstate = p_152290_.getBlockState(blockpos);
        TriState soilDecision = blockstate.canSustainPlant(p_152290_, blockpos, Direction.UP, p_152289_);
        if (!soilDecision.isDefault()) {
            return soilDecision.isTrue();
        }
        return blockstate.is((Block)((Object)this)) || blockstate.is(Blocks.BIG_DRIPLEAF_STEM) || blockstate.is(BlockTags.BIG_DRIPLEAF_PLACEABLE);
    }

    protected BlockState updateShape(BlockState p_152293_, LevelReader p_374459_, ScheduledTickAccess p_374181_, BlockPos p_152297_, Direction p_152294_, BlockPos p_152298_, BlockState p_152295_, RandomSource p_374504_) {
        if (p_152294_ == Direction.DOWN && !p_152293_.canSurvive(p_374459_, p_152297_)) {
            return Blocks.AIR.defaultBlockState();
        }
        if (((Boolean)p_152293_.getValue((Property)WATERLOGGED)).booleanValue()) {
            p_374181_.scheduleTick(p_152297_, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay(p_374459_));
        }
        return p_152294_ == Direction.UP && p_152295_.is((Block)((Object)this)) ? Blocks.BIG_DRIPLEAF_STEM.withPropertiesOf(p_152293_) : super.updateShape(p_152293_, p_374459_, p_374181_, p_152297_, p_152294_, p_152298_, p_152295_, p_374504_);
    }

    public boolean isValidBonemealTarget(LevelReader p_255698_, BlockPos p_256302_, BlockState p_255648_) {
        BlockState blockstate = p_255698_.getBlockState(p_256302_.above());
        return BigDripleafBlock.canReplace(blockstate);
    }

    public boolean isBonemealSuccess(Level p_220788_, RandomSource p_220789_, BlockPos p_220790_, BlockState p_220791_) {
        return true;
    }

    public void performBonemeal(ServerLevel p_220783_, RandomSource p_220784_, BlockPos p_220785_, BlockState p_220786_) {
        BlockState blockstate;
        BlockPos blockpos = p_220785_.above();
        if (BigDripleafBlock.canPlaceAt((LevelHeightAccessor)p_220783_, blockpos, blockstate = p_220783_.getBlockState(blockpos))) {
            Direction direction = (Direction)p_220786_.getValue((Property)FACING);
            BigDripleafStemBlock.place((LevelAccessor)p_220783_, (BlockPos)p_220785_, (FluidState)p_220786_.getFluidState(), (Direction)direction);
            BigDripleafBlock.place(p_220783_, blockpos, blockstate.getFluidState(), direction);
        }
    }

    protected void entityInside(BlockState p_152266_, Level p_152267_, BlockPos p_152268_, Entity p_152269_) {
        if (!p_152267_.isClientSide && p_152266_.getValue((Property)TILT) == Tilt.NONE && BigDripleafBlock.canEntityTilt(p_152268_, p_152269_) && !p_152267_.hasNeighborSignal(p_152268_)) {
            this.setTiltAndScheduleTick(p_152266_, p_152267_, p_152268_, Tilt.UNSTABLE, null);
        }
    }

    protected void tick(BlockState p_220798_, ServerLevel p_220799_, BlockPos p_220800_, RandomSource p_220801_) {
        if (p_220799_.hasNeighborSignal(p_220800_)) {
            BigDripleafBlock.resetTilt(p_220798_, p_220799_, p_220800_);
        } else {
            Tilt tilt = (Tilt)p_220798_.getValue((Property)TILT);
            if (tilt == Tilt.UNSTABLE) {
                this.setTiltAndScheduleTick(p_220798_, p_220799_, p_220800_, Tilt.PARTIAL, SoundEvents.BIG_DRIPLEAF_TILT_DOWN);
            } else if (tilt == Tilt.PARTIAL) {
                this.setTiltAndScheduleTick(p_220798_, p_220799_, p_220800_, Tilt.FULL, SoundEvents.BIG_DRIPLEAF_TILT_DOWN);
            } else if (tilt == Tilt.FULL) {
                BigDripleafBlock.resetTilt(p_220798_, p_220799_, p_220800_);
            }
        }
    }

    protected void neighborChanged(BlockState p_152271_, Level p_152272_, BlockPos p_152273_, Block p_152274_, @Nullable Orientation p_364767_, boolean p_152276_) {
        if (p_152272_.hasNeighborSignal(p_152273_)) {
            BigDripleafBlock.resetTilt(p_152271_, p_152272_, p_152273_);
        }
    }

    private static void playTiltSound(Level p_152233_, BlockPos p_152234_, SoundEvent p_152235_) {
        float f = Mth.randomBetween((RandomSource)p_152233_.random, (float)0.8f, (float)1.2f);
        p_152233_.playSound(null, p_152234_, p_152235_, SoundSource.BLOCKS, 1.0f, f);
    }

    private static boolean canEntityTilt(BlockPos p_152302_, Entity p_152303_) {
        return p_152303_.onGround() && p_152303_.position().y > (double)((float)p_152302_.getY() + 0.6875f);
    }

    private void setTiltAndScheduleTick(BlockState p_152283_, Level p_152284_, BlockPos p_152285_, Tilt p_152286_, @Nullable SoundEvent p_152287_) {
        int i;
        BigDripleafBlock.setTilt(p_152283_, p_152284_, p_152285_, p_152286_);
        if (p_152287_ != null) {
            BigDripleafBlock.playTiltSound(p_152284_, p_152285_, p_152287_);
        }
        if ((i = DELAY_UNTIL_NEXT_TILT_STATE.getInt((Object)p_152286_)) != -1) {
            p_152284_.scheduleTick(p_152285_, (Block)((Object)this), i);
        }
    }

    private static void resetTilt(BlockState p_152314_, Level p_152315_, BlockPos p_152316_) {
        BigDripleafBlock.setTilt(p_152314_, p_152315_, p_152316_, Tilt.NONE);
        if (p_152314_.getValue((Property)TILT) != Tilt.NONE) {
            BigDripleafBlock.playTiltSound(p_152315_, p_152316_, SoundEvents.BIG_DRIPLEAF_TILT_UP);
        }
    }

    private static void setTilt(BlockState p_152278_, Level p_152279_, BlockPos p_152280_, Tilt p_152281_) {
        Tilt tilt = (Tilt)p_152278_.getValue((Property)TILT);
        p_152279_.setBlock(p_152280_, (BlockState)((Object)p_152278_.setValue((Property)TILT, (Comparable)p_152281_)), 2);
        if (p_152281_.causesVibration() && p_152281_ != tilt) {
            p_152279_.gameEvent(null, GameEvent.BLOCK_CHANGE, p_152280_);
        }
    }

    protected VoxelShape getCollisionShape(BlockState p_152307_, BlockGetter p_152308_, BlockPos p_152309_, CollisionContext p_152310_) {
        return LEAF_SHAPES.get(p_152307_.getValue((Property)TILT));
    }

    protected VoxelShape getShape(BlockState p_152261_, BlockGetter p_152262_, BlockPos p_152263_, CollisionContext p_152264_) {
        return this.shapesCache.get((Object)p_152261_);
    }

    public BlockState getStateForPlacement(BlockPlaceContext p_152221_) {
        BlockState blockstate = p_152221_.getLevel().getBlockState(p_152221_.getClickedPos().below());
        FluidState fluidstate = p_152221_.getLevel().getFluidState(p_152221_.getClickedPos());
        boolean flag = blockstate.is(Blocks.BIG_DRIPLEAF) || blockstate.is(Blocks.BIG_DRIPLEAF_STEM);
        return (BlockState)((Object)((BlockState)((Object)this.defaultBlockState().setValue((Property)WATERLOGGED, Boolean.valueOf(fluidstate.isSourceOfType(Fluids.WATER))))).setValue((Property)FACING, (Comparable)(flag ? (Direction)blockstate.getValue((Property)FACING) : p_152221_.getHorizontalDirection().getOpposite())));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> p_152300_) {
        p_152300_.add(new Property[]{WATERLOGGED, FACING, TILT});
    }
}

