/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.FrontAndTop;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeCache;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.CrafterBlockEntity;
import net.minecraft.world.level.block.entity.HopperBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.items.VanillaInventoryCodeHooks;

public class CrafterBlock
extends BaseEntityBlock {
    public static final MapCodec<CrafterBlock> CODEC = CrafterBlock.simpleCodec(CrafterBlock::new);
    public static final BooleanProperty CRAFTING = BlockStateProperties.CRAFTING;
    public static final BooleanProperty TRIGGERED = BlockStateProperties.TRIGGERED;
    private static final EnumProperty<FrontAndTop> ORIENTATION = BlockStateProperties.ORIENTATION;
    private static final int MAX_CRAFTING_TICKS = 6;
    private static final int CRAFTING_TICK_DELAY = 4;
    private static final RecipeCache RECIPE_CACHE = new RecipeCache(10);
    private static final int CRAFTER_ADVANCEMENT_DIAMETER = 17;

    public CrafterBlock(BlockBehaviour.Properties p_307674_) {
        super(p_307674_);
        this.registerDefaultState((BlockState)((Object)((BlockState)((Object)((BlockState)((Object)((BlockState)this.stateDefinition.any()).setValue((Property)ORIENTATION, (Comparable)FrontAndTop.NORTH_UP))).setValue((Property)TRIGGERED, Boolean.valueOf(false)))).setValue((Property)CRAFTING, Boolean.valueOf(false))));
    }

    protected MapCodec<CrafterBlock> codec() {
        return CODEC;
    }

    protected boolean hasAnalogOutputSignal(BlockState p_307445_) {
        return true;
    }

    protected int getAnalogOutputSignal(BlockState p_307633_, Level p_307264_, BlockPos p_307557_) {
        int n;
        BlockEntity blockEntity = p_307264_.getBlockEntity(p_307557_);
        if (blockEntity instanceof CrafterBlockEntity) {
            CrafterBlockEntity crafterblockentity = (CrafterBlockEntity)blockEntity;
            n = crafterblockentity.getRedstoneSignal();
        } else {
            n = 0;
        }
        return n;
    }

    protected void neighborChanged(BlockState p_307205_, Level p_307451_, BlockPos p_307272_, Block p_307542_, @Nullable Orientation p_362007_, boolean p_307540_) {
        boolean flag = p_307451_.hasNeighborSignal(p_307272_);
        boolean flag1 = (Boolean)p_307205_.getValue((Property)TRIGGERED);
        BlockEntity blockentity = p_307451_.getBlockEntity(p_307272_);
        if (flag && !flag1) {
            p_307451_.scheduleTick(p_307272_, (Block)((Object)this), 4);
            p_307451_.setBlock(p_307272_, (BlockState)((Object)p_307205_.setValue((Property)TRIGGERED, Boolean.valueOf(true))), 2);
            this.setBlockEntityTriggered(blockentity, true);
        } else if (!flag && flag1) {
            p_307451_.setBlock(p_307272_, (BlockState)((Object)((BlockState)((Object)p_307205_.setValue((Property)TRIGGERED, Boolean.valueOf(false)))).setValue((Property)CRAFTING, Boolean.valueOf(false))), 2);
            this.setBlockEntityTriggered(blockentity, false);
        }
    }

    protected void tick(BlockState p_307471_, ServerLevel p_307641_, BlockPos p_307339_, RandomSource p_307565_) {
        this.dispenseFrom(p_307471_, p_307641_, p_307339_);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level p_307308_, BlockState p_307639_, BlockEntityType<T> p_307651_) {
        return p_307308_.isClientSide ? null : CrafterBlock.createTickerHelper(p_307651_, BlockEntityType.CRAFTER, CrafterBlockEntity::serverTick);
    }

    private void setBlockEntityTriggered(@Nullable BlockEntity p_307610_, boolean p_307577_) {
        if (p_307610_ instanceof CrafterBlockEntity) {
            CrafterBlockEntity crafterblockentity = (CrafterBlockEntity)p_307610_;
            crafterblockentity.setTriggered(p_307577_);
        }
    }

    public BlockEntity newBlockEntity(BlockPos p_307381_, BlockState p_307601_) {
        CrafterBlockEntity crafterblockentity = new CrafterBlockEntity(p_307381_, p_307601_);
        crafterblockentity.setTriggered(p_307601_.hasProperty((Property)TRIGGERED) && (Boolean)p_307601_.getValue((Property)TRIGGERED) != false);
        return crafterblockentity;
    }

    public BlockState getStateForPlacement(BlockPlaceContext p_307251_) {
        Direction direction = p_307251_.getNearestLookingDirection().getOpposite();
        Direction direction1 = switch (direction) {
            default -> throw new MatchException(null, null);
            case Direction.DOWN -> p_307251_.getHorizontalDirection().getOpposite();
            case Direction.UP -> p_307251_.getHorizontalDirection();
            case Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST -> Direction.UP;
        };
        return (BlockState)((Object)((BlockState)((Object)this.defaultBlockState().setValue((Property)ORIENTATION, (Comparable)FrontAndTop.fromFrontAndTop((Direction)direction, (Direction)direction1)))).setValue((Property)TRIGGERED, Boolean.valueOf(p_307251_.getLevel().hasNeighborSignal(p_307251_.getClickedPos()))));
    }

    public void setPlacedBy(Level p_307219_, BlockPos p_307681_, BlockState p_307383_, LivingEntity p_307647_, ItemStack p_307190_) {
        if (((Boolean)p_307383_.getValue((Property)TRIGGERED)).booleanValue()) {
            p_307219_.scheduleTick(p_307681_, (Block)((Object)this), 4);
        }
    }

    protected void onRemove(BlockState p_307425_, Level p_307460_, BlockPos p_307342_, BlockState p_307466_, boolean p_307349_) {
        Containers.dropContentsOnDestroy((BlockState)p_307425_, (BlockState)p_307466_, (Level)p_307460_, (BlockPos)p_307342_);
        super.onRemove(p_307425_, p_307460_, p_307342_, p_307466_, p_307349_);
    }

    protected InteractionResult useWithoutItem(BlockState p_307454_, Level p_307255_, BlockPos p_307303_, Player p_307670_, BlockHitResult p_307546_) {
        BlockEntity blockEntity;
        if (!p_307255_.isClientSide && (blockEntity = p_307255_.getBlockEntity(p_307303_)) instanceof CrafterBlockEntity) {
            CrafterBlockEntity crafterblockentity = (CrafterBlockEntity)blockEntity;
            p_307670_.openMenu((MenuProvider)crafterblockentity);
        }
        return InteractionResult.SUCCESS;
    }

    protected void dispenseFrom(BlockState p_307495_, ServerLevel p_307310_, BlockPos p_307672_) {
        BlockEntity blockEntity = p_307310_.getBlockEntity(p_307672_);
        if (blockEntity instanceof CrafterBlockEntity) {
            CrafterBlockEntity crafterblockentity = (CrafterBlockEntity)blockEntity;
            CraftingInput craftinginput = crafterblockentity.asCraftInput();
            Optional<RecipeHolder<CraftingRecipe>> optional = CrafterBlock.getPotentialResults(p_307310_, craftinginput);
            if (optional.isEmpty()) {
                p_307310_.levelEvent(1050, p_307672_, 0);
            } else {
                RecipeHolder<CraftingRecipe> recipeholder = optional.get();
                ItemStack itemstack = ((CraftingRecipe)recipeholder.value()).assemble(craftinginput, (HolderLookup.Provider)p_307310_.registryAccess());
                if (itemstack.isEmpty()) {
                    p_307310_.levelEvent(1050, p_307672_, 0);
                } else {
                    crafterblockentity.setCraftingTicksRemaining(6);
                    p_307310_.setBlock(p_307672_, (BlockState)((Object)p_307495_.setValue((Property)CRAFTING, Boolean.valueOf(true))), 2);
                    itemstack.onCraftedBySystem(p_307310_);
                    this.dispenseItem(p_307310_, p_307672_, crafterblockentity, itemstack, p_307495_, recipeholder);
                    for (ItemStack itemstack1 : ((CraftingRecipe)recipeholder.value()).getRemainingItems(craftinginput)) {
                        if (itemstack1.isEmpty()) continue;
                        this.dispenseItem(p_307310_, p_307672_, crafterblockentity, itemstack1, p_307495_, recipeholder);
                    }
                    crafterblockentity.getItems().forEach(p_307295_ -> {
                        if (!p_307295_.isEmpty()) {
                            p_307295_.shrink(1);
                        }
                    });
                    crafterblockentity.setChanged();
                }
            }
        }
    }

    public static Optional<RecipeHolder<CraftingRecipe>> getPotentialResults(ServerLevel p_380126_, CraftingInput p_345096_) {
        return RECIPE_CACHE.get(p_380126_, p_345096_);
    }

    private void dispenseItem(ServerLevel p_335887_, BlockPos p_307620_, CrafterBlockEntity p_307387_, ItemStack p_307296_, BlockState p_307501_, RecipeHolder<?> p_335494_) {
        Direction direction = ((FrontAndTop)p_307501_.getValue((Property)ORIENTATION)).front();
        Container container = HopperBlockEntity.getContainerAt(p_335887_, p_307620_.relative(direction));
        ItemStack itemstack = p_307296_.copy();
        if (container != null && (container instanceof CrafterBlockEntity || p_307296_.getCount() > container.getMaxStackSize(p_307296_))) {
            ItemStack itemstack2;
            ItemStack itemstack1;
            while (!itemstack.isEmpty() && (itemstack1 = HopperBlockEntity.addItem((Container)p_307387_, container, itemstack2 = itemstack.copyWithCount(1), direction.getOpposite())).isEmpty()) {
                itemstack.shrink(1);
            }
        } else if (container != null) {
            int i;
            while (!itemstack.isEmpty() && (i = itemstack.getCount()) != (itemstack = HopperBlockEntity.addItem((Container)p_307387_, container, itemstack, direction.getOpposite())).getCount()) {
            }
        } else {
            itemstack = VanillaInventoryCodeHooks.insertCrafterOutput((Level)p_335887_, (BlockPos)p_307620_, (CrafterBlockEntity)p_307387_, (ItemStack)itemstack);
        }
        if (!itemstack.isEmpty()) {
            Vec3 vec3 = Vec3.atCenterOf((Vec3i)p_307620_);
            Vec3 vec31 = vec3.relative(direction, 0.7);
            DefaultDispenseItemBehavior.spawnItem((Level)p_335887_, (ItemStack)itemstack, (int)6, (Direction)direction, (Position)vec31);
            for (ServerPlayer serverplayer : p_335887_.getEntitiesOfClass(ServerPlayer.class, AABB.ofSize(vec3, 17.0, 17.0, 17.0))) {
                CriteriaTriggers.CRAFTER_RECIPE_CRAFTED.trigger(serverplayer, p_335494_.id(), (List)p_307387_.getItems());
            }
            p_335887_.levelEvent(1049, p_307620_, 0);
            p_335887_.levelEvent(2010, p_307620_, direction.get3DDataValue());
        }
    }

    protected RenderShape getRenderShape(BlockState p_307427_) {
        return RenderShape.MODEL;
    }

    protected BlockState rotate(BlockState p_307240_, Rotation p_307431_) {
        return (BlockState)((Object)p_307240_.setValue((Property)ORIENTATION, (Comparable)p_307431_.rotation().rotate((FrontAndTop)p_307240_.getValue((Property)ORIENTATION))));
    }

    protected BlockState mirror(BlockState p_307514_, Mirror p_307198_) {
        return (BlockState)((Object)p_307514_.setValue((Property)ORIENTATION, (Comparable)p_307198_.rotation().rotate((FrontAndTop)p_307514_.getValue((Property)ORIENTATION))));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> p_307200_) {
        p_307200_.add(new Property[]{ORIENTATION, TRIGGERED, CRAFTING});
    }
}

