/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.util.TriState;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.event.level.BlockGrowFeatureEvent;

public class MushroomBlock
extends BushBlock
implements BonemealableBlock {
    public static final MapCodec<MushroomBlock> CODEC = RecordCodecBuilder.mapCodec(p_368432_ -> p_368432_.group((App)ResourceKey.codec(Registries.CONFIGURED_FEATURE).fieldOf("feature").forGetter(p_304931_ -> p_304931_.feature), MushroomBlock.propertiesCodec()).apply((Applicative)p_368432_, MushroomBlock::new));
    protected static final float AABB_OFFSET = 3.0f;
    protected static final VoxelShape SHAPE = Block.box(5.0, 0.0, 5.0, 11.0, 6.0, 11.0);
    private final ResourceKey<ConfiguredFeature<?, ?>> feature;

    public MapCodec<MushroomBlock> codec() {
        return CODEC;
    }

    public MushroomBlock(ResourceKey<ConfiguredFeature<?, ?>> p_256049_, BlockBehaviour.Properties p_256027_) {
        super(p_256027_);
        this.feature = p_256049_;
    }

    @Override
    protected VoxelShape getShape(BlockState p_54889_, BlockGetter p_54890_, BlockPos p_54891_, CollisionContext p_54892_) {
        return SHAPE;
    }

    @Override
    protected void randomTick(BlockState p_221784_, ServerLevel p_221785_, BlockPos p_221786_, RandomSource p_221787_) {
        if (p_221787_.nextInt(25) == 0) {
            int i = 5;
            int j = 4;
            for (BlockPos blockpos : BlockPos.betweenClosed((BlockPos)p_221786_.offset(-4, -1, -4), (BlockPos)p_221786_.offset(4, 1, 4))) {
                if (!p_221785_.getBlockState(blockpos).is(this) || --i > 0) continue;
                return;
            }
            BlockPos blockpos1 = p_221786_.offset(p_221787_.nextInt(3) - 1, p_221787_.nextInt(2) - p_221787_.nextInt(2), p_221787_.nextInt(3) - 1);
            for (int k = 0; k < 4; ++k) {
                if (p_221785_.isEmptyBlock(blockpos1) && p_221784_.canSurvive((LevelReader)((Object)p_221785_), blockpos1)) {
                    p_221786_ = blockpos1;
                }
                blockpos1 = p_221786_.offset(p_221787_.nextInt(3) - 1, p_221787_.nextInt(2) - p_221787_.nextInt(2), p_221787_.nextInt(3) - 1);
            }
            if (p_221785_.isEmptyBlock(blockpos1) && p_221784_.canSurvive((LevelReader)((Object)p_221785_), blockpos1)) {
                p_221785_.setBlock(blockpos1, p_221784_, 2);
            }
        }
    }

    @Override
    protected boolean mayPlaceOn(BlockState p_54894_, BlockGetter p_54895_, BlockPos p_54896_) {
        return p_54894_.isSolidRender();
    }

    @Override
    protected boolean canSurvive(BlockState p_54880_, LevelReader p_54881_, BlockPos p_54882_) {
        BlockPos blockpos = p_54882_.below();
        BlockState blockstate = p_54881_.getBlockState(blockpos);
        TriState soilDecision = blockstate.canSustainPlant(p_54881_, blockpos, Direction.UP, p_54880_);
        return blockstate.is(BlockTags.MUSHROOM_GROW_BLOCK) ? true : (soilDecision.isDefault() ? p_54881_.getRawBrightness(p_54882_, 0) < 13 && this.mayPlaceOn(blockstate, p_54881_, blockpos) : soilDecision.isTrue());
    }

    public boolean growMushroom(ServerLevel p_221774_, BlockPos p_221775_, BlockState p_221776_, RandomSource p_221777_) {
        Optional<Holder> optional = p_221774_.registryAccess().lookupOrThrow(Registries.CONFIGURED_FEATURE).get(this.feature);
        BlockGrowFeatureEvent event = EventHooks.fireBlockGrowFeature((LevelAccessor)p_221774_, (RandomSource)p_221777_, (BlockPos)p_221775_, (Holder)optional.orElse(null));
        if (event.isCanceled()) {
            return false;
        }
        optional = Optional.ofNullable(event.getFeature());
        if (optional.isEmpty()) {
            return false;
        }
        p_221774_.removeBlock(p_221775_, false);
        if (((ConfiguredFeature)optional.get().value()).place((WorldGenLevel)p_221774_, p_221774_.getChunkSource().getGenerator(), p_221777_, p_221775_)) {
            return true;
        }
        p_221774_.setBlock(p_221775_, p_221776_, 3);
        return false;
    }

    public boolean isValidBonemealTarget(LevelReader p_255904_, BlockPos p_54871_, BlockState p_54872_) {
        return true;
    }

    public boolean isBonemealSuccess(Level p_221779_, RandomSource p_221780_, BlockPos p_221781_, BlockState p_221782_) {
        return (double)p_221780_.nextFloat() < 0.4;
    }

    public void performBonemeal(ServerLevel p_221769_, RandomSource p_221770_, BlockPos p_221771_, BlockState p_221772_) {
        this.growMushroom(p_221769_, p_221771_, p_221772_, p_221770_);
    }
}

