/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.serialization.MapCodec;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.ARGB;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.ObserverBlock;
import net.minecraft.world.level.block.RepeaterBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RedstoneSide;
import net.minecraft.world.level.redstone.DefaultRedstoneWireEvaluator;
import net.minecraft.world.level.redstone.ExperimentalRedstoneUtils;
import net.minecraft.world.level.redstone.ExperimentalRedstoneWireEvaluator;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.level.redstone.RedstoneWireEvaluator;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class RedStoneWireBlock
extends Block {
    public static final MapCodec<RedStoneWireBlock> CODEC = RedStoneWireBlock.simpleCodec(RedStoneWireBlock::new);
    public static final EnumProperty<RedstoneSide> NORTH = BlockStateProperties.NORTH_REDSTONE;
    public static final EnumProperty<RedstoneSide> EAST = BlockStateProperties.EAST_REDSTONE;
    public static final EnumProperty<RedstoneSide> SOUTH = BlockStateProperties.SOUTH_REDSTONE;
    public static final EnumProperty<RedstoneSide> WEST = BlockStateProperties.WEST_REDSTONE;
    public static final IntegerProperty POWER = BlockStateProperties.POWER;
    public static final Map<Direction, EnumProperty<RedstoneSide>> PROPERTY_BY_DIRECTION = Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.NORTH, NORTH, (Object)Direction.EAST, EAST, (Object)Direction.SOUTH, SOUTH, (Object)Direction.WEST, WEST));
    protected static final int H = 1;
    protected static final int W = 3;
    protected static final int E = 13;
    protected static final int N = 3;
    protected static final int S = 13;
    private static final VoxelShape SHAPE_DOT = Block.box(3.0, 0.0, 3.0, 13.0, 1.0, 13.0);
    private static final Map<Direction, VoxelShape> SHAPES_FLOOR = Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.NORTH, (Object)Block.box(3.0, 0.0, 0.0, 13.0, 1.0, 13.0), (Object)Direction.SOUTH, (Object)Block.box(3.0, 0.0, 3.0, 13.0, 1.0, 16.0), (Object)Direction.EAST, (Object)Block.box(3.0, 0.0, 3.0, 16.0, 1.0, 13.0), (Object)Direction.WEST, (Object)Block.box(0.0, 0.0, 3.0, 13.0, 1.0, 13.0)));
    private static final Map<Direction, VoxelShape> SHAPES_UP = Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.NORTH, (Object)Shapes.or((VoxelShape)SHAPES_FLOOR.get(Direction.NORTH), (VoxelShape)Block.box(3.0, 0.0, 0.0, 13.0, 16.0, 1.0)), (Object)Direction.SOUTH, (Object)Shapes.or((VoxelShape)SHAPES_FLOOR.get(Direction.SOUTH), (VoxelShape)Block.box(3.0, 0.0, 15.0, 13.0, 16.0, 16.0)), (Object)Direction.EAST, (Object)Shapes.or((VoxelShape)SHAPES_FLOOR.get(Direction.EAST), (VoxelShape)Block.box(15.0, 0.0, 3.0, 16.0, 16.0, 13.0)), (Object)Direction.WEST, (Object)Shapes.or((VoxelShape)SHAPES_FLOOR.get(Direction.WEST), (VoxelShape)Block.box(0.0, 0.0, 3.0, 1.0, 16.0, 13.0))));
    private static final Map<BlockState, VoxelShape> SHAPES_CACHE = Maps.newHashMap();
    private static final int[] COLORS = Util.make(new int[16], p_381107_ -> {
        for (int i = 0; i <= 15; ++i) {
            float f;
            float f1 = f * 0.6f + ((f = (float)i / 15.0f) > 0.0f ? 0.4f : 0.3f);
            float f2 = Mth.clamp((float)(f * f * 0.7f - 0.5f), (float)0.0f, (float)1.0f);
            float f3 = Mth.clamp((float)(f * f * 0.6f - 0.7f), (float)0.0f, (float)1.0f);
            p_381107_[i] = ARGB.colorFromFloat((float)1.0f, (float)f1, (float)f2, (float)f3);
        }
    });
    private static final float PARTICLE_DENSITY = 0.2f;
    private final BlockState crossState;
    private final RedstoneWireEvaluator evaluator = new DefaultRedstoneWireEvaluator(this);
    private boolean shouldSignal = true;

    public MapCodec<RedStoneWireBlock> codec() {
        return CODEC;
    }

    public RedStoneWireBlock(BlockBehaviour.Properties p_55511_) {
        super(p_55511_);
        this.registerDefaultState((BlockState)((Object)((BlockState)((Object)((BlockState)((Object)((BlockState)((Object)((BlockState)((Object)((BlockState)this.stateDefinition.any()).setValue((Property)NORTH, (Comparable)RedstoneSide.NONE))).setValue((Property)EAST, (Comparable)RedstoneSide.NONE))).setValue((Property)SOUTH, (Comparable)RedstoneSide.NONE))).setValue((Property)WEST, (Comparable)RedstoneSide.NONE))).setValue((Property)POWER, Integer.valueOf(0))));
        this.crossState = (BlockState)((Object)((BlockState)((Object)((BlockState)((Object)((BlockState)((Object)this.defaultBlockState().setValue((Property)NORTH, (Comparable)RedstoneSide.SIDE))).setValue((Property)EAST, (Comparable)RedstoneSide.SIDE))).setValue((Property)SOUTH, (Comparable)RedstoneSide.SIDE))).setValue((Property)WEST, (Comparable)RedstoneSide.SIDE));
        for (BlockState blockstate : this.getStateDefinition().getPossibleStates()) {
            if ((Integer)blockstate.getValue((Property)POWER) != 0) continue;
            SHAPES_CACHE.put(blockstate, this.calculateShape(blockstate));
        }
    }

    private VoxelShape calculateShape(BlockState p_55643_) {
        VoxelShape voxelshape = SHAPE_DOT;
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            RedstoneSide redstoneside = (RedstoneSide)p_55643_.getValue((Property)PROPERTY_BY_DIRECTION.get(direction));
            if (redstoneside == RedstoneSide.SIDE) {
                voxelshape = Shapes.or((VoxelShape)voxelshape, (VoxelShape)SHAPES_FLOOR.get(direction));
                continue;
            }
            if (redstoneside != RedstoneSide.UP) continue;
            voxelshape = Shapes.or((VoxelShape)voxelshape, (VoxelShape)SHAPES_UP.get(direction));
        }
        return voxelshape;
    }

    @Override
    protected VoxelShape getShape(BlockState p_55620_, BlockGetter p_55621_, BlockPos p_55622_, CollisionContext p_55623_) {
        return SHAPES_CACHE.get(p_55620_.setValue((Property)POWER, Integer.valueOf(0)));
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext p_55513_) {
        return this.getConnectionState((BlockGetter)((Object)p_55513_.getLevel()), this.crossState, p_55513_.getClickedPos());
    }

    private BlockState getConnectionState(BlockGetter p_55515_, BlockState p_55516_, BlockPos p_55517_) {
        boolean flag6;
        boolean flag = RedStoneWireBlock.isDot(p_55516_);
        p_55516_ = this.getMissingConnections(p_55515_, (BlockState)((Object)this.defaultBlockState().setValue((Property)POWER, (Integer)p_55516_.getValue((Property)POWER))), p_55517_);
        if (flag && RedStoneWireBlock.isDot(p_55516_)) {
            return p_55516_;
        }
        boolean flag1 = ((RedstoneSide)p_55516_.getValue((Property)NORTH)).isConnected();
        boolean flag2 = ((RedstoneSide)p_55516_.getValue((Property)SOUTH)).isConnected();
        boolean flag3 = ((RedstoneSide)p_55516_.getValue((Property)EAST)).isConnected();
        boolean flag4 = ((RedstoneSide)p_55516_.getValue((Property)WEST)).isConnected();
        boolean flag5 = !flag1 && !flag2;
        boolean bl = flag6 = !flag3 && !flag4;
        if (!flag4 && flag5) {
            p_55516_ = (BlockState)((Object)p_55516_.setValue((Property)WEST, (Comparable)RedstoneSide.SIDE));
        }
        if (!flag3 && flag5) {
            p_55516_ = (BlockState)((Object)p_55516_.setValue((Property)EAST, (Comparable)RedstoneSide.SIDE));
        }
        if (!flag1 && flag6) {
            p_55516_ = (BlockState)((Object)p_55516_.setValue((Property)NORTH, (Comparable)RedstoneSide.SIDE));
        }
        if (!flag2 && flag6) {
            p_55516_ = (BlockState)((Object)p_55516_.setValue((Property)SOUTH, (Comparable)RedstoneSide.SIDE));
        }
        return p_55516_;
    }

    private BlockState getMissingConnections(BlockGetter p_55609_, BlockState p_55610_, BlockPos p_55611_) {
        boolean flag = !p_55609_.getBlockState(p_55611_.above()).isRedstoneConductor(p_55609_, p_55611_);
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            if (((RedstoneSide)p_55610_.getValue((Property)PROPERTY_BY_DIRECTION.get(direction))).isConnected()) continue;
            RedstoneSide redstoneside = this.getConnectingSide(p_55609_, p_55611_, direction, flag);
            p_55610_ = (BlockState)((Object)p_55610_.setValue((Property)PROPERTY_BY_DIRECTION.get(direction), (Comparable)redstoneside));
        }
        return p_55610_;
    }

    @Override
    protected BlockState updateShape(BlockState p_55598_, LevelReader p_374191_, ScheduledTickAccess p_374077_, BlockPos p_55602_, Direction p_55599_, BlockPos p_55603_, BlockState p_55600_, RandomSource p_374364_) {
        if (p_55599_ == Direction.DOWN) {
            return !this.canSurviveOn(p_374191_, p_55603_, p_55600_) ? Blocks.AIR.defaultBlockState() : p_55598_;
        }
        if (p_55599_ == Direction.UP) {
            return this.getConnectionState(p_374191_, p_55598_, p_55602_);
        }
        RedstoneSide redstoneside = this.getConnectingSide(p_374191_, p_55602_, p_55599_);
        return redstoneside.isConnected() == ((RedstoneSide)p_55598_.getValue((Property)PROPERTY_BY_DIRECTION.get(p_55599_))).isConnected() && !RedStoneWireBlock.isCross(p_55598_) ? (BlockState)((Object)p_55598_.setValue((Property)PROPERTY_BY_DIRECTION.get(p_55599_), (Comparable)redstoneside)) : this.getConnectionState(p_374191_, (BlockState)((Object)((BlockState)((Object)this.crossState.setValue((Property)POWER, (Integer)p_55598_.getValue((Property)POWER)))).setValue((Property)PROPERTY_BY_DIRECTION.get(p_55599_), (Comparable)redstoneside)), p_55602_);
    }

    private static boolean isCross(BlockState p_55645_) {
        return ((RedstoneSide)p_55645_.getValue((Property)NORTH)).isConnected() && ((RedstoneSide)p_55645_.getValue((Property)SOUTH)).isConnected() && ((RedstoneSide)p_55645_.getValue((Property)EAST)).isConnected() && ((RedstoneSide)p_55645_.getValue((Property)WEST)).isConnected();
    }

    private static boolean isDot(BlockState p_55647_) {
        return !((RedstoneSide)p_55647_.getValue((Property)NORTH)).isConnected() && !((RedstoneSide)p_55647_.getValue((Property)SOUTH)).isConnected() && !((RedstoneSide)p_55647_.getValue((Property)EAST)).isConnected() && !((RedstoneSide)p_55647_.getValue((Property)WEST)).isConnected();
    }

    @Override
    protected void updateIndirectNeighbourShapes(BlockState p_55579_, LevelAccessor p_55580_, BlockPos p_55581_, int p_55582_, int p_55583_) {
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            RedstoneSide redstoneside = (RedstoneSide)p_55579_.getValue((Property)PROPERTY_BY_DIRECTION.get(direction));
            if (redstoneside == RedstoneSide.NONE || p_55580_.getBlockState((BlockPos)blockpos$mutableblockpos.setWithOffset((Vec3i)p_55581_, direction)).is(this)) continue;
            blockpos$mutableblockpos.move(Direction.DOWN);
            BlockState blockstate = p_55580_.getBlockState((BlockPos)blockpos$mutableblockpos);
            if (blockstate.is(this)) {
                BlockPos blockpos = blockpos$mutableblockpos.relative(direction.getOpposite());
                p_55580_.neighborShapeChanged(direction.getOpposite(), (BlockPos)blockpos$mutableblockpos, blockpos, p_55580_.getBlockState(blockpos), p_55582_, p_55583_);
            }
            blockpos$mutableblockpos.setWithOffset((Vec3i)p_55581_, direction).move(Direction.UP);
            BlockState blockstate1 = p_55580_.getBlockState((BlockPos)blockpos$mutableblockpos);
            if (!blockstate1.is(this)) continue;
            BlockPos blockpos1 = blockpos$mutableblockpos.relative(direction.getOpposite());
            p_55580_.neighborShapeChanged(direction.getOpposite(), (BlockPos)blockpos$mutableblockpos, blockpos1, p_55580_.getBlockState(blockpos1), p_55582_, p_55583_);
        }
    }

    private RedstoneSide getConnectingSide(BlockGetter p_55519_, BlockPos p_55520_, Direction p_55521_) {
        return this.getConnectingSide(p_55519_, p_55520_, p_55521_, !p_55519_.getBlockState(p_55520_.above()).isRedstoneConductor(p_55519_, p_55520_));
    }

    private RedstoneSide getConnectingSide(BlockGetter p_55523_, BlockPos p_55524_, Direction p_55525_, boolean p_55526_) {
        BlockPos blockpos = p_55524_.relative(p_55525_);
        BlockState blockstate = p_55523_.getBlockState(blockpos);
        if (p_55526_) {
            boolean flag;
            boolean bl = flag = blockstate.getBlock() instanceof TrapDoorBlock || this.canSurviveOn(p_55523_, blockpos, blockstate);
            if (flag && p_55523_.getBlockState(blockpos.above()).canRedstoneConnectTo(p_55523_, blockpos.above(), null)) {
                if (blockstate.isFaceSturdy(p_55523_, blockpos, p_55525_.getOpposite())) {
                    return RedstoneSide.UP;
                }
                return RedstoneSide.SIDE;
            }
        }
        if (blockstate.canRedstoneConnectTo(p_55523_, blockpos, p_55525_)) {
            return RedstoneSide.SIDE;
        }
        if (blockstate.isRedstoneConductor(p_55523_, blockpos)) {
            return RedstoneSide.NONE;
        }
        BlockPos blockPosBelow = blockpos.below();
        return p_55523_.getBlockState(blockPosBelow).canRedstoneConnectTo(p_55523_, blockPosBelow, null) ? RedstoneSide.SIDE : RedstoneSide.NONE;
    }

    @Override
    protected boolean canSurvive(BlockState p_55585_, LevelReader p_55586_, BlockPos p_55587_) {
        BlockPos blockpos = p_55587_.below();
        BlockState blockstate = p_55586_.getBlockState(blockpos);
        return this.canSurviveOn(p_55586_, blockpos, blockstate);
    }

    private boolean canSurviveOn(BlockGetter p_55613_, BlockPos p_55614_, BlockState p_55615_) {
        return p_55615_.isFaceSturdy(p_55613_, p_55614_, Direction.UP) || p_55615_.is(Blocks.HOPPER);
    }

    private void updatePowerStrength(Level p_55531_, BlockPos p_55532_, BlockState p_55533_, @Nullable Orientation p_362758_, boolean p_366538_) {
        if (RedStoneWireBlock.useExperimentalEvaluator(p_55531_)) {
            new ExperimentalRedstoneWireEvaluator(this).updatePowerStrength(p_55531_, p_55532_, p_55533_, p_362758_, p_366538_);
        } else {
            this.evaluator.updatePowerStrength(p_55531_, p_55532_, p_55533_, p_362758_, p_366538_);
        }
    }

    public int getBlockSignal(Level p_360310_, BlockPos p_361281_) {
        this.shouldSignal = false;
        int i = p_360310_.getBestNeighborSignal(p_361281_);
        this.shouldSignal = true;
        return i;
    }

    private void checkCornerChangeAt(Level p_55617_, BlockPos p_55618_) {
        if (p_55617_.getBlockState(p_55618_).is(this)) {
            p_55617_.updateNeighborsAt(p_55618_, this);
            for (Direction direction : Direction.values()) {
                p_55617_.updateNeighborsAt(p_55618_.relative(direction), this);
            }
        }
    }

    @Override
    protected void onPlace(BlockState p_55630_, Level p_55631_, BlockPos p_55632_, BlockState p_55633_, boolean p_55634_) {
        if (!p_55633_.is(p_55630_.getBlock()) && !p_55631_.isClientSide) {
            this.updatePowerStrength(p_55631_, p_55632_, p_55630_, null, true);
            for (Direction direction : Direction.Plane.VERTICAL) {
                p_55631_.updateNeighborsAt(p_55632_.relative(direction), this);
            }
            this.updateNeighborsOfNeighboringWires(p_55631_, p_55632_);
        }
    }

    @Override
    protected void onRemove(BlockState p_55568_, Level p_55569_, BlockPos p_55570_, BlockState p_55571_, boolean p_55572_) {
        if (!p_55572_ && !p_55568_.is(p_55571_.getBlock())) {
            super.onRemove(p_55568_, p_55569_, p_55570_, p_55571_, p_55572_);
            if (!p_55569_.isClientSide) {
                for (Direction direction : Direction.values()) {
                    p_55569_.updateNeighborsAt(p_55570_.relative(direction), this);
                }
                this.updatePowerStrength(p_55569_, p_55570_, p_55568_, null, false);
                this.updateNeighborsOfNeighboringWires(p_55569_, p_55570_);
            }
        }
    }

    private void updateNeighborsOfNeighboringWires(Level p_55638_, BlockPos p_55639_) {
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            this.checkCornerChangeAt(p_55638_, p_55639_.relative(direction));
        }
        for (Direction direction1 : Direction.Plane.HORIZONTAL) {
            BlockPos blockpos = p_55639_.relative(direction1);
            if (p_55638_.getBlockState(blockpos).isRedstoneConductor((BlockGetter)((Object)p_55638_), blockpos)) {
                this.checkCornerChangeAt(p_55638_, blockpos.above());
                continue;
            }
            this.checkCornerChangeAt(p_55638_, blockpos.below());
        }
    }

    @Override
    protected void neighborChanged(BlockState p_55561_, Level p_55562_, BlockPos p_55563_, Block p_55564_, @Nullable Orientation p_362973_, boolean p_55566_) {
        if (!(p_55562_.isClientSide || p_55564_ == this && RedStoneWireBlock.useExperimentalEvaluator(p_55562_))) {
            if (p_55561_.canSurvive((LevelReader)((Object)p_55562_), p_55563_)) {
                this.updatePowerStrength(p_55562_, p_55563_, p_55561_, p_362973_, false);
            } else {
                RedStoneWireBlock.dropResources(p_55561_, p_55562_, p_55563_);
                p_55562_.removeBlock(p_55563_, false);
            }
        }
    }

    private static boolean useExperimentalEvaluator(Level p_360594_) {
        return p_360594_.enabledFeatures().contains(FeatureFlags.REDSTONE_EXPERIMENTS);
    }

    @Override
    protected int getDirectSignal(BlockState p_55625_, BlockGetter p_55626_, BlockPos p_55627_, Direction p_55628_) {
        return !this.shouldSignal ? 0 : p_55625_.getSignal(p_55626_, p_55627_, p_55628_);
    }

    @Override
    protected int getSignal(BlockState p_55549_, BlockGetter p_55550_, BlockPos p_55551_, Direction p_55552_) {
        if (this.shouldSignal && p_55552_ != Direction.DOWN) {
            int i = (Integer)p_55549_.getValue((Property)POWER);
            if (i == 0) {
                return 0;
            }
            return p_55552_ != Direction.UP && !((RedstoneSide)this.getConnectionState(p_55550_, p_55549_, p_55551_).getValue((Property)PROPERTY_BY_DIRECTION.get(p_55552_.getOpposite()))).isConnected() ? 0 : i;
        }
        return 0;
    }

    protected static boolean shouldConnectTo(BlockState p_55641_) {
        return RedStoneWireBlock.shouldConnectTo(p_55641_, null);
    }

    protected static boolean shouldConnectTo(BlockState p_55595_, @Nullable Direction p_55596_) {
        if (p_55595_.is(Blocks.REDSTONE_WIRE)) {
            return true;
        }
        if (p_55595_.is(Blocks.REPEATER)) {
            Direction direction = (Direction)p_55595_.getValue((Property)RepeaterBlock.FACING);
            return direction == p_55596_ || direction.getOpposite() == p_55596_;
        }
        return p_55595_.is(Blocks.OBSERVER) ? p_55596_ == p_55595_.getValue((Property)ObserverBlock.FACING) : p_55595_.isSignalSource() && p_55596_ != null;
    }

    @Override
    protected boolean isSignalSource(BlockState p_55636_) {
        return this.shouldSignal;
    }

    public static int getColorForPower(int p_55607_) {
        return COLORS[p_55607_];
    }

    private static void spawnParticlesAlongLine(Level p_221923_, RandomSource p_221924_, BlockPos p_221925_, int p_380943_, Direction p_221927_, Direction p_221928_, float p_221929_, float p_221930_) {
        float f = p_221930_ - p_221929_;
        if (!(p_221924_.nextFloat() >= 0.2f * f)) {
            float f1 = 0.4375f;
            float f2 = p_221929_ + f * p_221924_.nextFloat();
            double d0 = 0.5 + (double)(0.4375f * (float)p_221927_.getStepX()) + (double)(f2 * (float)p_221928_.getStepX());
            double d1 = 0.5 + (double)(0.4375f * (float)p_221927_.getStepY()) + (double)(f2 * (float)p_221928_.getStepY());
            double d2 = 0.5 + (double)(0.4375f * (float)p_221927_.getStepZ()) + (double)(f2 * (float)p_221928_.getStepZ());
            p_221923_.addParticle((ParticleOptions)new DustParticleOptions(p_380943_, 1.0f), (double)p_221925_.getX() + d0, (double)p_221925_.getY() + d1, (double)p_221925_.getZ() + d2, 0.0, 0.0, 0.0);
        }
    }

    @Override
    public void animateTick(BlockState p_221932_, Level p_221933_, BlockPos p_221934_, RandomSource p_221935_) {
        int i = (Integer)p_221932_.getValue((Property)POWER);
        if (i != 0) {
            block4: for (Direction direction : Direction.Plane.HORIZONTAL) {
                RedstoneSide redstoneside = (RedstoneSide)p_221932_.getValue((Property)PROPERTY_BY_DIRECTION.get(direction));
                switch (redstoneside) {
                    case UP: {
                        RedStoneWireBlock.spawnParticlesAlongLine(p_221933_, p_221935_, p_221934_, COLORS[i], direction, Direction.UP, -0.5f, 0.5f);
                    }
                    case SIDE: {
                        RedStoneWireBlock.spawnParticlesAlongLine(p_221933_, p_221935_, p_221934_, COLORS[i], Direction.DOWN, direction, 0.0f, 0.5f);
                        continue block4;
                    }
                }
                RedStoneWireBlock.spawnParticlesAlongLine(p_221933_, p_221935_, p_221934_, COLORS[i], Direction.DOWN, direction, 0.0f, 0.3f);
            }
        }
    }

    @Override
    protected BlockState rotate(BlockState p_55592_, Rotation p_55593_) {
        switch (p_55593_) {
            case CLOCKWISE_180: {
                return (BlockState)((Object)((BlockState)((Object)((BlockState)((Object)((BlockState)((Object)p_55592_.setValue((Property)NORTH, (Comparable)((RedstoneSide)p_55592_.getValue((Property)SOUTH))))).setValue((Property)EAST, (Comparable)((RedstoneSide)p_55592_.getValue((Property)WEST))))).setValue((Property)SOUTH, (Comparable)((RedstoneSide)p_55592_.getValue((Property)NORTH))))).setValue((Property)WEST, (Comparable)((RedstoneSide)p_55592_.getValue((Property)EAST))));
            }
            case COUNTERCLOCKWISE_90: {
                return (BlockState)((Object)((BlockState)((Object)((BlockState)((Object)((BlockState)((Object)p_55592_.setValue((Property)NORTH, (Comparable)((RedstoneSide)p_55592_.getValue((Property)EAST))))).setValue((Property)EAST, (Comparable)((RedstoneSide)p_55592_.getValue((Property)SOUTH))))).setValue((Property)SOUTH, (Comparable)((RedstoneSide)p_55592_.getValue((Property)WEST))))).setValue((Property)WEST, (Comparable)((RedstoneSide)p_55592_.getValue((Property)NORTH))));
            }
            case CLOCKWISE_90: {
                return (BlockState)((Object)((BlockState)((Object)((BlockState)((Object)((BlockState)((Object)p_55592_.setValue((Property)NORTH, (Comparable)((RedstoneSide)p_55592_.getValue((Property)WEST))))).setValue((Property)EAST, (Comparable)((RedstoneSide)p_55592_.getValue((Property)NORTH))))).setValue((Property)SOUTH, (Comparable)((RedstoneSide)p_55592_.getValue((Property)EAST))))).setValue((Property)WEST, (Comparable)((RedstoneSide)p_55592_.getValue((Property)SOUTH))));
            }
        }
        return p_55592_;
    }

    @Override
    protected BlockState mirror(BlockState p_55589_, Mirror p_55590_) {
        switch (p_55590_) {
            case LEFT_RIGHT: {
                return (BlockState)((Object)((BlockState)((Object)p_55589_.setValue((Property)NORTH, (Comparable)((RedstoneSide)p_55589_.getValue((Property)SOUTH))))).setValue((Property)SOUTH, (Comparable)((RedstoneSide)p_55589_.getValue((Property)NORTH))));
            }
            case FRONT_BACK: {
                return (BlockState)((Object)((BlockState)((Object)p_55589_.setValue((Property)EAST, (Comparable)((RedstoneSide)p_55589_.getValue((Property)WEST))))).setValue((Property)WEST, (Comparable)((RedstoneSide)p_55589_.getValue((Property)EAST))));
            }
        }
        return super.mirror(p_55589_, p_55590_);
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> p_55605_) {
        p_55605_.add(new Property[]{NORTH, EAST, SOUTH, WEST, POWER});
    }

    @Override
    protected InteractionResult useWithoutItem(BlockState p_55554_, Level p_55555_, BlockPos p_55556_, Player p_55557_, BlockHitResult p_55559_) {
        if (!p_55557_.getAbilities().mayBuild) {
            return InteractionResult.PASS;
        }
        if (RedStoneWireBlock.isCross(p_55554_) || RedStoneWireBlock.isDot(p_55554_)) {
            BlockState blockstate = RedStoneWireBlock.isCross(p_55554_) ? this.defaultBlockState() : this.crossState;
            blockstate = (BlockState)((Object)blockstate.setValue((Property)POWER, (Integer)p_55554_.getValue((Property)POWER)));
            if ((blockstate = this.getConnectionState((BlockGetter)((Object)p_55555_), blockstate, p_55556_)) != p_55554_) {
                p_55555_.setBlock(p_55556_, blockstate, 3);
                this.updatesOnShapeChange(p_55555_, p_55556_, p_55554_, blockstate);
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    private void updatesOnShapeChange(Level p_55535_, BlockPos p_55536_, BlockState p_55537_, BlockState p_55538_) {
        Orientation orientation = ExperimentalRedstoneUtils.initialOrientation((Level)p_55535_, null, (Direction)Direction.UP);
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BlockPos blockpos = p_55536_.relative(direction);
            if (((RedstoneSide)p_55537_.getValue((Property)PROPERTY_BY_DIRECTION.get(direction))).isConnected() == ((RedstoneSide)p_55538_.getValue((Property)PROPERTY_BY_DIRECTION.get(direction))).isConnected() || !p_55535_.getBlockState(blockpos).isRedstoneConductor((BlockGetter)((Object)p_55535_), blockpos)) continue;
            p_55535_.updateNeighborsAtExceptFromFacing(blockpos, p_55538_.getBlock(), direction.getOpposite(), ExperimentalRedstoneUtils.withFront((Orientation)orientation, (Direction)direction));
        }
    }
}

