/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.datafixers.DataFixUtils;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.CommonHooks;

public class StemBlock
extends BushBlock
implements BonemealableBlock {
    public static final MapCodec<StemBlock> CODEC = RecordCodecBuilder.mapCodec(p_368441_ -> p_368441_.group((App)ResourceKey.codec(Registries.BLOCK).fieldOf("fruit").forGetter(p_304695_ -> p_304695_.fruit), (App)ResourceKey.codec(Registries.BLOCK).fieldOf("attached_stem").forGetter(p_304684_ -> p_304684_.attachedStem), (App)ResourceKey.codec(Registries.ITEM).fieldOf("seed").forGetter(p_304883_ -> p_304883_.seed), StemBlock.propertiesCodec()).apply((Applicative)p_368441_, StemBlock::new));
    public static final int MAX_AGE = 7;
    public static final IntegerProperty AGE = BlockStateProperties.AGE_7;
    protected static final float AABB_OFFSET = 1.0f;
    protected static final VoxelShape[] SHAPE_BY_AGE = new VoxelShape[]{Block.box(7.0, 0.0, 7.0, 9.0, 2.0, 9.0), Block.box(7.0, 0.0, 7.0, 9.0, 4.0, 9.0), Block.box(7.0, 0.0, 7.0, 9.0, 6.0, 9.0), Block.box(7.0, 0.0, 7.0, 9.0, 8.0, 9.0), Block.box(7.0, 0.0, 7.0, 9.0, 10.0, 9.0), Block.box(7.0, 0.0, 7.0, 9.0, 12.0, 9.0), Block.box(7.0, 0.0, 7.0, 9.0, 14.0, 9.0), Block.box(7.0, 0.0, 7.0, 9.0, 16.0, 9.0)};
    private final ResourceKey<Block> fruit;
    private final ResourceKey<Block> attachedStem;
    private final ResourceKey<Item> seed;

    public MapCodec<StemBlock> codec() {
        return CODEC;
    }

    public StemBlock(ResourceKey<Block> p_304976_, ResourceKey<Block> p_304671_, ResourceKey<Item> p_304942_, BlockBehaviour.Properties p_154730_) {
        super(p_154730_);
        this.fruit = p_304976_;
        this.attachedStem = p_304671_;
        this.seed = p_304942_;
        this.registerDefaultState((BlockState)((Object)((BlockState)this.stateDefinition.any()).setValue((Property)AGE, Integer.valueOf(0))));
    }

    @Override
    protected VoxelShape getShape(BlockState p_57047_, BlockGetter p_57048_, BlockPos p_57049_, CollisionContext p_57050_) {
        return SHAPE_BY_AGE[(Integer)p_57047_.getValue((Property)AGE)];
    }

    @Override
    protected boolean mayPlaceOn(BlockState p_57053_, BlockGetter p_57054_, BlockPos p_57055_) {
        return p_57053_.getBlock() instanceof FarmBlock;
    }

    @Override
    protected void randomTick(BlockState p_222538_, ServerLevel p_222539_, BlockPos p_222540_, RandomSource p_222541_) {
        float f;
        if (!p_222539_.isAreaLoaded(p_222540_, 1)) {
            return;
        }
        if (p_222539_.getRawBrightness(p_222540_, 0) >= 9 && CommonHooks.canCropGrow((Level)p_222539_, (BlockPos)p_222540_, (BlockState)p_222538_, (p_222541_.nextInt((int)(25.0f / (f = CropBlock.getGrowthSpeed(p_222538_, (BlockGetter)((Object)p_222539_), p_222540_))) + 1) == 0 ? 1 : 0) != 0)) {
            int i = (Integer)p_222538_.getValue((Property)AGE);
            if (i < 7) {
                p_222539_.setBlock(p_222540_, (BlockState)((Object)p_222538_.setValue((Property)AGE, Integer.valueOf(i + 1))), 2);
            } else {
                Direction direction = Direction.Plane.HORIZONTAL.getRandomDirection(p_222541_);
                BlockPos blockpos = p_222540_.relative(direction);
                BlockState blockstate = p_222539_.getBlockState(blockpos.below());
                if (p_222539_.isEmptyBlock(blockpos) && (blockstate.getBlock() instanceof FarmBlock || blockstate.is(BlockTags.DIRT))) {
                    Registry registry = p_222539_.registryAccess().lookupOrThrow(Registries.BLOCK);
                    Optional<Block> optional = registry.getOptional(this.fruit);
                    Optional<Block> optional1 = registry.getOptional(this.attachedStem);
                    if (optional.isPresent() && optional1.isPresent()) {
                        p_222539_.setBlockAndUpdate(blockpos, optional.get().defaultBlockState());
                        p_222539_.setBlockAndUpdate(p_222540_, (BlockState)((Object)optional1.get().defaultBlockState().setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)direction)));
                    }
                }
            }
            CommonHooks.fireCropGrowPost((Level)p_222539_, (BlockPos)p_222540_, (BlockState)p_222538_);
        }
    }

    @Override
    public ItemStack getCloneItemStack(LevelReader p_304982_, BlockPos p_57027_, BlockState p_57028_) {
        return new ItemStack((ItemLike)DataFixUtils.orElse(p_304982_.registryAccess().lookupOrThrow(Registries.ITEM).getOptional(this.seed), (Object)this));
    }

    public boolean isValidBonemealTarget(LevelReader p_255699_, BlockPos p_57031_, BlockState p_57032_) {
        return (Integer)p_57032_.getValue((Property)AGE) != 7;
    }

    public boolean isBonemealSuccess(Level p_222533_, RandomSource p_222534_, BlockPos p_222535_, BlockState p_222536_) {
        return true;
    }

    public void performBonemeal(ServerLevel p_222528_, RandomSource p_222529_, BlockPos p_222530_, BlockState p_222531_) {
        int i = Math.min(7, (Integer)p_222531_.getValue((Property)AGE) + Mth.nextInt((RandomSource)p_222528_.random, (int)2, (int)5));
        BlockState blockstate = (BlockState)((Object)p_222531_.setValue((Property)AGE, Integer.valueOf(i)));
        p_222528_.setBlock(p_222530_, blockstate, 2);
        if (i == 7) {
            blockstate.randomTick(p_222528_, p_222530_, p_222528_.random);
        }
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> p_57040_) {
        p_57040_.add(new Property[]{AGE});
    }
}

