/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import java.util.HashSet;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.CrashReportCategory;
import net.minecraft.CrashReportDetail;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.component.PatchedDataComponentMap;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.attachment.AttachmentHolder;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.common.extensions.IBlockEntityExtension;
import org.slf4j.Logger;

public abstract class BlockEntity
extends AttachmentHolder
implements IBlockEntityExtension {
    private static final Logger LOGGER = LogUtils.getLogger();
    @Deprecated
    private final BlockEntityType<?> type;
    @Nullable
    protected Level level;
    protected final BlockPos worldPosition;
    protected boolean remove;
    private BlockState blockState;
    private DataComponentMap components = DataComponentMap.EMPTY;
    @Nullable
    private CompoundTag customPersistentData;

    public BlockEntity(BlockEntityType<?> p_155228_, BlockPos p_155229_, BlockState p_155230_) {
        this.type = p_155228_;
        this.worldPosition = p_155229_.immutable();
        this.validateBlockState(p_155230_);
        this.blockState = p_155230_;
    }

    private void validateBlockState(BlockState p_353132_) {
        if (!this.isValidBlockState(p_353132_)) {
            throw new IllegalStateException("Invalid block entity " + this.getNameForReporting() + " state at " + String.valueOf(this.worldPosition) + ", got " + String.valueOf((Object)p_353132_));
        }
    }

    public boolean isValidBlockState(BlockState p_353131_) {
        return this.getType().isValid(p_353131_);
    }

    public static BlockPos getPosFromTag(CompoundTag p_187473_) {
        return new BlockPos(p_187473_.getInt("x"), p_187473_.getInt("y"), p_187473_.getInt("z"));
    }

    @Nullable
    public Level getLevel() {
        return this.level;
    }

    public void setLevel(Level p_155231_) {
        this.level = p_155231_;
    }

    public boolean hasLevel() {
        return this.level != null;
    }

    protected void loadAdditional(CompoundTag p_338466_, HolderLookup.Provider p_338445_) {
        if (p_338466_.contains("NeoForgeData", 10)) {
            this.customPersistentData = p_338466_.getCompound("NeoForgeData");
        }
        if (p_338466_.contains("neoforge:attachments", 10)) {
            this.deserializeAttachments(p_338445_, p_338466_.getCompound("neoforge:attachments"));
        }
    }

    public final void loadWithComponents(CompoundTag p_338356_, HolderLookup.Provider p_338558_) {
        this.loadAdditional(p_338356_, p_338558_);
        ComponentHelper.COMPONENTS_CODEC.parse(p_338558_.createSerializationContext(NbtOps.INSTANCE), (Object)p_338356_).resultOrPartial(p_337987_ -> LOGGER.warn("Failed to load components: {}", p_337987_)).ifPresent(p_337995_ -> {
            this.components = p_337995_;
        });
    }

    public final void loadCustomOnly(CompoundTag p_338387_, HolderLookup.Provider p_338713_) {
        this.loadAdditional(p_338387_, p_338713_);
    }

    protected void saveAdditional(CompoundTag p_187471_, HolderLookup.Provider p_323635_) {
        CompoundTag attachmentsTag;
        if (this.customPersistentData != null) {
            p_187471_.put("NeoForgeData", this.customPersistentData.copy());
        }
        if ((attachmentsTag = this.serializeAttachments(p_323635_)) != null) {
            p_187471_.put("neoforge:attachments", attachmentsTag);
        }
    }

    public final CompoundTag saveWithFullMetadata(HolderLookup.Provider p_323767_) {
        CompoundTag compoundtag = this.saveWithoutMetadata(p_323767_);
        this.saveMetadata(compoundtag);
        return compoundtag;
    }

    public final CompoundTag saveWithId(HolderLookup.Provider p_324357_) {
        CompoundTag compoundtag = this.saveWithoutMetadata(p_324357_);
        this.saveId(compoundtag);
        return compoundtag;
    }

    public final CompoundTag saveWithoutMetadata(HolderLookup.Provider p_324030_) {
        CompoundTag compoundtag = new CompoundTag();
        this.saveAdditional(compoundtag, p_324030_);
        ComponentHelper.COMPONENTS_CODEC.encodeStart(p_324030_.createSerializationContext(NbtOps.INSTANCE), (Object)this.components).resultOrPartial(p_337988_ -> LOGGER.warn("Failed to save components: {}", p_337988_)).ifPresent(p_337994_ -> compoundtag.merge((CompoundTag)p_337994_));
        return compoundtag;
    }

    public final CompoundTag saveCustomOnly(HolderLookup.Provider p_338656_) {
        CompoundTag compoundtag = new CompoundTag();
        this.saveAdditional(compoundtag, p_338656_);
        return compoundtag;
    }

    public final CompoundTag saveCustomAndMetadata(HolderLookup.Provider p_339688_) {
        CompoundTag compoundtag = this.saveCustomOnly(p_339688_);
        this.saveMetadata(compoundtag);
        return compoundtag;
    }

    private void saveId(CompoundTag p_187475_) {
        ResourceLocation resourcelocation = BlockEntityType.getKey(this.getType());
        if (resourcelocation == null) {
            throw new RuntimeException(String.valueOf(((Object)((Object)this)).getClass()) + " is missing a mapping! This is a bug!");
        }
        p_187475_.putString("id", resourcelocation.toString());
    }

    public static void addEntityType(CompoundTag p_187469_, BlockEntityType<?> p_187470_) {
        p_187469_.putString("id", BlockEntityType.getKey(p_187470_).toString());
    }

    public void saveToItem(ItemStack p_187477_, HolderLookup.Provider p_323484_) {
        CompoundTag compoundtag = this.saveCustomOnly(p_323484_);
        this.removeComponentsFromTag(compoundtag);
        p_187477_.clearComponents();
        BlockItem.setBlockEntityData(p_187477_, this.getType(), compoundtag);
        p_187477_.applyComponents(this.collectComponents());
    }

    private void saveMetadata(CompoundTag p_187479_) {
        this.saveId(p_187479_);
        p_187479_.putInt("x", this.worldPosition.getX());
        p_187479_.putInt("y", this.worldPosition.getY());
        p_187479_.putInt("z", this.worldPosition.getZ());
    }

    @Nullable
    public static BlockEntity loadStatic(BlockPos p_155242_, BlockState p_155243_, CompoundTag p_155244_, HolderLookup.Provider p_323542_) {
        String s = p_155244_.getString("id");
        ResourceLocation resourcelocation = ResourceLocation.tryParse(s);
        if (resourcelocation == null) {
            LOGGER.error("Block entity has invalid type: {}", (Object)s);
            return null;
        }
        return BuiltInRegistries.BLOCK_ENTITY_TYPE.getOptional(resourcelocation).map(p_155240_ -> {
            try {
                return p_155240_.create(p_155242_, p_155243_);
            }
            catch (Throwable throwable) {
                LOGGER.error("Failed to create block entity {}", (Object)s, (Object)throwable);
                return null;
            }
        }).map(p_337992_ -> {
            try {
                p_337992_.loadWithComponents(p_155244_, p_323542_);
                return p_337992_;
            }
            catch (Throwable throwable) {
                LOGGER.error("Failed to load data for block entity {}", (Object)s, (Object)throwable);
                return null;
            }
        }).orElseGet(() -> {
            LOGGER.warn("Skipping BlockEntity with id {}", (Object)s);
            return null;
        });
    }

    public void setChanged() {
        if (this.level != null) {
            BlockEntity.setChanged(this.level, this.worldPosition, this.blockState);
        }
    }

    protected static void setChanged(Level p_155233_, BlockPos p_155234_, BlockState p_155235_) {
        p_155233_.blockEntityChanged(p_155234_);
        if (!p_155235_.isAir()) {
            p_155233_.updateNeighbourForOutputSignal(p_155234_, p_155235_.getBlock());
        }
    }

    public BlockPos getBlockPos() {
        return this.worldPosition;
    }

    public BlockState getBlockState() {
        return this.blockState;
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return null;
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider p_323910_) {
        return new CompoundTag();
    }

    public boolean isRemoved() {
        return this.remove;
    }

    public void setRemoved() {
        this.remove = true;
        this.invalidateCapabilities();
        this.requestModelDataUpdate();
    }

    public void clearRemoved() {
        this.remove = false;
        this.invalidateCapabilities();
    }

    public boolean triggerEvent(int p_58889_, int p_58890_) {
        return false;
    }

    public void fillCrashReportCategory(CrashReportCategory p_58887_) {
        p_58887_.setDetail("Name", (CrashReportDetail<String>)((CrashReportDetail)this::getNameForReporting));
        if (this.level != null) {
            CrashReportCategory.populateBlockDetails(p_58887_, (LevelHeightAccessor)this.level, this.worldPosition, this.getBlockState());
            CrashReportCategory.populateBlockDetails(p_58887_, (LevelHeightAccessor)this.level, this.worldPosition, this.level.getBlockState(this.worldPosition));
        }
    }

    private String getNameForReporting() {
        return String.valueOf(BuiltInRegistries.BLOCK_ENTITY_TYPE.getKey(this.getType())) + " // " + ((Object)((Object)this)).getClass().getCanonicalName();
    }

    public boolean onlyOpCanSetNbt() {
        return false;
    }

    public BlockEntityType<?> getType() {
        return this.type;
    }

    public CompoundTag getPersistentData() {
        if (this.customPersistentData == null) {
            this.customPersistentData = new CompoundTag();
        }
        return this.customPersistentData;
    }

    @Nullable
    public final <T> T setData(AttachmentType<T> type, T data) {
        this.setChanged();
        return (T)super.setData(type, data);
    }

    @Nullable
    public final <T> T removeData(AttachmentType<T> type) {
        this.setChanged();
        return (T)super.removeData(type);
    }

    @Deprecated
    public void setBlockState(BlockState p_155251_) {
        this.validateBlockState(p_155251_);
        this.blockState = p_155251_;
    }

    protected void applyImplicitComponents(DataComponentInput p_338718_) {
    }

    public final void applyComponentsFromItemStack(ItemStack p_338428_) {
        this.applyComponents(p_338428_.getPrototype(), p_338428_.getComponentsPatch());
    }

    public final void applyComponents(DataComponentMap p_330364_, DataComponentPatch p_338381_) {
        final HashSet<DataComponentType> set = new HashSet<DataComponentType>();
        set.add(DataComponents.BLOCK_ENTITY_DATA);
        final PatchedDataComponentMap datacomponentmap = PatchedDataComponentMap.fromPatch(p_330364_, p_338381_);
        this.applyImplicitComponents(new DataComponentInput(){

            @Override
            @Nullable
            public <T> T get(DataComponentType<T> p_338266_) {
                set.add(p_338266_);
                return datacomponentmap.get(p_338266_);
            }

            @Override
            public <T> T getOrDefault(DataComponentType<? extends T> p_338358_, T p_338352_) {
                set.add(p_338358_);
                return datacomponentmap.getOrDefault(p_338358_, p_338352_);
            }
        });
        DataComponentPatch datacomponentpatch = p_338381_.forget(set::contains);
        this.components = datacomponentpatch.split().added();
    }

    protected void collectImplicitComponents(DataComponentMap.Builder p_338210_) {
    }

    @Deprecated
    public void removeComponentsFromTag(CompoundTag p_332032_) {
    }

    public final DataComponentMap collectComponents() {
        DataComponentMap.Builder datacomponentmap$builder = DataComponentMap.builder();
        datacomponentmap$builder.addAll(this.components);
        this.collectImplicitComponents(datacomponentmap$builder);
        return datacomponentmap$builder.build();
    }

    public DataComponentMap components() {
        return this.components;
    }

    public void setComponents(DataComponentMap p_338529_) {
        this.components = p_338529_;
    }

    @Nullable
    public static Component parseCustomNameSafe(String p_342033_, HolderLookup.Provider p_342030_) {
        try {
            return Component.Serializer.fromJson((String)p_342033_, (HolderLookup.Provider)p_342030_);
        }
        catch (Exception exception) {
            LOGGER.warn("Failed to parse custom name from string '{}', discarding", (Object)p_342033_, (Object)exception);
            return null;
        }
    }

    static class ComponentHelper {
        public static final Codec<DataComponentMap> COMPONENTS_CODEC = DataComponentMap.CODEC.optionalFieldOf("components", (Object)DataComponentMap.EMPTY).codec();

        private ComponentHelper() {
        }
    }

    protected static interface DataComponentInput {
        @Nullable
        public <T> T get(DataComponentType<T> var1);

        public <T> T getOrDefault(DataComponentType<? extends T> var1, T var2);

        @Nullable
        default public <T> T get(Supplier<? extends DataComponentType<T>> componentType) {
            return this.get(componentType.get());
        }

        default public <T> T getOrDefault(Supplier<? extends DataComponentType<T>> componentType, T value) {
            return this.getOrDefault(componentType.get(), value);
        }
    }
}

