/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.piston;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.SignalGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.piston.MovingPistonBlock;
import net.minecraft.world.level.block.piston.PistonHeadBlock;
import net.minecraft.world.level.block.piston.PistonMovingBlockEntity;
import net.minecraft.world.level.block.piston.PistonStructureResolver;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.PistonType;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.redstone.ExperimentalRedstoneUtils;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.event.EventHooks;

public class PistonBaseBlock
extends DirectionalBlock {
    public static final MapCodec<PistonBaseBlock> CODEC = RecordCodecBuilder.mapCodec(p_368476_ -> p_368476_.group((App)Codec.BOOL.fieldOf("sticky").forGetter(p_304492_ -> p_304492_.isSticky), (App)PistonBaseBlock.propertiesCodec()).apply((Applicative)p_368476_, PistonBaseBlock::new));
    public static final BooleanProperty EXTENDED = BlockStateProperties.EXTENDED;
    public static final int TRIGGER_EXTEND = 0;
    public static final int TRIGGER_CONTRACT = 1;
    public static final int TRIGGER_DROP = 2;
    public static final float PLATFORM_THICKNESS = 4.0f;
    protected static final VoxelShape EAST_AABB = Block.box(0.0, 0.0, 0.0, 12.0, 16.0, 16.0);
    protected static final VoxelShape WEST_AABB = Block.box(4.0, 0.0, 0.0, 16.0, 16.0, 16.0);
    protected static final VoxelShape SOUTH_AABB = Block.box(0.0, 0.0, 0.0, 16.0, 16.0, 12.0);
    protected static final VoxelShape NORTH_AABB = Block.box(0.0, 0.0, 4.0, 16.0, 16.0, 16.0);
    protected static final VoxelShape UP_AABB = Block.box(0.0, 0.0, 0.0, 16.0, 12.0, 16.0);
    protected static final VoxelShape DOWN_AABB = Block.box(0.0, 4.0, 0.0, 16.0, 16.0, 16.0);
    private final boolean isSticky;

    public MapCodec<PistonBaseBlock> codec() {
        return CODEC;
    }

    public PistonBaseBlock(boolean p_60163_, BlockBehaviour.Properties p_60164_) {
        super(p_60164_);
        this.registerDefaultState((BlockState)((Object)((BlockState)((Object)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH))).setValue((Property)EXTENDED, Boolean.valueOf(false))));
        this.isSticky = p_60163_;
    }

    protected VoxelShape getShape(BlockState p_60220_, BlockGetter p_60221_, BlockPos p_60222_, CollisionContext p_60223_) {
        if (((Boolean)p_60220_.getValue((Property)EXTENDED)).booleanValue()) {
            switch ((Direction)p_60220_.getValue((Property)FACING)) {
                case DOWN: {
                    return DOWN_AABB;
                }
                default: {
                    return UP_AABB;
                }
                case NORTH: {
                    return NORTH_AABB;
                }
                case SOUTH: {
                    return SOUTH_AABB;
                }
                case WEST: {
                    return WEST_AABB;
                }
                case EAST: 
            }
            return EAST_AABB;
        }
        return Shapes.block();
    }

    public void setPlacedBy(Level p_60172_, BlockPos p_60173_, BlockState p_60174_, LivingEntity p_60175_, ItemStack p_60176_) {
        if (!p_60172_.isClientSide) {
            this.checkIfExtend(p_60172_, p_60173_, p_60174_);
        }
    }

    protected void neighborChanged(BlockState p_60198_, Level p_60199_, BlockPos p_60200_, Block p_60201_, @Nullable Orientation p_363070_, boolean p_60203_) {
        if (!p_60199_.isClientSide) {
            this.checkIfExtend(p_60199_, p_60200_, p_60198_);
        }
    }

    protected void onPlace(BlockState p_60225_, Level p_60226_, BlockPos p_60227_, BlockState p_60228_, boolean p_60229_) {
        if (!p_60228_.is(p_60225_.getBlock()) && !p_60226_.isClientSide && p_60226_.getBlockEntity(p_60227_) == null) {
            this.checkIfExtend(p_60226_, p_60227_, p_60225_);
        }
    }

    public BlockState getStateForPlacement(BlockPlaceContext p_60166_) {
        return (BlockState)((Object)((BlockState)((Object)this.defaultBlockState().setValue((Property)FACING, (Comparable)p_60166_.getNearestLookingDirection().getOpposite()))).setValue((Property)EXTENDED, Boolean.valueOf(false)));
    }

    private void checkIfExtend(Level p_60168_, BlockPos p_60169_, BlockState p_60170_) {
        Direction direction = (Direction)p_60170_.getValue((Property)FACING);
        boolean flag = this.getNeighborSignal((SignalGetter)((Object)p_60168_), p_60169_, direction);
        if (flag && !((Boolean)p_60170_.getValue((Property)EXTENDED)).booleanValue()) {
            if (new PistonStructureResolver(p_60168_, p_60169_, direction, true).resolve()) {
                p_60168_.blockEvent(p_60169_, (Block)((Object)this), 0, direction.get3DDataValue());
            }
        } else if (!flag && ((Boolean)p_60170_.getValue((Property)EXTENDED)).booleanValue()) {
            PistonMovingBlockEntity pistonmovingblockentity;
            BlockEntity blockEntity;
            BlockPos blockpos = p_60169_.relative(direction, 2);
            BlockState blockstate = p_60168_.getBlockState(blockpos);
            int i = 1;
            if (blockstate.is(Blocks.MOVING_PISTON) && blockstate.getValue((Property)FACING) == direction && (blockEntity = p_60168_.getBlockEntity(blockpos)) instanceof PistonMovingBlockEntity && (pistonmovingblockentity = (PistonMovingBlockEntity)blockEntity).isExtending() && (pistonmovingblockentity.getProgress(0.0f) < 0.5f || p_60168_.getGameTime() == pistonmovingblockentity.getLastTicked() || ((ServerLevel)p_60168_).isHandlingTick())) {
                i = 2;
            }
            p_60168_.blockEvent(p_60169_, (Block)((Object)this), i, direction.get3DDataValue());
        }
    }

    private boolean getNeighborSignal(SignalGetter p_277378_, BlockPos p_60179_, Direction p_60180_) {
        for (Direction direction : Direction.values()) {
            if (direction == p_60180_ || !p_277378_.hasSignal(p_60179_.relative(direction), direction)) continue;
            return true;
        }
        if (p_277378_.hasSignal(p_60179_, Direction.DOWN)) {
            return true;
        }
        BlockPos blockpos = p_60179_.above();
        for (Direction direction1 : Direction.values()) {
            if (direction1 == Direction.DOWN || !p_277378_.hasSignal(blockpos.relative(direction1), direction1)) continue;
            return true;
        }
        return false;
    }

    protected boolean triggerEvent(BlockState p_60192_, Level p_60193_, BlockPos p_60194_, int p_60195_, int p_60196_) {
        Direction direction = (Direction)p_60192_.getValue((Property)FACING);
        BlockState blockstate = (BlockState)((Object)p_60192_.setValue((Property)EXTENDED, Boolean.valueOf(true)));
        if (!p_60193_.isClientSide) {
            boolean flag = this.getNeighborSignal((SignalGetter)((Object)p_60193_), p_60194_, direction);
            if (flag && (p_60195_ == 1 || p_60195_ == 2)) {
                p_60193_.setBlock(p_60194_, blockstate, 2);
                return false;
            }
            if (!flag && p_60195_ == 0) {
                return false;
            }
        }
        if (p_60195_ == 0) {
            if (EventHooks.onPistonMovePre((Level)p_60193_, (BlockPos)p_60194_, (Direction)direction, (boolean)true)) {
                return false;
            }
            if (!this.moveBlocks(p_60193_, p_60194_, direction, true)) {
                return false;
            }
            p_60193_.setBlock(p_60194_, blockstate, 67);
            p_60193_.playSound(null, p_60194_, SoundEvents.PISTON_EXTEND, SoundSource.BLOCKS, 0.5f, p_60193_.random.nextFloat() * 0.25f + 0.6f);
            p_60193_.gameEvent(GameEvent.BLOCK_ACTIVATE, p_60194_, GameEvent.Context.of((BlockState)blockstate));
        } else if (p_60195_ == 1 || p_60195_ == 2) {
            if (EventHooks.onPistonMovePre((Level)p_60193_, (BlockPos)p_60194_, (Direction)direction, (boolean)false)) {
                return false;
            }
            BlockEntity blockentity = p_60193_.getBlockEntity(p_60194_.relative(direction));
            if (blockentity instanceof PistonMovingBlockEntity) {
                ((PistonMovingBlockEntity)blockentity).finalTick();
            }
            BlockState blockstate1 = (BlockState)((Object)((BlockState)((Object)Blocks.MOVING_PISTON.defaultBlockState().setValue((Property)MovingPistonBlock.FACING, (Comparable)direction))).setValue((Property)MovingPistonBlock.TYPE, (Comparable)(this.isSticky ? PistonType.STICKY : PistonType.DEFAULT)));
            p_60193_.setBlock(p_60194_, blockstate1, 20);
            p_60193_.setBlockEntity(MovingPistonBlock.newMovingBlockEntity((BlockPos)p_60194_, (BlockState)blockstate1, (BlockState)((BlockState)((Object)this.defaultBlockState().setValue((Property)FACING, (Comparable)Direction.from3DDataValue((int)(p_60196_ & 7))))), (Direction)direction, (boolean)false, (boolean)true));
            p_60193_.blockUpdated(p_60194_, blockstate1.getBlock());
            blockstate1.updateNeighbourShapes(p_60193_, p_60194_, 2);
            if (this.isSticky) {
                PistonMovingBlockEntity pistonmovingblockentity;
                BlockEntity blockEntity;
                BlockPos blockpos = p_60194_.offset(direction.getStepX() * 2, direction.getStepY() * 2, direction.getStepZ() * 2);
                BlockState blockstate2 = p_60193_.getBlockState(blockpos);
                boolean flag1 = false;
                if (blockstate2.is(Blocks.MOVING_PISTON) && (blockEntity = p_60193_.getBlockEntity(blockpos)) instanceof PistonMovingBlockEntity && (pistonmovingblockentity = (PistonMovingBlockEntity)blockEntity).getDirection() == direction && pistonmovingblockentity.isExtending()) {
                    pistonmovingblockentity.finalTick();
                    flag1 = true;
                }
                if (!flag1) {
                    if (p_60195_ != 1 || blockstate2.isAir() || !PistonBaseBlock.isPushable(blockstate2, p_60193_, blockpos, direction.getOpposite(), false, direction) || blockstate2.getPistonPushReaction() != PushReaction.NORMAL && !blockstate2.is(Blocks.PISTON) && !blockstate2.is(Blocks.STICKY_PISTON)) {
                        p_60193_.removeBlock(p_60194_.relative(direction), false);
                    } else {
                        this.moveBlocks(p_60193_, p_60194_, direction, false);
                    }
                }
            } else {
                p_60193_.removeBlock(p_60194_.relative(direction), false);
            }
            p_60193_.playSound(null, p_60194_, SoundEvents.PISTON_CONTRACT, SoundSource.BLOCKS, 0.5f, p_60193_.random.nextFloat() * 0.15f + 0.6f);
            p_60193_.gameEvent(GameEvent.BLOCK_DEACTIVATE, p_60194_, GameEvent.Context.of((BlockState)blockstate1));
        }
        EventHooks.onPistonMovePost((Level)p_60193_, (BlockPos)p_60194_, (Direction)direction, (p_60195_ == 0 ? 1 : 0) != 0);
        return true;
    }

    public static boolean isPushable(BlockState p_60205_, Level p_60206_, BlockPos p_60207_, Direction p_60208_, boolean p_60209_, Direction p_60210_) {
        if (p_60207_.getY() < p_60206_.getMinY() || p_60207_.getY() > p_60206_.getMaxY() || !p_60206_.getWorldBorder().isWithinBounds(p_60207_)) {
            return false;
        }
        if (p_60205_.isAir()) {
            return true;
        }
        if (p_60205_.is(Blocks.OBSIDIAN) || p_60205_.is(Blocks.CRYING_OBSIDIAN) || p_60205_.is(Blocks.RESPAWN_ANCHOR) || p_60205_.is(Blocks.REINFORCED_DEEPSLATE)) {
            return false;
        }
        if (p_60208_ == Direction.DOWN && p_60207_.getY() == p_60206_.getMinY()) {
            return false;
        }
        if (p_60208_ == Direction.UP && p_60207_.getY() == p_60206_.getMaxY()) {
            return false;
        }
        if (!p_60205_.is(Blocks.PISTON) && !p_60205_.is(Blocks.STICKY_PISTON)) {
            if (p_60205_.getDestroySpeed((BlockGetter)((Object)p_60206_), p_60207_) == -1.0f) {
                return false;
            }
            switch (p_60205_.getPistonPushReaction()) {
                case BLOCK: {
                    return false;
                }
                case DESTROY: {
                    return p_60209_;
                }
                case PUSH_ONLY: {
                    return p_60208_ == p_60210_;
                }
            }
        } else if (((Boolean)p_60205_.getValue((Property)EXTENDED)).booleanValue()) {
            return false;
        }
        return !p_60205_.hasBlockEntity();
    }

    /*
     * WARNING - void declaration
     */
    private boolean moveBlocks(Level p_60182_, BlockPos p_60183_, Direction p_60184_, boolean p_60185_) {
        void var16_30;
        void var16_28;
        PistonStructureResolver pistonstructureresolver;
        BlockPos blockpos = p_60183_.relative(p_60184_);
        if (!p_60185_ && p_60182_.getBlockState(blockpos).is(Blocks.PISTON_HEAD)) {
            p_60182_.setBlock(blockpos, Blocks.AIR.defaultBlockState(), 20);
        }
        if (!(pistonstructureresolver = new PistonStructureResolver(p_60182_, p_60183_, p_60184_, p_60185_)).resolve()) {
            return false;
        }
        HashMap map = Maps.newHashMap();
        List<BlockPos> list = pistonstructureresolver.getToPush();
        ArrayList list1 = Lists.newArrayList();
        for (BlockPos blockpos1 : list) {
            BlockState blockstate = p_60182_.getBlockState(blockpos1);
            list1.add(blockstate);
            map.put(blockpos1, blockstate);
        }
        List<BlockPos> list2 = pistonstructureresolver.getToDestroy();
        BlockState[] ablockstate = new BlockState[list.size() + list2.size()];
        Direction direction = p_60185_ ? p_60184_ : p_60184_.getOpposite();
        int i = 0;
        for (int j = list2.size() - 1; j >= 0; --j) {
            BlockPos blockpos2 = list2.get(j);
            BlockState blockState = p_60182_.getBlockState(blockpos2);
            BlockEntity blockentity = blockState.hasBlockEntity() ? p_60182_.getBlockEntity(blockpos2) : null;
            PistonBaseBlock.dropResources((BlockState)blockState, (LevelAccessor)p_60182_, (BlockPos)blockpos2, (BlockEntity)blockentity);
            blockState.onDestroyedByPushReaction(p_60182_, blockpos2, direction, p_60182_.getFluidState(blockpos2));
            if (!blockState.is(BlockTags.FIRE)) {
                p_60182_.addDestroyBlockEffect(blockpos2, blockState);
            }
            ablockstate[i++] = blockState;
        }
        for (int k = list.size() - 1; k >= 0; --k) {
            BlockPos blockpos3 = list.get(k);
            BlockState blockState = p_60182_.getBlockState(blockpos3);
            blockpos3 = blockpos3.relative(direction);
            map.remove(blockpos3);
            BlockState blockstate7 = (BlockState)((Object)Blocks.MOVING_PISTON.defaultBlockState().setValue((Property)FACING, (Comparable)p_60184_));
            p_60182_.setBlock(blockpos3, blockstate7, 68);
            p_60182_.setBlockEntity(MovingPistonBlock.newMovingBlockEntity((BlockPos)blockpos3, (BlockState)blockstate7, (BlockState)((BlockState)((Object)list1.get(k))), (Direction)p_60184_, (boolean)p_60185_, (boolean)false));
            ablockstate[i++] = blockState;
        }
        if (p_60185_) {
            PistonType pistontype = this.isSticky ? PistonType.STICKY : PistonType.DEFAULT;
            BlockState blockstate4 = (BlockState)((Object)((BlockState)((Object)Blocks.PISTON_HEAD.defaultBlockState().setValue((Property)PistonHeadBlock.FACING, (Comparable)p_60184_))).setValue((Property)PistonHeadBlock.TYPE, (Comparable)pistontype));
            BlockState blockState = (BlockState)((Object)((BlockState)((Object)Blocks.MOVING_PISTON.defaultBlockState().setValue((Property)MovingPistonBlock.FACING, (Comparable)p_60184_))).setValue((Property)MovingPistonBlock.TYPE, (Comparable)(this.isSticky ? PistonType.STICKY : PistonType.DEFAULT)));
            map.remove(blockpos);
            p_60182_.setBlock(blockpos, blockState, 68);
            p_60182_.setBlockEntity(MovingPistonBlock.newMovingBlockEntity((BlockPos)blockpos, (BlockState)blockState, (BlockState)blockstate4, (Direction)p_60184_, (boolean)true, (boolean)true));
        }
        BlockState blockstate3 = Blocks.AIR.defaultBlockState();
        for (BlockPos blockPos : map.keySet()) {
            p_60182_.setBlock(blockPos, blockstate3, 82);
        }
        for (Map.Entry entry : map.entrySet()) {
            BlockPos blockpos5 = (BlockPos)entry.getKey();
            BlockState blockstate2 = (BlockState)((Object)entry.getValue());
            blockstate2.updateIndirectNeighbourShapes(p_60182_, blockpos5, 2);
            blockstate3.updateNeighbourShapes(p_60182_, blockpos5, 2);
            blockstate3.updateIndirectNeighbourShapes(p_60182_, blockpos5, 2);
        }
        Orientation orientation = ExperimentalRedstoneUtils.initialOrientation((Level)p_60182_, (Direction)pistonstructureresolver.getPushDirection(), null);
        i = 0;
        int n = list2.size() - 1;
        while (var16_28 >= 0) {
            BlockState blockstate8 = ablockstate[i++];
            BlockPos blockpos6 = list2.get((int)var16_28);
            blockstate8.updateIndirectNeighbourShapes(p_60182_, blockpos6, 2);
            p_60182_.updateNeighborsAt(blockpos6, blockstate8.getBlock(), orientation);
            --var16_28;
        }
        int n2 = list.size() - 1;
        while (var16_30 >= 0) {
            p_60182_.updateNeighborsAt(list.get((int)var16_30), ablockstate[i++].getBlock(), orientation);
            --var16_30;
        }
        if (p_60185_) {
            p_60182_.updateNeighborsAt(blockpos, Blocks.PISTON_HEAD, orientation);
        }
        return true;
    }

    protected BlockState rotate(BlockState p_60215_, Rotation p_60216_) {
        return (BlockState)((Object)p_60215_.setValue((Property)FACING, (Comparable)p_60216_.rotate((Direction)p_60215_.getValue((Property)FACING))));
    }

    public BlockState rotate(BlockState state, LevelAccessor world, BlockPos pos, Rotation direction) {
        return (Boolean)state.getValue((Property)EXTENDED) != false ? state : super.rotate(state, world, pos, direction);
    }

    protected BlockState mirror(BlockState p_60212_, Mirror p_60213_) {
        return p_60212_.rotate(p_60213_.getRotation((Direction)p_60212_.getValue((Property)FACING)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> p_60218_) {
        p_60218_.add(new Property[]{FACING, EXTENDED});
    }

    protected boolean useShapeForLightOcclusion(BlockState p_60231_) {
        return (Boolean)p_60231_.getValue((Property)EXTENDED);
    }

    protected boolean isPathfindable(BlockState p_60187_, PathComputationType p_60190_) {
        return false;
    }
}

