/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk.storage;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.shorts.ShortArrayList;
import it.unimi.dsi.fastutil.shorts.ShortList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.Optionull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.SectionPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongArrayTag;
import net.minecraft.nbt.NbtException;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.ShortTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ThreadedLevelLightEngine;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.CarvingMask;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.DataLayer;
import net.minecraft.world.level.chunk.ImposterProtoChunk;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.PalettedContainer;
import net.minecraft.world.level.chunk.PalettedContainerRO;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.chunk.UpgradeData;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.chunk.status.ChunkType;
import net.minecraft.world.level.chunk.storage.RegionStorageInfo;
import net.minecraft.world.level.levelgen.BelowZeroRetrogen;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.blending.BlendingData;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.ticks.LevelChunkTicks;
import net.minecraft.world.ticks.ProtoChunkTicks;
import net.minecraft.world.ticks.SavedTick;
import org.slf4j.Logger;

public record SerializableChunkData(Registry<Biome> biomeRegistry, ChunkPos chunkPos, int minSectionY, long lastUpdateTime, long inhabitedTime, ChunkStatus chunkStatus, @Nullable BlendingData.Packed blendingData, @Nullable BelowZeroRetrogen belowZeroRetrogen, UpgradeData upgradeData, @Nullable long[] carvingMask, Map<Heightmap.Types, long[]> heightmaps, ChunkAccess.PackedTicks packedTicks, ShortList[] postProcessingSections, boolean lightCorrect, List<SectionData> sectionData, List<CompoundTag> entities, List<CompoundTag> blockEntities, CompoundTag structureData, @Nullable CompoundTag attachmentData, @Nullable ListTag auxLightData) {
    private static final Codec<PalettedContainer<BlockState>> BLOCK_STATE_CODEC = PalettedContainer.codecRW(Block.BLOCK_STATE_REGISTRY, BlockState.CODEC, PalettedContainer.Strategy.SECTION_STATES, Blocks.AIR.defaultBlockState());
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final String TAG_UPGRADE_DATA = "UpgradeData";
    private static final String BLOCK_TICKS_TAG = "block_ticks";
    private static final String FLUID_TICKS_TAG = "fluid_ticks";
    public static final String X_POS_TAG = "xPos";
    public static final String Z_POS_TAG = "zPos";
    public static final String HEIGHTMAPS_TAG = "Heightmaps";
    public static final String IS_LIGHT_ON_TAG = "isLightOn";
    public static final String SECTIONS_TAG = "sections";
    public static final String BLOCK_LIGHT_TAG = "BlockLight";
    public static final String SKY_LIGHT_TAG = "SkyLight";

    @Deprecated
    SerializableChunkData(Registry<Biome> biomeRegistry, ChunkPos chunkPos, int minSectionY, long lastUpdateTime, long inhabitedTime, ChunkStatus chunkStatus, @Nullable BlendingData.Packed blendingData, @Nullable BelowZeroRetrogen belowZeroRetrogen, UpgradeData upgradeData, @Nullable long[] carvingMask, Map<Heightmap.Types, long[]> heightmaps, ChunkAccess.PackedTicks packedTicks, ShortList[] postProcessingSections, boolean lightCorrect, List<SectionData> sectionData, List<CompoundTag> entities, List<CompoundTag> blockEntities, CompoundTag structureData) {
        this(biomeRegistry, chunkPos, minSectionY, lastUpdateTime, inhabitedTime, chunkStatus, blendingData, belowZeroRetrogen, upgradeData, carvingMask, heightmaps, packedTicks, postProcessingSections, lightCorrect, sectionData, entities, blockEntities, structureData, null, null);
    }

    @Nullable
    public static SerializableChunkData parse(LevelHeightAccessor p_361938_, RegistryAccess p_365010_, CompoundTag p_362040_) {
        if (!p_362040_.contains("Status", 8)) {
            return null;
        }
        ChunkPos chunkpos = new ChunkPos(p_362040_.getInt(X_POS_TAG), p_362040_.getInt(Z_POS_TAG));
        long i = p_362040_.getLong("LastUpdate");
        long j = p_362040_.getLong("InhabitedTime");
        ChunkStatus chunkstatus = ChunkStatus.byName((String)p_362040_.getString("Status"));
        UpgradeData upgradedata = p_362040_.contains(TAG_UPGRADE_DATA, 10) ? new UpgradeData(p_362040_.getCompound(TAG_UPGRADE_DATA), p_361938_) : UpgradeData.EMPTY;
        boolean flag = p_362040_.getBoolean(IS_LIGHT_ON_TAG);
        BlendingData.Packed blendingdata$packed = p_362040_.contains("blending_data", 10) ? (BlendingData.Packed)BlendingData.Packed.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)p_362040_.getCompound("blending_data")).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).orElse(null) : null;
        BelowZeroRetrogen belowzeroretrogen = p_362040_.contains("below_zero_retrogen", 10) ? (BelowZeroRetrogen)BelowZeroRetrogen.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)p_362040_.getCompound("below_zero_retrogen")).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).orElse(null) : null;
        long[] along = p_362040_.contains("carving_mask", 12) ? p_362040_.getLongArray("carving_mask") : null;
        CompoundTag compoundtag = p_362040_.getCompound(HEIGHTMAPS_TAG);
        EnumMap<Heightmap.Types, long[]> map = new EnumMap<Heightmap.Types, long[]>(Heightmap.Types.class);
        for (Heightmap.Types heightmap$types : chunkstatus.heightmapsAfter()) {
            String s = heightmap$types.getSerializationKey();
            if (!compoundtag.contains(s, 12)) continue;
            map.put(heightmap$types, compoundtag.getLongArray(s));
        }
        List list1 = SavedTick.loadTickList((ListTag)p_362040_.getList(BLOCK_TICKS_TAG, 10), p_363212_ -> BuiltInRegistries.BLOCK.getOptional(ResourceLocation.tryParse(p_363212_)), (ChunkPos)chunkpos);
        List list2 = SavedTick.loadTickList((ListTag)p_362040_.getList(FLUID_TICKS_TAG, 10), p_364483_ -> BuiltInRegistries.FLUID.getOptional(ResourceLocation.tryParse(p_364483_)), (ChunkPos)chunkpos);
        ChunkAccess.PackedTicks chunkaccess$packedticks = new ChunkAccess.PackedTicks(list1, list2);
        ListTag listtag = p_362040_.getList("PostProcessing", 9);
        ShortList[] ashortlist = new ShortList[listtag.size()];
        for (int k = 0; k < listtag.size(); ++k) {
            ListTag listtag1 = listtag.getList(k);
            ShortArrayList shortlist = new ShortArrayList(listtag1.size());
            for (int l = 0; l < listtag1.size(); ++l) {
                shortlist.add(listtag1.getShort(l));
            }
            ashortlist[k] = shortlist;
        }
        List list3 = Lists.transform((List)p_362040_.getList("entities", 10), p_365486_ -> (CompoundTag)p_365486_);
        List list4 = Lists.transform((List)p_362040_.getList("block_entities", 10), p_362941_ -> (CompoundTag)p_362941_);
        CompoundTag compoundtag2 = p_362040_.getCompound("structures");
        ListTag listtag2 = p_362040_.getList(SECTIONS_TAG, 10);
        ArrayList<SectionData> list = new ArrayList<SectionData>(listtag2.size());
        Registry registry = p_365010_.lookupOrThrow(Registries.BIOME);
        Codec<PalettedContainerRO<Holder<Biome>>> codec = SerializableChunkData.makeBiomeCodec(registry);
        for (int i1 = 0; i1 < listtag2.size(); ++i1) {
            LevelChunkSection levelchunksection;
            CompoundTag compoundtag1 = listtag2.getCompound(i1);
            byte j1 = compoundtag1.getByte("Y");
            if (j1 >= p_361938_.getMinSectionY() && j1 <= p_361938_.getMaxSectionY()) {
                PalettedContainer palettedcontainer = compoundtag1.contains("block_states", 10) ? (PalettedContainer)BLOCK_STATE_CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)compoundtag1.getCompound("block_states")).promotePartial(p_361842_ -> SerializableChunkData.logErrors(chunkpos, j1, p_361842_)).getOrThrow(ChunkReadException::new) : new PalettedContainer(Block.BLOCK_STATE_REGISTRY, Blocks.AIR.defaultBlockState(), PalettedContainer.Strategy.SECTION_STATES);
                PalettedContainerRO palettedcontainerro = compoundtag1.contains("biomes", 10) ? (PalettedContainerRO)codec.parse((DynamicOps)NbtOps.INSTANCE, (Object)compoundtag1.getCompound("biomes")).promotePartial(p_361282_ -> SerializableChunkData.logErrors(chunkpos, j1, p_361282_)).getOrThrow(ChunkReadException::new) : new PalettedContainer(registry.asHolderIdMap(), registry.getOrThrow(Biomes.PLAINS), PalettedContainer.Strategy.SECTION_BIOMES);
                levelchunksection = new LevelChunkSection(palettedcontainer, (PalettedContainerRO<Holder<Biome>>)palettedcontainerro);
            } else {
                levelchunksection = null;
            }
            DataLayer datalayer = compoundtag1.contains(BLOCK_LIGHT_TAG, 7) ? new DataLayer(compoundtag1.getByteArray(BLOCK_LIGHT_TAG)) : null;
            DataLayer datalayer1 = compoundtag1.contains(SKY_LIGHT_TAG, 7) ? new DataLayer(compoundtag1.getByteArray(SKY_LIGHT_TAG)) : null;
            list.add(new SectionData(j1, levelchunksection, datalayer, datalayer1));
        }
        CompoundTag attachmentData = null;
        if (p_362040_.contains("neoforge:attachments", 10)) {
            attachmentData = p_362040_.getCompound("neoforge:attachments");
        }
        ListTag auxLightData = null;
        if (p_362040_.contains("neoforge:aux_lights", 9)) {
            auxLightData = p_362040_.getList("neoforge:aux_lights", 10);
        }
        return new SerializableChunkData(registry, chunkpos, p_361938_.getMinSectionY(), i, j, chunkstatus, blendingdata$packed, belowzeroretrogen, upgradedata, along, map, chunkaccess$packedticks, ashortlist, flag, list, list3, list4, compoundtag2, attachmentData, auxLightData);
    }

    public ProtoChunk read(ServerLevel p_360452_, PoiManager p_364451_, RegionStorageInfo p_364971_, ChunkPos p_360628_) {
        ChunkAccess chunkaccess;
        if (!Objects.equals(p_360628_, this.chunkPos)) {
            LOGGER.error("Chunk file at {} is in the wrong location; relocating. (Expected {}, got {})", new Object[]{p_360628_, p_360628_, this.chunkPos});
            p_360452_.getServer().reportMisplacedChunk(this.chunkPos, p_360628_, p_364971_);
        }
        int i = p_360452_.getSectionsCount();
        LevelChunkSection[] alevelchunksection = new LevelChunkSection[i];
        boolean flag = p_360452_.dimensionType().hasSkyLight();
        ServerChunkCache chunksource = p_360452_.getChunkSource();
        LevelLightEngine levellightengine = chunksource.getLightEngine();
        Registry registry = p_360452_.registryAccess().lookupOrThrow(Registries.BIOME);
        boolean flag1 = false;
        for (SectionData serializablechunkdata$sectiondata : this.sectionData) {
            boolean flag3;
            SectionPos sectionpos = SectionPos.of((ChunkPos)p_360628_, (int)serializablechunkdata$sectiondata.y);
            if (serializablechunkdata$sectiondata.chunkSection != null) {
                alevelchunksection[p_360452_.getSectionIndexFromSectionY((int)serializablechunkdata$sectiondata.y)] = serializablechunkdata$sectiondata.chunkSection;
                p_364451_.checkConsistencyWithBlocks(sectionpos, serializablechunkdata$sectiondata.chunkSection);
            }
            boolean flag2 = serializablechunkdata$sectiondata.blockLight != null;
            boolean bl = flag3 = flag && serializablechunkdata$sectiondata.skyLight != null;
            if (!flag2 && !flag3) continue;
            if (!flag1) {
                levellightengine.retainData(p_360628_, true);
                flag1 = true;
            }
            if (flag2) {
                levellightengine.queueSectionData(LightLayer.BLOCK, sectionpos, serializablechunkdata$sectiondata.blockLight);
            }
            if (!flag3) continue;
            levellightengine.queueSectionData(LightLayer.SKY, sectionpos, serializablechunkdata$sectiondata.skyLight);
        }
        ChunkType chunktype = this.chunkStatus.getChunkType();
        if (chunktype == ChunkType.LEVELCHUNK) {
            LevelChunkTicks levelchunkticks = new LevelChunkTicks(this.packedTicks.blocks());
            LevelChunkTicks levelchunkticks1 = new LevelChunkTicks(this.packedTicks.fluids());
            chunkaccess = new LevelChunk(p_360452_.getLevel(), p_360628_, this.upgradeData, (LevelChunkTicks<Block>)levelchunkticks, (LevelChunkTicks<Fluid>)levelchunkticks1, this.inhabitedTime, alevelchunksection, SerializableChunkData.postLoadChunk(p_360452_, this.entities, this.blockEntities), BlendingData.unpack((BlendingData.Packed)this.blendingData));
            if (this.auxLightData != null) {
                ((LevelChunk)chunkaccess).getAuxLightManager(this.chunkPos).deserializeNBT((HolderLookup.Provider)p_360452_.registryAccess(), this.auxLightData);
            }
        } else {
            ProtoChunkTicks protochunkticks = ProtoChunkTicks.load(this.packedTicks.blocks());
            ProtoChunkTicks protochunkticks1 = ProtoChunkTicks.load(this.packedTicks.fluids());
            ProtoChunk protochunk1 = new ProtoChunk(p_360628_, this.upgradeData, alevelchunksection, (ProtoChunkTicks<Block>)protochunkticks, (ProtoChunkTicks<Fluid>)protochunkticks1, (LevelHeightAccessor)p_360452_, registry, BlendingData.unpack((BlendingData.Packed)this.blendingData));
            chunkaccess = protochunk1;
            protochunk1.setInhabitedTime(this.inhabitedTime);
            if (this.belowZeroRetrogen != null) {
                protochunk1.setBelowZeroRetrogen(this.belowZeroRetrogen);
            }
            protochunk1.setPersistedStatus(this.chunkStatus);
            if (this.chunkStatus.isOrAfter(ChunkStatus.INITIALIZE_LIGHT)) {
                protochunk1.setLightEngine(levellightengine);
            }
        }
        chunkaccess.setLightCorrect(this.lightCorrect);
        EnumSet<Heightmap.Types> enumset = EnumSet.noneOf(Heightmap.Types.class);
        for (Heightmap.Types heightmap$types : chunkaccess.getPersistedStatus().heightmapsAfter()) {
            long[] along = this.heightmaps.get(heightmap$types);
            if (along != null) {
                chunkaccess.setHeightmap(heightmap$types, along);
                continue;
            }
            enumset.add(heightmap$types);
        }
        Heightmap.primeHeightmaps((ChunkAccess)chunkaccess, enumset);
        chunkaccess.setAllStarts(SerializableChunkData.unpackStructureStart(StructurePieceSerializationContext.fromLevel((ServerLevel)p_360452_), this.structureData, p_360452_.getSeed()));
        chunkaccess.setAllReferences(SerializableChunkData.unpackStructureReferences(p_360452_.registryAccess(), p_360628_, this.structureData));
        for (int j = 0; j < this.postProcessingSections.length; ++j) {
            chunkaccess.addPackedPostProcess(this.postProcessingSections[j], j);
        }
        if (this.attachmentData != null) {
            chunkaccess.readAttachmentsFromNBT((HolderLookup.Provider)p_360452_.registryAccess(), this.attachmentData);
        }
        if (chunktype == ChunkType.LEVELCHUNK) {
            return new ImposterProtoChunk((LevelChunk)chunkaccess, false);
        }
        ProtoChunk protochunk = (ProtoChunk)chunkaccess;
        for (CompoundTag compoundtag : this.entities) {
            protochunk.addEntity(compoundtag);
        }
        for (CompoundTag compoundtag1 : this.blockEntities) {
            protochunk.setBlockEntityNbt(compoundtag1);
        }
        if (this.carvingMask != null) {
            protochunk.setCarvingMask(new CarvingMask(this.carvingMask, chunkaccess.getMinY()));
        }
        return protochunk;
    }

    private static void logErrors(ChunkPos p_361949_, int p_364275_, String p_360703_) {
        LOGGER.error("Recoverable errors when loading section [{}, {}, {}]: {}", new Object[]{p_361949_.x, p_364275_, p_361949_.z, p_360703_});
    }

    private static Codec<PalettedContainerRO<Holder<Biome>>> makeBiomeCodec(Registry<Biome> p_364562_) {
        return PalettedContainer.codecRO(p_364562_.asHolderIdMap(), p_364562_.holderByNameCodec(), PalettedContainer.Strategy.SECTION_BIOMES, p_364562_.getOrThrow(Biomes.PLAINS));
    }

    public static SerializableChunkData copyOf(ServerLevel p_365319_, ChunkAccess p_362284_) {
        if (!p_362284_.canBeSerialized()) {
            throw new IllegalArgumentException("Chunk can't be serialized: " + String.valueOf(p_362284_));
        }
        ChunkPos chunkpos = p_362284_.getPos();
        ArrayList<SectionData> list = new ArrayList<SectionData>();
        LevelChunkSection[] alevelchunksection = p_362284_.getSections();
        ThreadedLevelLightEngine levellightengine = p_365319_.getChunkSource().getLightEngine();
        for (int i = levellightengine.getMinLightSection(); i < levellightengine.getMaxLightSection(); ++i) {
            DataLayer datalayer3;
            int j = p_362284_.getSectionIndexFromSectionY(i);
            boolean flag = j >= 0 && j < alevelchunksection.length;
            DataLayer datalayer = levellightengine.getLayerListener(LightLayer.BLOCK).getDataLayerData(SectionPos.of((ChunkPos)chunkpos, (int)i));
            DataLayer datalayer1 = levellightengine.getLayerListener(LightLayer.SKY).getDataLayerData(SectionPos.of((ChunkPos)chunkpos, (int)i));
            DataLayer dataLayer = datalayer != null && !datalayer.isEmpty() ? datalayer.copy() : null;
            DataLayer dataLayer2 = datalayer3 = datalayer1 != null && !datalayer1.isEmpty() ? datalayer1.copy() : null;
            if (!flag && dataLayer == null && datalayer3 == null) continue;
            LevelChunkSection levelchunksection = flag ? alevelchunksection[j].copy() : null;
            list.add(new SectionData(i, levelchunksection, dataLayer, datalayer3));
        }
        ArrayList<CompoundTag> list1 = new ArrayList<CompoundTag>(p_362284_.getBlockEntitiesPos().size());
        for (BlockPos blockpos : p_362284_.getBlockEntitiesPos()) {
            CompoundTag compoundtag = p_362284_.getBlockEntityNbtForSaving(blockpos, (HolderLookup.Provider)p_365319_.registryAccess());
            if (compoundtag == null) continue;
            list1.add(compoundtag);
        }
        ArrayList<CompoundTag> list2 = new ArrayList<CompoundTag>();
        long[] along = null;
        if (p_362284_.getPersistedStatus().getChunkType() == ChunkType.PROTOCHUNK) {
            ProtoChunk protochunk = (ProtoChunk)p_362284_;
            list2.addAll(protochunk.getEntities());
            CarvingMask carvingmask = protochunk.getCarvingMask();
            if (carvingmask != null) {
                along = carvingmask.toArray();
            }
        }
        EnumMap<Heightmap.Types, long[]> map = new EnumMap<Heightmap.Types, long[]>(Heightmap.Types.class);
        for (Map.Entry entry : p_362284_.getHeightmaps()) {
            if (!p_362284_.getPersistedStatus().heightmapsAfter().contains(entry.getKey())) continue;
            long[] along1 = ((Heightmap)entry.getValue()).getRawData();
            map.put((Heightmap.Types)entry.getKey(), (long[])along1.clone());
        }
        ChunkAccess.PackedTicks chunkaccess$packedticks = p_362284_.getTicksForSerialization(p_365319_.getGameTime());
        ShortList[] shortListArray = (ShortList[])Arrays.stream(p_362284_.getPostProcessing()).map(p_363794_ -> p_363794_ != null ? new ShortArrayList(p_363794_) : null).toArray(ShortList[]::new);
        CompoundTag compoundtag1 = SerializableChunkData.packStructureData(StructurePieceSerializationContext.fromLevel((ServerLevel)p_365319_), chunkpos, p_362284_.getAllStarts(), p_362284_.getAllReferences());
        CompoundTag attachmentData = null;
        try {
            attachmentData = p_362284_.writeAttachmentsToNBT((HolderLookup.Provider)p_365319_.registryAccess());
        }
        catch (Exception exception) {
            LOGGER.error("Failed to write chunk attachments. An attachment has likely thrown an exception trying to write state. It will not persist. Report this to the mod author", (Throwable)exception);
        }
        ListTag auxLightData = null;
        if (p_362284_ instanceof LevelChunk) {
            LevelChunk levelChunk = (LevelChunk)p_362284_;
            auxLightData = levelChunk.getAuxLightManager(chunkpos).serializeNBT((HolderLookup.Provider)p_365319_.registryAccess());
        }
        return new SerializableChunkData(p_365319_.registryAccess().lookupOrThrow(Registries.BIOME), chunkpos, p_362284_.getMinSectionY(), p_365319_.getGameTime(), p_362284_.getInhabitedTime(), p_362284_.getPersistedStatus(), (BlendingData.Packed)Optionull.map((Object)p_362284_.getBlendingData(), BlendingData::pack), p_362284_.getBelowZeroRetrogen(), p_362284_.getUpgradeData().copy(), along, map, chunkaccess$packedticks, shortListArray, p_362284_.isLightCorrect(), list, list2, list1, compoundtag1, attachmentData, auxLightData);
    }

    public CompoundTag write() {
        CompoundTag compoundtag = NbtUtils.addCurrentDataVersion((CompoundTag)new CompoundTag());
        compoundtag.putInt(X_POS_TAG, this.chunkPos.x);
        compoundtag.putInt("yPos", this.minSectionY);
        compoundtag.putInt(Z_POS_TAG, this.chunkPos.z);
        compoundtag.putLong("LastUpdate", this.lastUpdateTime);
        compoundtag.putLong("InhabitedTime", this.inhabitedTime);
        compoundtag.putString("Status", BuiltInRegistries.CHUNK_STATUS.getKey((Object)this.chunkStatus).toString());
        if (this.blendingData != null) {
            BlendingData.Packed.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.blendingData).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(p_360480_ -> compoundtag.put("blending_data", (Tag)p_360480_));
        }
        if (this.belowZeroRetrogen != null) {
            BelowZeroRetrogen.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.belowZeroRetrogen).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(p_363007_ -> compoundtag.put("below_zero_retrogen", (Tag)p_363007_));
        }
        if (!this.upgradeData.isEmpty()) {
            compoundtag.put(TAG_UPGRADE_DATA, this.upgradeData.write());
        }
        ListTag listtag = new ListTag();
        Codec<PalettedContainerRO<Holder<Biome>>> codec = SerializableChunkData.makeBiomeCodec(this.biomeRegistry);
        for (SectionData serializablechunkdata$sectiondata : this.sectionData) {
            CompoundTag compoundtag1 = new CompoundTag();
            LevelChunkSection levelchunksection = serializablechunkdata$sectiondata.chunkSection;
            if (levelchunksection != null) {
                compoundtag1.put("block_states", (Tag)BLOCK_STATE_CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, levelchunksection.getStates()).getOrThrow());
                compoundtag1.put("biomes", (Tag)codec.encodeStart((DynamicOps)NbtOps.INSTANCE, levelchunksection.getBiomes()).getOrThrow());
            }
            if (serializablechunkdata$sectiondata.blockLight != null) {
                compoundtag1.putByteArray(BLOCK_LIGHT_TAG, serializablechunkdata$sectiondata.blockLight.getData());
            }
            if (serializablechunkdata$sectiondata.skyLight != null) {
                compoundtag1.putByteArray(SKY_LIGHT_TAG, serializablechunkdata$sectiondata.skyLight.getData());
            }
            if (compoundtag1.isEmpty()) continue;
            compoundtag1.putByte("Y", (byte)serializablechunkdata$sectiondata.y);
            listtag.add((Object)compoundtag1);
        }
        compoundtag.put(SECTIONS_TAG, (Tag)listtag);
        if (this.lightCorrect) {
            compoundtag.putBoolean(IS_LIGHT_ON_TAG, true);
        }
        ListTag listtag1 = new ListTag();
        listtag1.addAll(this.blockEntities);
        compoundtag.put("block_entities", (Tag)listtag1);
        if (this.chunkStatus.getChunkType() == ChunkType.PROTOCHUNK) {
            ListTag listtag2 = new ListTag();
            listtag2.addAll(this.entities);
            compoundtag.put("entities", (Tag)listtag2);
            if (this.carvingMask != null) {
                compoundtag.putLongArray("carving_mask", this.carvingMask);
            }
        }
        SerializableChunkData.saveTicks(compoundtag, this.packedTicks);
        compoundtag.put("PostProcessing", (Tag)SerializableChunkData.packOffsets(this.postProcessingSections));
        CompoundTag compoundtag2 = new CompoundTag();
        this.heightmaps.forEach((p_362472_, p_363515_) -> compoundtag2.put(p_362472_.getSerializationKey(), (Tag)new LongArrayTag(p_363515_)));
        compoundtag.put(HEIGHTMAPS_TAG, compoundtag2);
        compoundtag.put("structures", this.structureData);
        if (this.attachmentData != null) {
            compoundtag.put("neoforge:attachments", this.attachmentData);
        }
        if (this.auxLightData != null) {
            compoundtag.put("neoforge:aux_lights", (Tag)this.auxLightData);
        }
        return compoundtag;
    }

    private static void saveTicks(CompoundTag p_362920_, ChunkAccess.PackedTicks p_361228_) {
        ListTag listtag = new ListTag();
        for (SavedTick<Block> savedtick : p_361228_.blocks()) {
            listtag.add((Object)savedtick.save(p_362770_ -> BuiltInRegistries.BLOCK.getKey(p_362770_).toString()));
        }
        p_362920_.put(BLOCK_TICKS_TAG, (Tag)listtag);
        ListTag listtag1 = new ListTag();
        for (SavedTick<Fluid> savedtick1 : p_361228_.fluids()) {
            listtag1.add((Object)savedtick1.save(p_362023_ -> BuiltInRegistries.FLUID.getKey(p_362023_).toString()));
        }
        p_362920_.put(FLUID_TICKS_TAG, (Tag)listtag1);
    }

    public static ChunkType getChunkTypeFromTag(@Nullable CompoundTag p_364385_) {
        return p_364385_ != null ? ChunkStatus.byName((String)p_364385_.getString("Status")).getChunkType() : ChunkType.PROTOCHUNK;
    }

    @Nullable
    private static LevelChunk.PostLoadProcessor postLoadChunk(ServerLevel p_363005_, List<CompoundTag> p_362405_, List<CompoundTag> p_364156_) {
        return p_362405_.isEmpty() && p_364156_.isEmpty() ? null : p_361360_ -> {
            if (!p_362405_.isEmpty()) {
                p_363005_.addLegacyChunkEntities(EntityType.loadEntitiesRecursive(p_362405_, p_363005_, EntitySpawnReason.LOAD));
            }
            for (CompoundTag compoundtag : p_364156_) {
                boolean flag = compoundtag.getBoolean("keepPacked");
                if (flag) {
                    p_361360_.setBlockEntityNbt(compoundtag);
                    continue;
                }
                BlockPos blockpos = BlockEntity.getPosFromTag(compoundtag);
                BlockEntity blockentity = BlockEntity.loadStatic(blockpos, p_361360_.getBlockState(blockpos), compoundtag, (HolderLookup.Provider)p_363005_.registryAccess());
                if (blockentity == null) continue;
                p_361360_.setBlockEntity(blockentity);
            }
        };
    }

    private static CompoundTag packStructureData(StructurePieceSerializationContext p_361063_, ChunkPos p_365377_, Map<Structure, StructureStart> p_365385_, Map<Structure, LongSet> p_362410_) {
        CompoundTag compoundtag = new CompoundTag();
        CompoundTag compoundtag1 = new CompoundTag();
        Registry registry = p_361063_.registryAccess().lookupOrThrow(Registries.STRUCTURE);
        for (Map.Entry<Structure, StructureStart> entry : p_365385_.entrySet()) {
            ResourceLocation resourcelocation = registry.getKey(entry.getKey());
            compoundtag1.put(resourcelocation.toString(), entry.getValue().createTag(p_361063_, p_365377_));
        }
        compoundtag.put("starts", compoundtag1);
        CompoundTag compoundtag2 = new CompoundTag();
        for (Map.Entry<Structure, LongSet> entry1 : p_362410_.entrySet()) {
            if (entry1.getValue().isEmpty()) continue;
            ResourceLocation resourcelocation1 = registry.getKey(entry1.getKey());
            compoundtag2.put(resourcelocation1.toString(), (Tag)new LongArrayTag(entry1.getValue()));
        }
        compoundtag.put("References", compoundtag2);
        return compoundtag;
    }

    private static Map<Structure, StructureStart> unpackStructureStart(StructurePieceSerializationContext p_360982_, CompoundTag p_363682_, long p_362695_) {
        HashMap map = Maps.newHashMap();
        Registry registry = p_360982_.registryAccess().lookupOrThrow(Registries.STRUCTURE);
        CompoundTag compoundtag = p_363682_.getCompound("starts");
        for (String s : compoundtag.getAllKeys()) {
            ResourceLocation resourcelocation = ResourceLocation.tryParse(s);
            Structure structure = (Structure)registry.getValue(resourcelocation);
            if (structure == null) {
                LOGGER.error("Unknown structure start: {}", (Object)resourcelocation);
                continue;
            }
            StructureStart structurestart = StructureStart.loadStaticStart(p_360982_, compoundtag.getCompound(s), p_362695_);
            if (structurestart == null) continue;
            map.put(structure, structurestart);
        }
        return map;
    }

    private static Map<Structure, LongSet> unpackStructureReferences(RegistryAccess p_360856_, ChunkPos p_362116_, CompoundTag p_360575_) {
        HashMap map = Maps.newHashMap();
        Registry registry = p_360856_.lookupOrThrow(Registries.STRUCTURE);
        CompoundTag compoundtag = p_360575_.getCompound("References");
        for (String s : compoundtag.getAllKeys()) {
            ResourceLocation resourcelocation = ResourceLocation.tryParse(s);
            Structure structure = (Structure)registry.getValue(resourcelocation);
            if (structure == null) {
                LOGGER.warn("Found reference to unknown structure '{}' in chunk {}, discarding", (Object)resourcelocation, (Object)p_362116_);
                continue;
            }
            long[] along = compoundtag.getLongArray(s);
            if (along.length == 0) continue;
            map.put(structure, new LongOpenHashSet(Arrays.stream(along).filter(p_360765_ -> {
                ChunkPos chunkpos = new ChunkPos(p_360765_);
                if (chunkpos.getChessboardDistance(p_362116_) > 8) {
                    LOGGER.warn("Found invalid structure reference [ {} @ {} ] for chunk {}.", new Object[]{resourcelocation, chunkpos, p_362116_});
                    return false;
                }
                return true;
            }).toArray()));
        }
        return map;
    }

    private static ListTag packOffsets(ShortList[] p_364852_) {
        ListTag listtag = new ListTag();
        for (ShortList shortlist : p_364852_) {
            ListTag listtag1 = new ListTag();
            if (shortlist != null) {
                for (int i = 0; i < shortlist.size(); ++i) {
                    listtag1.add((Object)ShortTag.valueOf((short)shortlist.getShort(i)));
                }
            }
            listtag.add((Object)listtag1);
        }
        return listtag;
    }

    public record SectionData(int y, @Nullable LevelChunkSection chunkSection, @Nullable DataLayer blockLight, @Nullable DataLayer skyLight) {
    }

    public static class ChunkReadException
    extends NbtException {
        public ChunkReadException(String p_361971_) {
            super(p_361971_);
        }
    }
}

