/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage;

import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.util.FastBufferedInputStream;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.level.saveddata.SavedData;
import net.neoforged.neoforge.common.IOUtilities;
import org.slf4j.Logger;

public class DimensionDataStorage
implements AutoCloseable {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final Map<String, Optional<SavedData>> cache = new HashMap<String, Optional<SavedData>>();
    private final DataFixer fixerUpper;
    private final HolderLookup.Provider registries;
    private final Path dataFolder;
    private CompletableFuture<?> pendingWriteFuture = CompletableFuture.completedFuture(null);

    public DimensionDataStorage(Path p_362421_, DataFixer p_78150_, HolderLookup.Provider p_324180_) {
        this.fixerUpper = p_78150_;
        this.dataFolder = p_362421_;
        this.registries = p_324180_;
    }

    private Path getDataFile(String p_78157_) {
        return this.dataFolder.resolve(p_78157_ + ".dat");
    }

    public <T extends SavedData> T computeIfAbsent(SavedData.Factory<T> p_294124_, String p_164864_) {
        T t = this.get(p_294124_, p_164864_);
        if (t != null) {
            return t;
        }
        SavedData t1 = (SavedData)p_294124_.constructor().get();
        this.set(p_164864_, t1);
        return (T)t1;
    }

    @Nullable
    public <T extends SavedData> T get(SavedData.Factory<T> p_295091_, String p_164860_) {
        Optional<SavedData> optional = this.cache.get(p_164860_);
        if (optional == null) {
            optional = Optional.ofNullable(this.readSavedData(p_295091_.deserializer(), p_295091_.type(), p_164860_));
            this.cache.put(p_164860_, optional);
        }
        return (T)((SavedData)optional.orElse(null));
    }

    @Nullable
    private <T extends SavedData> T readSavedData(BiFunction<CompoundTag, HolderLookup.Provider, T> p_324609_, @Nullable DataFixTypes p_295832_, String p_164870_) {
        try {
            Path path = this.getDataFile(p_164870_);
            if (Files.exists(path, new LinkOption[0])) {
                CompoundTag compoundtag = this.readTagFromDisk(p_164870_, p_295832_, SharedConstants.getCurrentVersion().getDataVersion().getVersion());
                return (T)((SavedData)p_324609_.apply(compoundtag.getCompound("data"), this.registries));
            }
        }
        catch (Exception exception) {
            LOGGER.error("Error loading saved data: {}", (Object)p_164870_, (Object)exception);
        }
        return null;
    }

    public void set(String p_164856_, SavedData p_164857_) {
        this.cache.put(p_164856_, Optional.of(p_164857_));
        p_164857_.setDirty();
    }

    public CompoundTag readTagFromDisk(String p_78159_, @Nullable DataFixTypes p_295038_, int p_78160_) throws IOException {
        CompoundTag compoundtag1;
        try (InputStream inputstream = Files.newInputStream(this.getDataFile(p_78159_), new OpenOption[0]);
             PushbackInputStream pushbackinputstream = new PushbackInputStream((InputStream)new FastBufferedInputStream(inputstream), 2);){
            CompoundTag compoundtag;
            if (this.isGzip(pushbackinputstream)) {
                compoundtag = NbtIo.readCompressed(pushbackinputstream, NbtAccounter.unlimitedHeap());
            } else {
                try (DataInputStream datainputstream = new DataInputStream(pushbackinputstream);){
                    compoundtag = NbtIo.read(datainputstream);
                }
            }
            if (p_295038_ != null) {
                int i = NbtUtils.getDataVersion((CompoundTag)compoundtag, (int)1343);
                compoundtag1 = p_295038_.update(this.fixerUpper, compoundtag, i, p_78160_);
            } else {
                compoundtag1 = compoundtag;
            }
        }
        IOUtilities.cleanupTempFiles((Path)this.dataFolder, (String)p_78159_);
        return compoundtag1;
    }

    private boolean isGzip(PushbackInputStream p_78155_) throws IOException {
        int j;
        byte[] abyte = new byte[2];
        boolean flag = false;
        int i = p_78155_.read(abyte, 0, 2);
        if (i == 2 && (j = (abyte[1] & 0xFF) << 8 | abyte[0] & 0xFF) == 35615) {
            flag = true;
        }
        if (i != 0) {
            p_78155_.unread(abyte, 0, i);
        }
        return flag;
    }

    public CompletableFuture<?> scheduleSave() {
        Map<Path, CompoundTag> map = this.collectDirtyTagsToSave();
        if (map.isEmpty()) {
            return CompletableFuture.completedFuture(null);
        }
        this.pendingWriteFuture = this.pendingWriteFuture.thenCompose(p_360267_ -> CompletableFuture.allOf((CompletableFuture[])map.entrySet().stream().map(p_360262_ -> DimensionDataStorage.tryWriteAsync((Path)p_360262_.getKey(), (CompoundTag)p_360262_.getValue())).toArray(CompletableFuture[]::new)));
        return this.pendingWriteFuture;
    }

    private Map<Path, CompoundTag> collectDirtyTagsToSave() {
        Object2ObjectArrayMap map = new Object2ObjectArrayMap();
        this.cache.forEach((arg_0, arg_1) -> this.lambda$collectDirtyTagsToSave$4((Map)map, arg_0, arg_1));
        return map;
    }

    private static CompletableFuture<Void> tryWriteAsync(Path p_364583_, CompoundTag p_363128_) {
        return CompletableFuture.runAsync(() -> {
            try {
                if (!Files.exists(p_364583_, new LinkOption[0])) {
                    Files.createDirectories(p_364583_.getParent(), new FileAttribute[0]);
                }
                IOUtilities.writeNbtCompressed((CompoundTag)p_363128_, (Path)p_364583_);
            }
            catch (IOException ioexception) {
                LOGGER.error("Could not save data to {}", (Object)p_364583_.getFileName(), (Object)ioexception);
            }
        }, (Executor)Util.ioPool());
    }

    public void saveAndJoin() {
        this.scheduleSave().join();
    }

    @Override
    public void close() {
        this.saveAndJoin();
    }

    private /* synthetic */ void lambda$collectDirtyTagsToSave$4(Map map, String p_360264_, Optional p_360265_) {
        p_360265_.filter(SavedData::isDirty).ifPresent(p_360261_ -> map.put(this.getDataFile(p_360264_), p_360261_.save(this.registries)));
    }
}

