/*
 * Decompiled with CFR 0.152.
 */
package co.aikar.util;

import java.lang.reflect.Constructor;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;

public class LoadingMap<K, V>
extends AbstractMap<K, V> {
    private final Map<K, V> backingMap;
    private final Function<K, V> loader;

    public LoadingMap(Map<K, V> backingMap, Function<K, V> loader) {
        this.backingMap = backingMap;
        this.loader = loader;
    }

    public static <K, V> Map<K, V> of(Map<K, V> backingMap, Function<K, V> loader) {
        return new LoadingMap<K, V>(backingMap, loader);
    }

    public static <K, V> Map<K, V> newAutoMap(Map<K, V> backingMap, Class<? extends K> keyClass, Class<? extends V> valueClass) {
        return new LoadingMap<K, V>(backingMap, new AutoInstantiatingLoader<K, V>(keyClass, valueClass));
    }

    public static <K, V> Map<K, V> newAutoMap(Map<K, V> backingMap, Class<? extends V> valueClass) {
        return LoadingMap.newAutoMap(backingMap, null, valueClass);
    }

    public static <K, V> Map<K, V> newHashAutoMap(Class<? extends K> keyClass, Class<? extends V> valueClass) {
        return LoadingMap.newAutoMap(new HashMap(), keyClass, valueClass);
    }

    public static <K, V> Map<K, V> newHashAutoMap(Class<? extends V> valueClass) {
        return LoadingMap.newHashAutoMap(null, valueClass);
    }

    public static <K, V> Map<K, V> newHashAutoMap(Class<? extends K> keyClass, Class<? extends V> valueClass, int initialCapacity, float loadFactor) {
        return LoadingMap.newAutoMap(new HashMap(initialCapacity, loadFactor), keyClass, valueClass);
    }

    public static <K, V> Map<K, V> newHashAutoMap(Class<? extends V> valueClass, int initialCapacity, float loadFactor) {
        return LoadingMap.newHashAutoMap(null, valueClass, initialCapacity, loadFactor);
    }

    public static <K, V> Map<K, V> newHashMap(Function<K, V> loader) {
        return new LoadingMap(new HashMap(), loader);
    }

    public static <K, V> Map<K, V> newHashMap(Function<K, V> loader, int initialCapacity, float loadFactor) {
        return new LoadingMap(new HashMap(initialCapacity, loadFactor), loader);
    }

    public static <K, V> Map<K, V> newIdentityHashMap(Function<K, V> loader) {
        return new LoadingMap(new IdentityHashMap(), loader);
    }

    public static <K, V> Map<K, V> newIdentityHashMap(Function<K, V> loader, int initialCapacity) {
        return new LoadingMap(new IdentityHashMap(initialCapacity), loader);
    }

    @Override
    public int size() {
        return this.backingMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.backingMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.backingMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.backingMap.containsValue(value);
    }

    @Override
    public V get(Object key) {
        V res = this.backingMap.get(key);
        if (res == null && key != null && (res = this.loader.apply(key)) != null) {
            this.backingMap.put(key, res);
        }
        return res;
    }

    @Override
    public V put(K key, V value) {
        return this.backingMap.put(key, value);
    }

    @Override
    public V remove(Object key) {
        return this.backingMap.remove(key);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        this.backingMap.putAll(m);
    }

    @Override
    public void clear() {
        this.backingMap.clear();
    }

    @Override
    public Set<K> keySet() {
        return this.backingMap.keySet();
    }

    @Override
    public Collection<V> values() {
        return this.backingMap.values();
    }

    @Override
    public boolean equals(Object o) {
        return this.backingMap.equals(o);
    }

    @Override
    public int hashCode() {
        return this.backingMap.hashCode();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.backingMap.entrySet();
    }

    @Override
    public LoadingMap<K, V> clone() {
        return new LoadingMap<K, V>(this.backingMap, this.loader);
    }

    public static abstract class Feeder<T>
    implements Function<Object, T> {
        @Override
        @Nullable
        public T apply(@Nullable Object input) {
            return this.apply();
        }

        public abstract T apply();
    }

    private static class AutoInstantiatingLoader<K, V>
    implements Function<K, V> {
        final Constructor<? extends V> constructor;
        private final Class<? extends V> valueClass;

        AutoInstantiatingLoader(Class<? extends K> keyClass, Class<? extends V> valueClass) {
            try {
                this.valueClass = valueClass;
                this.constructor = keyClass != null ? valueClass.getConstructor(keyClass) : null;
            }
            catch (NoSuchMethodException e) {
                throw new IllegalStateException(valueClass.getName() + " does not have a constructor for " + keyClass.getName());
            }
        }

        @Override
        public V apply(K input) {
            try {
                return this.constructor != null ? this.constructor.newInstance(input) : this.valueClass.newInstance();
            }
            catch (Exception e) {
                throw new ExceptionInInitializerError(e);
            }
        }

        public int hashCode() {
            return super.hashCode();
        }

        public boolean equals(Object object) {
            return false;
        }
    }
}

