/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

interface CycleDetectingLock<ID> {
    public ListMultimap<Long, ID> lockOrDetectPotentialLocksCycle();

    public void unlock();

    public static class CycleDetectingLockFactory<ID> {
        private Map<Long, ReentrantCycleDetectingLock> lockThreadIsWaitingOn = Maps.newHashMap();
        private final Multimap<Long, ReentrantCycleDetectingLock> locksOwnedByThread = LinkedHashMultimap.create();

        CycleDetectingLock<ID> create(ID newLockId) {
            return new ReentrantCycleDetectingLock(newLockId, new ReentrantLock());
        }

        class ReentrantCycleDetectingLock
        implements CycleDetectingLock<ID> {
            private final Lock lockImplementation;
            private final ID userLockId;
            private Long lockOwnerThreadId = null;
            private int lockReentranceCount = 0;

            ReentrantCycleDetectingLock(ID userLockId, Lock lockImplementation) {
                this.userLockId = Preconditions.checkNotNull(userLockId, (Object)"userLockId");
                this.lockImplementation = (Lock)Preconditions.checkNotNull((Object)lockImplementation, (Object)"lockImplementation");
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ListMultimap<Long, ID> lockOrDetectPotentialLocksCycle() {
                long currentThreadId = Thread.currentThread().getId();
                CycleDetectingLockFactory cycleDetectingLockFactory = CycleDetectingLockFactory.this;
                synchronized (cycleDetectingLockFactory) {
                    this.checkState();
                    ListMultimap locksInCycle = this.detectPotentialLocksCycle();
                    if (!locksInCycle.isEmpty()) {
                        return locksInCycle;
                    }
                    CycleDetectingLockFactory.this.lockThreadIsWaitingOn.put(currentThreadId, this);
                }
                this.lockImplementation.lock();
                cycleDetectingLockFactory = CycleDetectingLockFactory.this;
                synchronized (cycleDetectingLockFactory) {
                    CycleDetectingLockFactory.this.lockThreadIsWaitingOn.remove(currentThreadId);
                    this.checkState();
                    this.lockOwnerThreadId = currentThreadId;
                    ++this.lockReentranceCount;
                    CycleDetectingLockFactory.this.locksOwnedByThread.put((Object)currentThreadId, (Object)this);
                }
                return ImmutableListMultimap.of();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unlock() {
                long currentThreadId = Thread.currentThread().getId();
                CycleDetectingLockFactory cycleDetectingLockFactory = CycleDetectingLockFactory.this;
                synchronized (cycleDetectingLockFactory) {
                    this.checkState();
                    Preconditions.checkState((this.lockOwnerThreadId != null ? (char)'\u0001' : '\u0000') != '\u0000', (Object)"Thread is trying to unlock a lock that is not locked");
                    Preconditions.checkState((this.lockOwnerThreadId == currentThreadId ? (char)'\u0001' : '\u0000') != '\u0000', (Object)"Thread is trying to unlock a lock owned by another thread");
                    this.lockImplementation.unlock();
                    --this.lockReentranceCount;
                    if (this.lockReentranceCount == 0) {
                        this.lockOwnerThreadId = null;
                        Preconditions.checkState((boolean)CycleDetectingLockFactory.this.locksOwnedByThread.remove((Object)currentThreadId, (Object)this), (Object)"Internal error: Can not find this lock in locks owned by a current thread");
                        if (CycleDetectingLockFactory.this.locksOwnedByThread.get((Object)currentThreadId).isEmpty()) {
                            CycleDetectingLockFactory.this.locksOwnedByThread.removeAll((Object)currentThreadId);
                        }
                    }
                }
            }

            void checkState() throws IllegalStateException {
                long currentThreadId = Thread.currentThread().getId();
                Preconditions.checkState((!CycleDetectingLockFactory.this.lockThreadIsWaitingOn.containsKey(currentThreadId) ? (char)'\u0001' : '\u0000') != '\u0000', (Object)"Internal error: Thread should not be in a waiting thread on a lock now");
                if (this.lockOwnerThreadId != null) {
                    Preconditions.checkState((this.lockReentranceCount >= 0 ? (char)'\u0001' : '\u0000') != '\u0000', (Object)"Internal error: Lock ownership and reentrance count internal states do not match");
                    Preconditions.checkState((boolean)CycleDetectingLockFactory.this.locksOwnedByThread.get((Object)this.lockOwnerThreadId).contains(this), (Object)"Internal error: Set of locks owned by a current thread and lock ownership status do not match");
                } else {
                    Preconditions.checkState((this.lockReentranceCount == 0 ? (char)'\u0001' : '\u0000') != '\u0000', (Object)"Internal error: Reentrance count of a non locked lock is expect to be zero");
                    Preconditions.checkState((!CycleDetectingLockFactory.this.locksOwnedByThread.values().contains(this) ? (char)'\u0001' : '\u0000') != '\u0000', (Object)"Internal error: Non locked lock should not be owned by any thread");
                }
            }

            private ListMultimap<Long, ID> detectPotentialLocksCycle() {
                long currentThreadId = Thread.currentThread().getId();
                if (this.lockOwnerThreadId == null || this.lockOwnerThreadId == currentThreadId) {
                    return ImmutableListMultimap.of();
                }
                ListMultimap potentialLocksCycle = Multimaps.newListMultimap(new LinkedHashMap(), (Supplier)new Supplier<List<ID>>(){

                    public List<ID> get() {
                        return Lists.newArrayList();
                    }
                });
                ReentrantCycleDetectingLock lockOwnerWaitingOn = this;
                while (lockOwnerWaitingOn != null && lockOwnerWaitingOn.lockOwnerThreadId != null) {
                    Long threadOwnerThreadWaits = lockOwnerWaitingOn.lockOwnerThreadId;
                    potentialLocksCycle.putAll((Object)threadOwnerThreadWaits, this.getAllLockIdsAfter(threadOwnerThreadWaits, lockOwnerWaitingOn));
                    if (threadOwnerThreadWaits == currentThreadId) {
                        return potentialLocksCycle;
                    }
                    lockOwnerWaitingOn = (ReentrantCycleDetectingLock)CycleDetectingLockFactory.this.lockThreadIsWaitingOn.get(threadOwnerThreadWaits);
                }
                return ImmutableListMultimap.of();
            }

            private List<ID> getAllLockIdsAfter(long threadId, ReentrantCycleDetectingLock lock) {
                ArrayList ids = Lists.newArrayList();
                boolean found = false;
                Collection ownedLocks = CycleDetectingLockFactory.this.locksOwnedByThread.get((Object)threadId);
                Preconditions.checkNotNull((Object)ownedLocks, (Object)"Internal error: No locks were found taken by a thread");
                for (ReentrantCycleDetectingLock ownedLock : ownedLocks) {
                    if (ownedLock == lock) {
                        found = true;
                    }
                    if (!found) continue;
                    ids.add(ownedLock.userLockId);
                }
                Preconditions.checkState((boolean)found, (Object)"Internal error: We can not find locks that created a cycle that we detected");
                return ids;
            }

            public String toString() {
                Long localLockOwnerThreadId = this.lockOwnerThreadId;
                if (localLockOwnerThreadId != null) {
                    return String.format("CycleDetectingLock[%s][locked by %s]", this.userLockId, localLockOwnerThreadId);
                }
                return String.format("CycleDetectingLock[%s][unlocked]", this.userLockId);
            }
        }
    }
}

