/*
 * Decompiled with CFR 0.152.
 */
package ninja.leaping.configurate.objectmapping.serialize;

import com.google.common.base.Preconditions;
import com.google.common.reflect.TypeToken;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import ninja.leaping.configurate.objectmapping.serialize.TypeSerializer;

public class TypeSerializerCollection {
    private final TypeSerializerCollection parent;
    private final Map<TypeToken<?>, TypeSerializer<?>> typeMatches = new ConcurrentHashMap();
    private final Map<Predicate<TypeToken<?>>, TypeSerializer<?>> functionMatches = new ConcurrentHashMap();

    TypeSerializerCollection(TypeSerializerCollection parent) {
        this.parent = parent;
    }

    public <T> TypeSerializer<T> get(TypeToken<T> type) {
        Preconditions.checkNotNull((Object)type, (Object)"type");
        type = type.wrap();
        TypeSerializer<Object> serial = this.typeMatches.get(type);
        if (serial == null) {
            for (Map.Entry<Object, TypeSerializer<?>> entry : this.typeMatches.entrySet()) {
                if (!((TypeToken)entry.getKey()).isAssignableFrom(type)) continue;
                serial = entry.getValue();
                this.typeMatches.put(type, serial);
                break;
            }
        }
        if (serial == null) {
            for (Map.Entry<Object, TypeSerializer<?>> entry : this.functionMatches.entrySet()) {
                if (!((Predicate)entry.getKey()).test(type)) continue;
                serial = entry.getValue();
                this.typeMatches.put(type, serial);
                break;
            }
        }
        if (serial == null && this.parent != null) {
            serial = this.parent.get(type);
        }
        return serial;
    }

    public <T> TypeSerializerCollection registerType(TypeToken<T> type, TypeSerializer<? super T> serializer) {
        Preconditions.checkNotNull(type, (Object)"type");
        Preconditions.checkNotNull(serializer, (Object)"serializer");
        this.typeMatches.put(type, serializer);
        return this;
    }

    public <T> TypeSerializerCollection registerPredicate(Predicate<TypeToken<T>> type, TypeSerializer<? super T> serializer) {
        Preconditions.checkNotNull(type, (Object)"type");
        Preconditions.checkNotNull(serializer, (Object)"serializer");
        this.functionMatches.put(type, serializer);
        return this;
    }

    public TypeSerializerCollection newChild() {
        return new TypeSerializerCollection(this);
    }
}

