/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc;

import java.sql.BatchUpdateException;
import java.sql.ParameterMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import org.mariadb.jdbc.AbstractMariaDbPrepareStatement;
import org.mariadb.jdbc.MariaDbConnection;
import org.mariadb.jdbc.MariaDbParameterMetaData;
import org.mariadb.jdbc.MariaDbResultSetMetaData;
import org.mariadb.jdbc.internal.logging.Logger;
import org.mariadb.jdbc.internal.logging.LoggerFactory;
import org.mariadb.jdbc.internal.packet.dao.parameters.ParameterHolder;
import org.mariadb.jdbc.internal.queryresults.ExecutionResult;
import org.mariadb.jdbc.internal.queryresults.MultiFixedIntExecutionResult;
import org.mariadb.jdbc.internal.queryresults.SingleExecutionResult;
import org.mariadb.jdbc.internal.queryresults.resultset.MariaSelectResultSet;
import org.mariadb.jdbc.internal.util.ExceptionMapper;
import org.mariadb.jdbc.internal.util.Utils;
import org.mariadb.jdbc.internal.util.dao.QueryException;
import org.mariadb.jdbc.internal.util.dao.ServerPrepareResult;

public class MariaDbServerPreparedStatement
extends AbstractMariaDbPrepareStatement
implements Cloneable {
    private static Logger logger = LoggerFactory.getLogger(MariaDbServerPreparedStatement.class);
    String sql;
    ServerPrepareResult serverPrepareResult = null;
    boolean returnTableAlias = false;
    int parameterCount = -1;
    MariaDbResultSetMetaData metadata;
    MariaDbParameterMetaData parameterMetaData;
    SortedMap<Integer, ParameterHolder> currentParameterHolder;
    List<ParameterHolder[]> queryParameters = new ArrayList<ParameterHolder[]>();
    boolean mustExecuteOnMaster;

    public MariaDbServerPreparedStatement(MariaDbConnection connection, String sql, int resultSetScrollType, boolean forcePrepare) throws SQLException {
        super(connection, resultSetScrollType);
        this.sql = Utils.nativeSql(sql, connection.noBackslashEscapes);
        this.useFractionalSeconds = this.options.useFractionalSeconds;
        this.returnTableAlias = this.options.useOldAliasMetadataBehavior;
        this.currentParameterHolder = new TreeMap<Integer, ParameterHolder>();
        this.mustExecuteOnMaster = this.protocol.isMasterConnection();
        if (forcePrepare || !this.options.useBatchMultiSend) {
            this.prepare(this.sql);
        }
    }

    @Override
    public MariaDbServerPreparedStatement clone() throws CloneNotSupportedException {
        MariaDbServerPreparedStatement clone = (MariaDbServerPreparedStatement)super.clone();
        clone.metadata = this.metadata;
        clone.parameterMetaData = this.parameterMetaData;
        clone.queryParameters = new ArrayList<ParameterHolder[]>();
        clone.mustExecuteOnMaster = this.mustExecuteOnMaster;
        try {
            clone.prepare(this.sql);
        }
        catch (SQLException e) {
            throw new CloneNotSupportedException("PrepareStatement not ");
        }
        return clone;
    }

    private void prepare(String sql) throws SQLException {
        try {
            this.serverPrepareResult = this.protocol.prepare(sql, this.mustExecuteOnMaster);
            this.setMetaFromResult();
        }
        catch (QueryException e) {
            try {
                this.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            logger.error("error preparing query", e);
            ExceptionMapper.throwException(e, this.connection, this);
        }
    }

    private void setMetaFromResult() {
        this.parameterCount = this.serverPrepareResult.getParameters().length;
        this.metadata = new MariaDbResultSetMetaData(this.serverPrepareResult.getColumns(), this.protocol.getDataTypeMappingFlags(), this.returnTableAlias);
        this.parameterMetaData = new MariaDbParameterMetaData(this.serverPrepareResult.getParameters());
        this.sql = null;
    }

    @Override
    protected boolean isNoBackslashEscapes() {
        return this.connection.noBackslashEscapes;
    }

    @Override
    protected boolean useFractionalSeconds() {
        return this.useFractionalSeconds;
    }

    @Override
    protected Calendar cal() {
        return this.protocol.getCalendar();
    }

    @Override
    protected void setParameter(int parameterIndex, ParameterHolder holder) throws SQLException {
        this.currentParameterHolder.put(parameterIndex - 1, holder);
    }

    @Override
    public void addBatch() throws SQLException {
        this.validParameters();
        this.queryParameters.add(this.currentParameterHolder.values().toArray(new ParameterHolder[0]));
    }

    @Override
    public void clearBatch() {
        this.queryParameters.clear();
        this.hasLongData = false;
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        if (this.serverPrepareResult == null) {
            this.prepare(this.sql);
        }
        return this.parameterMetaData;
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        if (this.serverPrepareResult == null) {
            this.prepare(this.sql);
        }
        return this.metadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] executeBatch() throws SQLException {
        this.checkClose();
        this.batchResultSet = null;
        int queryParameterSize = this.queryParameters.size();
        if (queryParameterSize == 0) {
            return new int[0];
        }
        this.lock.lock();
        this.executing = true;
        QueryException exception = null;
        MultiFixedIntExecutionResult internalExecutionResult = null;
        try {
            this.executeQueryProlog(this.serverPrepareResult);
            try {
                internalExecutionResult = new MultiFixedIntExecutionResult(this, queryParameterSize, 0, false);
                this.executeBatchInternal(internalExecutionResult, queryParameterSize);
            }
            catch (QueryException queryException) {
                exception = queryException;
            }
            finally {
                this.executionResult = internalExecutionResult;
                this.executeQueryEpilog(exception);
                this.executing = false;
            }
            int[] queryException = internalExecutionResult.getAffectedRows();
            return queryException;
        }
        catch (SQLException sqle) {
            throw new BatchUpdateException(sqle.getMessage(), sqle.getSQLState(), sqle.getErrorCode(), internalExecutionResult.getAffectedRows(), (Throwable)sqle);
        }
        finally {
            this.lock.unlock();
            this.clearBatch();
        }
    }

    private void executeBatchInternal(MultiFixedIntExecutionResult internalExecutionResult, int queryParameterSize) throws QueryException, SQLException {
        if (this.options.useBatchMultiSend) {
            this.serverPrepareResult = this.protocol.prepareAndExecutes(this.mustExecuteOnMaster, this.serverPrepareResult, internalExecutionResult, this.sql, this.queryParameters, this.resultSetScrollType);
            if (this.metadata == null) {
                this.setMetaFromResult();
            }
            return;
        }
        QueryException exception = null;
        for (int counter = 0; counter < queryParameterSize; ++counter) {
            ParameterHolder[] parameterHolder = this.queryParameters.get(counter);
            try {
                this.serverPrepareResult.resetParameterTypeHeader();
                this.protocol.executePreparedQuery(this.mustExecuteOnMaster, this.serverPrepareResult, internalExecutionResult, parameterHolder, this.resultSetScrollType);
                continue;
            }
            catch (QueryException queryException) {
                if (this.options.continueBatchOnError) {
                    if (exception != null) continue;
                    exception = queryException;
                    continue;
                }
                throw queryException;
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    private void executeQueryProlog(ServerPrepareResult serverPrepareResult) throws SQLException {
        if (this.closed) {
            throw new SQLException("execute() is called on closed statement");
        }
        this.protocol.prologProxy(serverPrepareResult, this.executionResult, this.maxRows, this.protocol.getProxy() != null, this.connection, this);
        if (this.queryTimeout != 0) {
            this.setTimerTask();
        }
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        if (this.execute()) {
            return this.executionResult.getResultSet();
        }
        return MariaSelectResultSet.EMPTY;
    }

    @Override
    public int executeUpdate() throws SQLException {
        this.execute();
        return this.getUpdateCount();
    }

    @Override
    public void clearParameters() throws SQLException {
        this.currentParameterHolder.clear();
    }

    @Override
    public boolean execute() throws SQLException {
        return this.executeInternal(this.getFetchSize(), false);
    }

    protected void validParameters() throws SQLException {
        if (this.serverPrepareResult != null) {
            for (int i = 0; i < this.parameterCount; ++i) {
                if (this.currentParameterHolder.get(i) != null) continue;
                logger.error("Parameter at position " + (i + 1) + " is not set");
                ExceptionMapper.throwException(new QueryException("Parameter at position " + (i + 1) + " is not set", -1, "07004"), this.connection, this);
            }
        } else {
            if (this.parameterCount == -1) {
                this.parameterCount = this.currentParameterHolder.size();
            }
            for (int i = 0; i < this.parameterCount; ++i) {
                if (this.currentParameterHolder.containsKey(i)) continue;
                this.parameterCount = -1;
                logger.error("Parameter at position " + (i + 1) + " is not set");
                ExceptionMapper.throwException(new QueryException("Parameter at position " + (i + 1) + " is not set", -1, "07004"), this.connection, this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean executeInternal(int fetchSize, boolean canHaveCallableResultset) throws SQLException {
        this.validParameters();
        this.lock.lock();
        try {
            boolean bl;
            this.executing = true;
            QueryException exception = null;
            this.executeQueryProlog(this.serverPrepareResult);
            try {
                this.batchResultSet = null;
                SingleExecutionResult internalExecutionResult = new SingleExecutionResult((Statement)this, fetchSize, true, canHaveCallableResultset, true);
                ParameterHolder[] parameterHolders = this.currentParameterHolder.values().toArray(new ParameterHolder[0]);
                if (this.serverPrepareResult != null) {
                    this.serverPrepareResult.resetParameterTypeHeader();
                    this.protocol.executePreparedQuery(this.mustExecuteOnMaster, this.serverPrepareResult, internalExecutionResult, parameterHolders, this.resultSetScrollType);
                } else {
                    this.serverPrepareResult = this.protocol.prepareAndExecute(this.mustExecuteOnMaster, null, internalExecutionResult, this.sql, parameterHolders, this.resultSetScrollType);
                    this.setMetaFromResult();
                }
                this.executionResult = internalExecutionResult;
                bl = this.executionResult.getResultSet() != null;
            }
            catch (QueryException e) {
                boolean bl2;
                try {
                    exception = e;
                    bl2 = false;
                }
                catch (Throwable throwable) {
                    this.executeQueryEpilog(exception);
                    this.executing = false;
                    throw throwable;
                }
                this.executeQueryEpilog(exception);
                this.executing = false;
                this.lock.unlock();
                return bl2;
            }
            this.executeQueryEpilog(exception);
            this.executing = false;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void close() throws SQLException {
        this.lock.lock();
        try {
            this.closed = true;
            if (this.serverPrepareResult != null && this.protocol != null && this.protocol.isConnected()) {
                try {
                    this.serverPrepareResult.getUnProxiedProtocol().releasePrepareStatement(this.serverPrepareResult);
                }
                catch (QueryException queryException) {
                    // empty catch block
                }
            }
            this.serverPrepareResult = null;
            this.protocol = null;
            if (this.connection == null || this.connection.pooledConnection == null || this.connection.pooledConnection.statementEventListeners.isEmpty()) {
                return;
            }
            this.connection.pooledConnection.fireStatementClosed(this);
            this.connection = null;
        }
        finally {
            this.lock.unlock();
        }
    }

    protected int getParameterCount() {
        return this.parameterCount;
    }

    public String toString() {
        StringBuffer sb;
        if (this.serverPrepareResult != null) {
            sb = new StringBuffer("sql : '" + this.serverPrepareResult.getSql() + "'");
            if (this.parameterCount > 0) {
                sb.append(", parameters : [");
                for (int i = 0; i < this.parameterCount; ++i) {
                    ParameterHolder holder = (ParameterHolder)this.currentParameterHolder.get(i);
                    if (holder == null) {
                        sb.append("null");
                    } else {
                        sb.append(holder.toString());
                    }
                    if (i == this.parameterCount - 1) continue;
                    sb.append(",");
                }
                sb.append("]");
            }
        } else {
            sb = new StringBuffer("sql : '" + this.sql + "'");
            sb.append(", parameters : [");
            for (int i = 0; i < this.currentParameterHolder.size(); ++i) {
                ParameterHolder holder = (ParameterHolder)this.currentParameterHolder.get(i);
                if (holder == null) {
                    sb.append("null");
                } else {
                    sb.append(holder.toString());
                }
                if (i == this.currentParameterHolder.size() - 1) continue;
                sb.append(",");
            }
            sb.append("]");
        }
        return sb.toString();
    }

    protected ExecutionResult getExecutionResult() {
        return this.executionResult;
    }
}

