/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.logging;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.mariadb.jdbc.internal.logging.Logger;
import org.mariadb.jdbc.internal.logging.NoLogger;
import org.mariadb.jdbc.internal.logging.Slf4JLogger;

public class LoggerFactory {
    public static Boolean hasToLog = null;
    public static final Logger NO_LOGGER = new NoLogger();
    public static Class loggerClass = null;
    public static Method method = null;

    public static void init(boolean mustLog) {
        if ((hasToLog == null || hasToLog != mustLog) && mustLog) {
            try {
                hasToLog = Boolean.TRUE;
                loggerClass = Class.forName("org.slf4j.LoggerFactory");
                method = loggerClass.getMethod("getLogger", Class.class);
            }
            catch (ClassNotFoundException classNotFound) {
                System.out.println("Logging cannot be activated, missing slf4j dependency");
            }
            catch (NoSuchMethodException classNotFound) {
                System.out.println("Logging cannot be activated, missing slf4j dependency");
            }
        }
    }

    public static Logger getLogger(Class<?> clazz) {
        if (hasToLog != null && hasToLog.booleanValue()) {
            try {
                return new Slf4JLogger((org.slf4j.Logger)method.invoke((Object)loggerClass, clazz));
            }
            catch (IllegalAccessException illegalAccess) {
                return null;
            }
            catch (InvocationTargetException invocationException) {
                return null;
            }
        }
        return NO_LOGGER;
    }
}

