/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.stream;

import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.mariadb.jdbc.internal.stream.MariaDbInputStream;

public class MariaDbBufferedInputStream
extends BufferedInputStream
implements MariaDbInputStream {
    private byte[] headerBuffer = new byte[4];

    public MariaDbBufferedInputStream(InputStream in, int size) {
        super(in, size);
    }

    @Override
    public int readHeader() throws IOException {
        int count;
        int avail = this.count - this.pos;
        if (avail >= 4) {
            int returnValue = (this.buf[this.pos] & 0xFF) + ((this.buf[this.pos + 1] & 0xFF) << 8) + ((this.buf[this.pos + 2] & 0xFF) << 16);
            this.pos += 4;
            return returnValue;
        }
        int read = 0;
        do {
            if ((count = this.read(this.headerBuffer, read, 4 - read)) > 0) continue;
            throw new EOFException("unexpected end of stream, read " + read + " bytes from " + 4);
        } while ((read += count) < 4);
        return (this.headerBuffer[0] & 0xFF) + ((this.headerBuffer[1] & 0xFF) << 8) + ((this.headerBuffer[2] & 0xFF) << 16);
    }
}

