/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.util;

import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.Socket;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.SQLException;
import java.util.TimeZone;
import java.util.concurrent.locks.ReentrantLock;
import javax.net.SocketFactory;
import org.mariadb.jdbc.UrlParser;
import org.mariadb.jdbc.internal.failover.FailoverProxy;
import org.mariadb.jdbc.internal.failover.impl.AuroraListener;
import org.mariadb.jdbc.internal.failover.impl.MastersFailoverListener;
import org.mariadb.jdbc.internal.failover.impl.MastersSlavesListener;
import org.mariadb.jdbc.internal.logging.ProtocolLoggingProxy;
import org.mariadb.jdbc.internal.protocol.AuroraProtocol;
import org.mariadb.jdbc.internal.protocol.MasterProtocol;
import org.mariadb.jdbc.internal.protocol.MastersSlavesProtocol;
import org.mariadb.jdbc.internal.protocol.Protocol;
import org.mariadb.jdbc.internal.socket.NamedPipeSocket;
import org.mariadb.jdbc.internal.socket.SharedMemorySocket;
import org.mariadb.jdbc.internal.socket.UnixDomainSocket;
import org.mariadb.jdbc.internal.util.dao.QueryException;

public class Utils {
    public static String escapeString(String value, boolean noBackslashEscapes) {
        if (value.indexOf("'") == -1) {
            if (noBackslashEscapes) {
                return value;
            }
            if (value.indexOf("\\") == -1) {
                return value;
            }
        }
        String escaped = value.replace("'", "''");
        if (noBackslashEscapes) {
            return escaped;
        }
        return escaped.replace("\\", "\\\\");
    }

    public static byte[] encryptPassword(String password, byte[] seed) throws NoSuchAlgorithmException {
        if (password == null || password.equals("")) {
            return new byte[0];
        }
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
        byte[] stage1 = messageDigest.digest(password.getBytes());
        messageDigest.reset();
        byte[] stage2 = messageDigest.digest(stage1);
        messageDigest.reset();
        messageDigest.update(seed);
        messageDigest.update(stage2);
        byte[] digest = messageDigest.digest();
        byte[] returnBytes = new byte[digest.length];
        for (int i = 0; i < digest.length; ++i) {
            returnBytes[i] = (byte)(stage1[i] ^ digest[i]);
        }
        return returnBytes;
    }

    public static byte[] copyWithLength(byte[] orig, int length) {
        byte[] result = new byte[length];
        int howMuchToCopy = length < orig.length ? length : orig.length;
        System.arraycopy(orig, 0, result, 0, howMuchToCopy);
        return result;
    }

    public static byte[] copyRange(byte[] orig, int from, int to) {
        int length = to - from;
        byte[] result = new byte[length];
        int howMuchToCopy = orig.length - from < length ? orig.length - from : length;
        System.arraycopy(orig, from, result, 0, howMuchToCopy);
        return result;
    }

    public static String replaceFunctionParameter(String functionString) {
        int index;
        if (!functionString.contains("SQL_")) {
            return functionString;
        }
        char[] input = functionString.toCharArray();
        StringBuilder sb = new StringBuilder();
        for (index = 0; index < input.length && input[index] == ' '; ++index) {
        }
        while ((input[index] >= 'a' && index <= 122 || input[index] >= 'A' && input[index] <= 'Z') && index < input.length) {
            sb.append(input[index]);
            ++index;
        }
        String func = sb.toString().toLowerCase();
        if (func.equals("convert") || func.equals("timestampdiff") || func.equals("timestampadd")) {
            if (func.equals("timestampdiff") || func.equals("timestampadd")) {
                while (index < input.length && (Character.isWhitespace(input[index]) || input[index] == '(')) {
                    ++index;
                }
                if (index == input.length) {
                    return new String(input);
                }
                if (index >= input.length - 8) {
                    return new String(input);
                }
                String paramPrefix = new String(input, index, 8);
                if (paramPrefix.equals("SQL_TSI_")) {
                    return new String(input, 0, index) + new String(input, index + 8, input.length - (index + 8));
                }
                return new String(input);
            }
            int lastCommaIndex = functionString.lastIndexOf(44);
            for (index = lastCommaIndex + 1; index < input.length && Character.isWhitespace(input[index]); ++index) {
            }
            if (index >= input.length - 4) {
                return new String(input);
            }
            String paramPrefix = new String(input, index, 4);
            if (paramPrefix.equals("SQL_")) {
                return new String(input, 0, index) + new String(input, index + 4, input.length - (index + 4));
            }
        }
        return new String(input);
    }

    private static String resolveEscapes(String escaped, boolean noBackslashEscapes) throws SQLException {
        if (escaped.charAt(0) != '{' || escaped.charAt(escaped.length() - 1) != '}') {
            throw new SQLException("unexpected escaped string");
        }
        int endIndex = escaped.length() - 1;
        String escapedLower = escaped.toLowerCase();
        if (escaped.startsWith("{fn ")) {
            String resolvedParams = Utils.replaceFunctionParameter(escaped.substring(4, endIndex));
            return Utils.nativeSql(resolvedParams, noBackslashEscapes);
        }
        if (escapedLower.startsWith("{oj ")) {
            return Utils.nativeSql(escaped.substring(4, endIndex), noBackslashEscapes);
        }
        if (escaped.startsWith("{d ")) {
            return escaped.substring(3, endIndex);
        }
        if (escaped.startsWith("{t ")) {
            return escaped.substring(3, endIndex);
        }
        if (escaped.startsWith("{ts ")) {
            return escaped.substring(4, endIndex);
        }
        if (escaped.startsWith("{d'")) {
            return escaped.substring(2, endIndex);
        }
        if (escaped.startsWith("{t'")) {
            return escaped.substring(2, endIndex);
        }
        if (escaped.startsWith("{ts'")) {
            return escaped.substring(3, endIndex);
        }
        if (escaped.startsWith("{call ") || escaped.startsWith("{CALL ")) {
            return Utils.nativeSql(escaped.substring(1, endIndex), noBackslashEscapes);
        }
        if (escaped.startsWith("{escape ")) {
            return escaped.substring(1, endIndex);
        }
        if (escaped.startsWith("{?")) {
            return Utils.nativeSql(escaped.substring(1, endIndex), noBackslashEscapes);
        }
        if (escaped.startsWith("{ ")) {
            for (int i = 2; i < escaped.length(); ++i) {
                if (Character.isWhitespace(escaped.charAt(i))) continue;
                return Utils.resolveEscapes("{" + escaped.substring(i), noBackslashEscapes);
            }
        }
        throw new SQLException("unknown escape sequence " + escaped);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String nativeSql(String sql, boolean noBackslashEscapes) throws SQLException {
        if (sql.indexOf(123) == -1) {
            return sql;
        }
        StringBuilder escapeSequenceBuf = new StringBuilder();
        StringBuilder sqlBuffer = new StringBuilder();
        char[] charArray = sql.toCharArray();
        char lastChar = '\u0000';
        boolean inQuote = false;
        char quoteChar = '\u0000';
        boolean inComment = false;
        boolean isSlashSlashComment = false;
        int inEscapeSeq = 0;
        block9: for (int i = 0; i < charArray.length; ++i) {
            char car = charArray[i];
            if (lastChar == '\\' && !noBackslashEscapes) {
                sqlBuffer.append(car);
                continue;
            }
            switch (car) {
                case '\"': 
                case '\'': {
                    if (inComment) break;
                    if (inQuote) {
                        if (quoteChar != car) break;
                        inQuote = false;
                        break;
                    }
                    inQuote = true;
                    quoteChar = car;
                    break;
                }
                case '*': {
                    if (inQuote || inComment || lastChar != 47) break;
                    inComment = true;
                    isSlashSlashComment = false;
                    break;
                }
                case '-': 
                case '/': {
                    if (inQuote) break;
                    if (inComment) {
                        if (lastChar == '*' && !isSlashSlashComment) {
                            inComment = false;
                            break;
                        }
                        if (lastChar != car || !isSlashSlashComment) break;
                        inComment = false;
                        break;
                    }
                    if (lastChar == car) {
                        inComment = true;
                        isSlashSlashComment = true;
                        break;
                    }
                    if (lastChar != 42) break;
                    inComment = true;
                    isSlashSlashComment = false;
                    break;
                }
                case 'S': {
                    if (inQuote || inComment || inEscapeSeq <= 0 || i + 4 >= charArray.length || charArray[i + 1] != 'Q' || charArray[i + 2] != 'L' || charArray[i + 3] != 'L' || charArray[i + 4] != '_') break;
                    if (i + 8 < charArray.length && charArray[i + 5] == 'T' && charArray[i + 6] == 'S' && charArray[i + 7] == 'I' && charArray[i + 8] == '_') {
                        i += 8;
                        continue block9;
                    }
                    i += 4;
                    continue block9;
                }
                case '\n': {
                    if (!inComment || !isSlashSlashComment) break;
                    inComment = false;
                    break;
                }
                case '{': {
                    if (inQuote || inComment) break;
                    ++inEscapeSeq;
                    break;
                }
                case '}': {
                    if (inQuote || inComment || --inEscapeSeq != 0) break;
                    escapeSequenceBuf.append(car);
                    sqlBuffer.append(Utils.resolveEscapes(escapeSequenceBuf.toString(), noBackslashEscapes));
                    escapeSequenceBuf.setLength(0);
                    continue block9;
                }
            }
            lastChar = car;
            if (inEscapeSeq > 0) {
                escapeSequenceBuf.append(car);
                continue;
            }
            sqlBuffer.append(car);
        }
        if (inEscapeSeq > 0) {
            throw new SQLException("Invalid escape sequence , missing closing '}' character in '" + sqlBuffer);
        }
        return sqlBuffer.toString();
    }

    public static Protocol retrieveProxy(UrlParser urlParser, ReentrantLock lock) throws QueryException, SQLException {
        switch (urlParser.getHaMode()) {
            case AURORA: {
                return Utils.getProxyLoggingIfNeeded(urlParser, (Protocol)Proxy.newProxyInstance(AuroraProtocol.class.getClassLoader(), new Class[]{Protocol.class}, (InvocationHandler)new FailoverProxy(new AuroraListener(urlParser), lock)));
            }
            case REPLICATION: {
                return Utils.getProxyLoggingIfNeeded(urlParser, (Protocol)Proxy.newProxyInstance(MastersSlavesProtocol.class.getClassLoader(), new Class[]{Protocol.class}, (InvocationHandler)new FailoverProxy(new MastersSlavesListener(urlParser), lock)));
            }
            case FAILOVER: 
            case SEQUENTIAL: {
                return Utils.getProxyLoggingIfNeeded(urlParser, (Protocol)Proxy.newProxyInstance(MasterProtocol.class.getClassLoader(), new Class[]{Protocol.class}, (InvocationHandler)new FailoverProxy(new MastersFailoverListener(urlParser), lock)));
            }
        }
        Protocol protocol = Utils.getProxyLoggingIfNeeded(urlParser, new MasterProtocol(urlParser, lock));
        protocol.connectWithoutProxy();
        return protocol;
    }

    private static Protocol getProxyLoggingIfNeeded(UrlParser urlParser, Protocol protocol) {
        if (urlParser.getOptions().profileSql || urlParser.getOptions().slowQueryThresholdNanos != null) {
            return (Protocol)Proxy.newProxyInstance(MasterProtocol.class.getClassLoader(), new Class[]{Protocol.class}, (InvocationHandler)new ProtocolLoggingProxy(protocol, urlParser.getOptions()));
        }
        return protocol;
    }

    public static TimeZone getTimeZone(String id) throws SQLException {
        TimeZone tz = TimeZone.getTimeZone(id);
        if (tz.getID().equals("GMT") && !id.equals("GMT")) {
            throw new SQLException("invalid timezone id '" + id + "'");
        }
        return tz;
    }

    public static Socket createSocket(UrlParser urlParser, String host) throws IOException {
        SocketFactory socketFactory;
        if (urlParser.getOptions().pipe != null) {
            return new NamedPipeSocket(host, urlParser.getOptions().pipe);
        }
        if (urlParser.getOptions().localSocket != null) {
            try {
                return new UnixDomainSocket(urlParser.getOptions().localSocket);
            }
            catch (RuntimeException re) {
                throw new IOException(re.getMessage(), re.getCause());
            }
        }
        if (urlParser.getOptions().sharedMemory != null) {
            try {
                return new SharedMemorySocket(urlParser.getOptions().sharedMemory);
            }
            catch (RuntimeException re) {
                throw new IOException(re.getMessage(), re.getCause());
            }
        }
        String socketFactoryName = urlParser.getOptions().socketFactory;
        if (socketFactoryName != null) {
            try {
                socketFactory = (SocketFactory)Class.forName(socketFactoryName).newInstance();
            }
            catch (Exception sfex) {
                socketFactory = SocketFactory.getDefault();
            }
        } else {
            socketFactory = SocketFactory.getDefault();
        }
        return socketFactory.createSocket();
    }
}

