/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.command.args;

import com.flowpowered.math.vector.Vector3d;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.spongepowered.api.CatalogType;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandMessageFormatting;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.ArgumentParseException;
import org.spongepowered.api.command.args.CommandArgs;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.CommandFlags;
import org.spongepowered.api.command.args.PatternMatchingCommandElement;
import org.spongepowered.api.command.args.SelectorCommandElement;
import org.spongepowered.api.command.source.ProxySource;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.plugin.PluginContainer;
import org.spongepowered.api.profile.GameProfile;
import org.spongepowered.api.service.user.UserStorageService;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.selector.Selector;
import org.spongepowered.api.util.GuavaCollectors;
import org.spongepowered.api.util.SpongeApiTranslationHelper;
import org.spongepowered.api.util.StartsWithPredicate;
import org.spongepowered.api.util.Tristate;
import org.spongepowered.api.util.blockray.BlockRay;
import org.spongepowered.api.util.blockray.BlockRayHit;
import org.spongepowered.api.world.DimensionType;
import org.spongepowered.api.world.Locatable;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.extent.EntityUniverse;
import org.spongepowered.api.world.extent.Extent;
import org.spongepowered.api.world.storage.WorldProperties;

public final class GenericArguments {
    private static final CommandElement NONE = new SequenceCommandElement((List<CommandElement>)ImmutableList.of());
    private static final Map<String, Boolean> BOOLEAN_CHOICES = ImmutableMap.builder().put((Object)"true", (Object)true).put((Object)"t", (Object)true).put((Object)"y", (Object)true).put((Object)"yes", (Object)true).put((Object)"verymuchso", (Object)true).put((Object)"1", (Object)true).put((Object)"false", (Object)false).put((Object)"f", (Object)false).put((Object)"n", (Object)false).put((Object)"no", (Object)false).put((Object)"notatall", (Object)false).put((Object)"0", (Object)false).build();

    private GenericArguments() {
    }

    public static CommandElement none() {
        return NONE;
    }

    static CommandElement markTrue(String flag) {
        return new MarkTrueCommandElement(flag);
    }

    public static CommandElement playerOrSource(Text key) {
        return new PlayerCommandElement(key, true);
    }

    public static CommandElement player(Text key) {
        return new PlayerCommandElement(key, false);
    }

    public static CommandElement user(Text key) {
        return new UserCommandElement(key, false);
    }

    public static CommandElement userOrSource(Text key) {
        return new UserCommandElement(key, true);
    }

    public static CommandElement world(Text key) {
        return new WorldPropertiesCommandElement(key);
    }

    public static CommandElement dimension(Text key) {
        return GenericArguments.catalogedElement(key, DimensionType.class);
    }

    public static CommandElement vector3d(Text key) {
        return new Vector3dCommandElement(key);
    }

    public static CommandElement location(Text key) {
        return new LocationCommandElement(key);
    }

    public static <T extends CatalogType> CommandElement catalogedElement(Text key, Class<T> catalogType) {
        return new CatalogedTypeCommandElement<T>(key, catalogType);
    }

    public static CommandElement plugin(Text key) {
        return new PluginCommandElement(key);
    }

    public static CommandFlags.Builder flags() {
        return new CommandFlags.Builder();
    }

    public static CommandElement seq(CommandElement ... elements) {
        return new SequenceCommandElement((List<CommandElement>)ImmutableList.copyOf((Object[])elements));
    }

    public static CommandElement choices(Text key, Map<String, ?> choices) {
        return GenericArguments.choices(key, choices, choices.size() <= 5);
    }

    public static CommandElement choices(Text key, Map<String, ?> choices, boolean choicesInUsage) {
        ImmutableMap immChoices = ImmutableMap.copyOf(choices);
        return GenericArguments.choices(key, ((Map)immChoices)::keySet, ((Map)immChoices)::get, choicesInUsage);
    }

    public static CommandElement choices(Text key, Supplier<Collection<String>> keys, Function<String, ?> values) {
        return new ChoicesCommandElement(key, keys, values, Tristate.UNDEFINED);
    }

    public static CommandElement choices(Text key, Supplier<Collection<String>> keys, Function<String, ?> values, boolean choicesInUsage) {
        return new ChoicesCommandElement(key, keys, values, choicesInUsage ? Tristate.TRUE : Tristate.FALSE);
    }

    public static CommandElement firstParsing(CommandElement ... elements) {
        return new FirstParsingCommandElement((List<CommandElement>)ImmutableList.copyOf((Object[])elements));
    }

    public static CommandElement optional(CommandElement element) {
        return new OptionalCommandElement(element, null, false);
    }

    public static CommandElement optional(CommandElement element, Object value) {
        return new OptionalCommandElement(element, value, false);
    }

    public static CommandElement optionalWeak(CommandElement element) {
        return new OptionalCommandElement(element, null, true);
    }

    public static CommandElement optionalWeak(CommandElement element, Object value) {
        return new OptionalCommandElement(element, value, true);
    }

    public static CommandElement repeated(CommandElement element, int times) {
        return new RepeatedCommandElement(element, times);
    }

    public static CommandElement allOf(CommandElement element) {
        return new AllOfCommandElement(element);
    }

    public static CommandElement string(Text key) {
        return new StringElement(key);
    }

    public static CommandElement integer(Text key) {
        return new NumericElement<Integer>(key, Integer::parseInt, Integer::parseInt, input -> SpongeApiTranslationHelper.t("Expected an integer, but input '%s' was not", input));
    }

    public static CommandElement longNum(Text key) {
        return new NumericElement<Long>(key, Long::parseLong, Long::parseLong, input -> SpongeApiTranslationHelper.t("Expected a long, but input '%s' was not", input));
    }

    public static CommandElement doubleNum(Text key) {
        return new NumericElement<Double>(key, Double::parseDouble, null, input -> SpongeApiTranslationHelper.t("Expected a number, but input '%s' was not", input));
    }

    public static CommandElement bool(Text key) {
        return GenericArguments.choices(key, BOOLEAN_CHOICES);
    }

    public static <T extends Enum<T>> CommandElement enumValue(Text key, Class<T> type) {
        return new EnumValueElement<T>(key, type);
    }

    public static CommandElement remainingJoinedStrings(Text key) {
        return new RemainingJoinedStringsCommandElement(key, false);
    }

    public static CommandElement remainingRawJoinedStrings(Text key) {
        return new RemainingJoinedStringsCommandElement(key, true);
    }

    public static CommandElement literal(Text key, String ... expectedArgs) {
        return new LiteralCommandElement(key, (List<String>)ImmutableList.copyOf((Object[])expectedArgs), true);
    }

    public static CommandElement literal(Text key, @Nullable Object putValue, String ... expectedArgs) {
        return new LiteralCommandElement(key, (List<String>)ImmutableList.copyOf((Object[])expectedArgs), putValue);
    }

    public static CommandElement onlyOne(CommandElement element) {
        return new OnlyOneCommandElement(element);
    }

    public static CommandElement requiringPermission(CommandElement element, String permission) {
        return new PermissionCommandElement(element, permission);
    }

    public static CommandElement entity(Text key) {
        return new EntityCommandElement(key, false);
    }

    public static CommandElement entityOrSource(Text key) {
        return new EntityCommandElement(key, true);
    }

    private static class EntityCommandElement
    extends SelectorCommandElement {
        private final boolean returnSource;

        protected EntityCommandElement(Text key, boolean returnSource) {
            super(key);
            this.returnSource = returnSource;
        }

        @Override
        protected Object parseValue(CommandSource source, CommandArgs args) throws ArgumentParseException {
            if (!args.hasNext() && this.returnSource) {
                return EntityCommandElement.tryReturnSource(source, args);
            }
            Object state = args.getState();
            try {
                return super.parseValue(source, args);
            }
            catch (ArgumentParseException ex) {
                if (this.returnSource) {
                    args.setState(state);
                    return EntityCommandElement.tryReturnSource(source, args);
                }
                throw ex;
            }
        }

        @Override
        protected Iterable<String> getChoices(CommandSource source) {
            Set worldEntities = Sponge.getServer().getWorlds().stream().map(EntityUniverse::getEntities).collect(Collectors.toSet());
            return Iterables.transform((Iterable)Iterables.concat(worldEntities), input -> {
                if (input == null) {
                    return null;
                }
                if (input instanceof Player) {
                    return ((Player)input).getName();
                }
                return input.getUniqueId().toString();
            });
        }

        @Override
        protected Object getValue(String choice) throws IllegalArgumentException {
            UUID uuid = UUID.fromString(choice);
            for (World world : Sponge.getServer().getWorlds()) {
                Optional<Entity> ret = world.getEntity(uuid);
                if (!ret.isPresent()) continue;
                return ret.get();
            }
            throw new IllegalArgumentException("Input value " + choice + " was not an entity");
        }

        private static Entity tryReturnSource(CommandSource source, CommandArgs args) throws ArgumentParseException {
            if (source instanceof Entity) {
                return (Entity)((Object)source);
            }
            if (source instanceof ProxySource && ((ProxySource)source).getOriginalSource() instanceof Entity) {
                return (Entity)((Object)((ProxySource)source).getOriginalSource());
            }
            throw args.createError(SpongeApiTranslationHelper.t("No entities matched and source was not an entity!", new Object[0]));
        }

        @Override
        public Text getUsage(CommandSource src) {
            return src instanceof Player && this.returnSource ? Text.of("[", super.getUsage(src), "]") : super.getUsage(src);
        }
    }

    private static class PermissionCommandElement
    extends CommandElement {
        private final CommandElement element;
        private final String permission;

        protected PermissionCommandElement(CommandElement element, String permission) {
            super(element.getKey());
            this.element = element;
            this.permission = permission;
        }

        @Override
        @Nullable
        protected Object parseValue(CommandSource source, CommandArgs args) throws ArgumentParseException {
            this.checkPermission(source, args);
            return this.element.parseValue(source, args);
        }

        private void checkPermission(CommandSource source, CommandArgs args) throws ArgumentParseException {
            if (!source.hasPermission(this.permission)) {
                Text key = this.getKey();
                throw args.createError(SpongeApiTranslationHelper.t("You do not have permission to use the %s argument", key != null ? key : SpongeApiTranslationHelper.t("unknown", new Object[0])));
            }
        }

        @Override
        public List<String> complete(CommandSource src, CommandArgs args, CommandContext context) {
            if (!src.hasPermission(this.permission)) {
                return ImmutableList.of();
            }
            return this.element.complete(src, args, context);
        }

        @Override
        public void parse(CommandSource source, CommandArgs args, CommandContext context) throws ArgumentParseException {
            this.checkPermission(source, args);
            this.element.parse(source, args, context);
        }

        @Override
        public Text getUsage(CommandSource src) {
            return this.element.getUsage(src);
        }
    }

    private static class OnlyOneCommandElement
    extends CommandElement {
        private final CommandElement element;

        protected OnlyOneCommandElement(CommandElement element) {
            super(element.getKey());
            this.element = element;
        }

        @Override
        public void parse(CommandSource source, CommandArgs args, CommandContext context) throws ArgumentParseException {
            this.element.parse(source, args, context);
            if (context.getAll(this.element.getUntranslatedKey()).size() > 1) {
                Text key = this.element.getKey();
                throw args.createError(SpongeApiTranslationHelper.t("Argument %s may have only one value!", key != null ? key : SpongeApiTranslationHelper.t("unknown", new Object[0])));
            }
        }

        @Override
        public Text getUsage(CommandSource src) {
            return this.element.getUsage(src);
        }

        @Override
        @Nullable
        protected Object parseValue(CommandSource source, CommandArgs args) throws ArgumentParseException {
            return this.element.parseValue(source, args);
        }

        @Override
        public List<String> complete(CommandSource src, CommandArgs args, CommandContext context) {
            return this.element.complete(src, args, context);
        }
    }

    private static class CatalogedTypeCommandElement<T extends CatalogType>
    extends PatternMatchingCommandElement {
        private final Class<T> catalogType;

        protected CatalogedTypeCommandElement(Text key, Class<T> catalogType) {
            super(key);
            this.catalogType = catalogType;
        }

        @Override
        protected Iterable<String> getChoices(CommandSource source) {
            return Sponge.getGame().getRegistry().getAllOf(this.catalogType).stream().map(input -> input == null ? null : input.getId()).collect(Collectors.toList());
        }

        @Override
        protected Object getValue(String choice) throws IllegalArgumentException {
            Optional<T> ret = Sponge.getGame().getRegistry().getType(this.catalogType, choice);
            if (!ret.isPresent()) {
                throw new IllegalArgumentException("Invalid input " + choice + " was found");
            }
            return ret.get();
        }
    }

    private static class LocationCommandElement
    extends CommandElement {
        private final WorldPropertiesCommandElement worldParser = new WorldPropertiesCommandElement(null);
        private final Vector3dCommandElement vectorParser = new Vector3dCommandElement(null);

        protected LocationCommandElement(Text key) {
            super(key);
        }

        @Override
        protected Object parseValue(CommandSource source, CommandArgs args) throws ArgumentParseException {
            Object world;
            Object state = args.getState();
            if (args.peek().startsWith("@")) {
                return Selector.parse(args.next()).resolve(source).stream().map(Locatable::getLocation).collect(GuavaCollectors.toImmutableSet());
            }
            Object vec = null;
            try {
                world = Preconditions.checkNotNull((Object)this.worldParser.parseValue(source, args), (Object)"worldVal");
            }
            catch (ArgumentParseException ex) {
                args.setState(state);
                if (!(source instanceof Locatable)) {
                    throw args.createError(SpongeApiTranslationHelper.t("Source must have a location in order to have a fallback world", new Object[0]));
                }
                world = ((Locatable)((Object)source)).getWorld().getProperties();
                try {
                    vec = Preconditions.checkNotNull((Object)this.vectorParser.parseValue(source, args), (Object)"vectorVal");
                }
                catch (ArgumentParseException ex2) {
                    args.setState(state);
                    throw ex;
                }
            }
            if (vec == null) {
                vec = Preconditions.checkNotNull((Object)this.vectorParser.parseValue(source, args), (Object)"vectorVal");
            }
            if (world instanceof Collection) {
                if (((Collection)world).size() != 1) {
                    throw args.createError(SpongeApiTranslationHelper.t("A location must be specified in only one world!", new Object[0]));
                }
                world = ((Collection)world).iterator().next();
            }
            WorldProperties targetWorldProps = (WorldProperties)world;
            Optional<World> targetWorld = Sponge.getGame().getServer().getWorld(targetWorldProps.getUniqueId());
            Vector3d vector = (Vector3d)vec;
            return new Location<Extent>((Extent)targetWorld.get(), vector);
        }

        @Override
        public List<String> complete(CommandSource src, CommandArgs args, CommandContext context) {
            Object state = args.getState();
            Optional<String> nextPossibility = args.nextIfPresent();
            if (nextPossibility.isPresent() && nextPossibility.get().startsWith("@")) {
                return Selector.complete(nextPossibility.get());
            }
            args.setState(state);
            List<String> ret = this.worldParser.complete(src, args, context);
            if (ret.isEmpty()) {
                args.setState(state);
                ret = this.vectorParser.complete(src, args, context);
            }
            return ret;
        }
    }

    private static class Vector3dCommandElement
    extends CommandElement {
        private static final ImmutableSet<String> SPECIAL_TOKENS = ImmutableSet.of((Object)"#target", (Object)"#me");

        protected Vector3dCommandElement(@Nullable Text key) {
            super(key);
        }

        @Override
        protected Object parseValue(CommandSource source, CommandArgs args) throws ArgumentParseException {
            String zStr;
            String yStr;
            String xStr = args.next();
            if (xStr.contains(",")) {
                String[] split = xStr.split(",");
                if (split.length != 3) {
                    throw args.createError(SpongeApiTranslationHelper.t("Comma-separated location must have 3 elements, not %s", split.length));
                }
                xStr = split[0];
                yStr = split[1];
                zStr = split[2];
            } else {
                if (xStr.equals("#target") && source instanceof Entity) {
                    Optional<BlockRayHit<World>> hit = BlockRay.from((Entity)((Object)source)).stopFilter(BlockRay.continueAfterFilter(BlockRay.onlyAirFilter(), 1)).build().end();
                    if (!hit.isPresent()) {
                        throw args.createError(SpongeApiTranslationHelper.t("No target block is available! Stop stargazing!", new Object[0]));
                    }
                    return hit.get().getPosition();
                }
                if (xStr.equalsIgnoreCase("#me") && source instanceof Locatable) {
                    return ((Locatable)((Object)source)).getLocation().getPosition();
                }
                yStr = args.next();
                zStr = args.next();
            }
            double x = this.parseRelativeDouble(args, xStr, source instanceof Locatable ? Double.valueOf(((Locatable)((Object)source)).getLocation().getX()) : null);
            double y = this.parseRelativeDouble(args, yStr, source instanceof Locatable ? Double.valueOf(((Locatable)((Object)source)).getLocation().getY()) : null);
            double z = this.parseRelativeDouble(args, zStr, source instanceof Locatable ? Double.valueOf(((Locatable)((Object)source)).getLocation().getZ()) : null);
            return new Vector3d(x, y, z);
        }

        @Override
        public List<String> complete(CommandSource src, CommandArgs args, CommandContext context) {
            Optional<String> arg = args.nextIfPresent();
            if (arg.isPresent()) {
                if (arg.get().startsWith("#")) {
                    return (List)SPECIAL_TOKENS.stream().filter(new StartsWithPredicate(arg.get())).collect(GuavaCollectors.toImmutableList());
                }
                if (arg.get().contains(",") || !args.hasNext()) {
                    return ImmutableList.of((Object)arg.get());
                }
                arg = args.nextIfPresent();
                if (args.hasNext()) {
                    return ImmutableList.of((Object)args.nextIfPresent().get());
                }
                return ImmutableList.of((Object)arg.get());
            }
            return ImmutableList.of();
        }

        private double parseRelativeDouble(CommandArgs args, String arg, @Nullable Double relativeTo) throws ArgumentParseException {
            boolean relative = arg.startsWith("~");
            if (relative) {
                if (relativeTo == null) {
                    throw args.createError(SpongeApiTranslationHelper.t("Relative position specified but source does not have a position", new Object[0]));
                }
                if ((arg = arg.substring(1)).isEmpty()) {
                    return relativeTo;
                }
            }
            try {
                double ret = Double.parseDouble(arg);
                return relative ? ret + relativeTo : ret;
            }
            catch (NumberFormatException e) {
                throw args.createError(SpongeApiTranslationHelper.t("Expected input %s to be a double, but was not", arg));
            }
        }
    }

    private static class WorldPropertiesCommandElement
    extends PatternMatchingCommandElement {
        private final CommandElement dimensionTypeElement;

        protected WorldPropertiesCommandElement(@Nullable Text key) {
            super(key);
            this.dimensionTypeElement = GenericArguments.onlyOne(GenericArguments.catalogedElement(key, DimensionType.class));
        }

        @Override
        @Nullable
        public Object parseValue(CommandSource source, CommandArgs args) throws ArgumentParseException {
            String next = args.peek();
            if (next.startsWith("#")) {
                String specifier = next.substring(1);
                if (specifier.equalsIgnoreCase("first")) {
                    args.next();
                    return Sponge.getGame().getServer().getAllWorldProperties().stream().filter(input -> input != null && input.isEnabled()).collect(Collectors.toList()).iterator().next();
                }
                if (specifier.equalsIgnoreCase("me") && source instanceof Locatable) {
                    args.next();
                    return ((Locatable)((Object)source)).getWorld().getProperties();
                }
                boolean firstOnly = false;
                if (specifier.endsWith(":first")) {
                    firstOnly = true;
                    specifier = specifier.substring(0, specifier.length() - 6);
                }
                args.next();
                args.insertArg(specifier);
                DimensionType type = (DimensionType)((Iterable)this.dimensionTypeElement.parseValue(source, args)).iterator().next();
                Iterable ret = Sponge.getGame().getServer().getAllWorldProperties().stream().filter(input -> input != null && input.isEnabled() && input.getDimensionType().equals(type)).collect(Collectors.toList());
                return firstOnly ? ret.iterator().next() : ret;
            }
            return super.parseValue(source, args);
        }

        @Override
        public List<String> complete(CommandSource src, CommandArgs args, CommandContext context) {
            Iterable choices = this.getCompletionChoices(src);
            Optional<String> nextArg = args.nextIfPresent();
            if (nextArg.isPresent()) {
                choices = Iterables.filter(choices, input -> this.getFormattedPattern((String)nextArg.get()).matcher((CharSequence)input).find());
            }
            return ImmutableList.copyOf(choices);
        }

        protected Iterable<String> getCompletionChoices(CommandSource source) {
            return Iterables.concat(this.getChoices(source), (Iterable)ImmutableSet.of((Object)"#first", (Object)"#me"), (Iterable)Iterables.transform(Sponge.getGame().getRegistry().getAllOf(DimensionType.class), input2 -> "#" + input2.getId()));
        }

        @Override
        protected Iterable<String> getChoices(CommandSource source) {
            return Sponge.getGame().getServer().getAllWorldProperties().stream().map(input -> input.getWorldName()).collect(Collectors.toList());
        }

        @Override
        protected Object getValue(String choice) throws IllegalArgumentException {
            Optional<WorldProperties> ret = Sponge.getGame().getServer().getWorldProperties(choice);
            if (!ret.isPresent()) {
                throw new IllegalArgumentException("Provided argument " + choice + " did not match a WorldProperties");
            }
            return ret.get();
        }
    }

    private static class PlayerCommandElement
    extends SelectorCommandElement {
        private final boolean returnSource;

        protected PlayerCommandElement(Text key, boolean returnSource) {
            super(key);
            this.returnSource = returnSource;
        }

        @Override
        protected Object parseValue(CommandSource source, CommandArgs args) throws ArgumentParseException {
            if (!args.hasNext() && this.returnSource) {
                return this.tryReturnSource(source, args);
            }
            Object state = args.getState();
            try {
                return Iterables.filter((Iterable)((Iterable)super.parseValue(source, args)), e -> e instanceof Player);
            }
            catch (ArgumentParseException ex) {
                if (this.returnSource) {
                    args.setState(state);
                    return this.tryReturnSource(source, args);
                }
                throw ex;
            }
        }

        @Override
        protected Iterable<String> getChoices(CommandSource source) {
            return Sponge.getGame().getServer().getOnlinePlayers().stream().map(input -> input == null ? null : input.getName()).collect(Collectors.toList());
        }

        @Override
        protected Object getValue(String choice) throws IllegalArgumentException {
            Optional<Player> ret = Sponge.getGame().getServer().getPlayer(choice);
            if (!ret.isPresent()) {
                throw new IllegalArgumentException("Input value " + choice + " was not a player");
            }
            return ret.get();
        }

        private Player tryReturnSource(CommandSource source, CommandArgs args) throws ArgumentParseException {
            if (source instanceof Player) {
                return (Player)source;
            }
            if (source instanceof ProxySource && ((ProxySource)source).getOriginalSource() instanceof Player) {
                return (Player)((ProxySource)source).getOriginalSource();
            }
            throw args.createError(SpongeApiTranslationHelper.t("No players matched and source was not a player!", new Object[0]));
        }

        @Override
        public Text getUsage(CommandSource src) {
            return src instanceof Player && this.returnSource ? Text.of("[", super.getUsage(src), "]") : super.getUsage(src);
        }
    }

    private static class UserCommandElement
    extends PatternMatchingCommandElement {
        private final PlayerCommandElement possiblePlayer;
        private final boolean returnSource;

        protected UserCommandElement(@Nullable Text key, boolean returnSource) {
            super(key);
            this.possiblePlayer = new PlayerCommandElement(key, returnSource);
            this.returnSource = returnSource;
        }

        @Override
        @Nullable
        protected Object parseValue(CommandSource source, CommandArgs args) throws ArgumentParseException {
            Object state = args.getState();
            try {
                return this.possiblePlayer.parseValue(source, args);
            }
            catch (ArgumentParseException ex) {
                args.setState(state);
                try {
                    return super.parseValue(source, args);
                }
                catch (ArgumentParseException ex2) {
                    if (this.returnSource && source instanceof User) {
                        return source;
                    }
                    throw ex2;
                }
            }
        }

        @Override
        protected Iterable<String> getChoices(CommandSource source) {
            return (Iterable)Sponge.getGame().getServiceManager().provideUnchecked(UserStorageService.class).getAll().stream().map(GameProfile::getName).filter(Optional::isPresent).map(Optional::get).collect(GuavaCollectors.toImmutableList());
        }

        @Override
        protected Object getValue(String choice) throws IllegalArgumentException {
            return Sponge.getGame().getServiceManager().provideUnchecked(UserStorageService.class).get(choice).get();
        }
    }

    private static class LiteralCommandElement
    extends CommandElement {
        private final List<String> expectedArgs;
        @Nullable
        private final Object putValue;

        protected LiteralCommandElement(@Nullable Text key, List<String> expectedArgs, @Nullable Object putValue) {
            super(key);
            this.expectedArgs = ImmutableList.copyOf(expectedArgs);
            this.putValue = putValue;
        }

        @Override
        @Nullable
        protected Object parseValue(CommandSource source, CommandArgs args) throws ArgumentParseException {
            for (String arg : this.expectedArgs) {
                String current = args.next();
                if (current.equalsIgnoreCase(arg)) continue;
                throw args.createError(SpongeApiTranslationHelper.t("Argument %s did not match expected next argument %s", current, arg));
            }
            return this.putValue;
        }

        @Override
        public List<String> complete(CommandSource src, CommandArgs args, CommandContext context) {
            for (String arg : this.expectedArgs) {
                Optional<String> next = args.nextIfPresent();
                if (!next.isPresent()) break;
                if (args.hasNext()) {
                    if (next.get().equalsIgnoreCase(arg)) continue;
                    break;
                }
                if (!arg.toLowerCase().startsWith(next.get().toLowerCase())) continue;
                return ImmutableList.of((Object)arg);
            }
            return ImmutableList.of();
        }

        @Override
        public Text getUsage(CommandSource src) {
            return Text.of(Joiner.on((char)' ').join(this.expectedArgs));
        }
    }

    private static class RemainingJoinedStringsCommandElement
    extends KeyElement {
        private final boolean raw;

        RemainingJoinedStringsCommandElement(Text key, boolean raw) {
            super(key);
            this.raw = raw;
        }

        @Override
        protected Object parseValue(CommandSource source, CommandArgs args) throws ArgumentParseException {
            if (this.raw) {
                args.next();
                String ret = args.getRaw().substring(args.getRawPosition());
                while (args.hasNext()) {
                    args.next();
                }
                return ret;
            }
            StringBuilder ret = new StringBuilder(args.next());
            while (args.hasNext()) {
                ret.append(' ').append(args.next());
            }
            return ret.toString();
        }

        @Override
        public Text getUsage(CommandSource src) {
            return Text.of(CommandMessageFormatting.LT_TEXT, this.getKey(), CommandMessageFormatting.ELLIPSIS_TEXT, CommandMessageFormatting.GT_TEXT);
        }
    }

    private static class EnumValueElement<T extends Enum<T>>
    extends PatternMatchingCommandElement {
        private final Class<T> type;

        EnumValueElement(Text key, Class<T> type) {
            super(key);
            this.type = type;
        }

        @Override
        protected Iterable<String> getChoices(CommandSource source) {
            return Arrays.asList(this.type.getEnumConstants()).stream().map(input -> input == null ? null : input.name()).collect(Collectors.toList());
        }

        @Override
        protected Object getValue(String choice) throws IllegalArgumentException {
            return Enum.valueOf(this.type, choice.toUpperCase());
        }
    }

    private static class NumericElement<T extends Number>
    extends KeyElement {
        private final Function<String, T> parseFunc;
        @Nullable
        private final BiFunction<String, Integer, T> parseRadixFunction;
        private final Function<String, Text> errorSupplier;

        protected NumericElement(Text key, Function<String, T> parseFunc, @Nullable BiFunction<String, Integer, T> parseRadixFunction, Function<String, Text> errorSupplier) {
            super(key);
            this.parseFunc = parseFunc;
            this.parseRadixFunction = parseRadixFunction;
            this.errorSupplier = errorSupplier;
        }

        @Override
        public Object parseValue(CommandSource source, CommandArgs args) throws ArgumentParseException {
            String input = args.next();
            try {
                if (this.parseRadixFunction != null) {
                    if (input.startsWith("0x")) {
                        return this.parseRadixFunction.apply(input.substring(2), 16);
                    }
                    if (input.startsWith("0b")) {
                        return this.parseRadixFunction.apply(input.substring(2), 2);
                    }
                }
                return this.parseFunc.apply(input);
            }
            catch (NumberFormatException ex) {
                throw args.createError(this.errorSupplier.apply(input));
            }
        }
    }

    private static class StringElement
    extends KeyElement {
        StringElement(Text key) {
            super(key);
        }

        @Override
        public Object parseValue(CommandSource source, CommandArgs args) throws ArgumentParseException {
            return args.next();
        }
    }

    private static abstract class KeyElement
    extends CommandElement {
        protected KeyElement(Text key) {
            super(key);
        }

        @Override
        public List<String> complete(CommandSource src, CommandArgs args, CommandContext context) {
            return Collections.emptyList();
        }
    }

    private static class AllOfCommandElement
    extends CommandElement {
        private final CommandElement element;

        protected AllOfCommandElement(CommandElement element) {
            super(null);
            this.element = element;
        }

        @Override
        public void parse(CommandSource source, CommandArgs args, CommandContext context) throws ArgumentParseException {
            while (args.hasNext()) {
                this.element.parse(source, args, context);
            }
        }

        @Override
        protected Object parseValue(CommandSource source, CommandArgs args) throws ArgumentParseException {
            return null;
        }

        @Override
        public List<String> complete(CommandSource src, CommandArgs args, CommandContext context) {
            while (args.hasNext()) {
                Object startState = args.getState();
                try {
                    this.element.parse(src, args, context);
                }
                catch (ArgumentParseException e) {
                    args.setState(startState);
                    return this.element.complete(src, args, context);
                }
            }
            return Collections.emptyList();
        }

        @Override
        public Text getUsage(CommandSource context) {
            return Text.of(this.element.getUsage(context), CommandMessageFormatting.STAR_TEXT);
        }
    }

    private static class RepeatedCommandElement
    extends CommandElement {
        private final CommandElement element;
        private final int times;

        protected RepeatedCommandElement(CommandElement element, int times) {
            super(null);
            this.element = element;
            this.times = times;
        }

        @Override
        public void parse(CommandSource source, CommandArgs args, CommandContext context) throws ArgumentParseException {
            for (int i = 0; i < this.times; ++i) {
                this.element.parse(source, args, context);
            }
        }

        @Override
        protected Object parseValue(CommandSource source, CommandArgs args) throws ArgumentParseException {
            return null;
        }

        @Override
        public List<String> complete(CommandSource src, CommandArgs args, CommandContext context) {
            for (int i = 0; i < this.times; ++i) {
                Object startState = args.getState();
                try {
                    this.element.parse(src, args, context);
                    continue;
                }
                catch (ArgumentParseException e) {
                    args.setState(startState);
                    return this.element.complete(src, args, context);
                }
            }
            return Collections.emptyList();
        }

        @Override
        public Text getUsage(CommandSource src) {
            return Text.of(this.times, Character.valueOf('*'), this.element.getUsage(src));
        }
    }

    private static class OptionalCommandElement
    extends CommandElement {
        private final CommandElement element;
        @Nullable
        private final Object value;
        private final boolean considerInvalidFormatEmpty;

        OptionalCommandElement(CommandElement element, @Nullable Object value, boolean considerInvalidFormatEmpty) {
            super(null);
            this.element = element;
            this.value = value;
            this.considerInvalidFormatEmpty = considerInvalidFormatEmpty;
        }

        @Override
        public void parse(CommandSource source, CommandArgs args, CommandContext context) throws ArgumentParseException {
            if (!args.hasNext()) {
                Text key = this.element.getKey();
                if (key != null && this.value != null) {
                    context.putArg(key.toPlain(), this.value);
                }
                return;
            }
            Object startState = args.getState();
            try {
                this.element.parse(source, args, context);
            }
            catch (ArgumentParseException ex) {
                if (this.considerInvalidFormatEmpty || args.hasNext()) {
                    args.setState(startState);
                    if (this.element.getKey() != null && this.value != null) {
                        context.putArg(this.element.getUntranslatedKey(), this.value);
                    }
                }
                throw ex;
            }
        }

        @Override
        protected Object parseValue(CommandSource source, CommandArgs args) throws ArgumentParseException {
            return args.hasNext() ? null : this.element.parseValue(source, args);
        }

        @Override
        public List<String> complete(CommandSource src, CommandArgs args, CommandContext context) {
            return this.element.complete(src, args, context);
        }

        @Override
        public Text getUsage(CommandSource src) {
            return Text.of("[", this.element.getUsage(src), "]");
        }
    }

    private static class FirstParsingCommandElement
    extends CommandElement {
        private final List<CommandElement> elements;

        FirstParsingCommandElement(List<CommandElement> elements) {
            super(null);
            this.elements = elements;
        }

        @Override
        public void parse(CommandSource source, CommandArgs args, CommandContext context) throws ArgumentParseException {
            ArgumentParseException lastException = null;
            for (CommandElement element : this.elements) {
                Object startState = args.getState();
                try {
                    element.parse(source, args, context);
                    return;
                }
                catch (ArgumentParseException ex) {
                    lastException = ex;
                    args.setState(startState);
                }
            }
            if (lastException != null) {
                throw lastException;
            }
        }

        @Override
        protected Object parseValue(CommandSource source, CommandArgs args) throws ArgumentParseException {
            return null;
        }

        @Override
        public List<String> complete(CommandSource src, CommandArgs args, CommandContext context) {
            return ImmutableList.copyOf((Iterable)Iterables.concat((Iterable)Iterables.transform(this.elements, input -> {
                if (input == null) {
                    return ImmutableList.of();
                }
                Object startState = args.getState();
                List<String> ret = input.complete(src, args, context);
                args.setState(startState);
                return ret;
            })));
        }

        @Override
        public Text getUsage(CommandSource commander) {
            Text.Builder ret = Text.builder();
            Iterator<CommandElement> it = this.elements.iterator();
            while (it.hasNext()) {
                ret.append(it.next().getUsage(commander));
                if (!it.hasNext()) continue;
                ret.append(CommandMessageFormatting.PIPE_TEXT);
            }
            return ret.build();
        }
    }

    private static class ChoicesCommandElement
    extends CommandElement {
        private static final int CUTOFF = 5;
        private final Supplier<Collection<String>> keySupplier;
        private final Function<String, ?> valueSupplier;
        private final Tristate choicesInUsage;

        ChoicesCommandElement(Text key, Supplier<Collection<String>> keySupplier, Function<String, ?> valueSupplier, Tristate choicesInUsage) {
            super(key);
            this.keySupplier = keySupplier;
            this.valueSupplier = valueSupplier;
            this.choicesInUsage = choicesInUsage;
        }

        @Override
        public Object parseValue(CommandSource source, CommandArgs args) throws ArgumentParseException {
            Object value = this.valueSupplier.apply(args.next());
            if (value == null) {
                throw args.createError(SpongeApiTranslationHelper.t("Argument was not a valid choice. Valid choices: %s", this.keySupplier.get().toString()));
            }
            return value;
        }

        @Override
        public List<String> complete(CommandSource src, CommandArgs args, CommandContext context) {
            String prefix = args.nextIfPresent().orElse("");
            return (List)this.keySupplier.get().stream().filter(new StartsWithPredicate(prefix)).collect(GuavaCollectors.toImmutableList());
        }

        @Override
        public Text getUsage(CommandSource commander) {
            Collection<String> keys = this.keySupplier.get();
            if (this.choicesInUsage == Tristate.TRUE || this.choicesInUsage == Tristate.UNDEFINED && keys.size() <= 5) {
                Text.Builder build = Text.builder();
                build.append(CommandMessageFormatting.LT_TEXT);
                Iterator<String> it = keys.iterator();
                while (it.hasNext()) {
                    build.append(Text.of(it.next()));
                    if (!it.hasNext()) continue;
                    build.append(CommandMessageFormatting.PIPE_TEXT);
                }
                build.append(CommandMessageFormatting.GT_TEXT);
                return build.build();
            }
            return super.getUsage(commander);
        }
    }

    private static class SequenceCommandElement
    extends CommandElement {
        private final List<CommandElement> elements;

        SequenceCommandElement(List<CommandElement> elements) {
            super(null);
            this.elements = elements;
        }

        @Override
        public void parse(CommandSource source, CommandArgs args, CommandContext context) throws ArgumentParseException {
            for (CommandElement element : this.elements) {
                element.parse(source, args, context);
            }
        }

        @Override
        protected Object parseValue(CommandSource source, CommandArgs args) throws ArgumentParseException {
            return null;
        }

        @Override
        public List<String> complete(CommandSource src, CommandArgs args, CommandContext context) {
            Iterator<CommandElement> it = this.elements.iterator();
            while (it.hasNext()) {
                CommandElement element = it.next();
                Object startState = args.getState();
                try {
                    element.parse(src, args, context);
                    Object endState = args.getState();
                    if (!args.hasNext()) {
                        args.setState(startState);
                        List<String> inputs = element.complete(src, args, context);
                        args.previous();
                        if (!inputs.contains(args.next())) {
                            return inputs;
                        }
                        args.setState(endState);
                    }
                }
                catch (ArgumentParseException e) {
                    args.setState(startState);
                    return element.complete(src, args, context);
                }
                if (it.hasNext()) continue;
                args.setState(startState);
            }
            return Collections.emptyList();
        }

        @Override
        public Text getUsage(CommandSource commander) {
            Text.Builder build = Text.builder();
            Iterator<CommandElement> it = this.elements.iterator();
            while (it.hasNext()) {
                build.append(it.next().getUsage(commander));
                if (!it.hasNext()) continue;
                build.append(CommandMessageFormatting.SPACE_TEXT);
            }
            return build.build();
        }
    }

    static class MarkTrueCommandElement
    extends CommandElement {
        MarkTrueCommandElement(String flag) {
            super(Text.of(flag));
        }

        @Override
        protected Object parseValue(CommandSource source, CommandArgs args) throws ArgumentParseException {
            return true;
        }

        @Override
        public List<String> complete(CommandSource src, CommandArgs args, CommandContext context) {
            return Collections.emptyList();
        }
    }

    private static class PluginCommandElement
    extends PatternMatchingCommandElement {
        protected PluginCommandElement(@Nullable Text key) {
            super(key);
        }

        @Override
        protected Iterable<String> getChoices(CommandSource source) {
            return Sponge.getPluginManager().getPlugins().stream().map(PluginContainer::getId).collect(Collectors.toList());
        }

        @Override
        protected Object getValue(String choice) throws IllegalArgumentException {
            Optional<PluginContainer> plugin = Sponge.getPluginManager().getPlugin(choice);
            return plugin.orElseThrow(() -> new IllegalArgumentException("Plugin " + choice + " was not found"));
        }
    }
}

