/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.data.manipulator.mutable;

import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.spongepowered.api.data.manipulator.DataManipulator;
import org.spongepowered.api.data.manipulator.immutable.ImmutableListData;
import org.spongepowered.api.data.value.BaseValue;
import org.spongepowered.api.data.value.mutable.ListValue;

public interface ListData<E, M extends ListData<E, M, I>, I extends ImmutableListData<E, I, M>>
extends DataManipulator<M, I> {
    public ListValue<E> getListValue();

    public List<E> asList();

    default public Optional<E> get(int index) {
        List<E> list = this.asList();
        if (list.size() < index) {
            return Optional.empty();
        }
        return Optional.of(list.get(index));
    }

    default public boolean contains(E element) {
        return this.getListValue().contains(element);
    }

    default public M setElement(int index, E element) {
        return (M)((ListData)this.set((BaseValue<?>)this.getListValue().set(index, element)));
    }

    default public M setElements(List<E> elements) {
        return (M)((ListData)this.set((BaseValue<?>)this.getListValue().set(elements)));
    }

    default public M addElement(E element) {
        return (M)((ListData)this.set((BaseValue<?>)this.getListValue().add(element)));
    }

    default public M addElement(int index, E element) {
        return (M)((ListData)this.set((BaseValue<?>)this.getListValue().add(index, element)));
    }

    default public M addElements(Iterable<E> elements) {
        return (M)((ListData)this.set((BaseValue<?>)this.getListValue().addAll(elements)));
    }

    default public M remove(int index) {
        return (M)((ListData)this.set((BaseValue<?>)this.getListValue().remove(index)));
    }

    default public M remove(E element) {
        return (M)((ListData)this.set((BaseValue<?>)this.getListValue().remove(element)));
    }

    default public M removeAll(Iterable<E> elements) {
        return (M)((ListData)this.set((BaseValue<?>)this.getListValue().removeAll(elements)));
    }

    default public M removeAll(Predicate<E> predicate) {
        return (M)((ListData)this.set((BaseValue<?>)this.getListValue().removeAll(predicate)));
    }
}

