/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.data.manipulator.mutable.common;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.MemoryDataContainer;
import org.spongepowered.api.data.Queries;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.manipulator.DataManipulator;
import org.spongepowered.api.data.manipulator.ImmutableDataManipulator;
import org.spongepowered.api.data.value.BaseValue;
import org.spongepowered.api.data.value.immutable.ImmutableValue;
import org.spongepowered.api.data.value.mutable.Value;

public abstract class AbstractData<M extends DataManipulator<M, I>, I extends ImmutableDataManipulator<I, M>>
implements DataManipulator<M, I> {
    private final Map<Key<?>, Supplier<Value<?>>> keyValueMap = Maps.newHashMap();
    private final Map<Key<?>, Supplier<?>> keyFieldGetterMap = Maps.newHashMap();
    private final Map<Key<?>, Consumer<Object>> keyFieldSetterMap = Maps.newHashMap();

    protected AbstractData() {
    }

    protected final void registerKeyValue(Key<?> key, Supplier<Value<?>> function) {
        this.keyValueMap.put((Key<?>)Preconditions.checkNotNull(key), (Supplier<Value<?>>)Preconditions.checkNotNull(function));
    }

    protected final void registerFieldGetter(Key<?> key, Supplier<?> function) {
        this.keyFieldGetterMap.put((Key<?>)Preconditions.checkNotNull(key, (Object)"The key cannot be null"), (Supplier<?>)Preconditions.checkNotNull(function, (Object)"The function cannot be null"));
    }

    protected final <E> void registerFieldSetter(Key<? extends BaseValue<E>> key, Consumer<E> function) {
        this.keyFieldSetterMap.put((Key<?>)Preconditions.checkNotNull(key), (Consumer<Object>)Preconditions.checkNotNull(function));
    }

    protected abstract void registerGettersAndSetters();

    @Override
    public <E> M set(Key<? extends BaseValue<E>> key, E value) {
        Preconditions.checkArgument((boolean)this.supports(key), (Object)("This data manipulator doesn't support the following key: " + key.toString()));
        this.keyFieldSetterMap.get(key).accept(value);
        return (M)this;
    }

    @Override
    public <E> M transform(Key<? extends BaseValue<E>> key, Function<E, E> function) {
        Preconditions.checkArgument((boolean)this.supports(key));
        this.keyFieldSetterMap.get(key).accept(Preconditions.checkNotNull(function.apply(this.keyFieldGetterMap.get(key).get())));
        return (M)this;
    }

    @Override
    public <E> Optional<E> get(Key<? extends BaseValue<E>> key) {
        if (!this.supports(key)) {
            return Optional.empty();
        }
        return Optional.of(this.keyFieldGetterMap.get(key).get());
    }

    @Override
    public <E, V extends BaseValue<E>> Optional<V> getValue(Key<V> key) {
        if (!this.keyValueMap.containsKey(key)) {
            return Optional.empty();
        }
        return Optional.of((BaseValue)Preconditions.checkNotNull(this.keyValueMap.get(key).get()));
    }

    @Override
    public boolean supports(Key<?> key) {
        return this.keyFieldSetterMap.containsKey(Preconditions.checkNotNull(key));
    }

    @Override
    public Set<Key<?>> getKeys() {
        return ImmutableSet.copyOf(this.keyFieldSetterMap.keySet());
    }

    @Override
    public Set<ImmutableValue<?>> getValues() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (Supplier<Value<?>> function : this.keyValueMap.values()) {
            builder.add(((Value)Preconditions.checkNotNull(function.get())).asImmutable());
        }
        return builder.build();
    }

    public int hashCode() {
        return Objects.hash(this.keyFieldGetterMap, this.keyFieldSetterMap, this.keyValueMap);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractData other = (AbstractData)obj;
        return Objects.equals(this.keyFieldGetterMap.values().stream().map(Supplier::get).collect(Collectors.toList()), other.keyFieldGetterMap.values().stream().map(Supplier::get).collect(Collectors.toList()));
    }

    @Override
    public DataContainer toContainer() {
        return new MemoryDataContainer().set(Queries.CONTENT_VERSION, (Object)this.getContentVersion());
    }
}

