/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.event.cause;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.profile.GameProfile;

public final class NamedCause {
    public static final String BLOCK_EVENT = "BlockEvent";
    public static final String BLOCK_PROTECTED = "BlockProtected";
    public static final String DECAY = "Decay";
    public static final String FAKE_PLAYER = "FakePlayer";
    public static final String FIRE_SPREAD = "FireSpread";
    public static final String HIT_TARGET = "HitTarget";
    public static final String IGNITER = "Igniter";
    public static final String LIQUID_FLOW = "LiquidFlow";
    public static final String LIQUID_MIX = "LiquidMix";
    public static final String NOTIFIER = "Notifier";
    public static final String OWNER = "Owner";
    public static final String PHYSICAL = "Physical";
    public static final String PISTON_EXTEND = "PistonExtend";
    public static final String PISTON_RETRACT = "PistonRetract";
    public static final String PLAYER_BREAK = "PlayerBreak";
    public static final String PLAYER_PLACE = "PlayerPlace";
    public static final String PLAYER_SIMULATED = "PlayerSimulated";
    public static final String SOURCE = "Source";
    public static final String THROWER = "Thrower";
    private final String name;
    private final Object object;

    public static NamedCause source(Object object) {
        return NamedCause.of(SOURCE, object);
    }

    public static NamedCause owner(Object object) {
        return NamedCause.of(OWNER, object);
    }

    public static NamedCause notifier(Object object) {
        return NamedCause.of(NOTIFIER, object);
    }

    public static NamedCause hitTarget(Object object) {
        return NamedCause.of(HIT_TARGET, object);
    }

    public static NamedCause simulated(Object object) {
        Preconditions.checkArgument((object instanceof Player || object instanceof User || object instanceof GameProfile ? 1 : 0) != 0, (Object)"Invalid object provided for player simulated methods");
        return NamedCause.of(PLAYER_SIMULATED, object);
    }

    public static NamedCause simulated(Player player) {
        return NamedCause.of(PLAYER_SIMULATED, player);
    }

    public static NamedCause simulated(User user) {
        return NamedCause.of(PLAYER_SIMULATED, user);
    }

    public static NamedCause simulated(GameProfile profile) {
        return NamedCause.of(PLAYER_SIMULATED, profile);
    }

    public static NamedCause of(String name, Object object) {
        Preconditions.checkNotNull((Object)name, (Object)"Cannot have a null name!");
        Preconditions.checkNotNull((Object)object, (Object)"Cannot have a null object!");
        Preconditions.checkArgument((!name.isEmpty() ? 1 : 0) != 0, (Object)"The name cannot be empty!");
        Preconditions.checkArgument((!(object instanceof NamedCause) ? 1 : 0) != 0, (Object)"Cannot nest a named cause in a named cause!");
        return new NamedCause(name, object);
    }

    private NamedCause(String name, Object object) {
        this.name = (String)Preconditions.checkNotNull((Object)name);
        this.object = Preconditions.checkNotNull((Object)object);
    }

    public String getName() {
        return this.name;
    }

    public Object getCauseObject() {
        return this.object;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.name, this.object});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        NamedCause other = (NamedCause)obj;
        return Objects.equal((Object)this.name, (Object)other.name) && Objects.equal((Object)this.object, (Object)other.object);
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("name", (Object)this.name).add("object", this.object).toString();
    }
}

