/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.event.impl;

import com.google.common.base.Preconditions;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.spongepowered.api.event.cause.entity.damage.DamageModifier;
import org.spongepowered.api.event.cause.entity.damage.DamageModifierType;
import org.spongepowered.api.event.entity.AttackEntityEvent;
import org.spongepowered.api.event.impl.AbstractModifierEvent;
import org.spongepowered.api.util.Tuple;
import org.spongepowered.api.util.annotation.eventgen.UseField;

public abstract class AbstractAttackEntityEvent
extends AbstractModifierEvent<DamageModifier>
implements AttackEntityEvent {
    @UseField
    protected double originalDamage;
    @UseField
    protected List<Tuple<DamageModifier, Function<? super Double, Double>>> originalFunctions;
    @UseField
    protected double baseDamage;

    @Override
    protected final void init() {
        this.originalFunctions = this.init(this.originalDamage, this.originalFunctions);
        this.baseDamage = this.originalDamage;
    }

    @Override
    public final double getOriginalModifierDamage(DamageModifier damageModifier) {
        Preconditions.checkArgument((damageModifier != null ? 1 : 0) != 0, (Object)"The damage modifier cannot be null!");
        for (Tuple tuple : this.originalModifiers) {
            if (!((DamageModifier)tuple.getFirst()).equals(damageModifier)) continue;
            return (Double)tuple.getSecond();
        }
        throw new IllegalArgumentException("The provided damage modifier is not applicable: " + damageModifier.toString());
    }

    @Override
    public final double getOriginalFinalDamage() {
        return this.originalFinalAmount;
    }

    @Override
    public final Map<DamageModifier, Double> getOriginalDamages() {
        return this.originalModifierMap;
    }

    @Override
    public final double getFinalOutputDamage() {
        return this.getFinalAmount(this.baseDamage);
    }

    @Override
    public final boolean isModifierApplicable(DamageModifier damageModifier) {
        return this.modifiers.containsKey(Preconditions.checkNotNull((Object)damageModifier));
    }

    @Override
    public final double getOutputDamage(DamageModifier damageModifier) {
        Preconditions.checkArgument((boolean)this.modifiers.containsKey(Preconditions.checkNotNull((Object)damageModifier)), (Object)("The provided damage modifier is not applicable : " + damageModifier.toString()));
        return (Double)this.modifiers.get(Preconditions.checkNotNull((Object)damageModifier));
    }

    @Override
    public final void setOutputDamage(DamageModifier damageModifier, Function<? super Double, Double> function) {
        Preconditions.checkNotNull((Object)damageModifier, (Object)"Damage modifier was null!");
        Preconditions.checkNotNull(function, (Object)"Function was null!");
        int indexToAddTo = 0;
        boolean addAtEnd = true;
        Iterator iterator = this.modifierFunctions.iterator();
        while (iterator.hasNext()) {
            Tuple tuple = (Tuple)iterator.next();
            if (((DamageModifier)tuple.getFirst()).equals(damageModifier)) {
                iterator.remove();
                addAtEnd = false;
                break;
            }
            ++indexToAddTo;
        }
        if (addAtEnd) {
            this.modifierFunctions.add(new Tuple<DamageModifier, Function<? super Double, Double>>(damageModifier, function));
        } else {
            this.modifierFunctions.add(indexToAddTo, new Tuple<DamageModifier, Function<? super Double, Double>>(damageModifier, function));
        }
        this.recalculateDamages(this.baseDamage);
    }

    @Override
    public void addDamageModifierBefore(DamageModifier damageModifier, Function<? super Double, Double> function, Set<DamageModifierType> before) {
        Preconditions.checkNotNull((Object)damageModifier, (Object)"Damage modifier was null!");
        Preconditions.checkNotNull(function, (Object)"Function was null!");
        int indexToAddBefore = -1;
        int index = 0;
        for (Tuple tuple : this.modifierFunctions) {
            Preconditions.checkArgument((!((DamageModifier)tuple.getFirst()).equals(damageModifier) ? 1 : 0) != 0, (Object)"Cannot add a duplicate modifier!");
            if (before.contains(((DamageModifier)tuple.getFirst()).getType())) {
                indexToAddBefore = index;
            }
            ++index;
        }
        if (indexToAddBefore == -1) {
            this.modifierFunctions.add(new Tuple<DamageModifier, Function<? super Double, Double>>(damageModifier, function));
        } else {
            this.modifierFunctions.add(indexToAddBefore, new Tuple<DamageModifier, Function<? super Double, Double>>(damageModifier, function));
        }
        this.recalculateDamages(this.baseDamage);
    }

    @Override
    public void addDamageModifierAfter(DamageModifier damageModifier, Function<? super Double, Double> function, Set<DamageModifierType> after) {
        Preconditions.checkNotNull((Object)damageModifier, (Object)"Damage modifier was null!");
        Preconditions.checkNotNull(function, (Object)"Function was null!");
        int indexToAddAfter = -1;
        int index = 0;
        for (Tuple tuple : this.modifierFunctions) {
            Preconditions.checkArgument((!((DamageModifier)tuple.getFirst()).equals(damageModifier) ? 1 : 0) != 0, (Object)"Cannot add a duplicate modifier!");
            if (after.contains(((DamageModifier)tuple.getFirst()).getType())) {
                indexToAddAfter = index;
            }
            ++index;
        }
        if (indexToAddAfter == -1) {
            this.modifierFunctions.add(new Tuple<DamageModifier, Function<? super Double, Double>>(damageModifier, function));
        } else {
            this.modifierFunctions.add(indexToAddAfter + 1, new Tuple<DamageModifier, Function<? super Double, Double>>(damageModifier, function));
        }
        this.recalculateDamages(this.baseDamage);
    }

    @Override
    public double getBaseOutputDamage() {
        return this.baseDamage;
    }

    @Override
    public final void setBaseOutputDamage(double baseDamage) {
        this.baseDamage = baseDamage;
        this.recalculateDamages(this.baseDamage);
    }
}

