/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.event.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.spongepowered.api.event.impl.AbstractEvent;
import org.spongepowered.api.util.Tuple;

public abstract class AbstractModifierEvent<T>
extends AbstractEvent {
    protected double originalFinalAmount;
    protected List<Tuple<T, Double>> originalModifiers;
    protected Map<T, Double> originalModifierMap;
    protected final LinkedHashMap<T, Double> modifiers = Maps.newLinkedHashMap();
    protected final List<Tuple<T, Function<? super Double, Double>>> modifierFunctions = new ArrayList<Tuple<T, Function<? super Double, Double>>>();

    protected ImmutableList<Tuple<T, Function<? super Double, Double>>> init(double originalValue, List<Tuple<T, Function<? super Double, Double>>> originalFunctions) {
        ImmutableList.Builder modifierMapBuilder = ImmutableList.builder();
        ImmutableList.Builder functionListBuilder = ImmutableList.builder();
        ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
        double finalDamage = originalValue;
        for (Tuple<T, Function<Double, Double>> tuple : originalFunctions) {
            this.modifierFunctions.add(new Tuple<T, Function<? super Double, Double>>(tuple.getFirst(), tuple.getSecond()));
            double tempDamage = (Double)Preconditions.checkNotNull((Object)tuple.getSecond().apply((Double)finalDamage));
            finalDamage += tempDamage;
            modifierMapBuilder.add(new Tuple<T, Double>(tuple.getFirst(), tempDamage));
            mapBuilder.put(tuple.getFirst(), (Object)tempDamage);
            this.modifiers.put(tuple.getFirst(), tempDamage);
            functionListBuilder.add(tuple);
        }
        this.originalFinalAmount = finalDamage;
        this.originalModifiers = modifierMapBuilder.build();
        this.originalModifierMap = mapBuilder.build();
        return functionListBuilder.build();
    }

    protected void recalculateDamages(double baseAmount) {
        double tempAmount = baseAmount;
        this.modifiers.clear();
        for (Tuple<T, Function<Double, Double>> entry : this.modifierFunctions) {
            double modifierAmount = (Double)Preconditions.checkNotNull((Object)entry.getSecond().apply((Double)tempAmount));
            if (this.modifiers.containsKey(entry.getFirst())) {
                double oldAmount = this.modifiers.get(entry.getFirst());
                double difference = oldAmount - modifierAmount;
                if (oldAmount > 0.0) {
                    this.modifiers.put(entry.getFirst(), Math.max(0.0, oldAmount - difference));
                } else {
                    this.modifiers.put(entry.getFirst(), Math.min(0.0, oldAmount - difference));
                }
            } else {
                this.modifiers.put(entry.getFirst(), modifierAmount);
            }
            tempAmount += modifierAmount;
        }
    }

    protected double getFinalAmount(double baseAmount) {
        double damage = baseAmount;
        for (Tuple<T, Function<Double, Double>> entry : this.modifierFunctions) {
            damage += ((Double)Preconditions.checkNotNull((Object)entry.getSecond().apply((Double)damage))).doubleValue();
        }
        return damage;
    }

    public final List<Tuple<T, Function<? super Double, Double>>> getModifiers() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Tuple<T, Function<Double, Double>> entry : this.modifierFunctions) {
            builder.add(new Tuple<T, Function<? super Double, Double>>(entry.getFirst(), entry.getSecond()));
        }
        return builder.build();
    }
}

