/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.item.merchant;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import org.spongepowered.api.data.type.Career;
import org.spongepowered.api.item.merchant.TradeOffer;
import org.spongepowered.api.item.merchant.TradeOfferListMutator;

public interface VillagerRegistry {
    public Multimap<Integer, TradeOfferListMutator> getTradeOfferLevelMap(Career var1);

    default public Collection<TradeOfferListMutator> getMutatorsForCareer(Career career, int level) {
        Multimap<Integer, TradeOfferListMutator> map = this.getTradeOfferLevelMap((Career)Preconditions.checkNotNull((Object)career, (Object)"Career cannot be null!"));
        Collection mutators = map.get((Object)level);
        return ImmutableList.copyOf((Collection)mutators);
    }

    public VillagerRegistry addMutator(Career var1, int var2, TradeOfferListMutator var3);

    public VillagerRegistry addMutators(Career var1, int var2, TradeOfferListMutator var3, TradeOfferListMutator ... var4);

    public VillagerRegistry setMutators(Career var1, int var2, List<TradeOfferListMutator> var3);

    public VillagerRegistry setMutators(Career var1, Multimap<Integer, TradeOfferListMutator> var2);

    default public Collection<TradeOffer> generateTradeOffers(Career career, int level, Random random) {
        Preconditions.checkNotNull((Object)random, (Object)"Random cannot be null!");
        ArrayList<TradeOffer> generatedList = new ArrayList<TradeOffer>();
        this.getMutatorsForCareer(career, level).stream().forEach(mutator -> mutator.accept((List<TradeOffer>)generatedList, random));
        return generatedList;
    }

    default public List<TradeOffer> populateOffers(List<TradeOffer> currentOffers, Career career, int level, Random random) {
        this.getMutatorsForCareer(career, level).forEach(mutator -> mutator.accept(currentOffers, random));
        return currentOffers;
    }
}

