/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.profile;

import java.util.Collection;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import org.spongepowered.api.profile.GameProfile;
import org.spongepowered.api.profile.GameProfileCache;
import org.spongepowered.api.profile.property.ProfileProperty;

public interface GameProfileManager {
    public GameProfile createProfile(UUID var1, @Nullable String var2);

    public ProfileProperty createProfileProperty(String var1, String var2, @Nullable String var3);

    default public CompletableFuture<GameProfile> get(UUID uniqueId) {
        return this.get(uniqueId, true);
    }

    default public CompletableFuture<GameProfile> get(String name) {
        return this.get(name, true);
    }

    public CompletableFuture<GameProfile> get(UUID var1, boolean var2);

    public CompletableFuture<GameProfile> get(String var1, boolean var2);

    public CompletableFuture<Collection<GameProfile>> getAllById(Iterable<UUID> var1, boolean var2);

    public CompletableFuture<Collection<GameProfile>> getAllByName(Iterable<String> var1, boolean var2);

    default public CompletableFuture<GameProfile> fill(GameProfile profile) {
        return this.fill(profile, false);
    }

    default public CompletableFuture<GameProfile> fill(GameProfile profile, boolean signed) {
        return this.fill(profile, signed, true);
    }

    public CompletableFuture<GameProfile> fill(GameProfile var1, boolean var2, boolean var3);

    public GameProfileCache getCache();

    public void setCache(GameProfileCache var1);

    public GameProfileCache getDefaultCache();

    @Deprecated
    default public Collection<GameProfile> getCachedProfiles() {
        return this.getCache().getProfiles();
    }

    @Deprecated
    default public Collection<GameProfile> match(String name) {
        return this.getCache().match(name);
    }
}

