/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.service;

import com.google.common.base.Preconditions;
import com.google.common.collect.MapMaker;
import java.util.Optional;
import java.util.concurrent.ConcurrentMap;
import javax.inject.Inject;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.plugin.PluginContainer;
import org.spongepowered.api.plugin.PluginManager;
import org.spongepowered.api.service.ProviderRegistration;
import org.spongepowered.api.service.ProvisioningException;
import org.spongepowered.api.service.ServiceManager;

public class SimpleServiceManager
implements ServiceManager {
    private final ConcurrentMap<Class<?>, ProviderRegistration<?>> providers = new MapMaker().concurrencyLevel(3).makeMap();
    private final PluginManager pluginManager;

    @Inject
    public SimpleServiceManager(PluginManager pluginManager) {
        Preconditions.checkNotNull((Object)pluginManager, (Object)"pluginManager");
        this.pluginManager = pluginManager;
    }

    @Override
    public <T> void setProvider(Object plugin, Class<T> service, T provider) {
        Preconditions.checkNotNull((Object)plugin, (Object)"plugin");
        Preconditions.checkNotNull(service, (Object)"service");
        Preconditions.checkNotNull(provider, (Object)"provider");
        Optional<PluginContainer> containerOptional = this.pluginManager.fromInstance(plugin);
        if (!containerOptional.isPresent()) {
            throw new IllegalArgumentException("The provided plugin object does not have an associated plugin container (in other words, is 'plugin' actually your plugin object?)");
        }
        PluginContainer container = containerOptional.get();
        ProviderRegistration oldProvider = this.providers.put(service, new Provider<T>(container, service, provider));
        Sponge.getEventManager().post(SpongeEventFactory.createChangeServiceProviderEvent(Cause.source(container).build(), (ProviderRegistration)this.providers.get(service), Optional.ofNullable(oldProvider)));
    }

    @Override
    public <T> Optional<T> provide(Class<T> service) {
        Preconditions.checkNotNull(service, (Object)"service");
        ProviderRegistration provider = (ProviderRegistration)this.providers.get(service);
        return provider != null ? Optional.of(provider.getProvider()) : Optional.empty();
    }

    @Override
    public <T> Optional<ProviderRegistration<T>> getRegistration(Class<T> service) {
        return Optional.ofNullable((ProviderRegistration)this.providers.get(service));
    }

    @Override
    public <T> T provideUnchecked(Class<T> service) throws ProvisioningException {
        Preconditions.checkNotNull(service, (Object)"service");
        ProviderRegistration provider = (ProviderRegistration)this.providers.get(service);
        if (provider == null) {
            throw new ProvisioningException("No provider is registered for the service '" + service.getName() + "'", service);
        }
        return provider.getProvider();
    }

    private static class Provider<T>
    implements ProviderRegistration<T> {
        private final PluginContainer container;
        private final Class<T> service;
        private final T provider;

        Provider(PluginContainer container, Class<T> service, T provider) {
            this.container = container;
            this.service = service;
            this.provider = provider;
        }

        @Override
        public Class<T> getService() {
            return this.service;
        }

        @Override
        public T getProvider() {
            return this.provider;
        }

        @Override
        public PluginContainer getPlugin() {
            return this.container;
        }
    }
}

