/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.service.pagination;

import java.util.Optional;
import javax.annotation.Nullable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.service.pagination.PaginationService;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.channel.MessageChannel;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.api.util.ResettableBuilder;

public interface PaginationList {
    public static Builder builder() {
        return Sponge.getServiceManager().provideUnchecked(PaginationService.class).builder();
    }

    public Iterable<Text> getContents();

    public Optional<Text> getTitle();

    public Optional<Text> getHeader();

    public Optional<Text> getFooter();

    public Text getPadding();

    public int getLinesPerPage();

    public void sendTo(MessageReceiver var1);

    default public void sendTo(MessageChannel channel) {
        for (MessageReceiver receiver : channel.getMembers()) {
            this.sendTo(receiver);
        }
    }

    public static interface Builder
    extends ResettableBuilder<PaginationList, Builder> {
        public Builder contents(Iterable<Text> var1);

        public Builder contents(Text ... var1);

        public Builder title(Text var1);

        public Builder header(@Nullable Text var1);

        public Builder footer(@Nullable Text var1);

        public Builder padding(Text var1);

        public Builder linesPerPage(int var1);

        public PaginationList build();

        default public void sendTo(MessageReceiver receiver) {
            this.build().sendTo(receiver);
        }

        default public void sendTo(MessageChannel channel) {
            channel.getMembers().forEach(this::sendTo);
        }

        default public void sendTo(Iterable<MessageReceiver> receivers) {
            receivers.forEach(this::sendTo);
        }
    }
}

