/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.service.permission;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.spongepowered.api.util.Tristate;

public class NodeTree {
    private static final Pattern SPLIT_REGEX = Pattern.compile("\\.");
    private final Node rootNode;

    private NodeTree(Tristate value) {
        this.rootNode = new Node(new HashMap<String, Node>());
        this.rootNode.value = value;
    }

    private NodeTree(Node rootNode) {
        this.rootNode = rootNode;
    }

    public static NodeTree of(Map<String, Boolean> values) {
        return NodeTree.of(values, Tristate.UNDEFINED);
    }

    public static NodeTree of(Map<String, Boolean> values, Tristate defaultValue) {
        NodeTree newTree = new NodeTree(defaultValue);
        for (Map.Entry<String, Boolean> value : values.entrySet()) {
            String[] parts = SPLIT_REGEX.split(value.getKey().toLowerCase());
            Node currentNode = newTree.rootNode;
            for (String part : parts) {
                if (currentNode.children.containsKey(part)) {
                    currentNode = currentNode.children.get(part);
                    continue;
                }
                Node newNode = new Node(new HashMap<String, Node>());
                currentNode.children.put(part, newNode);
                currentNode = newNode;
            }
            currentNode.value = Tristate.fromBoolean(value.getValue());
        }
        return newTree;
    }

    public Tristate get(String node) {
        String[] parts = SPLIT_REGEX.split(node.toLowerCase());
        Node currentNode = this.rootNode;
        Tristate lastUndefinedVal = Tristate.UNDEFINED;
        for (String str : parts) {
            if (!currentNode.children.containsKey(str)) break;
            currentNode = currentNode.children.get(str);
            if (currentNode.value == Tristate.UNDEFINED) continue;
            lastUndefinedVal = currentNode.value;
        }
        return lastUndefinedVal;
    }

    public Map<String, Boolean> asMap() {
        ImmutableMap.Builder ret = ImmutableMap.builder();
        for (Map.Entry<String, Node> ent : this.rootNode.children.entrySet()) {
            this.populateMap((ImmutableMap.Builder<String, Boolean>)ret, ent.getKey(), ent.getValue());
        }
        return ret.build();
    }

    private void populateMap(ImmutableMap.Builder<String, Boolean> values, String prefix, Node currentNode) {
        if (currentNode.value != Tristate.UNDEFINED) {
            values.put((Object)prefix, (Object)currentNode.value.asBoolean());
        }
        for (Map.Entry<String, Node> ent : currentNode.children.entrySet()) {
            this.populateMap(values, prefix + '.' + ent.getKey(), ent.getValue());
        }
    }

    public NodeTree withValue(String node, Tristate value) {
        Node newRoot;
        String[] parts = SPLIT_REGEX.split(node.toLowerCase());
        Node newPtr = newRoot = new Node(new HashMap<String, Node>(this.rootNode.children));
        Node currentPtr = this.rootNode;
        newPtr.value = currentPtr == null ? Tristate.UNDEFINED : currentPtr.value;
        for (String part : parts) {
            Node oldChild = currentPtr == null ? null : currentPtr.children.get(part);
            Node newChild = new Node((Map<String, Node>)(oldChild != null ? new HashMap<String, Node>(oldChild.children) : new HashMap()));
            newPtr.children.put(part, newChild);
            currentPtr = oldChild;
            newPtr = newChild;
        }
        newPtr.value = value;
        return new NodeTree(newRoot);
    }

    public NodeTree withAll(Map<String, Tristate> values) {
        NodeTree ret = this;
        for (Map.Entry<String, Tristate> ent : values.entrySet()) {
            ret = ret.withValue(ent.getKey(), ent.getValue());
        }
        return ret;
    }

    private static class Node {
        final Map<String, Node> children;
        Tristate value = Tristate.UNDEFINED;

        Node(Map<String, Node> children) {
            this.children = children;
        }
    }
}

