/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.text;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.reflect.TypeToken;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import ninja.leaping.configurate.objectmapping.serialize.TypeSerializers;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.DataSerializable;
import org.spongepowered.api.data.MemoryDataContainer;
import org.spongepowered.api.data.Queries;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.serializer.BookViewDataBuilder;
import org.spongepowered.api.util.ResettableBuilder;

public final class BookView
implements DataSerializable {
    final Text title;
    final Text author;
    final ImmutableList<Text> pages;

    BookView(Text title, Text author, ImmutableList<Text> pages) {
        this.title = title;
        this.pages = pages;
        this.author = author;
    }

    public Text getTitle() {
        return this.title;
    }

    public Text getAuthor() {
        return this.author;
    }

    public ImmutableList<Text> getPages() {
        return this.pages;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public int getContentVersion() {
        return 1;
    }

    @Override
    public DataContainer toContainer() {
        List pages = this.pages.stream().map(Text::toContainer).collect(Collectors.toList());
        return new MemoryDataContainer().set(Queries.CONTENT_VERSION, (Object)this.getContentVersion()).set(Queries.TEXT_TITLE, (Object)this.title.toContainer()).set(Queries.TEXT_AUTHOR, (Object)this.author.toContainer()).set(Queries.TEXT_PAGE_LIST, pages);
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("title", (Object)this.title).add("author", (Object)this.author).add("pages", this.pages).toString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BookView)) {
            return false;
        }
        BookView that = (BookView)obj;
        return this.title.equals(that.title) && this.author.equals(that.author) && this.pages.equals(that.pages);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.title, this.author, this.pages});
    }

    static {
        TypeSerializers.getDefaultSerializers().registerType(TypeToken.of(BookView.class), new BookViewDataBuilder());
    }

    public static final class Builder
    implements ResettableBuilder<BookView, Builder> {
        Text title = Text.EMPTY;
        Text author = Text.EMPTY;
        List<Text> pages = new ArrayList<Text>();

        public Builder title(Text title) {
            this.title = (Text)Preconditions.checkNotNull((Object)title, (Object)"title");
            return this;
        }

        public Builder author(Text author) {
            this.author = (Text)Preconditions.checkNotNull((Object)author, (Object)"author");
            return this;
        }

        public Builder addPage(Text page) {
            this.pages.add((Text)Preconditions.checkNotNull((Object)page, (Object)"page"));
            return this;
        }

        public Builder addPages(Collection<Text> pages) {
            this.pages.addAll((Collection)Preconditions.checkNotNull(pages, (Object)"pages"));
            return this;
        }

        public Builder addPages(Text ... pages) {
            this.addPages(Arrays.asList((Object[])Preconditions.checkNotNull((Object)pages, (Object)"pages")));
            return this;
        }

        public Builder insertPage(int i, Text page) {
            this.pages.add(i, (Text)Preconditions.checkNotNull((Object)page, (Object)"page"));
            return this;
        }

        public Builder insertPages(int i, Collection<Text> pages) {
            this.pages.addAll(i, (Collection)Preconditions.checkNotNull(pages, (Object)"pages"));
            return this;
        }

        public Builder insertPages(int i, Text ... pages) {
            this.insertPages(i, Arrays.asList((Object[])Preconditions.checkNotNull((Object)pages, (Object)"pages")));
            return this;
        }

        public Builder removePage(Text page) {
            this.pages.remove(Preconditions.checkNotNull((Object)page, (Object)"page"));
            return this;
        }

        public Builder removePage(int i) {
            this.pages.remove(i);
            return this;
        }

        public Builder removePages(Collection<Text> pages) {
            this.pages.removeAll((Collection)Preconditions.checkNotNull(pages, (Object)"pages"));
            return this;
        }

        public Builder removePages(Text ... pages) {
            this.removePages(Arrays.asList((Object[])Preconditions.checkNotNull((Object)pages, (Object)"pages")));
            return this;
        }

        public Builder clearPages() {
            this.pages.clear();
            return this;
        }

        public BookView build() {
            return new BookView(this.title, this.author, (ImmutableList<Text>)ImmutableList.copyOf(this.pages));
        }

        @Override
        public Builder from(BookView value) {
            return BookView.builder().title(value.title).author(value.author).addPages((Collection<Text>)value.pages);
        }

        @Override
        public Builder reset() {
            return BookView.builder();
        }
    }
}

