/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.text;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Iterator;
import javax.annotation.Nullable;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.action.ClickAction;
import org.spongepowered.api.text.action.HoverAction;
import org.spongepowered.api.text.action.ShiftClickAction;
import org.spongepowered.api.text.format.TextColor;
import org.spongepowered.api.text.format.TextFormat;
import org.spongepowered.api.text.format.TextStyle;
import org.spongepowered.api.text.translation.Translatable;
import org.spongepowered.api.text.translation.Translation;

public final class TranslatableText
extends Text {
    final Translation translation;
    final ImmutableList<Object> arguments;

    TranslatableText(Translation translation, ImmutableList<Object> arguments) {
        this.translation = (Translation)Preconditions.checkNotNull((Object)translation, (Object)"translation");
        this.arguments = (ImmutableList)Preconditions.checkNotNull(arguments, (Object)"arguments");
    }

    TranslatableText(TextFormat format, ImmutableList<Text> children, @Nullable ClickAction<?> clickAction, @Nullable HoverAction<?> hoverAction, @Nullable ShiftClickAction<?> shiftClickAction, Translation translation, ImmutableList<Object> arguments) {
        super(format, children, clickAction, hoverAction, shiftClickAction);
        this.translation = (Translation)Preconditions.checkNotNull((Object)translation, (Object)"translation");
        this.arguments = (ImmutableList)Preconditions.checkNotNull(arguments, (Object)"arguments");
    }

    public Translation getTranslation() {
        return this.translation;
    }

    public ImmutableList<Object> getArguments() {
        return this.arguments;
    }

    @Override
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TranslatableText) || !super.equals(o)) {
            return false;
        }
        TranslatableText that = (TranslatableText)o;
        return this.translation.equals(that.translation) && this.arguments.equals(that.arguments);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.translation, this.arguments});
    }

    @Override
    Objects.ToStringHelper toStringHelper() {
        return super.toStringHelper().addValue((Object)this.translation).add("arguments", this.arguments);
    }

    public static class Builder
    extends Text.Builder {
        private Translation translation;
        private ImmutableList<Object> arguments;

        Builder(Translation translation, Object ... args) {
            this.translation(translation, args);
        }

        Builder(Translatable translatable, Object ... args) {
            this.translation(translatable, args);
        }

        Builder(Text text, Translation translation, Object ... args) {
            super(text);
            this.translation(translation, args);
        }

        Builder(Text text, Translatable translatable, Object ... args) {
            super(text);
            this.translation(translatable, args);
        }

        Builder(TranslatableText text) {
            super(text);
            this.translation = text.translation;
            this.arguments = text.arguments;
        }

        public final Translation getTranslation() {
            return this.translation;
        }

        public final ImmutableList<Object> getArguments() {
            return this.arguments;
        }

        public Builder translation(Translation translation, Object ... args) {
            this.translation = (Translation)Preconditions.checkNotNull((Object)translation, (Object)"translation");
            this.arguments = ImmutableList.copyOf((Object[])((Object[])Preconditions.checkNotNull((Object)args, (Object)"args")));
            return this;
        }

        public Builder translation(Translatable translatable, Object ... args) {
            return this.translation(((Translatable)Preconditions.checkNotNull((Object)translatable, (Object)"translatable")).getTranslation(), args);
        }

        @Override
        public TranslatableText build() {
            return new TranslatableText(this.format, (ImmutableList<Text>)ImmutableList.copyOf((Collection)this.children), this.clickAction, this.hoverAction, this.shiftClickAction, this.translation, this.arguments);
        }

        @Override
        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Builder) || !super.equals(o)) {
                return false;
            }
            Builder that = (Builder)o;
            return Objects.equal((Object)this.translation, (Object)that.translation) && Objects.equal(this.arguments, that.arguments);
        }

        @Override
        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.translation, this.arguments});
        }

        @Override
        Objects.ToStringHelper toStringHelper() {
            return super.toStringHelper().addValue((Object)this.translation).add("arguments", this.arguments);
        }

        @Override
        public Builder format(TextFormat format) {
            return (Builder)super.format(format);
        }

        @Override
        public Builder color(TextColor color) {
            return (Builder)super.color(color);
        }

        @Override
        public Builder style(TextStyle ... styles) {
            return (Builder)super.style(styles);
        }

        @Override
        public Builder onClick(@Nullable ClickAction<?> clickAction) {
            return (Builder)super.onClick(clickAction);
        }

        @Override
        public Builder onHover(@Nullable HoverAction<?> hoverAction) {
            return (Builder)super.onHover(hoverAction);
        }

        @Override
        public Builder onShiftClick(@Nullable ShiftClickAction<?> shiftClickAction) {
            return (Builder)super.onShiftClick(shiftClickAction);
        }

        @Override
        public Builder append(Text ... children) {
            return (Builder)super.append(children);
        }

        @Override
        public Builder append(Collection<? extends Text> children) {
            return (Builder)super.append(children);
        }

        @Override
        public Builder append(Iterable<? extends Text> children) {
            return (Builder)super.append(children);
        }

        @Override
        public Builder append(Iterator<? extends Text> children) {
            return (Builder)super.append(children);
        }

        @Override
        public Builder insert(int pos, Text ... children) {
            return (Builder)super.insert(pos, children);
        }

        @Override
        public Builder insert(int pos, Collection<? extends Text> children) {
            return (Builder)super.insert(pos, children);
        }

        @Override
        public Builder insert(int pos, Iterable<? extends Text> children) {
            return (Builder)super.insert(pos, children);
        }

        @Override
        public Builder insert(int pos, Iterator<? extends Text> children) {
            return (Builder)super.insert(pos, children);
        }

        @Override
        public Builder remove(Text ... children) {
            return (Builder)super.remove(children);
        }

        @Override
        public Builder remove(Collection<? extends Text> children) {
            return (Builder)super.remove(children);
        }

        @Override
        public Builder remove(Iterable<? extends Text> children) {
            return (Builder)super.remove(children);
        }

        @Override
        public Builder remove(Iterator<? extends Text> children) {
            return (Builder)super.remove(children);
        }

        @Override
        public Builder removeAll() {
            return (Builder)super.removeAll();
        }
    }
}

