/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.text.channel.type;

import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import javax.annotation.Nullable;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.channel.MessageChannel;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.api.text.chat.ChatType;
import org.spongepowered.api.util.GuavaCollectors;

public class CombinedMessageChannel
implements MessageChannel {
    protected final Collection<MessageChannel> channels;

    public CombinedMessageChannel(MessageChannel ... channels) {
        this(Arrays.asList(channels));
    }

    public CombinedMessageChannel(Collection<MessageChannel> channels) {
        this.channels = ImmutableSet.copyOf(channels);
    }

    @Override
    public Optional<Text> transformMessage(@Nullable Object sender, MessageReceiver recipient, Text original, ChatType type) {
        Text text = original;
        for (MessageChannel channel : this.channels) {
            text = channel.transformMessage(sender, recipient, text, type).orElse(text);
        }
        return Optional.ofNullable(text);
    }

    @Override
    public Collection<MessageReceiver> getMembers() {
        return (Collection)this.channels.stream().flatMap(channel -> channel.getMembers().stream()).collect(GuavaCollectors.toImmutableSet());
    }
}

