/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.text.channel.type;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Map;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.service.permission.PermissionService;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.text.channel.MessageChannel;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.api.util.GuavaCollectors;

public class PermissionMessageChannel
implements MessageChannel {
    protected final String permission;

    public PermissionMessageChannel(String permission) {
        this.permission = (String)Preconditions.checkNotNull((Object)permission, (Object)"permission");
    }

    public String getPermission() {
        return this.permission;
    }

    @Override
    public Collection<MessageReceiver> getMembers() {
        PermissionService service = Sponge.getGame().getServiceManager().provideUnchecked(PermissionService.class);
        return (Collection)service.getKnownSubjects().values().stream().flatMap(input -> input.getAllWithPermission(this.permission).entrySet().stream().filter(Map.Entry::getValue).map(entry -> ((Subject)entry.getKey()).getCommandSource().orElse(null)).filter(source -> source != null)).collect(GuavaCollectors.toImmutableSet());
    }
}

