/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.text.serializer;

import com.google.common.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Optional;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.gson.GsonConfigurationLoader;
import ninja.leaping.configurate.loader.HeaderMode;
import ninja.leaping.configurate.objectmapping.ObjectMappingException;
import ninja.leaping.configurate.objectmapping.serialize.TypeSerializer;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.DataView;
import org.spongepowered.api.data.MemoryDataContainer;
import org.spongepowered.api.data.Queries;
import org.spongepowered.api.data.persistence.AbstractDataBuilder;
import org.spongepowered.api.data.persistence.InvalidDataException;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.serializer.TextParseException;
import org.spongepowered.api.text.serializer.TextSerializers;

public class TextConfigSerializer
extends AbstractDataBuilder<Text>
implements TypeSerializer<Text> {
    public TextConfigSerializer() {
        super(Text.class, 1);
    }

    @Override
    public Text deserialize(TypeToken<?> type, ConfigurationNode value) throws ObjectMappingException {
        StringWriter writer = new StringWriter();
        GsonConfigurationLoader gsonLoader = ((GsonConfigurationLoader.Builder)((GsonConfigurationLoader.Builder)GsonConfigurationLoader.builder().setIndent(0).setSink(() -> new BufferedWriter(writer))).setHeaderMode(HeaderMode.NONE)).build();
        try {
            gsonLoader.save(value);
        }
        catch (IOException e) {
            throw new ObjectMappingException(e);
        }
        return Sponge.getDataManager().deserialize(Text.class, new MemoryDataContainer().set(Queries.JSON, (Object)writer.toString())).get();
    }

    @Override
    public void serialize(TypeToken<?> type, Text obj, ConfigurationNode value) throws ObjectMappingException {
        String json = (String)obj.toContainer().get(Queries.JSON).get();
        GsonConfigurationLoader gsonLoader = ((GsonConfigurationLoader.Builder)GsonConfigurationLoader.builder().setSource(() -> new BufferedReader(new StringReader(json)))).build();
        try {
            value.setValue(gsonLoader.load());
        }
        catch (IOException e) {
            throw new ObjectMappingException(e);
        }
    }

    @Override
    protected Optional<Text> buildContent(DataView container) throws InvalidDataException {
        try {
            return container.get(Queries.JSON).map(json -> TextSerializers.JSON.deserialize(json.toString()));
        }
        catch (TextParseException e) {
            throw new InvalidDataException(e);
        }
    }
}

