/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.world.extent;

import com.flowpowered.math.vector.Vector3i;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.util.DiscreteTransform3;
import org.spongepowered.api.world.extent.ImmutableBlockVolume;
import org.spongepowered.api.world.extent.MutableBlockVolume;
import org.spongepowered.api.world.extent.StorageType;
import org.spongepowered.api.world.extent.UnmodifiableBlockVolume;
import org.spongepowered.api.world.extent.worker.BlockVolumeWorker;

public interface BlockVolume {
    public Vector3i getBlockMin();

    public Vector3i getBlockMax();

    public Vector3i getBlockSize();

    default public boolean containsBlock(Vector3i position) {
        return this.containsBlock(position.getX(), position.getY(), position.getZ());
    }

    public boolean containsBlock(int var1, int var2, int var3);

    default public BlockState getBlock(Vector3i position) {
        return this.getBlock(position.getX(), position.getY(), position.getZ());
    }

    public BlockState getBlock(int var1, int var2, int var3);

    default public BlockType getBlockType(Vector3i position) {
        return this.getBlockType(position.getX(), position.getY(), position.getZ());
    }

    public BlockType getBlockType(int var1, int var2, int var3);

    public BlockVolume getBlockView(Vector3i var1, Vector3i var2);

    public BlockVolume getBlockView(DiscreteTransform3 var1);

    default public BlockVolume getRelativeBlockView() {
        return this.getBlockView(DiscreteTransform3.fromTranslation(this.getBlockMin().negate()));
    }

    public UnmodifiableBlockVolume getUnmodifiableBlockView();

    default public MutableBlockVolume getBlockCopy() {
        return this.getBlockCopy(StorageType.STANDARD);
    }

    public MutableBlockVolume getBlockCopy(StorageType var1);

    public ImmutableBlockVolume getImmutableBlockCopy();

    public BlockVolumeWorker<? extends BlockVolume> getBlockWorker(Cause var1);
}

