/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common;

import net.minecraft.server.dedicated.DedicatedServer;
import org.spongepowered.api.Platform;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandCallable;
import org.spongepowered.api.service.ban.BanService;
import org.spongepowered.api.service.pagination.PaginationService;
import org.spongepowered.api.service.permission.PermissionService;
import org.spongepowered.api.service.rcon.RconService;
import org.spongepowered.api.service.sql.SqlService;
import org.spongepowered.api.service.user.UserStorageService;
import org.spongepowered.api.service.whitelist.WhitelistService;
import org.spongepowered.api.util.annotation.NonnullByDefault;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.SpongeInternalListeners;
import org.spongepowered.common.command.SpongeCommand;
import org.spongepowered.common.command.SpongeHelpCommand;
import org.spongepowered.common.service.ban.SpongeBanService;
import org.spongepowered.common.service.pagination.SpongePaginationService;
import org.spongepowered.common.service.rcon.MinecraftRconService;
import org.spongepowered.common.service.sql.SqlServiceImpl;
import org.spongepowered.common.service.user.SpongeUserStorageService;
import org.spongepowered.common.service.whitelist.SpongeWhitelistService;
import org.spongepowered.common.text.action.SpongeCallbackHolder;
import org.spongepowered.common.util.SpongeUsernameCache;

@NonnullByDefault
public final class SpongeBootstrap {
    public static void initializeServices() {
        SpongeBootstrap.registerService(SqlService.class, new SqlServiceImpl());
        SpongeBootstrap.registerService(PaginationService.class, new SpongePaginationService());
        if (SpongeImpl.getGame().getPlatform().getType() == Platform.Type.SERVER) {
            SpongeBootstrap.registerService(RconService.class, new MinecraftRconService((DedicatedServer)Sponge.getServer()));
        }
        SpongeBootstrap.registerService(UserStorageService.class, new SpongeUserStorageService());
        SpongeBootstrap.registerService(BanService.class, new SpongeBanService());
        SpongeBootstrap.registerService(WhitelistService.class, new SpongeWhitelistService());
        SpongeInternalListeners.getInstance().registerServiceCallback(PermissionService.class, input -> SpongeImpl.getGame().getServer().getConsole().getContainingCollection());
        SpongeUsernameCache.load();
    }

    public static void initializeCommands() {
        Sponge.getCommandManager().register((Object)SpongeImpl.getPlugin(), (CommandCallable)SpongeCommand.getCommand(), "sponge", "sp");
        Sponge.getCommandManager().register((Object)SpongeImpl.getPlugin(), (CommandCallable)SpongeHelpCommand.create(), "help", "?");
        Sponge.getCommandManager().register((Object)SpongeImpl.getPlugin(), (CommandCallable)SpongeCallbackHolder.getInstance().createCommand(), "callback");
    }

    private static <T> void registerService(Class<T> serviceClass, T serviceImpl) {
        SpongeImpl.getGame().getServiceManager().setProvider(SpongeImpl.getPlugin(), serviceClass, serviceImpl);
    }
}

