/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.nio.file.Path;
import javax.inject.Singleton;
import org.apache.logging.log4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongepowered.api.Game;
import org.spongepowered.api.GameState;
import org.spongepowered.api.Platform;
import org.spongepowered.api.asset.AssetManager;
import org.spongepowered.api.command.CommandManager;
import org.spongepowered.api.config.ConfigManager;
import org.spongepowered.api.data.DataManager;
import org.spongepowered.api.data.property.PropertyRegistry;
import org.spongepowered.api.event.EventManager;
import org.spongepowered.api.network.ChannelRegistrar;
import org.spongepowered.api.plugin.PluginManager;
import org.spongepowered.api.scheduler.Scheduler;
import org.spongepowered.api.service.ServiceManager;
import org.spongepowered.api.world.TeleportHelper;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.command.SpongeCommandDisambiguator;
import org.spongepowered.common.command.SpongeCommandManager;
import org.spongepowered.common.config.SpongeConfigManager;
import org.spongepowered.common.data.SpongeDataManager;
import org.spongepowered.common.data.property.SpongePropertyRegistry;
import org.spongepowered.common.registry.SpongeGameRegistry;
import org.spongepowered.common.scheduler.SpongeScheduler;

@Singleton
public abstract class SpongeGame
implements Game {
    private final Platform platform;
    private final PluginManager pluginManager;
    private final EventManager eventManager;
    private final AssetManager assetManager;
    private final SpongeGameRegistry gameRegistry;
    private final ServiceManager serviceManager;
    private final TeleportHelper teleportHelper;
    private final ConfigManager configManager;
    private final CommandManager commandManager;
    private final ChannelRegistrar channelRegistrar;
    private GameState state = GameState.CONSTRUCTION;

    protected SpongeGame(Platform platform, PluginManager pluginManager, EventManager eventManager, AssetManager assetManager, ServiceManager serviceManager, TeleportHelper teleportHelper, ChannelRegistrar channelRegistrar, Logger logger, SpongeGameRegistry gameRegistry) {
        this.platform = (Platform)Preconditions.checkNotNull((Object)platform, (Object)"platform");
        this.pluginManager = (PluginManager)Preconditions.checkNotNull((Object)pluginManager, (Object)"pluginManager");
        this.eventManager = (EventManager)Preconditions.checkNotNull((Object)eventManager, (Object)"eventManager");
        this.assetManager = assetManager;
        this.gameRegistry = (SpongeGameRegistry)Preconditions.checkNotNull((Object)gameRegistry, (Object)"gameRegistry");
        this.serviceManager = (ServiceManager)Preconditions.checkNotNull((Object)serviceManager, (Object)"serviceManager");
        this.teleportHelper = (TeleportHelper)Preconditions.checkNotNull((Object)teleportHelper, (Object)"teleportHelper");
        this.channelRegistrar = (ChannelRegistrar)Preconditions.checkNotNull((Object)channelRegistrar, (Object)"channelRegistrar");
        this.configManager = new SpongeConfigManager();
        this.commandManager = new SpongeCommandManager(LoggerFactory.getLogger(logger.getName()), new SpongeCommandDisambiguator(this));
    }

    @Override
    public Platform getPlatform() {
        return this.platform;
    }

    @Override
    public PluginManager getPluginManager() {
        return this.pluginManager;
    }

    @Override
    public EventManager getEventManager() {
        return this.eventManager;
    }

    @Override
    public AssetManager getAssetManager() {
        return this.assetManager;
    }

    @Override
    public SpongeGameRegistry getRegistry() {
        return this.gameRegistry;
    }

    @Override
    public ServiceManager getServiceManager() {
        return this.serviceManager;
    }

    @Override
    public CommandManager getCommandManager() {
        return this.commandManager;
    }

    @Override
    public TeleportHelper getTeleportHelper() {
        return this.teleportHelper;
    }

    @Override
    public ChannelRegistrar getChannelRegistrar() {
        return this.channelRegistrar;
    }

    @Override
    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    @Override
    public Path getGameDirectory() {
        return SpongeImpl.getGameDir();
    }

    @Override
    public Scheduler getScheduler() {
        return SpongeScheduler.getInstance();
    }

    @Override
    public DataManager getDataManager() {
        return SpongeDataManager.getInstance();
    }

    @Override
    public PropertyRegistry getPropertyRegistry() {
        return SpongePropertyRegistry.getInstance();
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("platform", (Object)this.platform).toString();
    }

    @Override
    public GameState getState() {
        return this.state;
    }

    public void setState(GameState state) {
        this.state = (GameState)((Object)Preconditions.checkNotNull((Object)((Object)state)));
    }
}

