/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.inject.Injector;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.LogManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongepowered.api.Game;
import org.spongepowered.api.GameState;
import org.spongepowered.api.Platform;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.event.Event;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.event.game.state.GameStateEvent;
import org.spongepowered.api.plugin.PluginContainer;
import org.spongepowered.common.SpongeGame;
import org.spongepowered.common.SpongeMinecraftVersion;
import org.spongepowered.common.config.SpongeConfig;
import org.spongepowered.common.config.type.GlobalConfig;
import org.spongepowered.common.event.SpongeEventManager;
import org.spongepowered.common.launch.SpongeLaunch;
import org.spongepowered.common.registry.SpongeGameRegistry;

@Singleton
public final class SpongeImpl {
    public static final String GAME_ID = "minecraft";
    public static final String GAME_NAME = "Minecraft";
    public static final String API_NAME = (String)Objects.firstNonNull((Object)SpongeImpl.getPackage().getSpecificationTitle(), (Object)"SpongeAPI");
    public static final Optional<String> API_VERSION = Optional.ofNullable(SpongeImpl.getPackage().getSpecificationVersion());
    public static final String ECOSYSTEM_ID = "sponge";
    public static final String ECOSYSTEM_NAME = "Sponge";
    public static final Optional<String> IMPLEMENTATION_NAME = Optional.ofNullable(SpongeImpl.getPackage().getImplementationTitle());
    public static final Optional<String> IMPLEMENTATION_VERSION = Optional.ofNullable(SpongeImpl.getPackage().getImplementationVersion());
    public static final SpongeMinecraftVersion MINECRAFT_VERSION = new SpongeMinecraftVersion("1.10.2", 210);
    private static final org.apache.logging.log4j.Logger logger = LogManager.getLogger((String)"Sponge");
    private static final Logger slf4jLogger = LoggerFactory.getLogger("Sponge");
    @Nullable
    private static SpongeImpl instance;
    @Nullable
    private static SpongeConfig<GlobalConfig> globalConfig;
    public static final Random random;
    private final Injector injector;
    private final Game game;
    private final PluginContainer plugin;
    private final PluginContainer minecraftPlugin;
    private final Cause implementationCause;
    @Nullable
    private static List<PluginContainer> components;

    @Inject
    public SpongeImpl(Injector injector, Game game, @Named(value="sponge") PluginContainer plugin, @Named(value="minecraft") PluginContainer minecraftPlugin) {
        Preconditions.checkState((instance == null ? 1 : 0) != 0, (Object)"SpongeImpl was already initialized");
        instance = this;
        this.injector = (Injector)Preconditions.checkNotNull((Object)injector, (Object)"injector");
        this.game = (Game)Preconditions.checkNotNull((Object)game, (Object)"game");
        this.plugin = (PluginContainer)Preconditions.checkNotNull((Object)plugin, (Object)"plugin");
        this.minecraftPlugin = (PluginContainer)Preconditions.checkNotNull((Object)minecraftPlugin, (Object)"minecraftPlugin");
        this.implementationCause = Cause.source(this.plugin).build();
    }

    public static SpongeImpl getInstance() {
        Preconditions.checkState((instance != null ? 1 : 0) != 0, (Object)"SpongeImpl was not initialized");
        return instance;
    }

    public static boolean isInitialized() {
        return instance != null;
    }

    public static Injector getInjector() {
        return SpongeImpl.getInstance().injector;
    }

    public static SpongeGame getGame() {
        return (SpongeGame)SpongeImpl.getInstance().game;
    }

    public static MinecraftServer getServer() {
        return (MinecraftServer)SpongeImpl.getGame().getServer();
    }

    public static SpongeGameRegistry getRegistry() {
        return SpongeImpl.getGame().getRegistry();
    }

    public static boolean postEvent(Event event) {
        return SpongeImpl.getGame().getEventManager().post(event);
    }

    public static org.apache.logging.log4j.Logger getLogger() {
        return logger;
    }

    public static Logger getSlf4jLogger() {
        return slf4jLogger;
    }

    public static PluginContainer getPlugin() {
        return SpongeImpl.getInstance().plugin;
    }

    public static PluginContainer getMinecraftPlugin() {
        return SpongeImpl.getInstance().minecraftPlugin;
    }

    public static Path getGameDir() {
        return SpongeLaunch.getGameDir();
    }

    public static Path getPluginConfigDir() {
        return SpongeLaunch.getPluginConfigDir();
    }

    public static Path getPluginsDir() {
        return SpongeLaunch.getPluginsDir();
    }

    public static Path getSpongeConfigDir() {
        return SpongeLaunch.getSpongeConfigDir();
    }

    public static SpongeConfig<GlobalConfig> getGlobalConfig() {
        if (globalConfig == null) {
            globalConfig = new SpongeConfig(SpongeConfig.Type.GLOBAL, SpongeImpl.getSpongeConfigDir().resolve("global.conf"), ECOSYSTEM_ID);
        }
        return globalConfig;
    }

    public static List<PluginContainer> getInternalPlugins() {
        if (components == null) {
            components = new ArrayList<PluginContainer>(6);
            for (Platform.Component component : Platform.Component.values()) {
                components.add(Sponge.getPlatform().getContainer(component));
            }
        }
        return components;
    }

    public static void postState(GameState state, GameStateEvent event) {
        SpongeImpl.getGame().setState(state);
        ((SpongeEventManager)SpongeImpl.getGame().getEventManager()).post((Event)event, true);
    }

    public static void postShutdownEvents() {
        SpongeImpl.postState(GameState.GAME_STOPPING, SpongeEventFactory.createGameStoppingEvent(Cause.source(SpongeImpl.getGame()).build()));
        SpongeImpl.postState(GameState.GAME_STOPPED, SpongeEventFactory.createGameStoppedEvent(Cause.source(SpongeImpl.getGame()).build()));
    }

    private static Package getPackage() {
        return SpongeImpl.class.getPackage();
    }

    public static Cause getImplementationCause() {
        return SpongeImpl.getInstance().implementationCause;
    }

    static {
        random = new Random();
    }
}

