/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.block;

import com.flowpowered.math.vector.Vector3i;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.BlockTypes;
import org.spongepowered.api.data.DataView;
import org.spongepowered.api.data.Queries;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.manipulator.DataManipulator;
import org.spongepowered.api.data.manipulator.ImmutableDataManipulator;
import org.spongepowered.api.data.persistence.AbstractDataBuilder;
import org.spongepowered.api.data.persistence.InvalidDataException;
import org.spongepowered.api.data.value.BaseValue;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.storage.WorldProperties;
import org.spongepowered.common.block.SpongeBlockSnapshot;
import org.spongepowered.common.data.persistence.NbtTranslator;
import org.spongepowered.common.data.util.DataQueries;
import org.spongepowered.common.data.util.DataUtil;

public class SpongeBlockSnapshotBuilder
extends AbstractDataBuilder<BlockSnapshot>
implements BlockSnapshot.Builder {
    BlockState blockState;
    BlockState extendedState;
    UUID worldUuid;
    UUID creatorUuid;
    UUID notifierUuid;
    Vector3i coords;
    @Nullable
    List<ImmutableDataManipulator<?, ?>> manipulators;
    @Nullable
    NBTTagCompound compound;

    public SpongeBlockSnapshotBuilder() {
        super(BlockSnapshot.class, 1);
    }

    @Override
    public SpongeBlockSnapshotBuilder world(WorldProperties worldProperties) {
        this.worldUuid = ((WorldProperties)Preconditions.checkNotNull((Object)worldProperties)).getUniqueId();
        return this;
    }

    public SpongeBlockSnapshotBuilder worldId(UUID worldUuid) {
        this.worldUuid = (UUID)Preconditions.checkNotNull((Object)worldUuid);
        return this;
    }

    @Override
    public SpongeBlockSnapshotBuilder blockState(BlockState blockState) {
        this.blockState = (BlockState)Preconditions.checkNotNull((Object)blockState);
        return this;
    }

    public SpongeBlockSnapshotBuilder extendedState(BlockState extendedState) {
        this.extendedState = (BlockState)Preconditions.checkNotNull((Object)extendedState);
        return this;
    }

    @Override
    public SpongeBlockSnapshotBuilder position(Vector3i position) {
        this.coords = (Vector3i)Preconditions.checkNotNull((Object)position);
        if (this.compound != null) {
            this.compound.func_74768_a("x", position.getX());
            this.compound.func_74768_a("y", position.getY());
            this.compound.func_74768_a("z", position.getZ());
        }
        return this;
    }

    @Override
    public SpongeBlockSnapshotBuilder from(Location<World> location) {
        this.blockState = location.getBlock();
        this.worldUuid = location.getExtent().getUniqueId();
        this.coords = location.getBlockPosition();
        if (this.blockState.getType() instanceof ITileEntityProvider && location.hasTileEntity()) {
            this.compound = new NBTTagCompound();
            ((TileEntity)location.getTileEntity().get()).func_189515_b(this.compound);
            this.manipulators = location.getContainers().stream().map(DataManipulator::asImmutable).collect(Collectors.toList());
        }
        return this;
    }

    @Override
    public BlockSnapshot.Builder creator(UUID uuid) {
        this.creatorUuid = (UUID)Preconditions.checkNotNull((Object)uuid);
        return this;
    }

    @Override
    public BlockSnapshot.Builder notifier(UUID uuid) {
        this.notifierUuid = (UUID)Preconditions.checkNotNull((Object)uuid);
        return this;
    }

    public SpongeBlockSnapshotBuilder unsafeNbt(NBTTagCompound compound) {
        this.compound = compound.func_74737_b();
        return this;
    }

    @Override
    public SpongeBlockSnapshotBuilder add(DataManipulator<?, ?> manipulator) {
        return this.add((ImmutableDataManipulator)((DataManipulator)Preconditions.checkNotNull(manipulator, (Object)"manipulator")).asImmutable());
    }

    @Override
    public SpongeBlockSnapshotBuilder add(ImmutableDataManipulator<?, ?> manipulator) {
        Preconditions.checkNotNull(manipulator, (Object)"manipulator");
        if (this.manipulators == null) {
            this.manipulators = Lists.newArrayList();
        }
        Iterator<ImmutableDataManipulator<?, ?>> iterator = this.manipulators.iterator();
        while (iterator.hasNext()) {
            ImmutableDataManipulator<?, ?> existing = iterator.next();
            if (!manipulator.getClass().isInstance(existing)) continue;
            iterator.remove();
        }
        this.manipulators.add(manipulator);
        return this;
    }

    @Override
    public <V> BlockSnapshot.Builder add(Key<? extends BaseValue<V>> key, V value) {
        Preconditions.checkNotNull(key, (Object)"key");
        Preconditions.checkState((this.blockState != null ? 1 : 0) != 0);
        this.blockState = this.blockState.with(key, value).orElse(this.blockState);
        if (this.extendedState != null) {
            this.extendedState = this.extendedState.with(key, value).orElse(this.extendedState);
        }
        return this;
    }

    @Override
    public SpongeBlockSnapshotBuilder from(BlockSnapshot holder) {
        this.blockState = holder.getState();
        this.worldUuid = holder.getWorldUniqueId();
        if (holder.getCreator().isPresent()) {
            this.creatorUuid = holder.getCreator().get();
        }
        if (holder.getNotifier().isPresent()) {
            this.notifierUuid = holder.getNotifier().get();
        }
        this.coords = holder.getPosition();
        this.manipulators = Lists.newArrayList(holder.getManipulators());
        if (holder instanceof SpongeBlockSnapshot && ((SpongeBlockSnapshot)holder).compound != null) {
            this.compound = ((SpongeBlockSnapshot)holder).compound.func_74737_b();
        }
        return this;
    }

    @Override
    public SpongeBlockSnapshotBuilder reset() {
        this.blockState = BlockTypes.AIR.getDefaultState();
        this.worldUuid = null;
        this.creatorUuid = null;
        this.notifierUuid = null;
        this.coords = null;
        this.manipulators = null;
        this.compound = null;
        return this;
    }

    @Override
    public BlockSnapshot build() {
        Preconditions.checkState((this.blockState != null ? 1 : 0) != 0);
        if (this.extendedState == null) {
            this.extendedState = this.blockState;
        }
        return new SpongeBlockSnapshot(this);
    }

    @Override
    protected Optional<BlockSnapshot> buildContent(DataView container) throws InvalidDataException {
        Optional<DataView> unsafeCompound;
        NBTTagCompound compound;
        if (!container.contains(DataQueries.BLOCK_STATE, Queries.WORLD_ID, DataQueries.SNAPSHOT_WORLD_POSITION)) {
            return Optional.empty();
        }
        DataUtil.checkDataExists(container, DataQueries.BLOCK_STATE);
        DataUtil.checkDataExists(container, Queries.WORLD_ID);
        SpongeBlockSnapshotBuilder builder = new SpongeBlockSnapshotBuilder();
        UUID worldUuid = UUID.fromString(container.getString(Queries.WORLD_ID).get());
        Vector3i coordinate = DataUtil.getPosition3i(container);
        Optional<String> creatorUuid = container.getString(Queries.CREATOR_ID);
        Optional<String> notifierUuid = container.getString(Queries.NOTIFIER_ID);
        BlockState blockState = container.getSerializable(DataQueries.BLOCK_STATE, BlockState.class).get();
        BlockState extendedState = null;
        extendedState = container.contains(DataQueries.BLOCK_EXTENDED_STATE) ? container.getSerializable(DataQueries.BLOCK_EXTENDED_STATE, BlockState.class).get() : blockState;
        builder.blockState(blockState).extendedState(extendedState).position(coordinate).worldId(worldUuid);
        if (creatorUuid.isPresent()) {
            builder.creator(UUID.fromString(creatorUuid.get()));
        }
        if (notifierUuid.isPresent()) {
            builder.notifier(UUID.fromString(notifierUuid.get()));
        }
        NBTTagCompound nBTTagCompound = compound = (unsafeCompound = container.getView(DataQueries.UNSAFE_NBT)).isPresent() ? NbtTranslator.getInstance().translateData(unsafeCompound.get()) : null;
        if (compound != null) {
            builder.unsafeNbt(compound);
        }
        if (container.contains(DataQueries.SNAPSHOT_TILE_DATA)) {
            List<DataView> dataViews = container.getViewList(DataQueries.SNAPSHOT_TILE_DATA).get();
            DataUtil.deserializeImmutableManipulatorList(dataViews).stream().forEach(immutableDataManipulator -> this.add((ImmutableDataManipulator)immutableDataManipulator));
        }
        return Optional.of(new SpongeBlockSnapshot(builder));
    }
}

