/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.block;

import com.google.common.base.Preconditions;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.tileentity.TileEntityArchetype;
import org.spongepowered.api.block.tileentity.TileEntityType;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.DataView;
import org.spongepowered.api.data.MemoryDataContainer;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.manipulator.DataManipulator;
import org.spongepowered.api.data.persistence.AbstractDataBuilder;
import org.spongepowered.api.data.persistence.InvalidDataException;
import org.spongepowered.api.data.value.BaseValue;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;
import org.spongepowered.common.SpongeImplHooks;
import org.spongepowered.common.block.BlockUtil;
import org.spongepowered.common.block.SpongeTileEntityArchetype;
import org.spongepowered.common.data.SpongeDataManager;
import org.spongepowered.common.data.nbt.NbtDataTypes;
import org.spongepowered.common.data.nbt.validation.Validations;
import org.spongepowered.common.data.persistence.NbtTranslator;
import org.spongepowered.common.data.util.DataQueries;

public class SpongeTileEntityArchetypeBuilder
extends AbstractDataBuilder<TileEntityArchetype>
implements TileEntityArchetype.Builder {
    BlockState blockState;
    @Nullable
    TileEntityType tileEntityType;
    DataContainer tileData;

    public SpongeTileEntityArchetypeBuilder() {
        super(TileEntityArchetype.class, 1);
    }

    @Override
    public TileEntityArchetype.Builder reset() {
        this.blockState = null;
        this.tileEntityType = null;
        this.tileData = null;
        return this;
    }

    @Override
    public TileEntityArchetype.Builder from(TileEntityArchetype value) {
        this.tileEntityType = value.getTileEntityType();
        this.blockState = value.getState();
        this.tileData = value.getTileData();
        return this;
    }

    @Override
    public TileEntityArchetype.Builder state(BlockState state) {
        IBlockState blockState = BlockUtil.toNative(state);
        if (!SpongeImplHooks.hasBlockTileEntity(blockState.func_177230_c(), blockState)) {
            throw new IllegalArgumentException("BlockState does not provide TileEntities!");
        }
        if (this.blockState != state) {
            this.tileData = null;
        }
        this.blockState = state;
        return this;
    }

    @Override
    public TileEntityArchetype.Builder tile(TileEntityType tileEntityType) {
        this.tileEntityType = (TileEntityType)Preconditions.checkNotNull((Object)tileEntityType, (Object)"TileEntityType cannot be null!");
        return this;
    }

    @Override
    public TileEntityArchetype.Builder from(Location<World> location) {
        org.spongepowered.api.block.tileentity.TileEntity tileEntity = location.getTileEntity().orElseThrow(() -> new IllegalArgumentException("There is no tile entity available at the provided location: " + location));
        return this.tile(tileEntity);
    }

    @Override
    public TileEntityArchetype.Builder tile(org.spongepowered.api.block.tileentity.TileEntity tileEntity) {
        Preconditions.checkArgument((boolean)(tileEntity instanceof TileEntity), (Object)"TileEntity is not compatible with this implementation!");
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        ((TileEntity)tileEntity).func_189515_b(nbttagcompound);
        nbttagcompound.func_82580_o("x");
        nbttagcompound.func_82580_o("y");
        nbttagcompound.func_82580_o("z");
        this.tileData = NbtTranslator.getInstance().translate(nbttagcompound);
        this.blockState = tileEntity.getBlock();
        this.tileEntityType = tileEntity.getType();
        return this;
    }

    @Override
    public TileEntityArchetype.Builder tileData(DataView dataView) {
        Preconditions.checkNotNull((Object)dataView, (Object)"Provided DataView cannot be null!");
        DataContainer copy = dataView.copy();
        SpongeDataManager.getInstance().getValidators(Validations.TILE_ENTITY).validate(copy);
        this.tileData = copy;
        return this;
    }

    @Override
    public TileEntityArchetype.Builder setData(DataManipulator<?, ?> manipulator) {
        if (this.tileData == null) {
            this.tileData = new MemoryDataContainer();
        }
        SpongeDataManager.getInstance().getRawNbtProcessor(NbtDataTypes.TILE_ENTITY, manipulator.getClass()).ifPresent(processor -> processor.storeToView(this.tileData, manipulator));
        return this;
    }

    @Override
    public <E, V extends BaseValue<E>> TileEntityArchetype.Builder set(V value) {
        if (this.tileData == null) {
            this.tileData = new MemoryDataContainer();
        }
        SpongeDataManager.getInstance().getRawNbtProcessor(NbtDataTypes.TILE_ENTITY, value.getKey()).ifPresent(processor -> processor.offer(this.tileData, value));
        return this;
    }

    @Override
    public <E, V extends BaseValue<E>> TileEntityArchetype.Builder set(Key<V> key, E value) {
        if (this.tileData == null) {
            this.tileData = new MemoryDataContainer();
        }
        SpongeDataManager.getInstance().getRawNbtProcessor(NbtDataTypes.TILE_ENTITY, key).ifPresent(processor -> processor.offer(this.tileData, value));
        return this;
    }

    @Override
    public TileEntityArchetype build() {
        Preconditions.checkState((this.blockState != null ? 1 : 0) != 0, (Object)"BlockState cannot be null!");
        Preconditions.checkState((this.tileEntityType != null ? 1 : 0) != 0, (Object)"TileEntityType cannot be null!");
        if (this.tileData == null) {
            this.tileData = new MemoryDataContainer();
        }
        return new SpongeTileEntityArchetype(this);
    }

    @Override
    protected Optional<TileEntityArchetype> buildContent(DataView container) throws InvalidDataException {
        SpongeTileEntityArchetypeBuilder builder = new SpongeTileEntityArchetypeBuilder();
        if (!container.contains(DataQueries.TileEntityArchetype.TILE_TYPE, DataQueries.TileEntityArchetype.BLOCK_STATE)) {
            throw new InvalidDataException("Missing the TileEntityType and BlockState! Cannot re-construct a TileEntityArchetype!");
        }
        builder.tile(container.getCatalogType(DataQueries.TileEntityArchetype.TILE_TYPE, TileEntityType.class).orElseThrow(() -> new InvalidDataException("Could not deserialize a TileEntityType!")));
        builder.state(container.getCatalogType(DataQueries.TileEntityArchetype.BLOCK_STATE, BlockState.class).orElseThrow(() -> new InvalidDataException("Could not deserialize a BlockState!")));
        if (container.contains(DataQueries.TileEntityArchetype.TILE_DATA)) {
            builder.tileData(container.getView(DataQueries.TileEntityArchetype.TILE_DATA).orElseThrow(() -> new InvalidDataException("No DataView found for the TileEntity data tag!")));
        }
        return Optional.of(builder.build());
    }
}

