/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.command;

import co.aikar.timings.SpongeTimingsFactory;
import co.aikar.timings.Timings;
import java.io.File;
import java.text.DecimalFormat;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import org.spongepowered.api.Platform;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.command.CommandCallable;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandManager;
import org.spongepowered.api.command.CommandMapping;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.ChildCommandElementExecutor;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.command.spec.CommandExecutor;
import org.spongepowered.api.command.spec.CommandSpec;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.event.cause.NamedCause;
import org.spongepowered.api.plugin.PluginContainer;
import org.spongepowered.api.text.LiteralText;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.action.ClickAction;
import org.spongepowered.api.text.action.TextActions;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.text.format.TextStyles;
import org.spongepowered.api.util.annotation.NonnullByDefault;
import org.spongepowered.api.world.DimensionType;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.storage.WorldProperties;
import org.spongepowered.asm.mixin.MixinEnvironment;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.block.BlockUtil;
import org.spongepowered.common.command.ChunkSaveHelper;
import org.spongepowered.common.config.SpongeConfig;
import org.spongepowered.common.config.type.DimensionConfig;
import org.spongepowered.common.config.type.GlobalConfig;
import org.spongepowered.common.config.type.WorldConfig;
import org.spongepowered.common.entity.EntityUtil;
import org.spongepowered.common.interfaces.IMixinChunk;
import org.spongepowered.common.interfaces.IMixinMinecraftServer;
import org.spongepowered.common.interfaces.entity.IMixinEntity;
import org.spongepowered.common.interfaces.world.IMixinDimensionType;
import org.spongepowered.common.interfaces.world.IMixinWorldInfo;
import org.spongepowered.common.interfaces.world.IMixinWorldServer;
import org.spongepowered.common.util.SpongeHooks;
import org.spongepowered.common.world.WorldManager;

@NonnullByDefault
public class SpongeCommand {
    static final String INDENT = "    ";
    static final String LONG_INDENT = "        ";
    static final Text INDENT_TEXT = Text.of("    ");
    static final Text NEWLINE_TEXT = Text.NEW_LINE;
    static final Text SEPARATOR_TEXT = Text.of(", ");
    static final Text LIST_ITEM_TEXT = Text.of(TextColors.GRAY, "- ");
    static final Text UNKNOWN = Text.of("UNKNOWN");
    private static final DecimalFormat THREE_DECIMAL_DIGITS_FORMATTER = new DecimalFormat("########0.000");
    private static final Text IMPLEMENTATION_NAME = Text.of(TextColors.YELLOW, TextStyles.BOLD, Sponge.getPlatform().getContainer(Platform.Component.IMPLEMENTATION).getName());

    public static CommandSpec getCommand() {
        ChildCommandElementExecutor flagChildren = new ChildCommandElementExecutor(null);
        ChildCommandElementExecutor nonFlagChildren = new ChildCommandElementExecutor(flagChildren);
        nonFlagChildren.register((CommandCallable)SpongeCommand.getVersionCommand(), "version");
        nonFlagChildren.register((CommandCallable)SpongeCommand.getBlockInfoCommand(), "blockInfo");
        nonFlagChildren.register((CommandCallable)SpongeCommand.getEntityInfoCommand(), "entityInfo");
        nonFlagChildren.register((CommandCallable)SpongeCommand.getAuditCommand(), "audit");
        nonFlagChildren.register((CommandCallable)SpongeCommand.getHeapCommand(), "heap");
        nonFlagChildren.register((CommandCallable)SpongeCommand.getPluginsCommand(), "plugins");
        nonFlagChildren.register(SpongeCommand.getTimingsCommand(), "timings");
        nonFlagChildren.register((CommandCallable)SpongeCommand.getWhichCommand(), "which");
        flagChildren.register((CommandCallable)SpongeCommand.getChunksCommand(), "chunks");
        flagChildren.register((CommandCallable)SpongeCommand.getConfigCommand(), "config");
        flagChildren.register((CommandCallable)SpongeCommand.getReloadCommand(), "reload");
        flagChildren.register((CommandCallable)SpongeCommand.getSaveCommand(), "save");
        flagChildren.register((CommandCallable)SpongeCommand.getTpsCommand(), "tps");
        return CommandSpec.builder().description(Text.of("General Sponge command")).extendedDescription(Text.of("commands:\n", INDENT, SpongeCommand.title("chunks"), LONG_INDENT, "Prints chunk data for a specific dimension or world(s)\n", INDENT, SpongeCommand.title("conf"), LONG_INDENT, "Configure sponge settings\n", INDENT, SpongeCommand.title("heap"), LONG_INDENT, "Dump live JVM heap\n", INDENT, SpongeCommand.title("reload"), LONG_INDENT, "Reloads a global, dimension, or world config\n", INDENT, SpongeCommand.title("save"), LONG_INDENT, "Saves a global, dimension, or world config\n", INDENT, SpongeCommand.title("version"), LONG_INDENT, "Prints current Sponge version\n", INDENT, SpongeCommand.title("audit"), LONG_INDENT, "Audit mixin classes for implementation\n", INDENT, SpongeCommand.title("plugins"), LONG_INDENT, "List currently installed plugins\n", INDENT, SpongeCommand.title("which"), LONG_INDENT, "List plugins that own a specific command\n", INDENT, SpongeCommand.title("tps"), LONG_INDENT, "Provides TPS (ticks per second) data for loaded worlds")).arguments(GenericArguments.firstParsing(nonFlagChildren, GenericArguments.flags().flag("-global", "g").valueFlag(GenericArguments.world(Text.of("world")), "-world", "w").valueFlag(GenericArguments.dimension(Text.of("dimension")), "-dimension", "d").buildWith(flagChildren))).executor(nonFlagChildren).build();
    }

    private static CommandSpec getChunksCommand() {
        return CommandSpec.builder().description(Text.of("Print chunk information, optionally dump")).arguments(GenericArguments.optional(GenericArguments.seq(GenericArguments.literal((Text)Text.of("dump"), "dump"), GenericArguments.optional(GenericArguments.literal((Text)Text.of("dump-all"), "all"))))).permission("sponge.command.chunks").executor(new ConfigUsingExecutor(true){

            @Override
            public CommandResult execute(CommandSource src, CommandContext args) throws CommandException {
                CommandResult res = super.execute(src, args);
                if (args.hasAny("dump")) {
                    File file = new File(new File(new File("."), "chunk-dumps"), "chunk-info-" + DateTimeFormatter.ofPattern("yyyy-MM-dd_HH.mm.ss").format(Instant.now()) + "-server.txt");
                    src.sendMessage(Text.of("Writing chunk info to: ", file));
                    ChunkSaveHelper.writeChunks(file, args.hasAny("dump-all"));
                    src.sendMessage(Text.of("Chunk info complete"));
                }
                return res;
            }

            @Override
            protected Text processGlobal(SpongeConfig<GlobalConfig> config, CommandSource source, CommandContext args) throws CommandException {
                for (World world : SpongeImpl.getGame().getServer().getWorlds()) {
                    source.sendMessage(Text.of("World ", Text.of(TextStyles.BOLD, world.getName()), this.getChunksInfo((WorldServer)world)));
                }
                return Text.of("Printed chunk info for all worlds ");
            }

            @Override
            protected Text processDimension(SpongeConfig<DimensionConfig> config, DimensionType dim, CommandSource source, CommandContext args) throws CommandException {
                SpongeImpl.getGame().getServer().getWorlds().stream().filter(world -> world.getDimension().getType().equals(dim)).forEach(world -> source.sendMessage(Text.of("World ", Text.of(TextStyles.BOLD, world.getName()), this.getChunksInfo((WorldServer)world))));
                return Text.of("Printed chunk info for all worlds in dimension ", dim.getName());
            }

            @Override
            protected Text processWorld(SpongeConfig<WorldConfig> config, World world, CommandSource source, CommandContext args) throws CommandException {
                return this.getChunksInfo((WorldServer)world);
            }

            protected Text key(Object text) {
                return Text.of(TextColors.GOLD, text);
            }

            protected Text value(Object text) {
                return Text.of(TextColors.GRAY, text);
            }

            protected Text getChunksInfo(WorldServer worldserver) {
                return Text.of(NEWLINE_TEXT, this.key("DimensionId: "), this.value(WorldManager.getDimensionId(worldserver)), NEWLINE_TEXT, this.key("Loaded chunks: "), this.value(worldserver.func_72863_F().func_73152_e()), NEWLINE_TEXT, this.key("Active chunks: "), this.value(worldserver.func_72863_F().func_189548_a().size()), NEWLINE_TEXT, this.key("Entities: "), this.value(worldserver.field_72996_f.size()), NEWLINE_TEXT, this.key("Tile Entities: "), this.value(worldserver.field_147482_g.size()), NEWLINE_TEXT, this.key("Removed Entities:"), this.value(worldserver.field_72997_g.size()), NEWLINE_TEXT, this.key("Removed Tile Entities: "), this.value(worldserver.field_147483_b), NEWLINE_TEXT);
            }
        }).build();
    }

    private static CommandSpec getConfigCommand() {
        return CommandSpec.builder().description(Text.of("Inspect the Sponge config")).arguments(GenericArguments.seq(GenericArguments.string(Text.of("key")), GenericArguments.optional(GenericArguments.string(Text.of("value"))))).permission("sponge.command.config").executor(new ConfigUsingExecutor(false){

            @Override
            protected Text process(SpongeConfig<?> config, CommandSource source, CommandContext args) throws CommandException {
                Optional key = args.getOne("key");
                Optional value = args.getOne("value");
                if (config.getSetting((String)key.get()) == null || config.getSetting((String)key.get()).isVirtual()) {
                    throw new CommandException(Text.of("Key ", Text.builder((String)key.get()).color(TextColors.GREEN).build(), " is not valid"));
                }
                if (value.isPresent()) {
                    config.updateSetting((String)key.get(), value.get());
                    return Text.builder().append(Text.of(TextColors.GOLD, key), Text.of(" set to "), SpongeCommand.title((String)value.get())).build();
                }
                return Text.builder().append(Text.of(TextColors.GOLD, key), Text.of(" is "), SpongeCommand.title(String.valueOf(config.getSetting((String)key.get()).getValue()))).build();
            }
        }).build();
    }

    private static CommandSpec getReloadCommand() {
        return CommandSpec.builder().description(Text.of("Reload the Sponge game")).permission("sponge.command.reload").executor(new ConfigUsingExecutor(false){

            @Override
            protected Text process(SpongeConfig<?> config, CommandSource source, CommandContext args) throws CommandException {
                config.reload();
                SpongeHooks.refreshActiveConfigs();
                return Text.of("Reloaded configuration");
            }
        }).build();
    }

    private static CommandSpec getSaveCommand() {
        return CommandSpec.builder().description(Text.of("Save the configuration")).permission("sponge.command.save").executor(new ConfigUsingExecutor(false){

            @Override
            protected Text process(SpongeConfig<?> config, CommandSource source, CommandContext args) throws CommandException {
                config.save();
                return Text.of("Saved");
            }
        }).build();
    }

    private static CommandSpec getHeapCommand() {
        return CommandSpec.builder().description(Text.of("Generate a dump of the Sponge heap")).permission("sponge.command.heap").executor((src, args) -> {
            File file = new File(new File(new File("."), "dumps"), "heap-dump-" + DateTimeFormatter.ofPattern("yyyy-MM-dd_HH.mm.ss").format(LocalDateTime.now()) + "-server.bin");
            src.sendMessage(Text.of("Writing JVM heap data to: ", file));
            SpongeHooks.dumpHeap(file, true);
            src.sendMessage(Text.of("Heap dump complete"));
            return CommandResult.success();
        }).build();
    }

    private static CommandSpec getVersionCommand() {
        return CommandSpec.builder().description(Text.of("Display Sponge's current version")).permission("sponge.command.version").executor((src, args) -> {
            Text.Builder builder = Text.builder().append(IMPLEMENTATION_NAME);
            for (PluginContainer container : SpongeImpl.getInternalPlugins()) {
                builder.append(NEWLINE_TEXT, Text.of(TextColors.GRAY, INDENT + container.getName(), ": "), container.getVersion().isPresent() ? Text.of(container.getVersion().get()) : UNKNOWN);
            }
            src.sendMessage(builder.build());
            return CommandResult.success();
        }).build();
    }

    private static CommandSpec getBlockInfoCommand() {
        return CommandSpec.builder().description(Text.of("Display the tracked information of the Block you are looking at.")).permission("sponge.command.blockinfo").executor((src, args) -> {
            if (!(src instanceof Player)) {
                src.sendMessage(Text.of(TextColors.RED, "Players must execute this command!"));
                return CommandResult.empty();
            }
            EntityPlayerMP entityPlayerMP = EntityUtil.toNative((Player)src);
            RayTraceResult rayTraceResult = EntityUtil.rayTraceFromEntity((net.minecraft.entity.Entity)entityPlayerMP, 5.0, 1.0f);
            if (rayTraceResult.field_72313_a != RayTraceResult.Type.BLOCK) {
                src.sendMessage(Text.of(TextColors.RED, TextStyles.ITALIC, "Failed to find an entity! Please execute the command when looking at an entity!"));
                return CommandResult.empty();
            }
            WorldServer worldServer = (WorldServer)entityPlayerMP.field_70170_p;
            Chunk chunk = worldServer.func_175726_f(rayTraceResult.func_178782_a());
            IMixinChunk mixinChunk = (IMixinChunk)chunk;
            IBlockState blockState = worldServer.func_180495_p(rayTraceResult.func_178782_a());
            BlockState spongeState = BlockUtil.fromNative(blockState);
            src.sendMessage(Text.of(TextColors.DARK_GREEN, TextStyles.BOLD, "Block Type: ", TextColors.BLUE, TextStyles.RESET, spongeState.getId()));
            src.sendMessage(Text.of(TextColors.DARK_GREEN, TextStyles.BOLD, "Block Owner: ", TextColors.BLUE, TextStyles.RESET, mixinChunk.getBlockOwner(rayTraceResult.func_178782_a())));
            src.sendMessage(Text.of(TextColors.DARK_GREEN, TextStyles.BOLD, "Block Notifier: ", TextColors.BLUE, TextStyles.RESET, mixinChunk.getBlockNotifier(rayTraceResult.func_178782_a())));
            return CommandResult.success();
        }).build();
    }

    private static CommandSpec getEntityInfoCommand() {
        return CommandSpec.builder().description(Text.of("Display the tracked information of the Entity you are looking at.")).permission("sponge.command.entityinfo").executor((src, args) -> {
            if (!(src instanceof Player)) {
                return CommandResult.empty();
            }
            EntityPlayerMP entityPlayerMP = EntityUtil.toNative((Player)src);
            RayTraceResult rayTraceResult = EntityUtil.rayTraceFromEntity((net.minecraft.entity.Entity)entityPlayerMP, 5.0, 1.0f, true);
            if (rayTraceResult.field_72313_a != RayTraceResult.Type.ENTITY) {
                src.sendMessage(Text.of(TextColors.RED, TextStyles.ITALIC, "Failed to find an entity! Please execute the command when looking at an entity!"));
                return CommandResult.empty();
            }
            net.minecraft.entity.Entity entityHit = rayTraceResult.field_72308_g;
            IMixinEntity mixinEntity = EntityUtil.toMixin(entityHit);
            Entity spongeEntity = EntityUtil.fromNative(entityHit);
            Text.Builder builder = Text.builder();
            builder.append(Text.of(TextColors.DARK_GREEN, TextStyles.BOLD, "EntityType: ")).append(Text.of(TextColors.BLUE, TextStyles.RESET, spongeEntity.getType().getId()));
            src.sendMessage(builder.build());
            Optional<User> owner = mixinEntity.getCreatorUser();
            Optional<User> notifier = mixinEntity.getNotifierUser();
            src.sendMessage(Text.of(TextColors.DARK_GREEN, TextStyles.BOLD, "Owner: ", TextColors.BLUE, TextStyles.RESET, owner));
            src.sendMessage(Text.of(TextColors.DARK_GREEN, TextStyles.BOLD, "Notifier: ", TextColors.BLUE, TextStyles.RESET, notifier));
            return CommandResult.success();
        }).build();
    }

    private static CommandSpec getAuditCommand() {
        return CommandSpec.builder().description(Text.of("Audit Mixin classes for implementation")).permission("sponge.command.audit").executor((src, args) -> {
            MixinEnvironment.getCurrentEnvironment().audit();
            return CommandResult.empty();
        }).build();
    }

    static Text title(String title) {
        return Text.of(TextColors.GREEN, title);
    }

    static Text hl(String toHighlight) {
        return Text.of(TextColors.DARK_GREEN, toHighlight);
    }

    private static CommandSpec getPluginsCommand() {
        return CommandSpec.builder().description(Text.of("List currently installed plugins")).permission("sponge.command.plugins").arguments(GenericArguments.optionalWeak(GenericArguments.literal((Text)Text.of("reload"), "reload")), GenericArguments.optional(GenericArguments.plugin(Text.of("plugin")))).executor((src, args) -> {
            if (args.hasAny("reload") && src.hasPermission("sponge.command.plugins.reload")) {
                src.sendMessage(Text.of("Sending reload event to all plugins. Please wait."));
                SpongeImpl.postEvent(SpongeEventFactory.createGameReloadEvent(Cause.of(NamedCause.source(src))));
                src.sendMessage(Text.of("Reload complete!"));
            } else if (args.hasAny("plugin")) {
                for (PluginContainer container : args.getAll("plugin")) {
                    Text.Builder builder = Text.builder().append(SpongeCommand.title(container.getName()));
                    container.getVersion().ifPresent(version -> builder.append(Text.of(" v" + version)));
                    SpongeCommand.appendPluginMeta(builder, "ID", container.getId());
                    SpongeCommand.appendPluginMeta(builder, "Description", container.getDescription());
                    SpongeCommand.appendPluginMeta(builder, "URL", container.getUrl());
                    if (!container.getAuthors().isEmpty()) {
                        SpongeCommand.appendPluginMeta(builder, "Authors", String.join((CharSequence)", ", container.getAuthors()));
                    }
                    SpongeCommand.appendPluginMeta(builder, "Main class", container.getInstance().map(instance -> instance.getClass().getCanonicalName()));
                    src.sendMessage(builder.build());
                }
            } else {
                Collection<PluginContainer> plugins = SpongeImpl.getGame().getPluginManager().getPlugins();
                LiteralText.Builder build = Text.builder(String.format("Plugins (%d): ", plugins.size()));
                boolean first = true;
                for (PluginContainer next : plugins) {
                    if (!first) {
                        ((Text.Builder)build).append(SEPARATOR_TEXT);
                    }
                    first = false;
                    Text.Builder pluginBuilder = Text.builder(next.getName()).color(TextColors.GREEN).onClick((ClickAction)TextActions.runCommand("/sponge:sponge plugins " + next.getId()));
                    next.getVersion().ifPresent(version -> pluginBuilder.onHover(TextActions.showText(Text.of("Version " + version))));
                    ((Text.Builder)build).append(pluginBuilder.build());
                }
                src.sendMessage(((Text.Builder)build).build());
            }
            return CommandResult.success();
        }).build();
    }

    private static void appendPluginMeta(Text.Builder builder, String key, Optional<String> value) {
        if (value.isPresent()) {
            SpongeCommand.appendPluginMeta(builder, key, value.get());
        }
    }

    private static void appendPluginMeta(Text.Builder builder, String key, String value) {
        builder.append(NEWLINE_TEXT, INDENT_TEXT, SpongeCommand.title(key + ": "), Text.of(value));
    }

    private static CommandCallable getTimingsCommand() {
        return CommandSpec.builder().permission("sponge.command.timings").description(Text.of("Manages Sponge Timings data to see performance of the server.")).child((CommandCallable)CommandSpec.builder().executor((src, args) -> {
            if (!Timings.isTimingsEnabled()) {
                src.sendMessage(Text.of("Please enable timings by typing /sponge timings on"));
                return CommandResult.empty();
            }
            Timings.reset();
            src.sendMessage(Text.of("Timings reset"));
            return CommandResult.success();
        }).build(), "reset").child((CommandCallable)CommandSpec.builder().executor((src, args) -> {
            if (!Timings.isTimingsEnabled()) {
                src.sendMessage(Text.of("Please enable timings by typing /sponge timings on"));
                return CommandResult.empty();
            }
            Timings.generateReport(src);
            return CommandResult.success();
        }).build(), "report", "paste").child((CommandCallable)CommandSpec.builder().executor((src, args) -> {
            Timings.setTimingsEnabled(true);
            src.sendMessage(Text.of("Enabled Timings & Reset"));
            return CommandResult.success();
        }).build(), "on").child((CommandCallable)CommandSpec.builder().executor((src, args) -> {
            Timings.setTimingsEnabled(false);
            src.sendMessage(Text.of("Disabled Timings"));
            return CommandResult.success();
        }).build(), "off").child((CommandCallable)CommandSpec.builder().executor((src, args) -> {
            if (!Timings.isTimingsEnabled()) {
                src.sendMessage(Text.of("Please enable timings by typing /sponge timings on"));
                return CommandResult.empty();
            }
            Timings.setVerboseTimingsEnabled(true);
            src.sendMessage(Text.of("Enabled Verbose Timings"));
            return CommandResult.success();
        }).build(), "verbon").child((CommandCallable)CommandSpec.builder().executor((src, args) -> {
            if (!Timings.isTimingsEnabled()) {
                src.sendMessage(Text.of("Please enable timings by typing /sponge timings on"));
                return CommandResult.empty();
            }
            Timings.setVerboseTimingsEnabled(false);
            src.sendMessage(Text.of("Disabled Verbose Timings"));
            return CommandResult.success();
        }).build(), "verboff").child((CommandCallable)CommandSpec.builder().executor((src, args) -> {
            if (!Timings.isTimingsEnabled()) {
                src.sendMessage(Text.of("Please enable timings by typing /sponge timings on"));
                return CommandResult.empty();
            }
            src.sendMessage(Text.of("Timings cost: " + SpongeTimingsFactory.getCost()));
            return CommandResult.success();
        }).build(), "cost").build();
    }

    private static CommandSpec getWhichCommand() {
        return CommandSpec.builder().permission("sponge.command.which").description(Text.of("List plugins that own a specific command")).arguments(GenericArguments.choices((Text)Text.of("command"), () -> Sponge.getCommandManager().getAll().keySet(), Function.identity())).executor((src, args) -> {
            CommandManager mgr = Sponge.getCommandManager();
            String commandName = (String)args.getOne("command").get();
            CommandMapping primary = mgr.get(commandName, src).orElseThrow(() -> new CommandException(Text.of("Invalid command ", commandName)));
            Set<? extends CommandMapping> all = mgr.getAll(commandName);
            src.sendMessage(Text.of(SpongeCommand.title("Primary: "), "Aliases ", SpongeCommand.hl(primary.getAllAliases().toString()), " owned by ", SpongeCommand.hl(mgr.getOwner(primary).map(PluginContainer::getName).orElse("unknown"))));
            if (all.size() > 1 || all.iterator().next() != primary) {
                src.sendMessage(SpongeCommand.title("Others:"));
                all.stream().filter(map -> !map.equals(primary)).forEach(mapping -> src.sendMessage(Text.of(LIST_ITEM_TEXT, "Aliases ", SpongeCommand.hl(mapping.getAllAliases().toString()), " owned by ", SpongeCommand.hl(mgr.getOwner((CommandMapping)mapping).map(PluginContainer::getName).orElse("unknown")))));
            }
            return CommandResult.success();
        }).build();
    }

    private static CommandSpec getTpsCommand() {
        return CommandSpec.builder().permission("sponge.command.tps").description(Text.of("Provides TPS (ticks per second) data for loaded worlds.")).arguments(GenericArguments.optional(GenericArguments.world(Text.of("world")))).executor((src, args) -> {
            if (args.hasAny("world")) {
                for (WorldProperties properties : args.getAll("world")) {
                    Optional<World> optWorld = Sponge.getServer().getWorld(properties.getWorldName());
                    if (!optWorld.isPresent()) {
                        src.sendMessage(Text.of(properties.getWorldName() + " has no TPS as it is offline!"));
                        continue;
                    }
                    SpongeCommand.printWorldTickTime(src, optWorld.get());
                }
            } else {
                Sponge.getServer().getWorlds().forEach(world -> SpongeCommand.printWorldTickTime(src, world));
            }
            double serverMeanTickTime = (double)SpongeCommand.mean(SpongeImpl.getServer().field_71311_j).longValue() * 1.0E-6;
            src.sendMessage(Text.of("Overall TPS: ", TextColors.LIGHT_PURPLE, THREE_DECIMAL_DIGITS_FORMATTER.format(Math.min(1000.0 / serverMeanTickTime, 20.0)), TextColors.RESET, ", Mean: ", TextColors.RED, THREE_DECIMAL_DIGITS_FORMATTER.format(serverMeanTickTime), "ms"));
            return CommandResult.success();
        }).build();
    }

    private static void printWorldTickTime(CommandSource src, World world) {
        long[] worldTickTimes = ((IMixinMinecraftServer)SpongeImpl.getServer()).getWorldTickTimes().get(((IMixinWorldServer)((Object)world)).getDimensionId());
        double worldMeanTickTime = (double)SpongeCommand.mean(worldTickTimes).longValue() * 1.0E-6;
        double worldTps = Math.min(1000.0 / worldMeanTickTime, 20.0);
        src.sendMessage(Text.of("World [", TextColors.DARK_GREEN, world.getName(), TextColors.RESET, "] (DIM", ((IMixinWorldServer)((Object)world)).getDimensionId(), ") TPS: ", TextColors.LIGHT_PURPLE, THREE_DECIMAL_DIGITS_FORMATTER.format(worldTps), TextColors.RESET, ", Mean: ", TextColors.RED, THREE_DECIMAL_DIGITS_FORMATTER.format(worldMeanTickTime), "ms"));
    }

    private static Long mean(long[] values) {
        Long mean = 0L;
        if (values.length > 0) {
            for (long value : values) {
                mean = mean + value;
            }
            mean = mean / (long)values.length;
        }
        return mean;
    }

    private static abstract class ConfigUsingExecutor
    implements CommandExecutor {
        private boolean requireWorldLoaded;

        ConfigUsingExecutor(boolean requireWorldLoaded) {
            this.requireWorldLoaded = requireWorldLoaded;
        }

        @Override
        public CommandResult execute(CommandSource src, CommandContext args) throws CommandException {
            int successes = 0;
            if (args.hasAny("global")) {
                src.sendMessage(Text.of("Global: ", this.processGlobal(SpongeImpl.getGlobalConfig(), src, args)));
                ++successes;
            }
            if (args.hasAny("dimension")) {
                for (DimensionType dimensionType : args.getAll("dimension")) {
                    src.sendMessage(Text.of("Dimension ", dimensionType.getName(), ": ", this.processDimension(((IMixinDimensionType)((Object)dimensionType)).getDimensionConfig(), dimensionType, src, args)));
                    ++successes;
                }
            }
            if (args.hasAny("world")) {
                for (WorldProperties properties : args.getAll("world")) {
                    Optional<World> world = SpongeImpl.getGame().getServer().getWorld(properties.getUniqueId());
                    if (!world.isPresent() && this.requireWorldLoaded) {
                        throw new CommandException(Text.of("World ", properties.getWorldName(), " is not loaded, cannot work with it"));
                    }
                    src.sendMessage(Text.of("World ", properties.getWorldName(), ": ", this.processWorld(((IMixinWorldInfo)((Object)properties)).getOrCreateWorldConfig(), world.orElse(null), src, args)));
                    ++successes;
                }
            }
            if (successes == 0) {
                throw new CommandException(Text.of("At least one target flag must be specified"));
            }
            return CommandResult.builder().successCount(successes).build();
        }

        protected Text processGlobal(SpongeConfig<GlobalConfig> config, CommandSource source, CommandContext args) throws CommandException {
            return this.process(config, source, args);
        }

        protected Text processDimension(SpongeConfig<DimensionConfig> config, DimensionType dim, CommandSource source, CommandContext args) throws CommandException {
            return this.process(config, source, args);
        }

        protected Text processWorld(SpongeConfig<WorldConfig> config, World world, CommandSource source, CommandContext args) throws CommandException {
            return this.process(config, source, args);
        }

        protected Text process(SpongeConfig<?> config, CommandSource source, CommandContext args) throws CommandException {
            return Text.of("Unimplemented");
        }
    }
}

