/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.command;

import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Optional;
import java.util.TreeSet;
import org.spongepowered.api.command.CommandCallable;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandMapping;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.command.spec.CommandSpec;
import org.spongepowered.api.service.pagination.PaginationList;
import org.spongepowered.api.service.pagination.PaginationService;
import org.spongepowered.api.text.LiteralText;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.action.TextActions;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.text.format.TextStyles;
import org.spongepowered.common.SpongeImpl;

public class SpongeHelpCommand {
    private static final Comparator<CommandMapping> COMMAND_COMPARATOR = (o1, o2) -> o1.getPrimaryAlias().compareTo(o2.getPrimaryAlias());

    public static CommandSpec create() {
        return CommandSpec.builder().arguments(GenericArguments.optional(GenericArguments.string(Text.of("command")))).description(Text.of("View a list of all commands.")).extendedDescription(Text.of("View a list of all commands. Hover over\n a command to view its description. Click\n a command to insert it into your chat bar.")).executor((src, args) -> {
            Optional command = args.getOne("command");
            if (command.isPresent()) {
                Optional<? extends CommandMapping> mapping = SpongeImpl.getGame().getCommandManager().get((String)command.get(), src);
                if (mapping.isPresent()) {
                    CommandCallable callable = mapping.get().getCallable();
                    Optional<Text> desc = callable.getHelp(src);
                    if (desc.isPresent()) {
                        src.sendMessage(desc.get());
                    } else {
                        src.sendMessage(Text.of("Usage: /", command.get(), callable.getUsage(src)));
                    }
                    return CommandResult.success();
                }
                throw new CommandException(Text.of("No such command: ", command.get()));
            }
            PaginationList.Builder builder = SpongeImpl.getGame().getServiceManager().provide(PaginationService.class).get().builder();
            builder.title(Text.builder("Available commands:").color(TextColors.DARK_GREEN).build());
            TreeSet<CommandMapping> commands = new TreeSet<CommandMapping>(COMMAND_COMPARATOR);
            commands.addAll(Collections2.filter((Collection)SpongeImpl.getGame().getCommandManager().getAll().values(), input -> input.getCallable().testPermission(src)));
            builder.contents((Iterable<Text>)ImmutableList.copyOf((Collection)Collections2.transform(commands, input -> SpongeHelpCommand.getDescription(src, input))));
            builder.sendTo(src);
            return CommandResult.success();
        }).build();
    }

    private static Text getDescription(CommandSource source, CommandMapping mapping) {
        Optional<Text> description = mapping.getCallable().getShortDescription(source);
        LiteralText.Builder text = Text.builder("/" + mapping.getPrimaryAlias());
        ((Text.Builder)text).color(TextColors.GREEN);
        ((Text.Builder)text).style(TextStyles.UNDERLINE);
        ((Text.Builder)text).onClick(TextActions.suggestCommand("/" + mapping.getPrimaryAlias() + " "));
        Optional<Text> longDescription = mapping.getCallable().getHelp(source);
        if (longDescription.isPresent()) {
            ((Text.Builder)text).onHover(TextActions.showText(longDescription.get()));
        }
        return Text.of(text, " ", description.orElse(mapping.getCallable().getUsage(source)));
    }
}

