/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.config.category;

import java.util.HashMap;
import java.util.Map;
import ninja.leaping.configurate.objectmapping.Setting;
import ninja.leaping.configurate.objectmapping.serialize.ConfigSerializable;
import org.spongepowered.common.config.category.ConfigCategory;

@ConfigSerializable
public class CollisionModCategory
extends ConfigCategory {
    @Setting(value="enabled", comment="Set to false if you want mod to ignore entity collision rules.")
    private boolean isEnabled = true;
    @Setting(value="defaults", comment="Default max collisions used for all entities/blocks unless overidden.")
    private Map<String, Integer> defaultMaxCollisions = new HashMap<String, Integer>();
    @Setting(value="blocks")
    private Map<String, Integer> blockList = new HashMap<String, Integer>();
    @Setting(value="entities")
    private Map<String, Integer> entityList = new HashMap<String, Integer>();

    public CollisionModCategory() {
        this.defaultMaxCollisions.put("blocks", 8);
        this.defaultMaxCollisions.put("entities", 8);
    }

    public CollisionModCategory(String modId) {
        if (modId.equals("minecraft")) {
            this.blockList.put("detector_rail", 1);
            this.blockList.put("heavy_weighted_pressure_plate", 150);
            this.blockList.put("light_weighted_pressure_plate", 15);
            this.blockList.put("mob_spawner", -1);
            this.blockList.put("stone_pressure_plate", 1);
            this.blockList.put("wooden_button", 1);
            this.blockList.put("wooden_pressure_plate", 1);
            this.entityList.put("thrownpotion", -1);
        } else if (modId.equals("botania")) {
            this.entityList.put("botaniaspark", -1);
            this.entityList.put("botaniacorporeaspark", -1);
        }
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public Map<String, Integer> getDefaultMaxCollisions() {
        return this.defaultMaxCollisions;
    }

    public Map<String, Integer> getBlockList() {
        return this.blockList;
    }

    public Map<String, Integer> getEntityList() {
        return this.entityList;
    }
}

