/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Lists;
import com.google.common.collect.MapMaker;
import com.google.common.collect.Maps;
import com.google.common.reflect.TypeToken;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import ninja.leaping.configurate.objectmapping.serialize.TypeSerializers;
import org.spongepowered.api.CatalogType;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.DataManager;
import org.spongepowered.api.data.DataSerializable;
import org.spongepowered.api.data.DataView;
import org.spongepowered.api.data.ImmutableDataBuilder;
import org.spongepowered.api.data.ImmutableDataHolder;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.manipulator.DataManipulator;
import org.spongepowered.api.data.manipulator.DataManipulatorBuilder;
import org.spongepowered.api.data.manipulator.ImmutableDataManipulator;
import org.spongepowered.api.data.persistence.AbstractDataBuilder;
import org.spongepowered.api.data.persistence.DataBuilder;
import org.spongepowered.api.data.persistence.DataContentUpdater;
import org.spongepowered.api.data.persistence.DataTranslator;
import org.spongepowered.api.data.value.BaseValue;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.config.DataSerializableTypeSerializer;
import org.spongepowered.common.data.DataProcessor;
import org.spongepowered.common.data.DataUpdaterDelegate;
import org.spongepowered.common.data.ValueProcessor;
import org.spongepowered.common.data.builder.manipulator.SpongeDataManipulatorBuilder;
import org.spongepowered.common.data.builder.manipulator.SpongeImmutableDataManipulatorBuilder;
import org.spongepowered.common.data.nbt.NbtDataType;
import org.spongepowered.common.data.nbt.SpongeNbtProcessorDelegate;
import org.spongepowered.common.data.nbt.data.NbtDataProcessor;
import org.spongepowered.common.data.nbt.validation.DelegateDataValidator;
import org.spongepowered.common.data.nbt.validation.RawDataValidator;
import org.spongepowered.common.data.nbt.validation.ValidationType;
import org.spongepowered.common.data.nbt.value.NbtValueProcessor;
import org.spongepowered.common.data.persistence.DataTranslatorTypeSerializer;
import org.spongepowered.common.data.processor.common.AbstractSingleDataSingleTargetProcessor;
import org.spongepowered.common.data.util.ComparatorUtil;
import org.spongepowered.common.data.util.DataFunction;
import org.spongepowered.common.data.util.DataProcessorDelegate;
import org.spongepowered.common.data.util.ValueProcessorDelegate;
import org.spongepowered.common.registry.type.data.DataTranslatorRegistryModule;

public final class SpongeDataManager
implements DataManager {
    private static final TypeToken<CatalogType> catalogTypeToken = TypeToken.of(CatalogType.class);
    private static final TypeToken<DataSerializable> dataSerializableTypeToken = TypeToken.of(DataSerializable.class);
    private static final SpongeDataManager instance;
    private final Map<Class<?>, DataBuilder<?>> builders = Maps.newHashMap();
    private final Map<Class<? extends ImmutableDataHolder<?>>, ImmutableDataBuilder<?, ?>> immutableDataBuilderMap = new MapMaker().concurrencyLevel(4).makeMap();
    private final Map<Class<? extends DataManipulator<?, ?>>, DataManipulatorBuilder<?, ?>> builderMap = new MapMaker().concurrencyLevel(4).makeMap();
    private final Map<Class<? extends ImmutableDataManipulator<?, ?>>, DataManipulatorBuilder<?, ?>> immutableBuilderMap = new MapMaker().concurrencyLevel(4).makeMap();
    private final Map<Class<?>, DataTranslator<?>> dataSerializerMap = new MapMaker().concurrencyLevel(4).makeMap();
    private final Map<Class<? extends DataManipulator<?, ?>>, List<DataProcessor<?, ?>>> processorMap = new MapMaker().concurrencyLevel(4).makeMap();
    private final Map<Class<? extends ImmutableDataManipulator<?, ?>>, List<DataProcessor<?, ?>>> immutableProcessorMap = new MapMaker().concurrencyLevel(4).makeMap();
    private final Map<Key<? extends BaseValue<?>>, List<ValueProcessor<?, ?>>> valueProcessorMap = new MapMaker().concurrencyLevel(4).makeMap();
    private final Map<Class<? extends DataManipulator<?, ?>>, List<NbtDataProcessor<?, ?>>> nbtProcessorMap = new MapMaker().concurrencyLevel(4).makeMap();
    private final Map<Key<? extends BaseValue<?>>, ValueProcessorDelegate<?, ?>> valueDelegates = new IdentityHashMap();
    private final Map<Class<? extends DataManipulator<?, ?>>, DataProcessorDelegate<?, ?>> dataProcessorDelegates = new IdentityHashMap();
    private final Map<Class<? extends ImmutableDataManipulator<?, ?>>, DataProcessorDelegate<?, ?>> immutableDataProcessorDelegates = new IdentityHashMap();
    private final Map<Class<? extends DataManipulator<?, ?>>, Class<? extends DataManipulator<?, ?>>> interfaceToImplDataManipulatorClasses = new IdentityHashMap();
    private ImmutableTable<Class<? extends DataManipulator<?, ?>>, NbtDataType, NbtDataProcessor<?, ?>> nbtProcessorTable = ImmutableTable.of();
    private ImmutableTable<Key<?>, NbtDataType, NbtValueProcessor<?, ?>> nbtValueTable = ImmutableTable.of();
    private final Map<Class<? extends DataSerializable>, List<DataContentUpdater>> updatersMap = new IdentityHashMap<Class<? extends DataSerializable>, List<DataContentUpdater>>();
    private static boolean allowRegistrations;

    public static SpongeDataManager getInstance() {
        return instance;
    }

    private SpongeDataManager() {
    }

    @Override
    public <T extends DataSerializable> void registerBuilder(Class<T> clazz, DataBuilder<T> builder) {
        Preconditions.checkNotNull(clazz);
        Preconditions.checkNotNull(builder);
        if (!this.builders.containsKey(clazz)) {
            if (!(builder instanceof AbstractDataBuilder || builder instanceof SpongeDataManipulatorBuilder || builder instanceof SpongeImmutableDataManipulatorBuilder)) {
                SpongeImpl.getLogger().warn("A custom DataBuilder is not extending AbstractDataBuilder! It is recommended that the custom data builder does extend it to gain automated content versioning updates and maintain simplicity. The offending builder's class is: {}", new Object[]{builder.getClass()});
            }
            this.builders.put(clazz, builder);
        } else {
            SpongeImpl.getLogger().warn("A DataBuilder has already been registered for %s. Attempted to register %s instead.%n", new Object[]{clazz, builder.getClass()});
        }
    }

    @Override
    public <T extends DataSerializable> void registerContentUpdater(Class<T> clazz, DataContentUpdater updater) {
        Preconditions.checkNotNull((Object)updater, (Object)"DataContentUpdater was null!");
        if (!this.updatersMap.containsKey(Preconditions.checkNotNull(clazz, (Object)"DataSerializable class was null!"))) {
            this.updatersMap.put(clazz, new ArrayList());
        }
        List<DataContentUpdater> updaters = this.updatersMap.get(clazz);
        updaters.add(updater);
        Collections.sort(updaters, ComparatorUtil.DATA_CONTENT_UPDATER_COMPARATOR);
    }

    @Override
    public <T extends DataSerializable> Optional<DataContentUpdater> getWrappedContentUpdater(Class<T> clazz, int fromVersion, int toVersion) {
        Preconditions.checkArgument((fromVersion != toVersion ? 1 : 0) != 0, (Object)"Attempting to convert to the same version!");
        Preconditions.checkArgument((fromVersion < toVersion ? 1 : 0) != 0, (Object)"Attempting to backwards convert data! This isn't supported!");
        List<DataContentUpdater> updaters = this.updatersMap.get(Preconditions.checkNotNull(clazz, (Object)"DataSerializable class was null!"));
        if (updaters == null) {
            return Optional.empty();
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        int version = fromVersion;
        for (DataContentUpdater updater : updaters) {
            if (updater.getInputVersion() != version || updater.getOutputVersion() > toVersion) continue;
            version = updater.getOutputVersion();
            builder.add((Object)updater);
        }
        if (version < toVersion || version > toVersion) {
            IllegalStateException e = new IllegalStateException("The requested content version for: " + clazz.getSimpleName() + " was requested, \nhowever, the versions supplied: from " + fromVersion + " to " + toVersion + " is impossible\nas the latest version registered is: " + version + ". Please notify the developer of\nthe requested consumed DataSerializable of this error.");
            e.printStackTrace();
            return Optional.empty();
        }
        return Optional.of(new DataUpdaterDelegate((ImmutableList<DataContentUpdater>)builder.build(), fromVersion, toVersion));
    }

    public <T extends DataSerializable> void registerBuilderAndImpl(Class<T> clazz, Class<? extends T> implClass, DataBuilder<T> builder) {
        this.registerBuilder(clazz, builder);
        this.registerBuilder(implClass, builder);
    }

    @Override
    public <T extends DataSerializable> Optional<DataBuilder<T>> getBuilder(Class<T> clazz) {
        Preconditions.checkNotNull(clazz);
        if (this.builders.containsKey(clazz)) {
            return Optional.of(this.builders.get(clazz));
        }
        if (this.builderMap.containsKey(clazz)) {
            return Optional.of((DataBuilder)this.builderMap.get(clazz));
        }
        if (this.immutableDataBuilderMap.containsKey(clazz)) {
            return Optional.of((DataBuilder)this.immutableDataBuilderMap.get(clazz));
        }
        return Optional.empty();
    }

    @Override
    public <T extends DataSerializable> Optional<T> deserialize(Class<T> clazz, DataView dataView) {
        Optional<DataBuilder<T>> optional = this.getBuilder(clazz);
        if (optional.isPresent()) {
            return optional.get().build(dataView);
        }
        return Optional.empty();
    }

    @Override
    public <T extends ImmutableDataHolder<T>, B extends ImmutableDataBuilder<T, B>> void register(Class<T> holderClass, B builder) {
        if (this.immutableDataBuilderMap.containsKey(Preconditions.checkNotNull(holderClass))) {
            throw new IllegalStateException("Already registered the DataUtil for " + holderClass.getCanonicalName());
        }
        this.immutableDataBuilderMap.put((Class<ImmutableDataHolder<?>>)holderClass, (ImmutableDataBuilder<?, ?>)Preconditions.checkNotNull(builder));
    }

    @Override
    public <T extends ImmutableDataHolder<T>, B extends ImmutableDataBuilder<T, B>> Optional<B> getImmutableBuilder(Class<T> holderClass) {
        return Optional.ofNullable(this.immutableDataBuilderMap.get(Preconditions.checkNotNull(holderClass)));
    }

    public static void finalizeRegistration() {
        allowRegistrations = false;
        SpongeDataManager registry = instance;
        registry.valueProcessorMap.entrySet().forEach(entry -> {
            ImmutableList.Builder valueListBuilder = ImmutableList.builder();
            Collections.sort((List)entry.getValue(), ComparatorUtil.VALUE_PROCESSOR_COMPARATOR);
            valueListBuilder.addAll((Iterable)entry.getValue());
            ValueProcessorDelegate delegate = new ValueProcessorDelegate((Key)entry.getKey(), valueListBuilder.build());
            registry.valueDelegates.put((Key<BaseValue<?>>)entry.getKey(), delegate);
        });
        registry.valueProcessorMap.clear();
        registry.processorMap.entrySet().forEach(entry -> {
            ImmutableList.Builder dataListBuilder = ImmutableList.builder();
            Collections.sort((List)entry.getValue(), ComparatorUtil.DATA_PROCESSOR_COMPARATOR);
            dataListBuilder.addAll((Iterable)entry.getValue());
            DataProcessorDelegate delegate = new DataProcessorDelegate(dataListBuilder.build());
            registry.dataProcessorDelegates.put((Class<DataManipulator<?, ?>>)entry.getKey(), delegate);
        });
        registry.processorMap.clear();
        SpongeDataManager serializationService = SpongeDataManager.getInstance();
        registry.dataProcessorDelegates.entrySet().forEach(entry -> {
            if (!Modifier.isInterface(((Class)entry.getKey()).getModifiers()) && !Modifier.isAbstract(((Class)entry.getKey()).getModifiers())) {
                DataFunction<DataContainer, DataManipulator, Optional> function = (dataContainer, dataManipulator) -> ((DataProcessor)entry.getValue()).fill((DataContainer)dataContainer, dataManipulator);
                SpongeDataManipulatorBuilder builder = new SpongeDataManipulatorBuilder((DataProcessorDelegate)entry.getValue(), (Class)entry.getKey(), function);
                registry.builderMap.put((Class<DataManipulator<?, ?>>)entry.getKey(), (DataManipulatorBuilder<?, ?>)Preconditions.checkNotNull(builder));
                serializationService.registerBuilder((Class)entry.getKey(), builder);
            } else {
                Class<? extends DataManipulator<?, ?>> clazz = registry.interfaceToImplDataManipulatorClasses.get(entry.getKey());
                DataFunction<DataContainer, DataManipulator, Optional> function = (dataContainer, dataManipulator) -> ((DataProcessor)entry.getValue()).fill((DataContainer)dataContainer, dataManipulator);
                SpongeDataManipulatorBuilder builder = new SpongeDataManipulatorBuilder((DataProcessorDelegate)entry.getValue(), clazz, function);
                registry.builderMap.put((Class<DataManipulator<?, ?>>)entry.getKey(), (DataManipulatorBuilder<?, ?>)Preconditions.checkNotNull(builder));
                serializationService.registerBuilder((Class)entry.getKey(), builder);
            }
        });
        registry.immutableProcessorMap.entrySet().forEach(entry -> {
            ImmutableList.Builder dataListBuilder = ImmutableList.builder();
            Collections.sort((List)entry.getValue(), ComparatorUtil.DATA_PROCESSOR_COMPARATOR);
            dataListBuilder.addAll((Iterable)entry.getValue());
            DataProcessorDelegate delegate = new DataProcessorDelegate(dataListBuilder.build());
            registry.immutableDataProcessorDelegates.put((Class<ImmutableDataManipulator<?, ?>>)entry.getKey(), delegate);
        });
        registry.immutableProcessorMap.clear();
        ImmutableTable.Builder builder = ImmutableTable.builder();
        registry.nbtProcessorMap.entrySet().forEach(entry -> {
            HashMultimap processorMultimap = HashMultimap.create();
            List value = (List)entry.getValue();
            for (NbtDataProcessor nbtDataProcessor : value) {
                processorMultimap.put((Object)nbtDataProcessor.getTargetType(), (Object)nbtDataProcessor);
            }
            for (Map.Entry entry2 : processorMultimap.asMap().entrySet()) {
                ImmutableList.Builder processorBuilder = ImmutableList.builder();
                processorBuilder.addAll((Iterable)entry2.getValue());
                NbtDataType dataType = (NbtDataType)entry2.getKey();
                builder.put(entry.getKey(), (Object)dataType, new SpongeNbtProcessorDelegate(processorBuilder.build(), dataType));
            }
        });
        registry.nbtProcessorMap.clear();
        registry.nbtProcessorTable = builder.build();
    }

    @Override
    public <T extends DataManipulator<T, I>, I extends ImmutableDataManipulator<I, T>> void register(Class<? extends T> manipulatorClass, Class<? extends I> immutableManipulatorClass, DataManipulatorBuilder<T, I> builder) {
        Preconditions.checkState((boolean)allowRegistrations, (Object)"Registrations are no longer allowed!");
        if (this.builderMap.containsKey(Preconditions.checkNotNull(manipulatorClass))) {
            throw new IllegalStateException("Already registered the DataUtil for " + manipulatorClass.getCanonicalName());
        }
        this.builderMap.put((Class<DataManipulator<?, ?>>)manipulatorClass, (DataManipulatorBuilder<?, ?>)Preconditions.checkNotNull(builder));
        this.immutableBuilderMap.put((Class<ImmutableDataManipulator<?, ?>>)Preconditions.checkNotNull(immutableManipulatorClass), builder);
        SpongeDataManager.getInstance().registerBuilder(manipulatorClass, builder);
    }

    @Override
    public <T extends DataManipulator<T, I>, I extends ImmutableDataManipulator<I, T>> Optional<DataManipulatorBuilder<T, I>> getManipulatorBuilder(Class<T> manipulatorClass) {
        return Optional.ofNullable(this.builderMap.get(Preconditions.checkNotNull(manipulatorClass)));
    }

    @Override
    public <T extends DataManipulator<T, I>, I extends ImmutableDataManipulator<I, T>> Optional<DataManipulatorBuilder<T, I>> getImmutableManipulatorBuilder(Class<I> immutableManipulatorClass) {
        return Optional.ofNullable(this.immutableBuilderMap.get(Preconditions.checkNotNull(immutableManipulatorClass)));
    }

    @Override
    public <T> void registerTranslator(Class<T> objectClass, DataTranslator<T> translator) {
        Preconditions.checkState((boolean)allowRegistrations, (Object)"Registrations are no longer allowed");
        Preconditions.checkNotNull(objectClass, (Object)"Target object class cannot be null!");
        Preconditions.checkNotNull(translator, (Object)("DataTranslator for : " + objectClass + " cannot be null!"));
        Preconditions.checkArgument((boolean)translator.getToken().isAssignableFrom(objectClass), (Object)("DataTranslator is not compatible with the target object class: " + objectClass));
        if (this.dataSerializerMap.containsKey(Preconditions.checkNotNull(objectClass, (Object)"Target class cannot be null!"))) {
            throw new IllegalStateException("Already registered the DataTranslator for " + objectClass.getCanonicalName());
        }
        this.dataSerializerMap.put(objectClass, translator);
        DataTranslatorRegistryModule.getInstance().registerAdditionalCatalog(translator);
        if (TypeSerializers.getDefaultSerializers().get(translator.getToken()) == null) {
            TypeSerializers.getDefaultSerializers().registerType(translator.getToken(), DataTranslatorTypeSerializer.from(translator));
        }
    }

    @Override
    public <T> Optional<DataTranslator<T>> getTranslator(Class<T> objectclass) {
        return Optional.ofNullable(this.dataSerializerMap.get(Preconditions.checkNotNull(objectclass, (Object)"Target class cannot be null!")));
    }

    public Optional<DataManipulatorBuilder<?, ?>> getWildManipulatorBuilder(Class<? extends DataManipulator<?, ?>> manipulatorClass) {
        return Optional.ofNullable(this.builderMap.get(Preconditions.checkNotNull(manipulatorClass)));
    }

    public Optional<DataManipulatorBuilder<?, ?>> getWildBuilderForImmutable(Class<? extends ImmutableDataManipulator<?, ?>> immutable) {
        return Optional.ofNullable(this.immutableBuilderMap.get(Preconditions.checkNotNull(immutable)));
    }

    public <T extends DataManipulator<T, I>, I extends ImmutableDataManipulator<I, T>> void registerDataProcessorAndImpl(Class<T> manipulatorClass, Class<? extends T> implClass, Class<I> immutableDataManipulator, Class<? extends I> implImClass, DataProcessor<T, I> processor) {
        List<DataProcessor<?, ?>> processorList;
        Preconditions.checkState((boolean)allowRegistrations, (Object)"Registrations are no longer allowed!");
        Preconditions.checkArgument((!Modifier.isAbstract(implClass.getModifiers()) ? 1 : 0) != 0, (Object)"The Implemented DataManipulator class cannot be abstract!");
        Preconditions.checkArgument((!Modifier.isInterface(implClass.getModifiers()) ? 1 : 0) != 0, (Object)"The Implemented DataManipulator class cannot be an interface!");
        Preconditions.checkArgument((!Modifier.isAbstract(implImClass.getModifiers()) ? 1 : 0) != 0, (Object)"The implemented ImmutableDataManipulator class cannot be an interface!");
        Preconditions.checkArgument((!Modifier.isInterface(implImClass.getModifiers()) ? 1 : 0) != 0, (Object)"The implemented ImmutableDataManipulator class cannot be an interface!");
        Preconditions.checkArgument((!(processor instanceof DataProcessorDelegate) ? 1 : 0) != 0, (Object)"Cannot register DataProcessorDelegates!");
        if (!this.interfaceToImplDataManipulatorClasses.containsKey(manipulatorClass)) {
            this.interfaceToImplDataManipulatorClasses.put(manipulatorClass, implClass);
        }
        if ((processorList = this.processorMap.get(manipulatorClass)) == null) {
            processorList = new CopyOnWriteArrayList();
            this.processorMap.put(manipulatorClass, processorList);
            this.processorMap.put(implClass, processorList);
        }
        Preconditions.checkArgument((!processorList.contains(processor) ? 1 : 0) != 0, (Object)"Duplicate DataProcessor Registration!");
        processorList.add(processor);
        List<DataProcessor<?, ?>> immutableProcessorList = this.immutableProcessorMap.get(immutableDataManipulator);
        if (immutableProcessorList == null) {
            immutableProcessorList = new CopyOnWriteArrayList();
            this.immutableProcessorMap.put(immutableDataManipulator, immutableProcessorList);
            this.immutableProcessorMap.put(implImClass, immutableProcessorList);
        }
        Preconditions.checkArgument((!immutableProcessorList.contains(processor) ? 1 : 0) != 0, (Object)"Duplicate DataProcessor Registration!");
        immutableProcessorList.add(processor);
    }

    public <E, V extends BaseValue<E>, T extends DataManipulator<T, I>, I extends ImmutableDataManipulator<I, T>> void registerDualProcessor(Class<T> manipulatorClass, Class<? extends T> implClass, Class<I> immutableDataManipulator, Class<? extends I> implImClass, AbstractSingleDataSingleTargetProcessor<?, E, V, T, I> processor) {
        this.registerDataProcessorAndImpl(manipulatorClass, implClass, immutableDataManipulator, implImClass, processor);
        this.registerValueProcessor(processor.getKey(), processor);
    }

    public <T extends DataManipulator<T, I>, I extends ImmutableDataManipulator<I, T>> Optional<DataProcessor<T, I>> getProcessor(Class<T> mutableClass) {
        return Optional.ofNullable((DataProcessor)this.dataProcessorDelegates.get(Preconditions.checkNotNull(mutableClass)));
    }

    public Optional<DataProcessor<?, ?>> getWildProcessor(Class<? extends DataManipulator<?, ?>> mutableClass) {
        return Optional.ofNullable(this.dataProcessorDelegates.get(Preconditions.checkNotNull(mutableClass)));
    }

    public Optional<DataProcessor> getWildDataProcessor(Class<? extends DataManipulator> class1) {
        return Optional.ofNullable(this.dataProcessorDelegates.get(Preconditions.checkNotNull(class1)));
    }

    public <T extends DataManipulator<T, I>, I extends ImmutableDataManipulator<I, T>> Optional<DataProcessor<T, I>> getImmutableProcessor(Class<I> immutableClass) {
        return Optional.ofNullable((DataProcessor)this.immutableDataProcessorDelegates.get(Preconditions.checkNotNull(immutableClass)));
    }

    public Optional<DataProcessor> getWildImmutableProcessor(Class<? extends ImmutableDataManipulator<?, ?>> immutableClass) {
        return Optional.ofNullable(this.immutableDataProcessorDelegates.get(Preconditions.checkNotNull(immutableClass)));
    }

    public <E, V extends BaseValue<E>> void registerValueProcessor(Key<V> key, ValueProcessor<E, V> valueProcessor) {
        Preconditions.checkState((boolean)allowRegistrations, (Object)"Registrations are no longer allowed!");
        Preconditions.checkNotNull(valueProcessor);
        Preconditions.checkArgument((!(valueProcessor instanceof ValueProcessorDelegate) ? 1 : 0) != 0, (Object)"Cannot register ValueProcessorDelegates! READ THE DOCS!");
        Preconditions.checkNotNull(key);
        List<ValueProcessor<Object, Object>> processorList = this.valueProcessorMap.get(key);
        if (processorList == null) {
            processorList = Collections.synchronizedList(Lists.newArrayList());
            this.valueProcessorMap.put(key, processorList);
        }
        Preconditions.checkArgument((!processorList.contains(valueProcessor) ? 1 : 0) != 0, (Object)"Duplicate ValueProcessor registration!");
        processorList.add(valueProcessor);
    }

    public <E, V extends BaseValue<E>> Optional<ValueProcessor<E, V>> getValueProcessor(Key<V> key) {
        return Optional.ofNullable((ValueProcessor)this.valueDelegates.get(key));
    }

    public Optional<ValueProcessor<?, ?>> getWildValueProcessor(Key<?> key) {
        return Optional.ofNullable(this.valueDelegates.get(key));
    }

    public <E> Optional<ValueProcessor<E, ? extends BaseValue<E>>> getBaseValueProcessor(Key<? extends BaseValue<E>> key) {
        return Optional.ofNullable((ValueProcessor)this.valueDelegates.get(key));
    }

    public RawDataValidator getValidators(ValidationType validationType) {
        return new DelegateDataValidator((ImmutableList<RawDataValidator>)ImmutableList.of(), validationType);
    }

    public <T extends DataManipulator<T, I>, I extends ImmutableDataManipulator<I, T>> Optional<NbtDataProcessor<T, I>> getNbtProcessor(NbtDataType dataType, Class<T> clazz) {
        return Optional.ofNullable((NbtDataProcessor)this.nbtProcessorTable.get(Preconditions.checkNotNull(clazz, (Object)"Manipulator class cannot be null!"), (Object)dataType));
    }

    public <E, V extends BaseValue<E>> Optional<NbtValueProcessor<E, V>> getNbtProcessor(NbtDataType dataType, Key<V> key) {
        return Optional.ofNullable((NbtValueProcessor)this.nbtValueTable.get(key, (Object)dataType));
    }

    public Optional<NbtDataProcessor> getRawNbtProcessor(NbtDataType dataType, Class<? extends DataManipulator> aClass) {
        return Optional.ofNullable(this.nbtProcessorTable.get(Preconditions.checkNotNull(aClass, (Object)"Manipulator class cannot be null!"), (Object)dataType));
    }

    public Optional<NbtValueProcessor> getRawNbtProcessor(NbtDataType dataType, Key<?> key) {
        return Optional.ofNullable(this.nbtValueTable.get(key, (Object)dataType));
    }

    public Collection<NbtDataProcessor<?, ?>> getNbtProcessors(NbtDataType type) {
        return this.nbtProcessorTable.column((Object)type).values();
    }

    public Collection<NbtValueProcessor<?, ?>> getNbtValueProcessors(NbtDataType type) {
        return this.nbtValueTable.column((Object)type).values();
    }

    public static boolean areRegistrationsComplete() {
        return !allowRegistrations;
    }

    static {
        TypeSerializers.getDefaultSerializers().registerPredicate(x -> dataSerializableTypeToken.isAssignableFrom(x) && !catalogTypeToken.isAssignableFrom(x), new DataSerializableTypeSerializer());
        instance = new SpongeDataManager();
        allowRegistrations = true;
    }
}

